/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ConfigUpdateRequest;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
@Schema(description="Config")
public class Config {
    private String compatibilityLevel;
    private String compatibilityGroup;
    private Metadata defaultMetadata;
    private Metadata overrideMetadata;
    private RuleSet defaultRuleSet;
    private RuleSet overrideRuleSet;

    @JsonCreator
    public Config(@JsonProperty(value="compatibilityLevel") String compatibilityLevel, @JsonProperty(value="compatibilityGroup") String compatibilityGroup, @JsonProperty(value="defaultMetadata") Metadata defaultMetadata, @JsonProperty(value="overrideMetadata") Metadata overrideMetadata, @JsonProperty(value="defaultRuleSet") RuleSet defaultRuleSet, @JsonProperty(value="overrideRuleSet") RuleSet overrideRuleSet) {
        this.compatibilityLevel = compatibilityLevel;
        this.compatibilityGroup = compatibilityGroup;
        this.defaultMetadata = defaultMetadata;
        this.overrideMetadata = overrideMetadata;
        this.defaultRuleSet = defaultRuleSet;
        this.overrideRuleSet = overrideRuleSet;
    }

    public Config(@JsonProperty(value="compatibilityLevel") String compatibilityLevel) {
        this.compatibilityLevel = compatibilityLevel;
    }

    public Config() {
    }

    public Config(ConfigUpdateRequest request) {
        this.compatibilityLevel = request.getCompatibilityLevel();
        this.compatibilityGroup = request.getCompatibilityGroup();
        this.defaultMetadata = request.getDefaultMetadata();
        this.overrideMetadata = request.getDefaultMetadata();
        this.defaultRuleSet = request.getDefaultRuleSet();
        this.overrideRuleSet = request.getOverrideRuleSet();
    }

    @Schema(description="Compatibility Level", allowableValues={"BACKWARD", "BACKWARD_TRANSITIVE", "FORWARD", "FORWARD_TRANSITIVE", "FULL", "FULL_TRANSITIVE", "NONE"}, example="FULL_TRANSITIVE")
    @JsonProperty(value="compatibilityLevel")
    public String getCompatibilityLevel() {
        return this.compatibilityLevel;
    }

    @JsonProperty(value="compatibilityLevel")
    public void setCompatibilityLevel(String compatibilityLevel) {
        this.compatibilityLevel = compatibilityLevel;
    }

    @JsonProperty(value="compatibilityGroup")
    public String getCompatibilityGroup() {
        return this.compatibilityGroup;
    }

    @JsonProperty(value="compatibilityGroup")
    public void setCompatibilityGroup(String compatibilityGroup) {
        this.compatibilityGroup = compatibilityGroup;
    }

    @JsonProperty(value="defaultMetadata")
    public Metadata getDefaultMetadata() {
        return this.defaultMetadata;
    }

    @JsonProperty(value="defaultMetadata")
    public void setDefaultMetadata(Metadata defaultMetadata) {
        this.defaultMetadata = defaultMetadata;
    }

    @JsonProperty(value="overrideMetadata")
    public Metadata getOverrideMetadata() {
        return this.overrideMetadata;
    }

    @JsonProperty(value="overrideMetadata")
    public void setOverrideMetadata(Metadata overrideMetadata) {
        this.overrideMetadata = overrideMetadata;
    }

    @JsonProperty(value="defaultRuleSet")
    public RuleSet getDefaultRuleSet() {
        return this.defaultRuleSet;
    }

    @JsonProperty(value="defaultRuleSet")
    public void setDefaultRuleSet(RuleSet defaultRuleSet) {
        this.defaultRuleSet = defaultRuleSet;
    }

    @JsonProperty(value="overrideRuleSet")
    public RuleSet getOverrideRuleSet() {
        return this.overrideRuleSet;
    }

    @JsonProperty(value="overrideRuleSet")
    public void setOverrideRuleSet(RuleSet overrideRuleSet) {
        this.overrideRuleSet = overrideRuleSet;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Config config = (Config)o;
        return Objects.equals(this.compatibilityLevel, config.compatibilityLevel) && Objects.equals(this.compatibilityGroup, config.compatibilityGroup) && Objects.equals(this.defaultMetadata, config.defaultMetadata) && Objects.equals(this.overrideMetadata, config.overrideMetadata) && Objects.equals(this.defaultRuleSet, config.defaultRuleSet) && Objects.equals(this.overrideRuleSet, config.overrideRuleSet);
    }

    public int hashCode() {
        return Objects.hash(this.compatibilityLevel, this.compatibilityGroup, this.defaultMetadata, this.overrideMetadata, this.defaultRuleSet, this.overrideRuleSet);
    }

    public String toString() {
        return "Config{compatibilityLevel='" + this.compatibilityLevel + '\'' + ", compatibilityGroup='" + this.compatibilityGroup + '\'' + ", defaultMetadata=" + this.defaultMetadata + ", overrideMetadata=" + this.overrideMetadata + ", defaultRuleSet=" + this.defaultRuleSet + ", overrideRuleSet=" + this.overrideRuleSet + '}';
    }
}

