/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.ImmutableLiteral;
import org.jruby.ir.operands.OperandType;
import org.jruby.runtime.ThreadContext;

public class UnboxedFloat
extends ImmutableLiteral {
    public final double value;

    public UnboxedFloat(double value2) {
        this.value = value2;
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.UNBOXED_FLOAT;
    }

    @Override
    public boolean hasKnownValue() {
        return true;
    }

    public Object createCacheObject(ThreadContext context) {
        return context.runtime.newFloat(this.value);
    }

    public String toString() {
        return "UnboxedFloat:" + this.value;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.UnboxedFloat(this);
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public boolean isTruthyImmediate() {
        return true;
    }
}

