#
# -*- coding: utf-8 -*-
# Copyright 2024 Dell Inc. or its subsidiaries. All Rights Reserved
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

"""
The arg spec for the sonic_ldap module
"""

from __future__ import absolute_import, division, print_function
__metaclass__ = type


class LdapArgs(object):  # pylint: disable=R0903
    """The arg spec for the sonic_ldap module
    """

    def __init__(self, **kwargs):
        pass

    argument_spec = {
        'config': {
            'elements': 'dict',
            'options': {
                'base': {'type': 'str'},
                'bind_timelimit': {'type': 'int'},
                'binddn': {'type': 'str'},
                'bindpw': {
                    'options': {
                        'pwd': {'required': True, 'type': 'str'},
                        'encrypted': {'type': 'bool'},
                    },
                    'type': 'dict'
                },
                'idle_timelimit': {'type': 'int'},
                'map': {
                    'options': {
                        'attribute': {
                            'elements': 'dict',
                            'options': {
                                'from': {'type': 'str'},
                                'to': {'type': 'str'}
                            },
                            'required_together': [['from', 'to']],
                            'type': 'list'
                        },
                        'default_attribute': {
                            'elements': 'dict',
                            'options': {
                                'from': {'type': 'str'},
                                'to': {'type': 'str'}
                            },
                            'required_together': [['from', 'to']],
                            'type': 'list'
                        },
                        'map_remote_groups_to_sonic_roles': {
                            'elements': 'dict',
                            'options': {
                                'remote_group': {'type': 'str'},
                                'sonic_roles': {
                                    'type': 'list',
                                    'elements': 'str',
                                    'choices': ['admin', 'operator', 'netadmin', 'secadmin']
                                }
                            },
                            'required_together': [['remote_group', 'sonic_roles']],
                            'type': 'list'
                        },
                        'objectclass': {
                            'elements': 'dict',
                            'options': {
                                'from': {'type': 'str'},
                                'to': {'type': 'str'}
                            },
                            'required_together': [['from', 'to']],
                            'type': 'list'
                        },
                        'override_attribute': {
                            'elements': 'dict',
                            'options': {
                                'from': {'type': 'str'},
                                'to': {'type': 'str'}
                            },
                            'required_together': [['from', 'to']],
                            'type': 'list'
                        }
                    },
                    'type': 'dict'
                },
                'name': {
                    'choices': ['global', 'nss', 'pam', 'sudo'],
                    'required': True,
                    'type': 'str'
                },
                'nss_base_group': {'type': 'str'},
                'nss_base_netgroup': {'type': 'str'},
                'nss_base_passwd': {'no_log': True, 'type': 'str'},
                'nss_base_shadow': {'type': 'str'},
                'nss_base_sudoers': {'type': 'str'},
                'nss_initgroups_ignoreusers': {'type': 'str'},
                'nss_skipmembers': {'type': 'bool'},
                'pam_filter': {'type': 'str'},
                'pam_group_dn': {'type': 'str'},
                'pam_login_attribute': {'type': 'str'},
                'pam_member_attribute': {'type': 'str'},
                'port': {'type': 'int'},
                'retry': {'type': 'int'},
                'scope': {
                    'choices': ['sub', 'one', 'base'],
                    'type': 'str'
                },
                'servers': {
                    'elements': 'dict',
                    'options': {
                        'address': {'required': True, 'type': 'str'},
                        'port': {'type': 'int'},
                        'priority': {'type': 'int'},
                        'retry': {'type': 'int'},
                        'server_type': {
                            'choices': ['all', 'nss', 'sudo', 'pam', 'nss_sudo', 'nss_pam', 'sudo_pam'],
                            'type': 'str'
                        },
                        'ssl': {
                            'choices': ['on', 'off', 'start_tls'],
                            'type': 'str'
                        }
                    },
                    'type': 'list'
                },
                'source_interface': {'type': 'str'},
                'ssl': {
                    'choices': ['on', 'off', 'start_tls'],
                    'type': 'str'
                },
                'sudoers_base': {'type': 'str'},
                'sudoers_search_filter': {'type': 'str'},
                'timelimit': {'type': 'int'},
                'version': {
                    'choices': [2, 3],
                    'type': 'int'
                },
                'vrf': {'type': 'str'}
            },
            'type': 'list'
        },
        'state': {
            'choices': ['merged', 'deleted', 'replaced', 'overridden'],
            'default': 'merged'
        }
    }   # pylint: disable=C0301
