{$N-,W-,G+,V-,C MOVEABLE DISCARDABLE}

Unit wbibedob;

Interface

uses
  wobjects, WinTypes, WinProcs, Strings, commdlg, windos, ole, ShellAPI, win31,
  rc_id, rc_strng, wc_help, graphio, wbibjpeg, wbibbmp,
  wbibdisp, wbibgui, wbibole, wbibslct, wbibbin, whugemem,
  bibstrg, streams, bibvars, bibutil, bibfile, lfnunit, lzssunit;

const
  ton_ok = 0; ton_Properties = 1; ton_Abort = 2;
  toc_Download = wm_User+1;
  toc_Upload   = wm_User+2;
  toc_Show     = wm_User+3;
  toc_PopupCmd = wm_User+4;

  EdObj_PasteNone    = 0;
  EdObj_PasteObject  = 1;
  EdObj_PasteObjLink = 2;
  EdObj_PasteImage   = 3; 

type

  PEditObjectDlg = ^TEditObjectDlg;
  TEditObjectDlg = object(TBasicDialog)
    BasicEBox: PEdit;
    LeadingWhite,TrailingWhite,Selected,Image,Embedded: boolean;
    Setup_End: boolean;
    Space,StartPos,EndPos,FromPaste: integer;
    EditBoxes: TCollection;
    VisualWnd: PWindow;
    BinObject: PBinObject;
    BinList  : PBinList;
    OrigName : PString;
    constructor init(AParent: PWindowsObject; ABasicEBox: PEdit;
                     AImage: boolean; AFromPaste: integer; ABinList: PBinList);
    procedure   InitEBoxes;
    procedure   SetupWindow; virtual;
    procedure   Update;
    procedure   wmActivate(var Msg: TMessage);  virtual wm_first+wm_Activate;
    procedure   wmCommand(var Msg: TMessage);   virtual wm_first+wm_command;
    procedure   TocPopup(var Msg: TMessage);    virtual wm_first+toc_PopupCmd;
    procedure   BrowseBtn(var Msg: TMessage);   virtual id_first+dl_EdObjBrowse;
    procedure   ClassBtn(var Msg: TMessage);    virtual id_first+dl_EdObjGetClass;
    procedure   InsertBtn(var Msg: TMessage);   virtual id_first+dl_EdObjInsert;
    procedure   UploadDimen(O: POleObj);
    procedure   CopyBtn(var Msg: TMessage);
    procedure   EmbedImage(DIB: THandle; M: LPPictInfo);
    procedure   EmbedBtn(var Msg: TMessage);    virtual id_first+dl_EdImageEmbed;
    procedure   PasteObject;
    procedure   PasteImage;
    procedure   PasteBtn(var Msg: TMessage);    virtual id_first+dl_EdObjPaste;
    procedure   EmbedObject(Obj: POleObject; ObjName: PChar);
    procedure   PasteLnkBtn(var Msg: TMessage); virtual id_first+dl_EdObjPasteLink;
    procedure   TestBtn(var Msg: TMessage);     virtual id_first+dl_EdObjTest;
    procedure   ActivateBtn(var Msg: TMessage); virtual id_first+dl_EdObjActivate;
    function    CanClose: boolean;              virtual;
    procedure   ok(var Msg: TMessage);          virtual id_first+id_ok;
    destructor  done; virtual;
  end;

procedure CleanupBinList(Entry: EntryRecPtr);

implementation

const
  BitMsg_FlipH = 1;
  BitMsg_FlipW = 2;
  BitMsg_DefH  = 3;
  BitMsg_DefW  = 4;
  BitMsg_Save  = 5;
  BitMsg_Cancel= 6;

  IconMargin = 3;

type
  PTestObject = ^TTestObject;
  TTestObject = object(TWindow)
    Obj      : POleObj;
    FX,FY    : integer;
    Orig     : TPoint;
    FirstTime,DontUpdate,Image,WDef,HDef,Embedded: boolean;
    Popup    : HMenu;
    MsgParent: PWindowsObject;
    BinList  : PBinList;
    BinObjPtr: PPBinObject;
    constructor init(AParent,AMsgParent: PWindowsObject; AImage: boolean;
                     ABinList: PBinList; ABinObjPtr: PPBinObject);
    procedure   SetupWindow; virtual;
    procedure   UploadInfo(var Msg: TMessage);   virtual wm_First+toc_Upload;
    procedure   DownloadInfo(var Msg: TMessage); virtual wm_First+toc_Download;
    procedure   ShowIt(var Msg: TMessage);       virtual wm_first+toc_Show;
    function    GetClassName: PChar; virtual;
    procedure   GetWindowClass(var AWndClass: TWndClass); virtual;
    function    WmGetMinMaxInfo(var Msg: TMessage): bool; virtual
                                           wm_first+wm_GetMinMaxInfo;
    procedure   wmRButtonDown(var Msg: TMessage);virtual wm_first+wm_RButtonDown;
    procedure   wmCommand(var Msg: TMessage);    virtual wm_first+wm_Command;
    procedure   Paint(PaintDC: HDC; var PaintInfo: TPaintStruct); virtual;
    procedure   wmSize(var Msg: TMessage);       virtual wm_First+wm_Size;
    destructor  done; virtual;
  end;

  PIconListDlg = ^TIconListDlg;
  TIconListDlg = object(TBasicDialog)
    Name: PChar;
    Selected: PInteger;
    Initial: integer;
    Wid,Hei: integer;
    constructor init(AParent: PWindowsObject; AName: PChar;
                     ASelected: PInteger);
    procedure   SetupWindow; virtual;
    procedure   wmMeasureItem(var Msg: TMessage); virtual wm_first+wm_MeasureItem;
    procedure   wmDrawItem(var Msg: TMessage);    virtual wm_first+wm_DrawItem;
    procedure   HandleLBox(var Msg: TMessage);    virtual id_first+dl_IconListLBox;
    procedure   ok(var Msg: TMessage);            virtual id_first+id_ok;
    procedure   wmDestroy(var Msg: TMessage);     virtual wm_first+wm_Destroy;
  end;

  PObjectNameDlg = ^TObjectNameDlg;
  TObjectNameDlg = object(TBasicDialog)
    S      : PChar;
    Slen   : word;
    BinList: PBinList;
    EBox   : PEditNoCR;
    Image  : boolean;
    constructor init(AParent: PWindowsObject; AImage: boolean;
                     AS: PChar; ASLen: word; ABinList: PBinList);
    procedure   SetupWindow; virtual;
    procedure   ok(var Msg: TMessage); virtual id_first+id_ok;
  end;

  PInsObjDlg = ^TInsObjDlg;
  TInsObjDlg = object(TBasicDialog)
    Class   : PChar;
    ClassLen: longint;
    constructor init(AParent: PWindowsObject; AClass: PChar; AClassLen: longint);
    procedure   SetupWindow; virtual;
    procedure   HandleLBox(var Msg: TMessage); virtual id_first+dl_InsObjLBox;
    procedure   ok(var Msg: TMessage);         virtual id_first+id_ok;
  end;

{ TTestObject methods }

constructor TTestObject.init(AParent,AMsgParent: PWindowsObject; AImage: Boolean;
                             ABinList: PBinList; ABinObjPtr: PPBinObject);
var
  D,N,E: PString;
  F: array[0..255] of char;
  R: TRect;
  Msg: TMessage;
  H: HMenu;
begin
  AllocStrings(true,@D,@N,@E,Nil);
  if AMsgParent=Nil then AMsgParent:=AParent;
  GetDlgItemText(AMsgParent^.HWindow,dl_EdObjFile,F,255);
  LFNFSplit(StrPas(F),D,N,E); StrPCopy(F,N^+E^);
  TWindow.init(AParent,F); Obj:=Nil; Image:=AImage; Embedded:=false;

  BinList:=ABinList; BinObjPtr:=ABinObjPtr;
  MsgParent:=AMsgParent;
  FX:=2*GetSystemMetrics(sm_CXFrame);
  FY:=GetSystemMetrics(sm_CyCaption)+2*GetSystemMetrics(sm_CYFrame)
      -GetSystemMetrics(sm_CYBorder);

  FirstTime:=true; DontUpdate:=true;
  UploadInfo(Msg);

  GetWindowRect(MsgParent^.HWindow,R);
  with Attr do
  begin
    X:=R.Right; Y:=R.Top;
    Style:=ws_Border or ws_ThickFrame or ws_Popup or ws_Caption;
    if X+W>ScreenRect.Right then X:=ScreenRect.Right-W;
    Orig.X:=W; Orig.Y:=H;
  end;
  WDef:=true; HDef:=true;
  H:=LoadMenu(HInstance,PChar(rc_BitMenu));
  Popup:=GetSubMenu(H,0);
  RemoveMenu(H,0,mf_ByPosition); DestroyMenu(H);
  if Image then
  begin
    RemoveMenu(Popup,mi_BitPasteLink,mf_ByCommand);
    RemoveMenu(Popup,mi_BitIconized ,mf_ByCommand);
  end;
  AllocStrings(false,@D,@N,@E,Nil);
end;                   { TTestObject.init }

procedure TTestObject.SetupWindow;
begin
  TWindow.SetupWindow;
  FirstTime:=false;
  PostMessage(HWindow,toc_Show,0,0);
end;

procedure TTestObject.UploadInfo(var Msg: TMessage);
var
  D,N,E: PString;
  F: array[0..255] of char;
  IcoName: array[0..2] of char;
  FName,Class,Part,P: PChar;
  OldIconized,NewIconized: boolean;
  TW,TH,DefTW,DefTH: real;

function GetDimenR(IdEBox,IdUnits: integer; IsX: boolean): real;
var
  i: integer;
  r: real;
  F: array[0..64] of char;
begin
  GetDimenR:=0;
  if (GetDlgItemText(MsgParent^.HWindow,IdEBox,F,64)>0) then
  begin
    Val(StrPas(F),r,i);
    if i=0 then
    begin
      i:=PDialog(MsgParent)^.SendDlgItemMsg(IdUnits,cb_GetCurSel,0,0);
      if IsX then r:=r*Units[i+1].F/Units[InUnits].F*ScreenResX
      else r:=r*Units[i+1].F/Units[InUnits].F*ScreenResY;
      if r>32767 then r:=32767
      else if r<-32767 then r:=-32767;
      GetDimenR:=r;
    end;
  end;
end;           { GetDimenR }

function GetDimen(IdEBox,IdUnits: integer; IsX: boolean): integer;
begin
  GetDimen:=round(GetDimenR(IdEBox,IdUnits,IsX));
end;

function IsEquiv(P1,P2: PChar): boolean;
begin
  if (p1<>Nil) and (p1[0]=#0) then p1:=Nil;
  if (p2<>Nil) and (p2[0]=#0) then p2:=Nil;
  if (p1=Nil) and (p2=Nil) then isEquiv:=true
  else if (p1=Nil) or (p2=Nil) then IsEquiv:=false
  else IsEquiv:=(StrLIComp(P1,P2,255)=0);
end;

begin               { TTestObject.UploadInfo }
  AllocStrings(true,@D,@N,@E,Nil);
  GetDlgItemText(MsgParent^.HWindow,dl_EdObjFile,F,255); FName:=StrNew(F);
  if (not Image) and (F[0]='<') then
  begin
    Embedded:=true;
  end else
  begin
    Embedded:=false;
    P:=PChar(@F)+StrLen(F)-1;
    while (P-F>2) and (P^<>'.') and (P^<>':') do dec(P);
    if P^=':' then P^:=#0;
    LFNFSplit(StrPas(F),D,N,E); StrPCopy(F,N^+E^);
  end;
  SetWindowText(HWindow,F);
  OldIconized:=true; NewIconized:=true;
  IcoName[0]:='1'; IcoName[1]:=#0;
  if Image then
  begin
    Class:=Nil; Part:=Nil;
  end else
  begin
    GetDlgItemText(MsgParent^.HWindow,dl_EdObjClass,F,255); Class:=StrNew(F);
    GetDlgItemText(MsgParent^.HWindow,dl_EdObjPart, F,255); Part :=StrNew(F);
  end;

  if not Image then
  begin
    if Obj<>Nil then OldIconized:=(Obj^.IsIconized<>ObjIcon_Render);
    NewIconized:=IsDlgButtonChecked(MsgParent^.HWindow,dl_EdObjIconizeCBox)=bf_Checked;
  end;
  if not NewIconized then IcoName[0]:='0';
  if Obj=Nil then
  begin
    New(Obj,init(@Self,Class,Fname,Part,IcoName,Image,false,
        bibname,BinList,BinObjPtr^));
  end else
    if not (IsEquiv(FName,Obj^.FName) and
            IsEquiv(Class,Obj^.Class) and
            IsEquiv(Part,Obj^.Part)   and (NewIconized=OldIconized) ) then
    begin
      Obj^.Renew(Class,Fname,Part,IcoName,Image,false,BinList,BinObjPtr^);
    end;
  with PEditObjectDlg(MsgParent)^ do
  if Selected then BasicEBox^.SetSelection(StartPos,EndPos);

  StrDispose(Part); StrDispose(Class); StrDispose(FName);

  if (Obj=Nil) or not Obj^.ok then
  begin
    if Obj<>Nil then Dispose(Obj,Done); Obj:=Nil;
    Attr.H:=100+FY; Attr.W:=100+FX;
    Show(sw_hide);
  end else
  begin
    show(sw_Show);
    TW:=0; TH:=0;
    WDef:=IsDlgButtonChecked(MsgParent^.HWindow,dl_EdObjWDefault)=bf_Checked;
    HDef:=IsDlgButtonChecked(MsgParent^.HWindow,dl_EdObjHDefault)=bf_Checked;
    DefTW:=Obj^.DefWidth /Units[InUnits].F*ScreenResX;
    DefTH:=Obj^.DefHeight/Units[InUnits].F*ScreenResY;

    if not WDef then TW:=abs(GetDimenR(dl_EdObjW,dl_EdObjWUnits,true));
    if TW=0 then TW:=DefTW;
    if not HDef then TH:=abs(GetDimenR(dl_EdObjH,dl_EdObjHUnits,false));
    if TH=0 then TH:=DefTH;

    if WDef and not HDef then TW:=TW/DefTH*TH;  { Preserve aspect ratio }
    if HDef and not WDef then TH:=TH/DefTW*TW;

    Attr.W:=round(TW)+FX; Attr.H:=round(TH)+FY;

    Obj^.FlipLR:=IsDlgButtonChecked(MsgParent^.HWindow,dl_EdObjWFlip)=bf_Checked;
    Obj^.FlipUD:=IsDlgButtonChecked(MsgParent^.HWindow,dl_EdObjHFlip)=bf_Checked;
  end;
  if not FirstTime then
  begin
    DontUpdate:=true;
    if (Obj<>Nil) and Obj^.ok then
    begin
      SetWindowPos(HWindow,0,0,0,Attr.W,Attr.H,swp_NoMove or SWP_NoZOrder);
      InvalidateRect(HWindow,Nil,true);
    end;
  end;
  DontUpdate:=true;
  AllocStrings(false,@D,@N,@E,Nil);
end;                { TTestObject.UploadInfo }

procedure TTestObject.DownloadInfo(var Msg: TMessage);
var
  R: TRect;
  aW,aH,b: real;
  F: array[0..3] of char;
  Upd,CustomW,CustomH,EmptyCustomW,EmptyCustomH: boolean;

procedure PutNum(a: real; id: integer);
var
  tmp: string[31];
  i,j: integer;
  F: array[0..31] of char;
begin
  Str(a:30:12,tmp); ChrDelL(tmp,' '); ChrDelR(tmp,'0');
  if tmp<>'' then
  begin
    i:=1; while (i<=length(tmp)) and (tmp[i] in ['0','.','-']) do inc(i);
    j:=0;
    while (i<=length(tmp)) do
    begin
      if tmp[i]<>'.' then inc(j); if j>=5 then tmp[0]:=Chr(i);
      inc(i);
    end;
  end;
  StrPCopy(F,tmp); SetDlgItemText(MsgParent^.HWindow,id,F);
end;            { PutNum }

begin           { TTestObject.DownloadInfo }
  if Obj=Nil then Exit;
  Upd:=false;
  GetClientRect(HWindow,R);
  Obj^.Width :=1.0*R.Right /ScreenResX*Units[InUnits].F;
  Obj^.Height:=1.0*R.Bottom/ScreenResY*Units[InUnits].F;

  CustomW:=(IsDlgButtonChecked(MsgParent^.HWindow,dl_EdObjWDefault)<>bf_Checked);
  CustomH:=(IsDlgButtonChecked(MsgParent^.HWindow,dl_EdObjHDefault)<>bf_Checked);
  EmptyCustomW:=(GetDlgItemText(MsgParent^.HWindow,dl_EdObjW,F,2)=0);
  EmptyCustomH:=(GetDlgItemText(MsgParent^.HWindow,dl_EdObjH,F,2)=0);
  aW:=1.0/Units[PEditObjectDlg(MsgParent)^.SendDlgItemMsg(dl_EdObjWUnits,
       cb_GetCurSel,0,0)+1].F*Units[InUnits].F*R.Right/ScreenResX;
  aH:=1.0/Units[PEditObjectDlg(MsgParent)^.SendDlgItemMsg(dl_EdObjHUnits,
      cb_GetCurSel,0,0)+1].F*Units[InUnits].F*R.bottom/ScreenResY;

  if not DontUpdate then
  begin
    WDef:=false; HDef:=false;
  end;

  if (not DontUpdate) and ((Not WDef) or CustomW) then
    PutNum(aW,dl_EdObjW);
  if not WDef then
  begin
    CheckDlgButton(MsgParent^.HWindow,dl_EdObjWDefault,bf_UnChecked);
    CheckDlgButton(MsgParent^.HWindow,dl_EdObjWCustom,bf_Checked);
    Upd:=true;
  end;
  if (not DontUpdate) and ((Not HDef) or CustomH) then
    PutNum(aH,dl_EdObjH);
  if not HDef then
  begin
    CheckDlgButton(MsgParent^.HWindow,dl_EdObjHDefault,bf_UnChecked);
    CheckDlgButton(MsgParent^.HWindow,dl_EdObjHCustom,bf_Checked);
    Upd:=true;
  end;

  if Embedded then
  begin
    SetDlgItemText(MsgParent^.HWindow,dl_EdObjClass,Obj^.Class);
    SetDlgItemText(MsgParent^.HWindow,dl_EdObjPart, Obj^.Part);
  end;

  if Upd then PEditObjectDlg(MsgParent)^.Update;
end;                { TTestObject.DownloadInfo }

procedure TTestObject.ShowIt(var Msg: TMessage);
begin
  if (Obj=Nil) or not Obj^.ok then Show(sw_Hide) else Show(sw_Show);
end;

procedure TTestObject.wmSize(var Msg: TMessage);
begin
  TWindow.wmSize(Msg);
  if not DontUpdate then
  begin
    WDef:=false; HDef:=false;
  end;
  if (Obj<>Nil) and Obj^.ok and (Msg.wParam<>SIZE_MINIMIZED) then
    DownloadInfo(Msg);
  DontUpdate:=false;
end;                     { TTestObject.wmSize }

function TTestObject.GetClassName: PChar;
begin
  GetClassName:=BibDBTestObjClass;
end;

procedure TTestObject.GetWindowClass(var AWndClass: TWndClass);
begin
  TWindow.GetWindowClass(AWndClass);
  AWndClass.Style:=AWndClass.Style or cs_DblClks;
end;

function TTestObject.WmGetMinMaxInfo(var Msg: TMessage): bool;
             { Determines the minimum size of the window }
begin
  with PMinMaxInfo(Msg.lparam)^ do
  begin
    ptMinTrackSize.X:=2*GetSystemMetrics(sm_CXFrame)+1;
    ptMinTrackSize.Y:=2*GetSystemMetrics(sm_CYFrame)+1;
  end;
  WmGetMinMaxInfo:=bool(0);
end;                    { TTestObject.WmGetMinMaxInfo }

procedure TTestObject.wmRButtonDown(var Msg: TMessage);
var
  PT: TPoint;

procedure CheckIt(Id: integer; On: boolean);
begin
  if on then CheckMenuItem(Popup,id,mf_ByCommand or mf_Checked)
  else CheckMenuItem(Popup,id,mf_ByCommand or mf_Unchecked);
end;

procedure EnableItem(id: integer; on: boolean);
begin
  if on then EnableMenuItem(Popup,id,mf_ByCommand or mf_Enabled)
  else       EnableMenuItem(Popup,id,mf_ByCommand or mf_Grayed);
end;

begin
  if (Obj=Nil) or not Obj^.ok then Exit;
  PT.X:=Msg.lParamLo; PT.Y:=Msg.lParamHi;
  ClientToScreen(Hwindow,PT);
  CheckIt(mi_BitDefH,
    IsDlgButtonChecked(MsgParent^.Hwindow,dl_EdObjHDefault)=bf_Checked);
  CheckIt(mi_BitDefW,
    IsDlgButtonChecked(MsgParent^.Hwindow,dl_EdObjWDefault)=bf_Checked);
  CheckIt(mi_BitFlipH,Obj^.FlipUD);
  CheckIt(mi_BitFlipW,Obj^.FlipLR);
  if Image then EnableItem(mi_BitPaste,IsClipImage)
  else begin
    CheckIt(mi_BitIconized,
      IsDlgButtonChecked(MsgParent^.Hwindow,dl_EdObjIconizeCBox)=bf_Checked);
    EnableItem(mi_BitPaste,IsClipEmbeddedObj);
    EnableItem(mi_BitPasteLink,IsClipLinkedObj);
  end;
  TrackPopupMenu(Popup,TPM_LeftAlign or TPM_RightButton,
        PT.X,PT.Y,0,HWindow,Nil);
end;                   { TTestObject.wmRButtonDown }

procedure TTestObject.wmCommand(var Msg: TMessage);
begin
  PostMessage(MsgParent^.HWindow,toc_PopupCmd,Msg.wParam,0);
end;

procedure TTestObject.Paint(PaintDC: HDC; var PaintInfo: TPaintStruct);
var
  R: TRect;
  i: integer;
begin
  if (Obj<>Nil) and Obj^.ok then
  begin
    GetClientRect(HWindow,R);
    if Obj^.FlipLR then
    begin
      i:=R.Left; R.Left:=R.Right; R.Right:=i;
    end;
    if Obj^.FlipUD then
    begin
      i:=R.Top; R.Top:=R.Bottom; R.Bottom:=i;
    end;
    Obj^.Display(HWindow,PaintDC,R,true);
  end;
end;                    { TTestObject.Paint }

destructor TTestObject.Done;
begin
  if Obj<>Nil then Dispose(Obj,Done);
  DestroyMenu(Popup);
  TWindow.Done;
end;

{ TIconListDlg methods }

constructor TIconListDlg.Init(AParent: PWindowsObject; AName: PChar;
                              ASelected: PInteger);
var
  Icon: HIcon;
  lpIcon: PCursorIconInfo;
begin
  TBasicDialog.init(AParent,PChar(rc_IconListDlg));
  Selected:=ASelected; Selected^:=-1;
  Name:=AName;
  Wid:=32; Hei:=32;
  Icon:=ExtractIcon(HInstance,Name,0);
  if (Icon<>0) and (integer(Icon)<>-1) then
  begin
    lpIcon:=LockResource(THandle(Icon));
    Wid:=lpIcon^.wWidth; Hei:=lpIcon^.wheight;
    UnlockResource(Icon);
  end;
end;             { TIconListDlg.Init }

procedure TIconListDlg.wmMeasureItem(var Msg: TMessage);
begin
  with PMeasureItemStruct(Msg.lParam)^ do
  begin
    ItemWidth:=Wid+2*IconMargin;
    ItemHeight:=Hei+2*IconMargin;
  end;
end;

procedure TIconListDlg.SetupWindow;
var
  NumIcons,i: integer;
  Icon: HIcon;
  F: array[0..255] of char;
  tmp: string;
begin
  TBasicDialog.SetupWindow;
  GetWindowText(HWindow,F,255); tmp:=StrPas(F);
  StrRepl(tmp,'%s',StrPas(Name),1,255,255); StrPCopy(F,tmp);
  SetWindowText(HWindow,F);
  NumIcons:=integer(ExtractIcon(HInstance,Name,word(-1)));
  if NumIcons<1 then
  begin
    EndDlg(id_cancel); Exit;
  end;
  for i:=1 to NumIcons do
  begin
    Icon:=ExtractIcon(HInstance,Name,i-1);
    SendDlgItemMsg(dl_IconListLBox,lb_AddString,0,MakeLong(word(Icon),0));
    SendDlgItemMsg(dl_IconListLBox,lb_SetItemData,i-1,MakeLong(word(Icon),0));
  end;
  SendDlgItemMsg(dl_IconListLBox,lb_SetColumnWidth,Wid+2*IconMargin,0);
  SendDlgItemMsg(dl_IconListLBox,lb_SetCurSel,0,0);
end;                   { TIconListDlg.SetupWindow }

procedure TIconListDlg.wmDrawItem(var Msg: TMessage);
var
  Color: TColorRef;
  Brush: HBrush;
  Icon: HIcon;
begin
  with PDrawItemStruct(Msg.lParam)^ do
  begin
    if ItemState AND ODS_Selected <> 0 then  { Selected }
      Color:=GetSysColor(Color_HighLight)
    else Color:=GetSysColor(Color_Window);
    Brush:=CreateSolidBrush(Color);
    FillRect(hDC,rcItem,Brush);
    DeleteObject(Brush);
    if (integer(ItemID)>=0) and (ItemData>0) then
      DrawIcon(hDC,rcItem.Left+IconMargin,rcItem.Top+IconMargin,
               HIcon(LoWord(ItemData)));
    if ItemState AND ODS_Selected <> 0 then  { Selected }
      FrameRect(hDC,rcItem,GetStockObject(Black_Brush));
  end;
end;                   { TIconListDlg.wmDrawItem }

procedure TIconListDlg.HandleLBox(var Msg: TMessage);
begin
  if Msg.lParamhi=lbn_DblClk then ok(Msg)
  else DefWndProc(Msg);
end;

procedure TIconListDlg.ok(var Msg: TMessage);
var
  i: integer;
begin
  if not CanClose then Exit;
  i:=SendDlgItemMsg(dl_IconListLBox,lb_GetCurSel,0,0);
  if i<>lb_Err then Selected^:=i;
  EndDlg(id_ok);
end;               { TIconListDlg.ok }

procedure TIconListDlg.wmDestroy(var Msg: TMessage);
var
  i,num: integer;
  Icon: HIcon;
begin
  num:=SendDlgItemMsg(dl_IconListLBox,lb_GetCount,0,0);
  if (num<>lb_err) and (num>0) then
  for i:=0 to num-1 do
  begin
    Icon:=HIcon(LoWord(SendDlgItemMsg(dl_IconListLBox,lb_GetItemData,i,0)));
    DestroyIcon(Icon);
  end;
  TbasicDialog.wmDestroy(Msg);
end;               { TIconListDlg.wmDestroy }

{ TObjectNameDlg methods }

constructor TObjectNameDlg.init(AParent: PWindowsObject; AImage: boolean;
                                AS: PChar; ASLen: word; ABinList: PBinList);
begin
  TBasicDialog.init(AParent,PChar(rc_ObjectNameDlg));
  S:=AS; SLen:=ASLen;
  Image:=AImage;
  BinList:=ABinList;
  HelpContext:=hc_Objects;
end;

procedure TObjectNameDlg.SetupWindow;
var
  tmp: string;
  F: Pchar;
begin
  TBasicDialog.SetupWindow;
  F:=@tmp[1];
  New(EBox,InitResource(@Self,dl_ObjectNameEBox,
        255,[#0..#32,'@',lbrace,rbrace,'<','>','%']));
  if S^='<' then
  begin
    F[0]:=#0; StrLCat(F,S+1,254);
    if F[StrLen(F)-1]='>' then F[StrLen(F)-1]:=#0;
    SetDlgItemText(HWindow,dl_ObjectNameEBox,F);
  end else if S^<>#0 then
    SetDlgItemText(HWindow,dl_ObjectNameEBox,S);
  if Image then
  begin
    GetDlgItemText(Hwindow,dl_ObjectNameStat,F,254);
    tmp[0]:=Chr(StrLen(F));
    StrRepl(tmp,'object','image',1,255,255);
    tmp[length(tmp)+1]:=#0;
    SetDlgItemText(HWindow,dl_ObjectNameStat,F);
  end;      
end;               { TObjectNameDlg.SetupWindow }

procedure TObjectNameDlg.ok(var Msg: TMessage);
var
  tmp: string;
  F: PChar;
  found: boolean;
  i: integer;
begin
  F:=@tmp[1];
  GetDlgItemText(HWindow,dl_ObjectNameEBox,F,250);
  tmp[0]:=Chr(StrLen(F)); ChrDel(tmp,'<'); ChrDel(tmp,'>'); ChrDel(tmp,' ');
  i:=0; Found:=false;
  while (i<BinList^.Count) and not found do
  begin
    Found:=(StrCmpI(tmp,PBinObject(BinList^.at(i))^.Name,1,1,255)=0);
    inc(i);
  end;
  if Found then ErrorMessageRC(Str_DupObjectName,tmp)
  else begin
    tmp:='<'+tmp+'>'#0;
    S[0]:=#0;
    StrLCat(S,F,Slen);
    EndDlg(id_ok);
  end;
end;              { TObjectNameDlg.ok }

{ TInsObjDlg methods }

constructor TInsObjDlg.init(AParent: PWindowsObject; AClass: PChar; AClassLen: longint);
begin
  TBasicDialog.init(AParent,PChar(rc_InsObjDlg));
  Class:=AClass; Class[0]:=#0; ClassLen:=AClassLen;
  HelpContext:=hc_Objects;
end;

procedure TInsObjDlg.SetupWindow;
var
  RegInd,num,len: longint;
  key,Subkey: array[0..255] of char;
  Exe: array[0..10] of char;
  SubKeyInd: HKey;
begin
  TBasicDialog.SetupWindow; InitPos;
  RegInd:=0; len:=255;
  while RegEnumKey(HKEY_CLASSES_ROOT,RegInd,Key,len)=Error_Success do
  begin
    if FindOleExe(Nil,Key,Exe,8) then
    begin
      len:=255; RegQueryValue(HKEY_CLASSES_ROOT,Key,SubKey,len);
      num:=SendDlgItemMsg(dl_InsObjLBox,lb_AddString,0,Longint(@SubKey));
      SendDlgItemMsg(dl_InsObjLBox,lb_SetItemData,num,longint(RegInd));
{      message(num2str(RegInd)+','+StrPas(SubKey));}
    end;
    inc(RegInd); len:=255;
  end;
  SendDlgItemMsg(dl_InsObjLBox,lb_SetCurSel,0,0); 
end;                { TInsObjDlg.SetupWindow }

procedure TInsObjDlg.HandleLBox(var Msg: TMessage);
begin
  if Msg.lParamHi=lbn_DblClk then ok(Msg);
  DefWndProc(Msg);
end;

procedure TInsObjDlg.ok(var Msg: TMessage);
var
  Ind: integer;
  RegInd: longint;
begin
  Ind:=SendDlgItemMsg(dl_InsObjLBox,lb_GetCurSel,0,0);
  if Ind=lb_Err then Exit;
  RegInd:=SendDlgItemMsg(dl_InsObjLBox,lb_GetItemData,Ind,0);
{  message(num2str(RegInd));}
  if RegEnumKey(HKEY_CLASSES_ROOT,RegInd,Class,ClassLen)<>Error_Success then
  begin
    Class[0]:=#0; EndDlg(id_Cancel);
  end else EndDlg(id_ok);
end;                      { TInsObjDlg.ok }


{ TEditObjectDlg methods }

constructor TEditObjectDlg.init(AParent: PWindowsObject; ABasicEBox: PEdit;
            AImage: boolean; AFromPaste: integer; ABinList: PBinList);
begin
  if AImage then
    TBasicDialog.init(AParent,PChar(rc_EditImageDlg))
  else
    TBasicDialog.init(AParent,PChar(rc_EditObjectDlg));
  BasicEBox:=ABasicEBox;
  FromPaste:=AFromPaste;
  Image:=AImage;
  HelpContext:=hc_EditObject;
  VisualWnd:=Nil; Embedded:=false;
  BinObject:=Nil;
  BinList:=ABinList;
  Embedded:=false;
  Setup_End:=false;
  OrigName:=Nil;
  InitEBoxes;
end;                 { TEditObjectDlg.init }

procedure TEditObjectDlg.InitEBoxes;
begin
  EditBoxes.init(20,20);
  EditBoxes.Insert(New(PEditNoCR,
      InitResource(@Self,dl_EdObjFile,
        255,[#0..#32,'@',lbrace,rbrace,'%','"',
                    '''','`','(',')'])));
  if not image then
  begin
    EditBoxes.Insert(New(PEditBalanced,
      InitResource(@Self,dl_EdObjClass,255,[#0..#32])));
    EditBoxes.Insert(New(PEditBalanced,
      InitResource(@Self,dl_EdObjPart,255,[#0..#31])));
  end;
  EditBoxes.Insert(New(PEditBalanced,
    InitResource(@Self,dl_EdObjTitle,255,[#0..#31])));
  EditBoxes.Insert(New(PEditNoCR,
    InitResource(@Self,dl_EdObjW,32,[#0..#255]-['0'..'9','.'])));
  EditBoxes.Insert(New(PEditNoCR,
    InitResource(@Self,dl_EdObjH,32,[#0..#255]-['0'..'9','.'])));
  EditBoxes.Insert(New(PEditNoCR,
    InitResource(@Self,dl_EdObjBase,32,[#0..#255]-['0'..'9','.','-'])));
end;                 { EditObjectDlg.IniEBoxes }

procedure TEditObjectDlg.SetupWindow;
var
  i,nbr: integer;
  tmp: Pstring;
  P,P0,F: PChar;
  l: word;
  Msg: TMessage;
  Found,HasLink,HasEmbed: boolean;

procedure Parse(var tmp: string);
var
  R: ObjInfoPtr;
  i: integer;
  F: array[0..31] of char;
begin
  New(R);
  i:=ParseObjectString(@tmp[1],length(tmp),R^);
  if i>0 then
  with R^ do
  begin
    { Misc }
    SetDlgItemText(HWindow,dl_EdObjFile,fname);
    if not Image then
    begin
      SetDlgItemText(HWindow,dl_EdObjPart,Part);
      SetDlgItemText(HWindow,dl_EdObjClass,Class);
      if (fname[0]='<') and (fname[StrLen(fname)-1]='>') then
      begin
        fname[StrLen(fname)-1]:=#0;
        Embedded:=true; OrigName:=NewStr(StrPas(PChar(@fname[1])));
      end;
    end;

    { Dimensions }
    if not DefW then
    begin
      CheckDlgButton(HWindow,dl_EdObjWDefault,bf_UnChecked);
      CheckDlgButton(HWindow,dl_EdObjWCustom,bf_Checked);
      SetDlgItemText(HWindow,dl_EdObjW,Width.S);
      SendDlgItemMsg(dl_EdObjWUnits,cb_SetCurSel,Width.U-1,0);
    end;
    if not DefH then
    begin
      CheckDlgButton(HWindow,dl_EdObjHDefault,bf_UnChecked);
      CheckDlgButton(HWindow,dl_EdObjHCustom,bf_Checked);
      SetDlgItemText(HWindow,dl_EdObjH,Height.S);
      SendDlgItemMsg(dl_EdObjHUnits,cb_SetCurSel,Height.U-1,0);
    end;

    { Alignment }
    if HAlign=ObjAlign_Left then
      CheckDlgButton(HWindow,dl_EdObjLeft,bf_Checked)
    else if HAlign=ObjAlign_Right then
      CheckDlgButton(HWindow,dl_EdObjRight,bf_Checked)
    else if HAlign=ObjAlign_Center then
      CheckDlgButton(HWindow,dl_EdObjCenter,bf_Checked)
    else if BaseTop then 
      CheckDlgButton(HWindow,dl_EdObjTop,bf_Checked)
    else if BaseMid then
      CheckDlgButton(HWindow,dl_EdObjMid,bf_Checked)
    else begin
      CheckDlgButton(HWindow,dl_EdObjBCustom,bf_Checked);
      if BaseBottom then SetDlgItemText(HWindow,dl_EdObjBase,'0')
      else begin
        if Base.S[0]<>#0 then SetDlgItemText(HWindow,dl_EdObjBase,Base.S);
        SendDlgItemMsg(dl_EdObjBUnits,cb_SetCurSel,Base.U-1,0);
      end;
    end;

    { Flip }
    if FlipLR then CheckDlgButton(HWindow,dl_EdObjWFlip,bf_Checked);
    if FlipUD then CheckDlgButton(HWindow,dl_EdObjHFlip,bf_Checked);

    { Iconized }
    if (StrIComp(IcoName,'off')<>0) and
       (StrIComp(IcoName,'no')<>0) and (StrIComp(IcoName,'0')<>0) then
           CheckDlgButton(HWindow,dl_EdObjIconizeCBox,bf_Checked);
  end;

  Dispose(R);
end;                   { Parse }

begin                 { TEditObjectDlg.SetupWindow }
  TBasicDialog.SetupWindow;
  GetMem(F,256); New(tmp);
  for i:=1 to NUnits do
  begin
    StrPCopy(F,Units[i].U);
    SendDlgItemMsg(dl_EdObjWUnits,cb_AddString,0,longint(F));
    SendDlgItemMsg(dl_EdObjHUnits,cb_AddString,0,longint(F));
    SendDlgItemMsg(dl_EdObjBUnits,cb_AddString,0,longint(F));
  end;
  BasicEBox^.GetSelection(StartPos,EndPos);
  Selected:=(StartPos<EndPos-1);
  P0:=Nil; P:=Nil; LeadingWhite:=false; TrailingWhite:=false;
  found:=false;
  if Selected then
  begin
    l:=EndPos-StartPos+10;
    GetMem(P0,l);
    BasicEBox^.GetSubText(P0,StartPos,EndPos);
    repeat    { Remove newlines }
      P:=StrScan(P0,#13);
      if P<>Nil then
        for i:=0 to StrLen(P) do P[i]:=P[i+2];
    until P=Nil;
    if (StartPos>0) then
    begin
      BasicEBox^.GetSubText(F,StartPos-1,StartPos);
      if (F[0]<>' ') and (F[0]<>lbrace) then LeadingWhite:=true;
    end;
    P:=P0;
    while (P[0]=' ') do P:=P+1;
    i:=StrLen(P)-1;
    while (i>=0) and (P[i]=' ') do
    begin
      TrailingWhite:=true; dec(i);
    end;
    P[i+1]:=#0;
  end else if StartPos>0 then
  begin
    BasicEBox^.GetSubText(F,StartPos-1,StartPos);
    if F[0]<>' ' then LeadingWhite:=true; 
  end;

  { Default settings }
  CheckDlgButton(HWindow,dl_EdObjWDefault,bf_Checked);
  CheckDlgButton(HWindow,dl_EdObjHDefault,bf_Checked);
{  CheckDlgButton(HWindow,dl_EdObjBCustom, bf_Checked);}
  SetDlgItemText(HWindow,dl_EdObjBase,'0');
  SendDlgItemMsg(dl_EdObjWUnits,cb_SetCurSel,0,0);
  SendDlgItemMsg(dl_EdObjHUnits,cb_SetCurSel,0,0);
  SendDlgItemMsg(dl_EdObjBUnits,cb_SetCurSel,0,0);

  { Paste }
  if      FromPaste=EdObj_PasteObject  then PasteObject      { Embedded object }
  else if FromPaste=EdObj_PasteObjLink then PasteLnkBtn(Msg) { Linked object   }
  else if FromPaste=EdObj_PasteImage   then PasteImage       { Image           }
  else if Selected then
  begin                            { from marked text }
    P:=P0; F[0]:=#0; while P[0]=' ' do P:=P+1;
    if P[0]='\' then
    begin
      F[0]:=#0;
      StrLCat(F,P,length(ObjectTeXMacro^)+1);
      if StrPas(F)=ObjectTeXMacro^+lbrace then
      begin
        found:=true;
        P:=P+length(ObjectTeXMacro^)+1;
      end else
      begin
        F[0]:=#0; StrLCat(F,P,length(ImageTeXMacro^)+1);
        if StrPas(F)=ImageTeXMacro^+lbrace then
        begin
          found:=true;
          P:=P+length(ImageTeXMacro^)+1;
        end;
      end;
    end;
    if found then   { Start object }
    begin
      tmp^:='';
      nbr:=1; i:=0;
      while (nbr>0) and (P[i]<>#0) do
      begin
        if P[i]=lbrace then inc(nbr)
        else if P[i]=rbrace then dec(nbr);
        if nbr>0 then inc(i);
      end;
      if i<=255 then
      begin
        Move(P^,tmp^[1],i); tmp^[0]:=Chr(i);
        Parse(tmp^);
        if (P[i]=rbrace) and (P[i+1]='[') then { Title }
        begin
          P:=P+i+2;
          nbr:=1; i:=0;
          while (nbr>0) and (P[i]<>#0) do
          begin
            if P[i]=lbrace then inc(nbr)
            else if P[i]=rbrace then dec(nbr)
            else if (nbr=1) and (P[i]=']') then dec(nbr);
            if nbr>0 then inc(i);
          end;
          P[i]:=#0;
          SetDlgItemText(HWindow,dl_EdObjTitle,P);
        end;
      end;
    end else
    begin
      SetDlgItemText(HWindow,dl_EdObjTitle,P);
    end;
  end;
  {
  tmp^:='';
  if IsClipboardFormatAvailable(CF_DIB) then tmp^:=tmp^+'DIB ';
  if IsClipboardFormatAvailable(CF_Bitmap) then tmp^:=tmp^+'Bitmap ';
  if IsClipboardFormatAvailable(CF_MetafilePict) then tmp^:=tmp^+'Metafile ';
  if tmp^='' then tmp^:='none';
  message(tmp^);
  }
  Dispose(tmp); FreeMem(F,256);


  if P0<>Nil then FreeMem(P0,l);
  VisualWnd:=New(PTestObject,init(Parent,@Self,Image,BinList,@BinObject));
  Application^.MakeWindow(VisualWnd);
  Update;
  Setup_End:=true;
end;                { TEditObjectDlg.SetupWindow }

procedure TEditObjectDlg.Update;
var
  btmp: boolean;
  F: array[0..2] of char;
begin
  btmp:=IsDlgButtonChecked(Hwindow,dl_EdObjWCustom)=bf_Checked;
  EnableWindow(GetItemHandle(dl_EdObjW),btmp);
  EnableWindow(GetItemHandle(dl_EdObjWUnits),btmp);
  btmp:=IsDlgButtonChecked(Hwindow,dl_EdObjHCustom)=bf_Checked;
  EnableWindow(GetItemHandle(dl_EdObjH),btmp);
  EnableWindow(GetItemHandle(dl_EdObjHUnits),btmp);
  btmp:=IsDlgButtonChecked(Hwindow,dl_EdObjBCustom)=bf_Checked;
  EnableWindow(GetItemHandle(dl_EdObjBase),btmp);
  EnableWindow(GetItemHandle(dl_EdObjBUnits),btmp);
  F[0]:=#0; GetDlgItemText(HWindow,dl_EdObjFile,F,2);
  Embedded:=(F[0]='<');
  if Image then
  begin
    EnableWindow(GetItemHandle(dl_EdObjPaste),IsClipImage);
    EnableWindow(GetItemHandle(dl_EdImageEmbed),
       (not Embedded) and (F[0]<>#0));
  end else
  begin
    EnableWindow(GetItemHandle(dl_EdObjPaste)    ,IsClipEmbeddedObj);
    EnableWindow(GetItemHandle(dl_EdObjPasteLink),IsClipLinkedObj);
    EnableWindow(GetItemHandle(dl_EdObjClass),    not Embedded);
    EnableWindow(GetItemHandle(dl_EdObjPart),     not Embedded);
    EnableWindow(GetItemHandle(dl_EdObjGetClass), not Embedded);
  end;
end;                { TEditObjectDlg.Update }

procedure TEditObjectDlg.wmActivate(var Msg: TMessage);
begin
  if Setup_End and (Msg.wParam<>wa_Inactive) then Update;
  DefWndProc(Msg);
end;                    { TEditObjectDlg.wmActivate }

const
  CheckedBtn: array[boolean] of integer = (bf_Unchecked,bf_Checked);

procedure TEditObjectDlg.tocPopup(var Msg: TMessage);
var
  check,Upd: boolean;
begin
  Upd:=true;
  case Msg.wParam of
    mi_BitDialog:
      begin
        SetFocus(HWindow); Exit;
      end;
    mi_BitFlipH:
        CheckDlgButton(Hwindow,dl_EdObjHFlip,CheckedBtn[
          IsDlgButtonChecked(Hwindow,dl_EdObjHFlip)<>bf_Checked]);
    mi_BitFlipW:
        CheckDlgButton(Hwindow,dl_EdObjWFlip,CheckedBtn[
          IsDlgButtonChecked(Hwindow,dl_EdObjWFlip)<>bf_Checked]);
    mi_BitDefH:
      begin
        Check:=IsDlgButtonChecked(Hwindow,dl_EdObjHDefault)=bf_Checked;
        CheckDlgButton(HWindow,dl_EdObjHDefault,CheckedBtn[not Check]);
        CheckDlgButton(Hwindow,dl_EdObjHCustom,CheckedBtn[Check]);
      end;
    mi_BitDefW:
      begin
        Check:=IsDlgButtonChecked(Hwindow,dl_EdObjWDefault)=bf_Checked;
        CheckDlgButton(HWindow,dl_EdObjWDefault,CheckedBtn[not Check]);
        CheckDlgButton(Hwindow,dl_EdObjWCustom,CheckedBtn[Check]);
      end;
    mi_BitOk:      begin SetFocus(HWindow); ok(Msg); Exit; end;
    mi_BitCancel:  begin Cancel(Msg); Exit; end;
    mi_BitIconized:
      begin
        CheckDlgButton(Hwindow,dl_EdObjIconizeCBox,CheckedBtn[
          IsDlgButtonChecked(Hwindow,dl_EdObjIconizeCBox)<>bf_Checked]);
      end;
    mi_BitCopy     : CopyBtn(Msg);
    mi_BitPaste    : PasteBtn(Msg);
    mi_BitPasteLink: PasteLnkBtn(Msg);
    else Exit;
  end;
  SendMessage(VisualWnd^.HWindow,toc_Upload,0,0);
  Update;
end;                         { TEditObjectDlg.tocPopup }

procedure TEditObjectDlg.wmCommand(var Msg: TMessage);
begin
  case Msg.wParam of
    dl_EdObjWDefault,dl_EdObjHDefault,dl_EdObjWCustom,dl_EdObjHCustom,
      dl_EdObjWFlip,dl_EdObjHFlip,dl_EdObjIconizeCBox:
      begin
        SendMessage(VisualWnd^.HWindow,toc_Upload,0,0);
        Update; SetFocus(HWindow);
      end;
    dl_EdObjTop,dl_EdObjMid,dl_EdObjBCustom,
      dl_EdObjLeft,dl_EdObjRight,dl_EdObjCenter: Update;
  end;
  TBasicDialog.wmCommand(Msg);
end;                { TEditObjectDlg.wmCommand }

procedure TEditObjectDlg.BrowseBtn(var Msg: TMessage);
var
  T: TOpenFileName;
  FName,IDir: PChar;
  Title: array[0..63] of char;
  Filters,F,F1,F0,ExtList: PChar;
  Class,FiltLen,NumIcons,IconIndex: integer;
  D,D1,N,N1,E,E1: PString;
  FOpenHook: TFarProc;

procedure AddAType(var F: PChar; Ind: integer);
begin
  with IntGraphList[Ind] do
  if (Ext<>Nil) and (Ext^<>#0) and on then
  begin
    StrCopy(F,Desc); StrCat(F,'('); StrCat(F,Ext); StrCat(F,')');
    F:=F+StrLen(F)+1;
    StrCopy(F,Ext);
    F:=F+StrLen(F)+1;
    if ExtList^<>#0 then StrCat(ExtList,';');
    StrCat(ExtList,Ext);
  end;
end;

begin
  AllocStrings(true,@D,@N,@E,Nil); AllocStrings(true,@D1,@N1,@E1,Nil);
  GetMem(FName,256); GetMem(IDir,256);
  GetMem(Filters,2048); FillChar(Filters^,2048,0);
  Class:=SendDlgItemMsg(dl_EditHyperClass,cb_GetCurSel,0,0)+1;
  if Image then
  begin
    GetMem(F0,2048); FillChar(F0^,2048,0); F:=F0;
    GetMem(ExtList,512); FillChar(ExtList^,512,0);
    FiltLen:=0;
    AddAType(F,GrExt_BMP);
    AddAType(F,GrExt_PCX);
    AddAType(F,GrExt_WMF);
    AddAType(F,GrExt_GIF);
    if ECJ_Active then AddAType(F,GrExt_JPG);
    AddAType(F,GrExt_TGA);
    AddAType(F,GrExt_Ico);

    if UseGraphicsFilters then
    begin
      F1:=Get_OpenMask(F,1024,ExtList,1024,GRFilt_IniSection);
      if F1<>Nil then F:=F1;
    end;

    StrPCopy(F,'All files(*.*)'#0'*.*');

    Filters^:=#0; F:=Filters;
    StrCopy(F,IntGraphList[GrExt_All].Desc);
    FiltLen:=StrLen(F)+1; F:=F+StrLen(F)+1;
    StrCopy(F,ExtList); FiltLen:=FiltLen+StrLen(F)+1; F:=F+StrLen(F)+1;
    Move(F0^,F^,2048-FiltLen-1);
    FreeMem(ExtList,512); FreeMem(F0,2048);
    StrPCopy(Title,'Image');
  end else
  begin
    StrPCopy(Title,'Object');
    StrPCopy(Filters,'All files'#0'*.*'#0);
  end;
  Fname[0]:=#0;
  LFNFSplit(bibname^,D,N,E); CanonicalFname(D^);
  if (length(D^)>3) and (D^[length(D^)]='\') then dec(D^[0]);
  StrPCopy(IDir,D^);

  FOpenHook:=MakeProcInstance(TFarProc(@FOpenDlgHook),HInstance);
  FillChar(T,SizeOf(T),0);
  with T do
  begin
    lStructSize:=SizeOf(T);
    hWndOwner:=HWindow;
    lpstrFilter:=Filters; nFilterIndex:=1;
    lpstrFile:=Fname;     nMaxFile:=255;
    lpstrTitle:=@Title;
    lpstrInitialDir:=IDir;
    flags:=Ofn_FileMustExist or ofn_NoChangeDir or ofn_HideReadOnly
           or Ofn_EnableHook {or Ofn_EnableTemplate};
    if LFNAble then flags:=flags or ofn_LongNames;
    lpTemplateName:=PChar(rc_FileOpenBrowse);
    lpfnHook:=FOpenHookProc(FOpenHook);
  end;
  T.HInstance:=HInstance;
  if GetOpenFileName(T) then
  begin
    D^:=StrPas(Fname); CanonicalFname(D^); StrPCopy(fname,D^);
    LFNFSplit(D^,D,N,E); LFNFSplit(bibname^,D1,N1,E1);
    CanonicalFname(D^); CanonicalFname(D1^);
    if StrCmpI(D^,D1^,1,1,255)=0 then StrPCopy(fname,N^+E^);
{    StrLower(Fname);}
    { Icon lists }
    NumIcons:=ExtractIcon(HInstance,FName,word(-1));
    if NumIcons>1 then
    begin
      IconIndex:=0;
      if (Application^.ExecDialog(New(PIconListDlg,init(@Self,FName,@IconIndex)))
         =id_ok) and (IconIndex>0) then
      begin
        StrPCopy(Title,IcoSepChar+num2str(IconIndex));
        StrCat(FName,Title);
      end;
    end;
    SetDlgItemText(HWindow,dl_EdObjFile,Fname);
  end;
  FreeProcInstance(FOpenHook);
  FreeMem(Filters,2048);
  FreeMem(IDir,256); FreeMem(Fname,256);
  AllocStrings(false,@D1,@N1,@E1,Nil); AllocStrings(false,@D,@N,@E,Nil);
  SendMessage(VisualWnd^.HWindow,toc_Upload,  0,0);
  SendMessage(VisualWnd^.HWindow,toc_Download,0,0);
  Update;
  SetFocus(HWindow);
end;                     { TEditObjectDlg.BrowseBtn }

procedure TEditObjectDlg.UploadDimen(O: POleObj);
var
  r: real;
  i: integer;
  tmp: string[31];
  F: array[0..32] of char;
begin
  if (O<>Nil) and (O^.ok)  then
  with O^ do
  begin
    if GetDlgItemText(HWindow,dl_EdObjW,F,10)=0 then
    begin
      i:=SendDlgItemMsg(dl_EdObjWUnits,cb_GetCurSel,0,0)+1;
      r:=Width/Units[i].F;
      Str(r:30:12,tmp); ChrDelL(tmp,' '); ChrDelR(tmp,'0');
      StrPCopy(F,tmp); SetDlgItemText(HWindow,dl_EdObjW,F);
    end;
    if GetDlgItemText(HWindow,dl_EdObjH,F,10)=0 then
    begin
      i:=SendDlgItemMsg(dl_EdObjHUnits,cb_GetCurSel,0,0)+1;
      r:=Height/Units[i].F;
      Str(r:30:12,tmp); ChrDelL(tmp,' '); ChrDelR(tmp,'0');
      StrPCopy(F,tmp); SetDlgItemText(HWindow,dl_EdObjH,F);
    end;
  end;
end;                  { TEditObjectDlg.UploadDimen }

procedure TEditObjectDlg.CopyBtn(var Msg: TMessage);
begin
  if (VisualWnd=Nil) or (PTestObject(VisualWnd)^.Obj=Nil)
      or not PTestObject(VisualWnd)^.Obj^.ok then Exit;
  PTestObject(VisualWnd)^.Obj^.CopyToClip(HWindow);
end;

procedure TEditObjectDlg.EmbedImage(DIB: THandle; M: LPPictInfo);
var
  ImgName   : PChar;
  TempHandle: THandle;
  TempStream: PHugeMemStream;
  Size,NewSize: longint;
  ImgOffset : word;
  ImgVer    : TObjBinVersion;
  ImgFlags  : TObjBinFlags;
  Compress,IsMeta: boolean;
begin
  { Find object, init }
  if not Image then Exit;
  if (DIB=0) and ((M=Nil) or (M^.hMF=0)) then
  begin
    messagebeep(0); Exit;
  end;
  IsMeta:=(DIB=0);
  GetMem(ImgName,256); TempHandle:=0;

  { Get new name }
  ImgName[0]:=#0;
  if (Application^.ExecDialog(New(PObjectNameDlg,
              init(@Self,true,ImgName,255,BinList)))<>id_ok)
     or (StrLen(ImgName)<3) then
  begin
    FreeMem(ImgName,256); Exit;
  end;

  if IsMeta then TempHandle:=GetMetafileBits(M^.hmf)
  else TempHandle:=DIB;
  if TempHandle=0 then
  begin
    FreeMem(ImgName,256); Exit;
  end;
  Size:=GlobalSize(TempHandle);
{  message(num2str(Size));}
  { Set various quantities }
  ImgOffset:=sizeof(ImgVer)+sizeof(ImgFlags)+sizeof(Size)+sizeof(ImgOffset);

  ImgVer:=ImgBin_Version; ImgFlags:=0;
  if IsMeta then
  begin
    ImgFlags:=ImgFlags or ImgBin_Metafile;
    ImgOffset:=ImgOffset+sizeof(LPictInfo);
  end;
  if CompressImages {and
     ( (Itype=GrExt_None) or (not IntGraphList[Itype].Compressed) )} then
      ImgFlags:=ImgFlags or ObjBin_Compressed;
       
  { Init a new binary object }
  if BinObject<>Nil then Dispose(BinObject,Done);
  New(BinObject,Init(StrPas(ImgName),ImgOffset+Size+10,BinTyp_Image,0));
  BinObject^.P^.seek(0);

  { Store header }
  BinObject^.P^.write(ImgOffset,sizeof(word));
  BinObject^.P^.write(Size,     sizeof(longint));
  BinObject^.P^.write(ImgVer,   sizeof(ImgVer));
  BinObject^.P^.write(ImgFlags, sizeof(ImgFlags));
  if IsMeta then BinObject^.P^.write(M^,sizeof(LPictInfo));

  { Use the memory handle as a stream }
  New(TempStream,InitExt(TempHandle,GlobalSize(TempHandle),false));
  TempStream^.seek(0);
  if ImgFlags and ObjBin_Compressed = 0 then    { Uncompressed }
    BinObject^.P^.CopyFrom(TempStream^,Size)
  else begin
    LZInpStr:=TempStream; LZOutStr:=BinObject^.P;
    LZInit;
    LzSquash(LZReadProc,LzWriteProc);
    LzDone;
    NewSize:=BinObject^.P^.GetSize-ImgOffset;
    {
    message('Size = '+num2str(Size)
      +', compressed to '+num2str(MulDiv(NewSize,100,Size))
      +'% ('+num2str(NewSize)+' bytes)');
    }
  end;
  Dispose(TempStream,Done);
  if IsMeta then M^.hmf:=SetMetafileBits(TempHandle);

  SetDlgItemText(HWindow,dl_EdObjFile, ImgName);
  Embedded:=true;
  if VisualWnd<>Nil then
  begin
    SendMessage(VisualWnd^.HWindow,toc_Upload,  0,0);
    SendMessage(VisualWnd^.HWindow,toc_Download,0,0);
  end;
  Update;
  SetFocus(HWindow);
end;            { TEditObjectDlg.EmbedImage }

procedure TEditObjectDlg.EmbedBtn(var Msg: TMessage);
var
  ImgName   : PChar;
  O         : POleObj;
begin
  { Find object, init }
  if not Image then Exit;
  if (VisualWnd=Nil) or (PTestObject(VisualWnd)^.Obj=Nil)
      or not PTestObject(VisualWnd)^.Obj^.ok  then Exit;
  O:=PTestObject(VisualWnd)^.Obj;
  if (O^.DIB=0) and (O^.Metafile.hmf=0) then
  begin
    messagebeep(0); Exit;
  end;

  { Get image name }
  GetMem(ImgName,256);
  if (GetDlgItemText(HWindow,dl_EdObjFile,ImgName,255)=0)
     or (not IsFileName(StrPas(ImgName))) then
  begin
    FreeMem(ImgName,256); messagebeep(0); Exit;
  end;
  FreeMem(ImgName,256);

  if O^.Metafile.hmf<>0 then EmbedImage(0,@O^.Metafile)
  else                       EmbedImage(O^.DIB,Nil);
end;            { TEditObjectDlg.EmbedBtn }

procedure TEditObjectDlg.PasteImage;
var
  HasMeta,HasDSPMeta,HasDIB,HasBitmap,HasDSPBitmap: boolean;
  NewDIB,MF: THandle;
  NewMeta: LPictInfo;
  BInfo: PBitmapInfo;
  ClipBitmap: HBitmap;
  ClipMeta: PMetafilePict;
  Fact: real;
  ClipFormat: word;
  Found: boolean;
begin
  HasMeta:=false; HasDspMeta:=false;
  HasDIB:=false; HasBitmap:=false; HasDSPBitmap:=false;
  OpenClipboard(HWindow);
  ClipFormat:=EnumClipboardFormats(0); Found:=false;
  while (ClipFormat<>0) and not Found do
  begin
    Found:=true;
    if      ClipFormat=CF_MetafilePict    then HasMeta:=true
    else if ClipFormat=CF_DSPMetafilePict then HasDSPMeta:=true
    else if ClipFormat=CF_DIB             then HasDIB:=true
    else if ClipFormat=CF_Bitmap          then HasBitmap:=true
    else if ClipFormat=CF_DSPBitmap       then HasDSPBitmap:=true
    else Found:=false;
    ClipFormat:=EnumClipboardFormats(ClipFormat);
  end;
  if not Found then
  begin
    CloseClipboard; Exit;
  end;

  NewDIB:=0; NewMeta.hMF:=0;

  if HasMeta or HasDSPMeta then
  begin
    if HasMeta then MF:=GetClipboardData(CF_MetafilePict)
    else MF:=GetClipboardData(CF_DSPMetafilePict);
    ClipMeta:=GlobalLock(MF);
    with ClipMeta^ do
    begin
      NewMeta.hmf:=hmf;
      { Dimensions }
      with NewMeta.bbox do
      begin
        left:=0; top:=0; right:=(xExt); bottom:=(yExt);
        if ((right=0) or (bottom=0)) and (mm<>mm_Isotropic)
           and (mm<>mm_AnIsotropic) then mm:=mm_Isotropic;
        if right=0 then right:=100; if bottom=0 then bottom:=100;
      end;
      if mm<>mm_Text then
      begin
        Fact:=0;
        case mm of
          mm_HiEnglish  : Fact:=0.001;
          mm_LoEnglish  : Fact:=0.01;
          mm_HiMetric   : Fact:=1.0/Units[InUnits].F;
          mm_LoMetric   : Fact:=10.0/Units[InUnits].F;
          mm_Twips      : Fact:=1.0/1440.0;
          mm_Isotropic  : Fact:=1.0/Units[InUnits].F;
          mm_AnIsotropic: Fact:=1.0/Units[InUnits].F;
        end;
        if Fact<>0 then
        with NewMeta.bbox do
        begin
          right :=round(Fact*right*ScreenResX);
          bottom:=round(Fact*bottom*ScreenResy);
{          message(num2str(Right)+'x'+num2str(bottom));}
        end;
      end;
    end;
    GlobalUnlock(MF);
    if NewMeta.hMF<>0 then EmbedImage(0,@NewMeta);
{    message('Copied metafile');}
  end else if HasDIB then                          { DIB }
  begin
    NewDIB:=GetClipboardData(CF_DIB);
{    message('Copied DIB');}
  end else if HasDSPBitmap or HasBitmap then       { Device-dependent itmap }
  begin
{    message('Copied bitmap');}
    if HasBitmap  then ClipBitmap:=HBitmap(GetClipboardData(CF_Bitmap))
    else               ClipBitmap:=HBitmap(GetClipboardData(CF_DSPBitmap));
    { Retrieve bitmap in DIB form }
    NewDIB:=BitmapToDIB(ClipBitmap);
  end;
  if NewDIB<>0 then
  begin
    EmbedImage(NewDIB,Nil);
    if not HasDIB then GlobalFree(NewDIB);
  end;
  CloseClipboard;
end;                       { TEditObjectDlg.PasteImage }

procedure TEditObjectDlg.PasteObject;
label
  Term;
var
  ObjName: PChar;
  Obj: POleObject;
  Stat: TOleStatus;
  Client: TOleClient;
begin
  if not IsClipEmbeddedObj then Exit;
  Obj:=Nil; ObjName:=Nil;

  { Get object name }
  GetMem(ObjName,256);
  GetDlgItemText(HWindow,dl_EdObjFile,ObjName,255);
  if ObjName[0]<>'<' then ObjName[0]:=#0;
  if Application^.ExecDialog(New(PObjectNameDlg,
              init(@Self,false,ObjName,255,BinList)))<>id_ok then goto Term;

  { Get object from clipboard }
  OpenClipboard(HWindow);
  Client.lpvtbl:=@OleClientVTbl;
  Stat:=OleCreateFromClip(OleProtocol,@Client,ClientDoc,ObjName,Obj,
                          OleRender_draw,0);
  CloseClipboard;
  if OleCheck(HWindow,Obj,Stat)<>Ole_Ok then goto Term;

  EmbedObject(Obj,ObjName);

Term:
  if Obj  <>Nil then OleCheck(0,Obj,OleDelete(Obj));
  FreeMem(ObjName,256);
end;                    { TEditObjectDlg.PasteObject }

procedure TEditObjectDlg.EmbedObject(Obj: POleObject; ObjName: PChar);
label
  Term;
var
  Class,Part,P: PChar;
  T: THandle;
  Stat: TOleStatus;
  OleStream: TOleStreamExt;
  Size,NewSize: longint;
  ObjOffset: word;
  ObjVer   : TObjBinVersion;
  ObjFlags : TObjBinFlags;
begin
  if Image or (Obj=Nil) or (ObjName=Nil) or (ObjName[0]=#0) then Exit;
  Class:=Nil; GetMem(Part,256); Part[0]:=#0;

  { Extract class and item descriptions }
  Stat:=OleCheck(HWindow,Obj,OleGetData(Obj,CFOwnerLink,T));
  if (Stat<>Ole_ok) and (Stat<>Ole_Warn_Delete_Data) then goto Term;
  P:=GlobalLock(T);
  Class:=StrNew(P);
  P:=P+StrLen(P)+1; P:=P+StrLen(P)+1;
  StrLCat(Part,P,255);
  GlobalUnlock(T);
  if Stat=Ole_Warn_Delete_Data then GlobalFree(T);

{
  message(StrPas(Class));
  if Part=Nil then message('NIL') else message(StrPas(Part));
}

  { Initialize binary object and stream parameters }
  if BinObject<>Nil then Dispose(BinObject,Done);
  ObjOffset:=sizeof(ObjVer)+sizeof(ObjFlags)+sizeof(longint)
             +StrLen(Class)+StrLen(Part)+2+sizeof(ObjOffset);

  ObjVer:=ObjBin_Version; ObjFlags:=0;
  OleCheck(0,Obj,OleQuerySize(Obj,Size));
  OleStream.lpstbl:=@OleStreamVTbl;
  OleStream.Strm  :=Nil;
  if CompressObjects then
  begin
    OleStream.Strm:=New(PHugeMemStream,Init(Size));
    OleCheck(HWindow,Obj,OleSaveToStream(Obj,POleStream(@OleStream)));
    ObjFlags:=ObjFlags or ObjBin_Compressed;
  end;
  New(BinObject,Init(StrPas(ObjName),ObjOffset+Size+10,BinTyp_Object,0));
  BinObject^.P^.seek(0);

  { Store header, Class and Item }
  BinObject^.P^.write(ObjOffset,sizeof(word));
  BinObject^.P^.write(Size,     sizeof(longint));
  BinObject^.P^.write(ObjVer,   sizeof(ObjVer));
  BinObject^.P^.write(ObjFlags, sizeof(ObjFlags));
  BinObject^.P^.write(Class^,   StrLen(Class)+1);
  BinObject^.P^.write(Part^,    StrLen(Part)+1);

  { Store object }
  if not CompressObjects then   { Uncompressed }
  begin
    OleStream.Strm:=BinObject^.P;
    OleCheck(HWindow,Obj,OleSaveToStream(Obj,POleStream(@OleStream)));
  end else                      { Compressed   }
  begin
    OleStream.Strm^.seek(0);
    LzInpStr:=OleStream.Strm; LzOutStr:=BinObject^.P;
{    message('Old size = '+num2str(LZInpStr^.GetSize));}
    LZInit;
    LzSquash(LZReadProc,LzWriteProc);
    LzDone;
    NewSize:=BinObject^.P^.GetPos;
    {
    message('Size = '+num2str(Size)
      +', compressed to '+num2str(MulDiv(NewSize,100,Size))
      +'% ('+num2str(NewSize)+' bytes)');
    }
    Dispose(OleStream.Strm,Done);
  end;

  { Update dialog fields }
  SetDlgItemText(HWindow,dl_EdObjFile, ObjName);
  SetDlgItemText(HWindow,dl_EdObjClass,Class);
  SetDlgItemText(HWindow,dl_EdObjPart, Part);
  Embedded:=true;
  CheckDlgButton(HWindow,dl_EdObjIconizeCBox,bf_Checked);
  if VisualWnd<>Nil then
  begin
    SendMessage(VisualWnd^.HWindow,toc_Upload,  0,0);
    SendMessage(VisualWnd^.HWindow,toc_Download,0,0);
  end;
  Update;

Term:
  if Part <>Nil then FreeMem(Part,256);
  if Class<>Nil then StrDispose(Class);
  SetFocus(HWindow);
end;                    { TEditObjectDlg.EmbedObject }

procedure TEditObjectDlg.PasteBtn(var Msg: TMessage);
begin
  if Image then PasteImage else PasteObject;
end;

procedure TEditObjectDlg.PasteLnkBtn(var Msg: TMessage);
var
  Class: PChar;
  HasLink,HasEmbedded: boolean;
  T: THandle;
  P,P2: PChar;
  DefClass: array[0..127] of char;
  len: longint;
begin
  if not IsClipLinkedObj then Exit;
  Class:=Nil;
  OpenClipboard(HWindow);
  T:=GetClipboardData(CFObjectLink);
  P:=GlobalLock(T);
  Class:=StrNew(P);
  P:=P+StrLen(P)+1;
  if not LFNFileExist(StrPas(P)) then
  begin
    ErrorMessageRC(Str_ClipboardEmpty,'');
    if Class<>Nil then StrDispose(Class);
    GlobalUnlock(T); CloseClipboard;
    Exit;
  end;
  SetDlgItemText(HWindow,dl_EdObjFile,P);
  { Find default class }
  P2:=P+StrLen(P);
  while (P2>P) and (P2^<>'.') do dec(P2);
  if P2^='.' then
  begin
    len:=127;
    if (RegQueryValue(hKey_Classes_Root,P2,DefClass,len)=Error_Success)
      and (StrIComp(DefClass,Class)=0) then
    begin
      StrDispose(Class); Class:=Nil;
    end;
  end;
  P:=P+StrLen(P)+1;
  SetDlgItemText(HWindow,dl_EdObjPart,P);
  GlobalUnlock(T);
  CloseClipboard;

  if Class<>Nil then
  begin
    SetDlgItemText(HWindow,dl_EdObjClass,Class);
    StrDispose(Class);
  end;
  Embedded:=false;
  if BinObject<>Nil then Dispose(BinObject,Done); BinObject:=Nil;
  CheckDlgButton(HWindow,dl_EdObjIconizeCBox,bf_Checked);
  if VisualWnd<>Nil then
  begin
    SendMessage(VisualWnd^.HWindow,toc_Upload,  0,0);
    SendMessage(VisualWnd^.HWindow,toc_Download,0,0);
  end;
  SetFocus(HWindow);
end;                { TEditObjectDlg.PasteLinkBtn }

procedure TEditObjectDlg.TestBtn(var Msg: TMessage);
begin          { TEditObjectDlg.TestBtn }
  {if not Image then}
  begin
    WaitingMessage('Resolving...');
    SendMessage(VisualWnd^.HWindow,toc_Upload,0,0);
    WaitingOff;
  end;
  SetFocus(HWindow);
end;         { TEditObjectDlg.TestBtn }

procedure TEditObjectDlg.ActivateBtn(var Msg: TMessage);
begin
  if Image or (PTestObject(VisualWnd)^.Obj=Nil) then Exit;
  PTestObject(VisualWnd)^.Obj^.Activate(@Self,Nil);
end;

procedure TEditObjectDlg.InsertBtn(var Msg: TMessage);
label
  Term;
var
  Class: PChar;
  Obj: POleObject;
  ObjName: PChar;
  Stat: TOleStatus;
  Client: TOleClientExt;
begin
  if Image then Exit;
  GetMem(Class,256); Obj:=Nil; ObjName:=Nil;
  if Application^.ExecDialog(New(PInsObjDlg,init(@Self,Class,255)))<>id_ok then
    goto Term;

  GetMem(ObjName,256);
  GetDlgItemText(HWindow,dl_EdObjFile,ObjName,255);
  if ObjName[0]<>'<' then ObjName[0]:=#0;
  if Application^.ExecDialog(New(PObjectNameDlg,
              init(@Self,false,ObjName,255,BinList)))<>id_ok then goto Term;
  Client.lpvtbl:=@OleClientVTbl; Client.H:=HWindow; Client.Closed:=false;
  Stat:=OleCreate(OleProtocol,POleClient(@Client),Class,ClientDoc,ObjName,Obj,
                          OleRender_draw,CFNative);
  if OleCheck(HWindow,Obj,Stat)<>Ole_Ok then goto Term;
  OleWaitUntilClosed(@Client);
  WaitingMessage('Insert object...');
  EmbedObject(Obj,ObjName);

Term:
  WaitingOff;
  if Obj    <>Nil then OleCheck(0,Obj,OleDelete(Obj));
  if Class  <>Nil then FreeMem(Class,256);
  if ObjName<>Nil then FreeMem(ObjName,256);
end;                   { TEditObjectDlg.InsertBtn }

procedure TEditObjectDlg.ClassBtn(var Msg: TMessage);
var
  T: THandle;
  P: PChar;
  ClearData: boolean;
begin
  if Image or Embedded or (PTestObject(VisualWnd)^.Obj=Nil) then Exit;
  GetMem(P,256);
  PTestObject(VisualWnd)^.Obj^.GetObjClass(P,255);
  SetDlgItemText(HWindow,dl_EdObjClass,P);
  FreeMem(P,256);
  {
  ClearData:=OleGetData(PTestObject(VisualWnd)^.Obj^.O,cfObjectLink,T)
             =Ole_Warn_Delete_Data;
  P:=GlobalLock(T);
  SetDlgItemText(HWindow,dl_EdObjClass,P);
  GlobalUnlock(T);
  if ClearData then GlobalFree(T);
  }
end;              { TEditObjectDlg.ClassBtn }

function TEditObjectDlg.CanClose: boolean;
var
  F: array[0..31] of char;

function CheckNum(CBoxID,EBoxID: integer; EmptyOk: boolean): boolean;
var
  i: integer; r: real;
begin
  CheckNum:=false; 
  if IsDlgButtonChecked(HWindow,CBoxID)=bf_Checked then
  begin
    if GetDlgItemText(HWindow,EBoxID,F,31)=0 then
    begin
      if EmptyOk then CheckNum:=true
      else begin
        messagebeep(0); SetFocus(GetItemHandle(EBoxID));
      end;
      Exit;
    end;
    Val(StrPas(F),r,i); if i<>0 then
    begin
      messagebeep(0); SetFocus(GetItemHandle(EBoxID));
      Exit;
    end;
  end;
  CheckNum:=true;
end;           { CheckNum }

begin          { TEditObjectDlg.CanClose }
  CanClose:=false;
  if not TBasicDialog.CanClose then Exit;
  if GetDlgItemText(HWindow,dl_EdObjFile,F,2)=0 then
  begin
    messagebeep(0); SetFocus(GetItemHandle(dl_EdObjFile));
    Exit;
  end;
  if not CheckNum(dl_EdObjWCustom,dl_EdObjW,false) then Exit;
  if not CheckNum(dl_EdObjHCustom,dl_EdObjH,false) then Exit;
  if not CheckNum(dl_EdObjBCustom,dl_EdObjBase,true) then Exit;
  CanClose:=true;
end;          { TEditObjectDlg.CanClose }

procedure TEditObjectDlg.ok(var Msg: TMessage);
var
  P0,P,Pstart,F: PChar;
  i: integer;
  r: real;
  flip: string[2];

function GetNum(CBoxId,EBoxID,UnitID: integer; ch: char): boolean;
var
  i: integer;
  F2: array[0..10] of char;
begin
  GetNum:=false;
  if (IsDlgButtonChecked(HWindow,CBoxID)=bf_Checked) and
    (GetDlgItemText(HWindow,EBoxID,F,127)>0) then
  begin
    i:=SendDlgItemMsg(UnitID,cb_GetCurSel,0,0)+1;
    StrPCopy(F2,', '+ch+'='); StrCat(P,F2); StrCat(P,F);
    StrPcopy(F,Units[i].U); StrCat(P,F);
    GetNum:=true;
  end;
end;              { GetNum }

procedure PutStr(pre: PChar; id,MaxLen: integer);
var
  quote: boolean;
begin
  if GetDlgItemText(HWindow,id,F,MaxLen)>0 then
  begin
    quote:=(StrScan(F,' ')<>Nil) or (StrScan(F,',')<>Nil) or
           (StrScan(F,'=')<>Nil);
    StrCat(P,pre);
    if quote then StrCat(P,'"'); StrCat(P,F); if quote then StrCat(P,'"');
  end;
end;              { PutStr }

begin             { TEditObjectDlg.ok }
  if not CanClose then Exit;
  GetMem(F,256);
  GetMem(P0,2048); P:=P0;
  if LeadingWhite then
  begin
    if Image then StrPCopy(P,' '+ImageTeXMacro^+lbrace)
    else StrPCopy(P,' '+ObjectTeXMacro^+lbrace);
  end else
  begin
    if Image then StrPCopy(P,ImageTeXMacro^+lbrace)
    else StrPCopy(P,ObjectTeXMacro^+lbrace);
  end;
  Pstart:=P;

  PutStr('',dl_EdObjFile,255);
  if not (Image or Embedded) then
  begin
    PutStr(', C=',dl_EdObjClass,255);
    PutStr(', P=',dl_EdObjPart, 255);
  end;

  GetNum(dl_EdObjWCustom,dl_EdObjW,dl_EdObjWUnits,'W');
  GetNum(dl_EdObjHCustom,dl_EdObjH,dl_EdObjHUnits,'H');

  if IsDlgButtonChecked(HWindow,dl_EdObjLeft)=bf_Checked then
    StrCat(P,', A=L')
  else if IsDlgButtonChecked(HWindow,dl_EdObjRight)=bf_Checked then
    StrCat(P,', A=R')
  else if IsDlgButtonChecked(HWindow,dl_EdObjCenter)=bf_Checked then
    StrCat(P,', A=C')
  else begin
    if IsDlgButtonChecked(HWindow,dl_EdObjTop)=bf_Checked then
      StrCat(P,', A=T')
    else if IsDlgButtonChecked(HWindow,dl_EdObjMid)=bf_Checked then
      StrCat(P,', A=M')
    else begin
      r:=1;
      GetDlgItemText(HWindow,dl_EdObjBase,F,255);
      if F[0]<>#0 then
      begin
        Val(StrPas(F),r,i); if i<>0 then r:=1;
      end; 
      if r<>0 then GetNum(dl_EdObjBCustom,dl_EdObjBase,dl_EdObjBUnits,'A');
    end;
  end;
  Flip:='';
  if IsDlgButtonChecked(HWindow,dl_EdObjWFlip)=bf_Checked then Flip:='H';
  if IsDlgButtonChecked(HWindow,dl_EdObjHFlip)=bf_Checked then Flip:=Flip+'V';
  if Flip<>'' then
  begin
    StrPCopy(F,', FL='+Flip); StrCat(P,F);
  end;

  if (not Image) and
    (IsDlgButtonChecked(HWindow,dl_EdObjIconizeCBox)=bf_Unchecked) then StrCat(P,', I=0');

  StrCat(P,rbrace);
  if (GetDlgItemText(HWindow,dl_EdObjTitle,F,255)>0) then
  begin
    StrCat(P,'['); StrCat(P,F); StrCat(P,']');
  end;
  if TrailingWhite then StrCat(P,' ');

  if selected then BasicEBox^.SetSelection(StartPos,EndPos);
  BasicEBox^.Insert(P0);

  { Embedded objects binary data }
  if Embedded and (BinObject<>Nil) and BinObject^.IsOk then
  begin
    BinList^.FreeName(OrigName);
    BinList^.Insert(BinObject);
    {
    if BinList^.Search(BinList^.KeyOf(BinObject),i) then
      message('Saved "'+PBinObject(BinList^.at(i))^.Name+'"')
    else message('Problem saving');
    }
    BinObject:=Nil;
  end;

  FreeMem(P0,2048);
  FreeMem(F,256);
  EndDlg(id_ok);
end;             { TEditObjectDlg.ok }

destructor TEditObjectDlg.Done;
begin
  if VisualWnd<>Nil then Dispose(VisualWnd,Done);
  if BinObject<>Nil then Dispose(BinObject,Done);
  if OrigName <>Nil then DisposeStr(OrigName);
  EditBoxes.Done;
  TBasicDialog.Done;
end;                 { TEditObjectDlg.Done }

{------------------------------------------------------------}

procedure CleanupBinList(Entry: EntryRecPtr);
type
  TSRec = record
    S: PString;
    typ: word;
  end;
var
  i,j,ifld,FoundInd,NumObjects: integer;
  P,P2,F,SrchStr,PSlash: PChar;
  Ptmp: PString;
  BinObject: PBinObject;
  SrchArr: array[1..2] of TSRec; 
begin
  with Entry^ do
  begin
    if EditOnlyStrings or (nentry=0) or (BinList=Nil) or (BinList^.Count=0) then Exit;
    GetMem(F,256); GetMem(SrchStr,256); New(Ptmp);
    SrchArr[1].S:=ObjectTeXMacro; SrchArr[1].typ:=BinTyp_Object;
    SrchArr[2].S:=ImageTeXMacro;  SrchArr[2].typ:=BinTyp_Image;
    for i:=0 to BinList^.Count-1 do PBinObject(BinList^.at(i))^.Mark:=0;
    NumObjects:=0;
    for j:=1 to 2 do
    begin
      StrPCopy(SrchStr,SrchArr[j].S^+lbrace);
      for i:=1 to LastField do
      if (index[i]>0) and (Content[index[i]]<>'') then 
      begin
        ifld:=0;
        if BigIndex[i]=0 then
        begin
          StrPCopy(F,Content[Index[i]]); P:=F;
        end else
        begin
          P:=PChar(Big[BigIndex[i]]); P[Blen[BigIndex[i]]]:=#0;
        end;
        P:=StrPos(P,SrchStr);
        while (P<>Nil) and (P^<>#0) do
        begin
          P:=P+StrLen(SrchStr); while  P^=' ' do inc(P);
          if P^='<' then    { Possible embedded object }
          begin
            inc(P); P2:=P;
            while (P2^<>'>') and (P2^<>rbrace) and (P2^<>#0) do inc(P2);
            if (P2^='>') and (P2-P>0) and (P2-P<250) then    { Bingo! }
            begin
              Move(P^,Ptmp^[1],P2-P); Ptmp^[0]:=Chr(P2-P);
              BinObject:=PBinObject(BinList^.FindName(Ptmp,SrchArr[j].typ));
              if BinObject<>Nil then
              begin
{                message('Found "'+Ptmp^+'", exists');}
                BinObject^.Mark:=i;
                inc(NumObjects);
              end{ else message('Found "'+Ptmp^+'", doesn''t exist')};
            end;
            P:=P2;
          end;
          P:=StrPos(P,SrchStr);
        end;
      end;
    end;
    Dispose(Ptmp); FreeMem(SrchStr,256); FreeMem(F,256);
    i:=0;
    if NumObjects=0 then BinList^.FreeAll
    else while i<BinList^.Count do
      if PBinObject(BinList^.at(i))^.Mark=0 then BinList^.AtFree(i)
      else inc(i);
  end;
end;                { CleanupBinList }

end.
