#ifndef lint
static char *RCSid = "$Header: dist.c,v 1.10 89/10/16 20:24:19 mr-frog Exp $";
#endif /* not lint */

/*
 * dist.c
 *
 * name distribution sector (by a pathname) for a given
 * range of sectors (individually)
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "nsc.h"
#include "nat.h"
#include "file.h"
#include "path.h"

/*
 * distribute <SECT> <PATH>
 */
dist()
{
	extern	s_char *argp[];
	extern	int aborted;
	struct	sctstr sect;
	struct	nstr_sect nstr;
	s_char	*path;
	coord	dstx;
	coord	dsty;

	if (!snxtsct(&nstr, argp[1]))
		return RET_SYN;
	if (argp[2] != 0) {
		/*
		 *  Don't allow specifying a path over a range of
		 *  sectors, since this will almost always be a mistake.
		 */
		if (index(argp[1], ',') == 0 || index(argp[1], ':') != 0) {
			pr("It's too dangerous to do that!\n");
			return RET_SYN;
		}
	}
	while (!aborted && nxtsct(&nstr, &sect)) {
		if (!owner)
			continue;
		path = masktopath(sect.sct_distpath);
		pr(fmt("%s at %s ", dchr[sect.sct_type].d_name,
			xyas(nstr.x, nstr.y, cnum)));
		if (*path != 0) {
			dstx = nstr.x;
			dsty = nstr.y;
			(void) pathtoxy(path, &dstx, &dsty, mcost);
			getsect(dstx, dsty, &sect);
			if (sect.sct_own != cnum)
				pr(fmt("distributes to %s, not owned by you. ",
					xyas(dstx, dsty, cnum)));
			else
				pr(fmt("distributes to %s. ",
					xyas(dstx, dsty, cnum)));
		} else
			pr("has no dist sector. ");
		if ((path = getpath(argp[2], nstr.x, nstr.y, 0, 0, 0)) == 0)
			continue;
		if ((strlen(path) > 10) && (path[10] != 'h')) {
			pr("Path too long!\n");
			continue;
		}
		if (chkpath(cnum, path, nstr.x, nstr.y) == 0)
			pr("Warning: dist path not fully yours\n");
		dstx = nstr.x;
		dsty = nstr.y;
		(void) pathtoxy(path, &dstx, &dsty, mcost);
		if ((dstx == nstr.x) && (dsty == nstr.y)) {
			pr(fmt("Distribution from and to %s terminated\n",
					xyas(nstr.x, nstr.y, cnum)));
			getsect(nstr.x, nstr.y, &sect);
			sect.sct_distpath = pathtomask("h");
		} else {
			pr(fmt("New path distributes to %s\n", 
					xyas(dstx, dsty, cnum)));
			getsect(dstx, dsty, &sect);
			if (sect.sct_own == cnum && sect.sct_type != SCT_WAREH)
				pr(fmt("Warning: sector %s not a warehouse!\n",
					xyas(dstx, dsty, cnum)));
			getsect(nstr.x, nstr.y, &sect);
			sect.sct_distpath = pathtomask(path);
		}
		putsect(&sect);
	}
	return RET_OK;
}
