#ifndef lint
static char *RCSid = "$Header: dump.c,v 1.7 89/12/01 20:52:36 mr-frog Exp $";
#endif

/*
 * dump.c
 *
 * dump sector information (census, commodity, cutoff and level)
 *
 * Jeff Wallace (jeffw@scam.Berkeley.EDU) 02-23-89
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "nsc.h"
#include "nat.h"
#include "deity.h"
#include "path.h"
#include "file.h"


dump()
{
	extern	s_char *argp[];
	struct	sctstr sect;
	s_char	dirstr[20];
	int	nsect;
	int	n;
	struct	nstr_sect nstr;
	s_char	*path;
	coord	dstx;
	coord	dsty;
	int     del[I_MAX+1];
        int     dist[I_MAX+1];
        int     item[I_MAX+1];

	if (!snxtsct(&nstr, argp[1]))
		return RET_SYN;
	prdate();
	(void) strcpy(dirstr, ".      $");
	n = 1;
	for (n = 1; n <= 6; n++)
		dirstr[n] = dirch[n];
	nsect = 0;
	while (nxtsct(&nstr, &sect)) {
		if (!owner)
			continue;
		if (nsect++ == 0) {
			if (god)
				pr("   ");
			pr("DUMP SECTOR\n");
			if (god)
				pr("own ");
			pr("x y des sdes eff mob * ");
			pr("min gold fert ocontent uran work avail terr ");
			pr("civ mil uw food shell gun pet iron ");
			pr("dust bar oil lcm hcm rad ");
			pr("u_del f_del s_del g_del p_del i_del ");
			pr("d_del b_del o_del l_del h_del r_del ");
			pr("u_cut f_cut s_cut g_cut p_cut i_cut ");
			pr("d_cut b_cut o_cut l_cut h_cut r_cut ");
			pr("dist_path dist_x dist_y ");
			pr("u_dist f_dist s_dist g_dist p_dist i_dist ");
			pr("d_dist b_dist o_dist l_dist h_dist r_dist\n");
		}
/* census */
		dstx = nstr.x;
		dsty = nstr.y;
		if (god)
			pr(fmt("%d ", sect.sct_own));
		getvec(VT_DEL, del, (s_char *)&sect, EF_SECTOR);
                getvec(VT_DIST, dist, (s_char *)&sect, EF_SECTOR);
                getvec(VT_ITEM, item, (s_char *)&sect, EF_SECTOR);
		pr(xyfmt("%d %d ", nstr.x, nstr.y, cnum));
		pr(fmt("%c ", dchr[sect.sct_type].d_mnem));
		if (sect.sct_newtype != sect.sct_type)
			pr(fmt("%c ", dchr[sect.sct_newtype].d_mnem));
		else
			pr("_ ");
		pr(fmt("%d ", sect.sct_effic));
		pr(fmt("%d ", sect.sct_mobil));
		pr(fmt("%c ", sect.sct_own != sect.sct_oldown ? '*' : '.'));
		pr(fmt("%d ", sect.sct_min));
		pr(fmt("%d ", sect.sct_gmin));
		pr(fmt("%d ", sect.sct_fertil));
		pr(fmt("%d ", sect.sct_oil));
		pr(fmt("%d ", sect.sct_uran));
		pr(fmt("%d ", sect.sct_work));
		pr(fmt("%d ", sect.sct_avail));
	    	pr(fmt("%d ", sect.sct_terr));
		pr(fmt("%d ", item[I_CIVIL]));
		pr(fmt("%d ", item[I_MILIT]));
		pr(fmt("%d ", item[I_UW]));
		pr(fmt("%d ", item[I_FOOD]));
/* commodity */
		pr(fmt("%d ", item[I_SHELL]));
		pr(fmt("%d ", item[I_GUN]));
		pr(fmt("%d ", item[I_PETROL]));
		pr(fmt("%d ", item[I_IRON]));
		pr(fmt("%d ", item[I_DUST]));
		pr(fmt("%d ", item[I_BAR]));
		pr(fmt("%d ", item[I_OIL]));
		pr(fmt("%d ", item[I_LCM]));
		pr(fmt("%d ", item[I_HCM]));
		pr(fmt("%d ", item[I_RAD]));
/* cutoff */
                pr(fmt("%c ", dirstr[del[I_UW] & 0x7]));
                pr(fmt("%c ", dirstr[del[I_FOOD] & 0x7]));
                pr(fmt("%c ", dirstr[del[I_SHELL] & 0x7]));
                pr(fmt("%c ", dirstr[del[I_GUN] & 0x7]));
		pr(fmt("%c ", dirstr[del[I_PETROL] & 0x7]));
                pr(fmt("%c ", dirstr[del[I_IRON] & 0x7]));
                pr(fmt("%c ", dirstr[del[I_DUST] & 0x7]));
                pr(fmt("%c ", dirstr[del[I_BAR] & 0x7]));
                pr(fmt("%c ", dirstr[del[I_OIL] & 0x7]));
                pr(fmt("%c ", dirstr[del[I_LCM] & 0x7]));
                pr(fmt("%c ", dirstr[del[I_HCM] & 0x7]));
                pr(fmt("%c ", dirstr[del[I_RAD] & 0x7]));
                pr(fmt("%d ", del[I_UW] & ~0x7));
                pr(fmt("%d ", del[I_FOOD] & ~0x7));
                pr(fmt("%d ", del[I_SHELL] & ~0x7));
                pr(fmt("%d ", del[I_GUN] & ~0x7));
                pr(fmt("%d ", del[I_PETROL] & ~0x7));
                pr(fmt("%d ", del[I_IRON] & ~0x7));
                pr(fmt("%d ", del[I_DUST] & ~0x7));
                pr(fmt("%d ", del[I_BAR] & ~0x7));
                pr(fmt("%d ", del[I_OIL] & ~0x7));
                pr(fmt("%d ", del[I_LCM] & ~0x7));
                pr(fmt("%d ", del[I_HCM] & ~0x7));
                pr(fmt("%d ", del[I_RAD] & ~0x7));
/* level */
		path = masktopath(sect.sct_distpath);
		(void) pathtoxy(path, &dstx, &dsty, mcost);
		if (*path)
			pr(fmt("%s %s ",path,xyfmt("%d %d", dstx, dsty, cnum)));
		else
			pr(fmt("%s %s ","_",xyfmt("%d %d", dstx, dsty, cnum)));
                pr(fmt("%d ", dist[I_UW]));
                pr(fmt("%d ", dist[I_FOOD]));
                pr(fmt("%d ", dist[I_SHELL]));
                pr(fmt("%d ", dist[I_GUN]));
                pr(fmt("%d ", dist[I_PETROL]));
                pr(fmt("%d ", dist[I_IRON]));
                pr(fmt("%d ", dist[I_DUST]));
                pr(fmt("%d ", dist[I_BAR]));
                pr(fmt("%d ", dist[I_OIL]));
                pr(fmt("%d ", dist[I_LCM]));
                pr(fmt("%d ", dist[I_HCM]));
                pr(fmt("%d", dist[I_RAD]));
		pr("\n");
	}
	pr(fmt("    %d sector%s\n", nsect, splur(nsect)));
	return RET_OK;
}
