#ifndef lint
static char *RCSid = "$Header: look.c,v 1.1 89/12/14 08:20:07 jay Exp $";
#endif /* not lint */

/*
 * look.c
 *
 * lookout from a ship
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "ship.h"
#include "nsc.h"
#include "nat.h"
#include "path.h"
#include "file.h"
#include <fcntl.h>

static	look_ship();

look()
{
	extern	s_char *argp[];
	register int i;
	struct	nstr_item ni;
	struct	shpstr myship;
	struct	sctstr sect;
	int	x, y;
	int	civ;
	int	mil;
	u_char	bitmap[WORLD_X*WORLD_Y/8];

	if (!snxtitem(&ni, EF_SHIP, argp[1]))
		return RET_SYN;

	/* ick */
	(void) ef_close(EF_SHIP);
	if (!ef_open(EF_SHIP, O_RDONLY, EFF_MEM)) {
		pr("Cannot open ship file (EFF_MEM).\n");
		return RET_SYS;
	}

	bzero((s_char *)bitmap, sizeof (bitmap));
	while (nxtitem(&ni, (s_char *)&myship)) {
		if (!owner)
			continue;
		look_ship(&myship);
		for (i = 0; i <= 6; i++) {
			x = diroff[i][0] + myship.shp_x;
			y = diroff[i][1] + myship.shp_y;
			if (getbit(x, y, bitmap))
				continue;
			setbit(x, y, bitmap);
			getsect(x, y, &sect);
			if (sect.sct_type == SCT_WATER)
				continue;
			if (owner)
				pr("Your ");
			else
				pr(fmt("%s (#%d) ", cname(sect.sct_own),
					sect.sct_own));
			pr(dchr[sect.sct_type].d_name);
#if	defined(BMAP) || defined(AUTONAV)
			setbigmap(x, y, dchr[sect.sct_type].d_mnem);
#endif
			pr(fmt(" %d%% efficient ", owner ? sect.sct_effic :
				round((int)sect.sct_effic, 10)));
			civ = getvar(V_CIVIL, (s_char *)&sect, EF_SECTOR);
			mil = getvar(V_MILIT, (s_char *)&sect, EF_SECTOR);
			if (civ)
				pr(fmt("with %s%d civ ", owner ? "" : "approx ",
					owner ? civ : round(civ, 10)));
			if (mil)
				pr(fmt("with %s%d mil ", owner ? "" : "approx ",
					owner ? mil : round(mil, 10)));
			pr(fmt("@ %s\n", xyas(x, y, cnum)));
		}
#if	defined(BMAP) || defined(AUTONAV)
		writebigmap();
#endif
	}
	(void) ef_close(EF_SHIP);
	if (!ef_open(EF_SHIP, O_RDWR, 0)) {
		pr("Cannot open ship file (normal)\n");
		return RET_SYS;
	}
	return RET_OK;
}

static
look_ship(lookship)
	register struct shpstr *lookship;
{
	register struct shpstr *sp;
	register struct mchrstr *smcp;
	register struct mchrstr *tmcp;
	int	range;
	int	vrange;
	int	i;
	int	dist;
	s_char	*name;

	range = (int) techfact(lookship->shp_tech,
		(double) mchr[lookship->shp_type].m_vrnge);
	range = range * (lookship->shp_effic / 100.0);
	smcp = &mchr[lookship->shp_type];
	if (smcp->m_flags & M_SUB)
		range = min(range, 1);
	for (i=0; sp = getshipp(i); i++) {
		if (sp->shp_own == cnum || sp->shp_own == 0)
			continue;
		tmcp = &mchr[sp->shp_type];
		if (smcp->m_flags & M_SUB)
			vrange = (int)(mchr[sp->shp_type].m_visib * range/30.0);
		else
			vrange = (int)(mchr[sp->shp_type].m_visib * range/20.0);
		dist = mapdist(sp->shp_x, sp->shp_y,
			lookship->shp_x, lookship->shp_y);
		if (dist > vrange)
			continue;
		if (smcp->m_flags & M_SUB) {
			if (tmcp->m_flags & M_SONAR && dist < 2) {
#ifdef MERC
				if(sp->shp_own != 0)
#endif
				wu(0, sp->shp_own,
#ifdef	SHIPNAMES
			fmt("%s %s(#%d) detected surfacing noises in %s.\n",
					tmcp->m_name, sp->shp_name, sp->shp_uid,
#else
			fmt("%s #%d detected surfacing noises in %s.\n",
					tmcp->m_name, sp->shp_uid,
#endif	SHIPNAMES
					xyas(lookship->shp_x, lookship->shp_y,
						sp->shp_own)));
			}
			if (dist == 0 && (tmcp->m_flags & M_SUB) == 0)
#ifdef MERC
				if(sp->shp_own != 0)
#endif
				wu(0, sp->shp_own,
#ifdef	SHIPNAMES
				fmt("Periscope spotted in %s by %s %s(#%d)\n",
#else
				fmt("Periscope spotted in %s by %s #%d\n",
#endif	SHIPNAMES
					xyas(lookship->shp_x, lookship->shp_y,
						sp->shp_own),
#ifdef	SHIPNAMES
					tmcp->m_name, sp->shp_name,
					sp->shp_uid));
#else
					tmcp->m_name, sp->shp_uid));
#endif	SHIPNAMES
		}
		/* subs only seen by sonar */
		if (tmcp->m_flags & M_SUB) {
			continue;
		}
		if ((tmcp->m_flags & M_FOOD) && dist > 0)
			name = "fishing vessel";
		else
			name = tmcp->m_name;
		pr(fmt("%s (#%d) %s #%d @%s\n",
			cname(sp->shp_own), sp->shp_own, name,
			i, xyas(sp->shp_x, sp->shp_y, cnum)));
	}
}
