#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/player/commands/RCS/repa.c,v 1.8 89/09/16 16:28:16 mr-frog Exp $";
#endif

/*
 * repa.c
 *
 * repay loan from country
 *
 * from PSL Empire, 1985
 */

#include <math.h>
#include "misc.h"
#include "nat.h"
#include "loan.h"
#include "news.h"
#include "file.h"

int
repa()
{
	extern s_char *argp[];
	struct	lonstr loan;
	struct	natstr *natp;
	int	loan_num;
	long	payment;
	long	owe;
	long	due;
	long	last_payment;
	long	normaltime;
	long	doubletime;
	double	rate_per_sec,amt;
	s_char	*cp;
	time_t	now;

	natp = getnatp(cnum);
	cp = getstarg(argp[1], "Repay loan #? ");
	if (cp == 0)
		return RET_SYN;
	loan_num = atoi(cp);
	if (loan_num < 0)
		return RET_SYN;
	if (!getloan(loan_num, &loan) || loan.l_lonee != cnum
	    || loan.l_status != LS_SIGNED) {
		pr("You don't owe anything on that loan.\n");
		return RET_FAIL;
	}
	(void) time(&now);
	due = loan.l_duedate;
	last_payment = loan.l_lastpay;
	if (now < due) {
		normaltime = now - last_payment;
		doubletime = 0;
	}
	if (last_payment < due && due < now) {
		normaltime = due - last_payment;
		doubletime = now - due;
	}
	if (due < last_payment) {
		normaltime = 0;
		doubletime = now - last_payment;
	}
	rate_per_sec = loan.l_irate /
		((double) loan.l_ldur * SECS_PER_DAY * 100.0);

/* changed following to avoid overflow 3/27/89 bailey@math-cs.kent.edu
	owe = (long) (loan.l_amtdue *
		((double) normaltime * rate_per_sec + 1.0 +
		(double) doubletime * rate_per_sec * 2.0) + 0.5);
   Begin overflow fix */
		amt = ((double) normaltime * rate_per_sec + 1.0 +
			(double) doubletime * rate_per_sec * 2.0);
		if (((1 << 30) / amt) < loan.l_amtdue)
			owe = (1 << 30);
		else
		    owe = (long) (loan.l_amtdue *
			    ((double) normaltime * rate_per_sec + 1.0 +
			    (double) doubletime * rate_per_sec * 2.0) + 0.5);
/* End overflow fix */

	cp = getstarg(argp[2], fmt("You presently owe $%d; payment: $", owe));
	if (cp == 0)
		return RET_SYN;
	payment = atoi(cp);
	if (payment <= 0)
		return RET_SYN;
	if (payment > owe) {
		pr("You don't owe that much.\n");
		return RET_FAIL;
	}
	if (natp->nat_money < payment) {
		pr(fmt("You only have $%d.\n", natp->nat_money));
		return RET_FAIL;
	}
	dolcost += payment;
	NAT_DELTA(nat_money, loan.l_loner, payment);
	(void) time(&loan.l_lastpay);
	if (owe <= payment) {
		wu(0, loan.l_loner,
			fmt("Country #%d paid off loan #%d with $%d",
					cnum, loan_num, payment));
		nreport(cnum, N_REPAY_LOAN, loan.l_loner, 1);
		loan.l_status = LS_FREE;
		loan.l_ldur = 0;
		pr("Congratulations, you've paid off the loan!\n");
	} else {
		wu(0, loan.l_loner,
		   fmt("Country #%d paid $%.2f on loan %d", cnum,
		       (double) payment, loan_num));
		loan.l_amtdue = owe - payment;
		loan.l_amtpaid += payment;
	}
	if (!putloan(loan_num, &loan)) {
		pr("Can't save loan; get help!\n");
		return RET_SYS;
	}
	return RET_OK;
}
