#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/empmain/COMS/RCS/sect.c,v 1.10 89/09/02 02:38:47 mr-frog Exp $";
#endif

/*
 * sect.c
 *
 * show sectors in map-like format with conditionals.  All sectors
 * matching are shown as caps.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "nsc.h"
#include "com.h"
#include "nat.h"
#include "file.h"
#include "map.h"
#include "deity.h"

sct()
{
	extern	s_char *argp[];
	struct	nstr_sect ns;
	struct	sctstr sect;
	struct	nscstr cond[NS_NCOND];
	struct	range range;
	struct	natstr *np;
	s_char	map[WORLD_Y][MAPWIDTH(1)];
	int	ncond;
	int     nsect;
	s_char	*ptr;
	coord	y, yval;
	int	i;
	s_char	what[64];
	s_char	*str;

	nsect = 0;
	if(argp[1] == (s_char *) 0) {
		if ((str = getstring("(sects)? ")) == 0)
			return RET_SYN;
	}
	else {
		str = argp[1];
	}

	if(*str == '*') {
		sprintf(what, "%d:%d,%d:%d",
			-WORLD_X/2, WORLD_X/2-1,
			-WORLD_Y/2, WORLD_Y/2-1);
		if (!snxtsct(&ns, what))
			return RET_FAIL;
	}
	else
	if (!snxtsct(&ns, str))
		return RET_SYN;
	np = getnatp(cnum);
	ncond = ns.ncond;
	bcopy((s_char *)ns.cond, (s_char *)cond, sizeof(*cond) * ncond);
	ns.ncond = 0;
	xyrelrange(getnatp(cnum), &ns.range, &range);
	border(&range, "    ", "");
	blankfill((s_char *)map, &ns.range, 1);
	while (nxtsct(&ns, &sect)) {
		if (!owner)
			continue;
		ptr = &map[ns.dy][ns.dx];
		*ptr = dchr[sect.sct_type].d_mnem;
		if (nstr_exec(cond, ncond, (s_char *)&sect, EF_SECTOR)) {
			++nsect;
			*ptr |= 0x80;
		}
	}
	for (i=0,y=ns.range.ly; i < ns.range.height; y++,i++) {
		yval = yrel(np, y);
		pr(fmt("%3d %s %-3d\n", yval, map[i], yval));
		if (y >= WORLD_Y)
			y -= WORLD_Y;
	}
	border(&range, "    ", "");
	pr(fmt("\n%d sector%s.\n", nsect, splur(nsect)));
	return RET_OK;
}
