#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/player/commands/RCS/show.c,v 1.7 89/09/17 17:12:21 mr-frog Exp $";
#endif

/*
 * show - give info on empire internal data structures - e.g.
 * 	planes, boats, nukes etc.
 *
 * Julian Onions, 1988
 */

#include "misc.h"
#include "nat.h"
#include "file.h"
#include "deity.h"

extern	int show_nuke_build();
extern	int show_nuke_capab();
extern	int show_plane_build();
extern	int show_plane_capab();
extern	int show_ship_build();
extern	int show_ship_capab();

show()
{
	extern	s_char *argp[];
	s_char   *p;
	int     (*cfunc)();
	int	(*bfunc)();
	struct	natstr *natp;
	int	tlev;
#ifdef DRNUKE
	extern	int drnuke_const;
	int	rlev;
#endif /* DRNUKE */

	p = getstarg(argp[1], "Describe what (plane, nuke, bridge, ship)? ");

	natp = getnatp (cnum);
	tlev = (int) (1.25 * natp->nat_level[NAT_TLEV]);
#ifdef DRNUKE
	rlev = (int) (1.25 * natp->nat_level[NAT_RLEV]);
#endif /* DRNUKE */
	if (god){
		tlev = 99999;
#ifdef DRNUKE
		rlev = 99999;
#endif /* DRNUKE */
	}
	switch (*p) {
	case 'b':
		show_bridge(99999);
		return RET_OK;
	case 'n':
#ifdef DRNUKE
		tlev = ((rlev*drnuke_const) > tlev ? tlev : (rlev*2));
#endif /* DRNUKE */
		bfunc = show_nuke_build;
		cfunc = show_nuke_capab;
		break;
	case 'p':
		bfunc = show_plane_build;
		cfunc = show_plane_capab;
		break;
	case 's':
		bfunc = show_ship_build;
		cfunc = show_ship_capab;
		break;
	default:
		return RET_SYN;
	}
	p = getstarg(argp[2], "Build data or capability data (b or c)? ");
	if (*p == 'B' || *p == 'b')
		(*bfunc) (tlev);
	else if (*p == 'C' || *p == 'c')
		(*cfunc) (tlev);
	return RET_OK;
}
