#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/player/commands/RCS/upgr.c,v 1.7 89/09/17 17:36:39 mr-frog Exp $";
#endif /* not lint */

/*
 * upgr.c
 *
 * upgrade tech of ships.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "xy.h"
#include "var.h"
#include "ship.h"
#include "sect.h"
#include "nat.h"
#include "nsc.h"
#include "file.h"

upgr()
{
	extern	s_char *argp[];
	struct	sctstr sect;
	struct	natstr *natp;
	struct	nstr_item ni;
	struct	shpstr ship;
	struct	mchrstr *mp;
	int	n;
	int	tlev;
	int	w_p_eff;
	int	points;
#ifdef ALLYUPGRADE
	int	rel;
#endif /* ALLYUPGRADE */

	if (!snxtitem(&ni,EF_SHIP, argp[1]))
		return RET_SYN;
	natp = getnatp(cnum);
	tlev = (int) natp->nat_level[NAT_TLEV];
	n = 0;
	while (nxtitem(&ni, (s_char *) &ship)) {
		getsect(ship.shp_x, ship.shp_y, &sect);
		if (sect.sct_own != cnum)
			continue;
#ifdef ALLYUPGRADE
		rel=getrel(getnatp(ship.shp_own),sect.sct_own);
		if ((rel != ALLIED) && (sect.sct_own != ship.shp_own)){
			pr(fmt("You are not an ally of the owner of ship %d!\n",
				ship.shp_own));
			continue;
		}
#endif /* ALLYUPGRADE */
		if (!owner || sect.sct_type != SCT_HARBR || sect.sct_effic < 60)
			continue;
		n++;
		mp = &mchr[ship.shp_type];
		w_p_eff = ((mp->m_lcm / 2) + mp->m_hcm);
		points = sect.sct_avail * 100 / w_p_eff;
		if (points < 20) {
		    pr(fmt("Not enough available work in %s to upgrade a %s\n",
				xyas(sect.sct_x, sect.sct_y, cnum),
				mp->m_name));
			pr(fmt(" (%d available work required)\n",
				1 + (w_p_eff * 20)/100));
			continue;
		}
		if (ship.shp_effic < 60) {
#ifdef	SHIPNAMES
			pr(fmt("%s %s(#%d) is too damaged to upgrade!\n",
				mp->m_name, ship.shp_name, ship.shp_uid));
#else
			pr(fmt("%s #%d is too damaged to upgrade!\n",
				mp->m_name, ship.shp_uid));
#endif	SHIPNAMES
			continue;
		}
		if (ship.shp_tech >= tlev) {
#ifdef	SHIPNAMES
			pr(fmt("%s %s(#%d) tech: %d, yours is only %d\n",
				mp->m_name, ship.shp_name, ship.shp_uid,
				ship.shp_tech, tlev));
#else
			pr(fmt("%s #%d tech: %d, yours is only %d\n",
				mp->m_name, ship.shp_uid, ship.shp_tech, tlev));
#endif	SHIPNAMES
			continue;
		}
		sect.sct_avail = (sect.sct_avail * 100 - w_p_eff * 20) / 100;
		ship.shp_effic -= 35;
		ship.shp_tech = tlev;
		putship(ship.shp_uid, &ship);
		putsect(&sect);
		dolcost += (double) mp->m_cost * .15;
	}
	if (n == 0) {
		pr("No ships\n");
		return RET_SYN;
	}
	return RET_OK;
}
