/*
 * file:     main.c
 * author:   Wes Barris
 * date:     10/15/93
 * purpose:  X/GL-based image colorspace tester
 *
 * copyright info:
 *
 *    @Copyright, Research Equipment Inc., d/b/a Minnesota Supercomputer
 *    Center, Inc., 1993
 *
 * RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure of this software and its documentation
 * by the Government is subject to restrictions as set forth in subdivision
 * { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 * clause at 52.227-7013.
 */

#include "icop.h"
#include "proto.h"
#include <GL/gl.h>
#include <GL/glx.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/MwmUtil.h>
#include <X11/Xmu/Editres.h>

GLboolean doubleBuffer = GL_TRUE;
static int snglBuf[] = {GLX_RGBA, GLX_DEPTH_SIZE, 16, None};
static int dblBuf[] = {GLX_RGBA, GLX_DEPTH_SIZE, 16, GLX_DOUBLEBUFFER, None};
static String fallbackResources[] = {
#include "fallback.h"
    NULL,
};

/*extern  int _XEditResCheckMessages();*/

ICOP	icop;

main(argc, argv)
int	argc;
char	*argv[];
{
   Widget	form, w, ip,
		menubar;
   int		n;
   Arg		args[10];
   Colormap	cmap;
   GLint	gdtmp;
   int		errorBase, eventBase;
   XVisualInfo	*vi;

   /*glGetIntegerv(GL_DOUBLEBUFFER, &gdtmp);
   if (!gdtmp) {
      printf("Sorry, this program requires double buffered RGB mode.\n");
      exit(1);
      }*/
   n = 0;
   icop.toplevel = XtAppInitialize(&(icop.appContext), APP_CLASS, NULL,
      NULL, &argc, argv, fallbackResources, args, n);
/*
 * Make sure the GLX extension is supported.
 */
   if (!glXQueryExtension(XtDisplay(icop.toplevel), &errorBase, &eventBase)) {
      printf("Sorry, this X server has no OpenGL GLX extension.\n");
      exit(1);
      }
   /*XtAddEventHandler(icop.toplevel, (EventMask)0, True,
                     (XtEventHandler)_XEditResCheckMessages, NULL);*/
   /*XSynchronize(XtDisplay(icop.toplevel), True);*/
/*
 * Icop is held together by a form.
 */
   n = 0;
   form = XmCreateForm(icop.toplevel, "form", args, n);
   XtManageChild(form);
/*
 * Create Icop's main children.
 */
   menubar	=	MenuBarInit(form);
   ip		=	InfoInit(form, menubar);
   icop.plot.w	=	PlotInit(form, ip);
   icop.image.w	=	NULL;
   icop.image.width = 0;
   icop.image.height = 0;
/*
 * Anything that needs to be initialized...
 */
   icop.image.legalbuf = NULL;
   icop.image.illegalbuf = NULL;
   icop.image.correctedbuf = NULL;
   XtRealizeWidget(icop.toplevel);
/*
 * Let's go!
 */
   XtAppMainLoop(icop.appContext);
   /*exit(0);*/
}
