/*
** $Id: tdparser.h,v 2.2 1992/03/03 15:17:53 cogito Exp $
*/

/* This is the interface between the parsermodule and its environment */
/* It is adapted to the PGS-parser-interface in ELIV3 .               */

/****************************** INCLUDE-FILES *********************************/

#include "err.h"      /* Error-handler-module provided by ELI */
#include "treecon.h"  /* Structure connections */

/***************************** MACRO-CONSTANTS ********************************/

#define ZAttributKeller   &oldtoken
/* adaption to ELI's interface to semantic analysis */

#define parsercore Zerteiler
/* "Zerteiler" is the name of the PGS-parser-routine */

/***************************** TYPEDEFINITIONS ********************************/

typedef int attrvaltype;  /* type of an attribute-value */

typedef struct{
          POSITION       Pos;
          int            SyntaxCode;
          attrvaltype    Attr;
} tokentype; /* type for a basic-symbol */

/********************* DEFAULT FOR AN ATTRIBUTE-VALUE *************************/

#define DEFAULT_VALUE  0

/************************** EXTERNAL DECLARATIONS *****************************/

extern int glalex(/* int *attrval */);
/* the GLA-scanner-routine */

extern void SourceNode(/* int prodcode; tokentype *old_token; */);
/* routine for structure-connections */

extern void SourceLeaf(/* tokentype *old_token; */);
/* routine for symbol-connections */
   
/*********************** C-FUNCTIONS AND VARIABLES ****************************/

#ifndef SCNTST /* is not included on scanner-test */

static int severity[6] = { NOTE, ERROR, NOTE, DEADLY, DEADLY, WARNING };

static void e_message( class, msg_text, token )
   int        class;    /* error-class              */
   char      *msg_text; /* error-message-text       */
   tokentype *token;    /* pointer to current token */
   
  /* e_message suppresses messages for inserted or deleted token.
   *
   ***/
 { 
	if(class != 2) message( severity[class], msg_text, 0, &((token)->Pos));
#ifdef	_ERROR_OFF
	if(severity[class] == ERROR  || severity[class] == DEADLY) exit(0);
#endif 
 }/* e_message */

#endif

/************************ INTERFACE-FUNCTION-MACROS ***************************/

#define gettok( token ) { \
             oldtoken = *(token); \
             (token)->SyntaxCode = glalex( &((token)->Attr) ); \
             (token)->Pos = curpos; \
        }
/* get a new token from the lexikal analysis. For the semantic analysis the */
/* old basic symbol is saved, if the parser doesn't work on error-recovery. */
                
#define symbconn( token ) /* no need for it in this adaption, see also
			   * comment at #include "seminf.h" above.	*/
/*
#define structconn( action ) ==definition is in file "semprods.h"==
*/
#define errormsg(class, text, token) e_message(class, text, token)
/* send an error-message to the error-logging */

/************************* SPECIAL-FUNCTION-MACROS  ***************************/

#define gentok( term, val, token ) { \
             (token)->SyntaxCode = term;\
             (token)->Attr = val;\
             (token)->Pos  = rst_token.Pos;\
             oldtoken = *(token);\
        }
/* generate an error-token for Roehrichs error-recovery */

#define selectsxcode( token ) token.SyntaxCode
/* select syntaxcode from a basic-Symbol */

#define selectattr( token ) token.Attr
/* select attribute-value from a basic-symbol */

#define Init_parser()
/* initialization-operations for the parserframe, which may contain extra  */
/* type-definitions before it.                                             */
