# $Id: line_err.awk,v 1.1 1992/08/01 17:26:29 waite Exp $
# Copyright 1992, The Regents of the University of Colorado

# Add line_err hooks to a file with standard error reporting
#    On entry-
#       stdin is a text file with lines in the form:
#             seq file line column text
#          seq=irrelevant integer
#          file=Odin file name or "."
#          line=Decimal line number or "0"
#          column=Decimal column number or "0"
#    On exit-
#       stdout is a text file with lines grouped by file as follows:
#
#             . 0 0 text
#             ...
#             (|file1:line_err:file1 line1 column1 text1
#             file1 line2 column2 text2
#             ...
#             file1 linen columnn textn
#             |)
#             ...
#
#          Within each group the reports are sorted in increasing
#            order by coordinates

	{ line = ""
	  if ($2 != file) {
	    if (file != "." && file != "") line = "|)\n"
	    file = $2
	    if (file != ".") line = line "(|" $2 ":line_err:"
	  }
	  line = line $2
	  for (i = 3; i <= NF; i++) line = line " " $(i)
	  print line
	}

END	{if (file != ".") print "|)"}
