use ExtUtils::MakeMaker;

if (open my $fh, '|dot', )
{
	close $fh;
}
else
{
	die "Please install Graphviz from http://www.graphviz.org/.\n";
}

# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

WriteMakefile
(
	($] ge '5.005') ?
	(
		AUTHOR   => 'Ron Savage (ron@savage.net.au)',
		ABSTRACT => 'Provide various analyses of Graphviz dot files',
	) : (),
	clean =>
	{
		FILES => 'blib/* Makefile MANIFEST GraphViz2-Marpa-PathUtils-*'
	},
	dist =>
	{
		COMPRESS => 'gzip',
		SUFFIX   => 'gz'
	},
	DISTNAME  => 'GraphViz2-Marpa-PathUtils',
	NAME      => 'GraphViz2::Marpa::PathUtils',
	LICENSE   => 'artistic_2',
# Next line runs copy.config.pl when user runs 'make'.
# Warning: '...' => 0 is OK but => '' or undef are ignored.
	PL_FILES  => {'scripts/copy.config.pl' => 'Copying...'},
	PL_FILES  => {},
	PREREQ_PM =>
	{
		Capture::Tiny    => 0.10,
		Config           => undef,
		Config::Tiny     => 2.14,
		Date::Format     => 2.24,
		Date::Simple     => 3.03,
		feature          => 0,
		File::Copy       => 2.21,
		File::HomeDir    => 0.99,
		File::Slurp      => 9999.19,
		File::Spec       => 3.33,
		File::Which      => 1.09,
		Getopt::Long     => 2.38,
		GraphViz2        => 2.05,
		GraphViz2::Marpa => 1.06,
		Hash::FieldHash  => 0.10,
		IPC::Run3        => 0.045,
		open             => 0,
		parent           => 0.225,
		Path::Class      => 0.23,
		Pod::Usage       => 1.36,
		Set::Tiny        => 0.01,
		strict           => 0,
		Test::More     => 0.98,
#		Test::Pod        => 1.45, # Make it optional. See t/pod.t
		Text::Xslate     => 1.4001,
		warnings         => 0,
	},
	VERSION_FROM => 'lib/GraphViz2/Marpa/PathUtils.pm',
);
