#
# This is a short demonstration of toocl, the Tooltalk interface to Tcl/Tk
# Launch this program several times and move one slider : they will move
# altogether to reflect the new position

wm title . "Tooltalk demo"

proc nullProc {args} {
# Null procedure to avoid a ping-pong phenomenon
}

proc slideCallback {args} {
# Called each time the slider is moved
# Broadcast a message advertising our new position
    global TT_IN_OUT TT_STRING_MSG_ARG_TYPE TT_SESSION
    set mes [tt_pnotice_create [tt_default_session] Slide]
    tt_message_arg_add $mes $TT_IN_OUT $TT_STRING_MSG_ARG_TYPE $args
    tt_message_scope_set $mes $TT_SESSION
    tt_message_send $mes
}

proc patCallback {mes pat} {
# Called when we receive an update notification
# Before reflecting the change, nullify the callback so that we don't
# enter an infinite loop
    set val [tt_message_arg_val $mes 0]
    .scale configure -command {nullProc}
    .scale set $val
    .scale configure -command {slideCallback}
}

proc mainttcb {args} {
# Called each time Tooltalk's descriptor becomes active
    set msg [tt_message_receive]
}

# Create the slide
scale .scale -from 0 -to 100 -command {slideCallback}
pack append . .scale {top}

# Open the Tooltalk session
tt_open
tt_session_join [tt_default_session]

# Create the pattern
set pat [tt_pattern_create]
tt_pattern_category_set $pat $TT_OBSERVE
tt_pattern_scope_add $pat $TT_SESSION
tt_pattern_callback_add $pat patCallback
tt_pattern_register $pat
tt_session_join [tt_default_session]

# Register the main Tooltalk function
TT_main_tooltalk_callback mainttcb




