'\" -*- tcl -*- doctools manpage
'\"
'\" Generated from ../tcllib/modules/math/combinatorics.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "combinatorics" n 4.2 math "Tcl Math Library"
.BS
.SH NAME
combinatorics \- Combinatorial functions in the Tcl Math Library
.SH "SYNOPSIS"
package require \fBTcl 8.2\fR
.sp
package require \fBmath ?1.2?\fR
.sp
\fB::math::ln_Gamma\fR \fIz\fR\fR
.sp
\fB::math::factorial\fR \fIx\fR\fR
.sp
\fB::math::choose\fR \fIn k\fR\fR
.sp
\fB::math::Beta\fR \fIz w\fR\fR
.sp
.BE
.SH "DESCRIPTION"
.PP
The \fBmath\fR package contains implementations of several
functions useful in combinatorial problems.
.SH "COMMANDS"
.TP
\fB::math::ln_Gamma\fR \fIz\fR\fR
Returns the natural logarithm of the Gamma function for the argument
\fIz\fR.
.sp
The Gamma function is defined as the improper integral from zero to
positive infinity of
.nf
  t**(x-1)*exp(-t) dt
.fi
.sp
The approximation used in the Tcl Math Library is from Lanczos,
\fBISIAM J. Numerical Analysis, series B,\fR volume 1, p. 86.
For "\fBx\fR > 1", the absolute error of the result is claimed to be
smaller than 5.5*10**-10 -- that is, the resulting value of Gamma when
.nf
  exp( ln_Gamma( x) ) 
.fi
is computed is expected to be precise to better than nine significant
figures.
.TP
\fB::math::factorial\fR \fIx\fR\fR
Returns the factorial of the argument \fIx\fR.
.sp
For integer \fIx\fR, 0 <= \fIx\fR <= 12, an exact integer result is
returned.
.sp
For integer \fIx\fR, 13 <= \fIx\fR <= 21, an exact floating-point
result is returned on machines with IEEE floating point.
.sp
For integer \fIx\fR, 22 <= \fIx\fR <= 170, the result is exact to 1
ULP.
.sp
For real \fIx\fR, \fIx\fR >= 0, the result is approximated by
computing \fBGamma(x+1)\fR using the \fB::math::ln_Gamma\fR
function, and the result is expected to be precise to better than nine
significant figures.
.sp
It is an error to present \fIx\fR <= -1 or \fIx\fR > 170, or a value
of \fIx\fR that is not numeric.
.TP
\fB::math::choose\fR \fIn k\fR\fR
Returns the binomial coefficient \fBC(n, k)\fR
.nf
   C(n,k) = n! / k! (n-k)!
.fi
If both parameters are integers and the result fits in 32 bits, the
result is rounded to an integer.
.sp
Integer results are exact up to at least \fIn\fR = 34.  Floating point
results are precise to better than nine significant figures.
.TP
\fB::math::Beta\fR \fIz w\fR\fR
Returns the Beta function of the parameters \fIz\fR and \fIw\fR.
.nf
   Beta(z,w) = Beta(w,z) = Gamma(z) * Gamma(w) / Gamma(z+w)
.fi
Results are returned as a floating point number precise to better than
nine significant digits provided that \fIw\fR and \fIz\fR are both at
least 1.
