.TH WAISSERVER 1 "Fri Sep 13 1991" "Thinking Machines"
.SH NAME
waisserver \- serves WAIS requests

.SH SYNOPSIS
.B waisserver
[ \-p [ port_number ] ] [ \-s ] [ \-d directory ] [\ \-e [ pathname ] ] [\-u
user ] [ \-v ]
.TP
.B waisserver.d
[ same arguments ]

.SH DESCRIPTION
.PP
Part of the Wide Area Information Server system.
.PP
waisserver will take WAIS requests from a TCP port or standard-io and
return the appropriate response.  If the name of the command is
waisserver.d, then it is assumed it is running from inetd, and it uses
stdio for it's I/O sockets.  See the examples below for inetd.conf.

.SH OPTIONS
.TP 10
\fB \-p\fI [ port ] 
Listen to the port.  If the port is supplied, then that port number is
used.  If it is not supplied then the Z39.50 port (210) is used.
.TP 10
\fB \-s
listen to standard I/O for queries.
.TP10
\fB \-d\fI directory
Use this directory as the default location of the indexes.  Therefore if
the directory were /usr/local, then the database foo would be found in
/usr/local/foo (see waisindex for how to create an index)
.TP 10
 \fB \-e\fI [ filename ]
Redirect error output to pathname, if supplied, or to /dev/null.
Error output defaults to stderr, unless -s is selected,
in which case it defaults to /dev/null.
.TP 10
 \fB \-u\fI user
Set the server's user id to the user specified after attaching the tcp-port. 
This is only used if the server is started as root.
.TP 10
 \fB \-v
Print the current version and date of the server.
.SH EXAMPLES
The following are examples of \fIwaisserver\fR usage:
.TP
waisserver\ -p\ 8000\ -d\ wais-sources\ -e\ server.log
Runs waisserver as a standalone server, using tcp port 8000 on directory
wais-sources writing messages to server.log
.PP
Some example inetd.conf entries (note, these must be on one line in
inted.conf):
.PP
hpux 7.0/800, Interactive/386 2.2.1:
.TP 1
z3950\ stream\ tcp\ nowait\ root\ /etc/waisserver\ waisserver.d
-d\ /wais-sources\ -e\ /server.log
.PP
Ultrix 4.1:
.TP 1
z3950\ stream\ tcp\ nowait\ /etc/waisserver\ waisserver.d
-d\ /wais-sources\ -e\ /server.log
.PP
Also, add the next line to /etc/services, and tickle your YP server:
.PP
z3950\ 210/tcp\ #\ wide\ area\ information\ server\ (wais)
.SH SEE ALSO
.PP
waissearch(1), waisindex(1), waissearch-gmacs(1), xwais(1), xwaisq(1),
inetd(8C), inetd.conf(5)
.PP
Wide Area Information Servers Concepts by Brewster Kahle.
.br
Brewster@think.com
.SH DIAGNOSTICS
.PP
The diagnostics produced by the waisserver is meant to be self-explanatory.
.SH BUGS
Under BSD logging information is sent to standard output, instead of
standard error.  This means the -e and -s options won't work as expected.

