// Doc.h
//
// Free software created 1 Feb 1992
// by Paul Burchard <burchard@math.utah.edu>.
//
// Provides an abstract superclass to act as File's Owner for document
// NIB under the control of a DocControl.  That is, Doc owns the window
// which the user equates with the document, and mediates between this document 
// and the Application (which is represented by its DocControl delegate).  The 
// Doc's (i.e., File's Owner's) window outlet must be connected to the Window 
// in IB.
//
// The Doc object (File's Owner in IB) is set be set to be the Window's 
// delegate in its -init method, but window delegate methods can be
// delegated further by using the Doc object's delegate outlet.
//
// The -textDidChange: action method notifies the window that the document ist 
// contains has been edited and needs to be saved.  One way to use this method 
// is to make the Doc object the delegate of Text objects in the window; they 
// will then report alterations to the text.
//
// The -free method also closes the window in which the Doc lives. Since it
// forces a close, without asking the user or telling the DocControl, programs 
// generally shouldn't call this method directly; use DocControl's 
// -closeDoc:andFree:YES instead.
//
// Subclasses should never directly set the fileName variable;
// use -setFileName: instead.
//
// The following must be implemented by the subclass:
//	- dump:sender			Dump document to fileName; return nil
//					if fileName==0 or fail (default no-op).
//	- load:sender			Load document from fileName; return nil
//					if fileName==0 or fail (default no-op).
//
// The following would typically also be implemented by the subclass:
//	+ (const char *)fileType	Returns the file type extension 
//					accepted by class (default "").
//					Must be an invariant string.
//	+ (const char *)nibName		Returns name of NIB section which
//					sets up document window (default
//					"Doc.nib").  Must be invariant.
//	+ (const char *)miniIconName	Returns name for icon to be displayed
//					in doc's miniwindow (iconified form).
//					Default NULL results in no icon.
//	+ (BOOL)backupOnSave		Should backup files (~) be created
//					when saving?  (Default NO.)
//	+ (const char *)defaultFolder	Default folder for Open/Save Panels
//					(default default is home directory).
//

#import <objc/Object.h>

@interface Doc:Object
{
    id window;
    id delegate;
    const char *fileName;
}

+ (const char *)fileType;
+ (const char *)nibName;
+ (const char *)miniIconName;
+ (BOOL)backupOnSave;
+ (const char *)defaultFolder;
+ initialize;
- init;
- free;
- windowWillClose:sender;
- textDidChange:sender;
- setFileName:(const char *)aName;
- (const char *)fileName;
+ docForFileName:(const char *)aName;
- dump:sender;
- load:sender;
- window;
- setDelegate:anObject;
- delegate;
- forward:(SEL)aSelector :(marg_list)argFrame;

@end
