// IconWellControl.h
//
// Free software created 1 Feb 1992
// by Paul Burchard <burchard@math.utah.edu>.
//
// See IconWell.h for more info.

#import <objc/Object.h>

#define newIconName	"IconWellControl-tmp"

@interface IconWellControl : Object
{
    id window;
    unsigned int globalWindowNum;
    id wellListener;
    BOOL isListening;
    id newIconPath;
    id newIconImage;
}

+ initialize;
+ controlFor:theWindow;
- initWindow:theWindow;
- free;
- (const char *)newIconPath;
- (int)iconEntered:(int)windowNum at:(double)x :(double)y
    iconWindow:(int)iconWindowNum iconX:(double)iconX iconY:(double)iconY
    iconWidth:(double)iconWidth iconHeight:(double)iconHeight
    pathList:(char *)pathList;
- (int)iconMovedTo:(double)x :(double)y;
- (int)iconExitedAt:(double)x :(double)y;
- (int)iconReleasedAt:(double)x :(double)y ok:(int *)flag;

@end
