// SourceDoc.h
//
// Free software created 1 Feb 1992
// by Paul Burchard <burchard@math.utah.edu>.
//
// Strings needed in [[NXApp delegate] stringTable]:
//	"Warning!";
//	"This database is maintained by %s.  Are you sure you want to overwrite it?";
//

#import "Doc.h"

@interface SourceDoc:Doc
{
    // WAIS handle.
    id waisSource;
    
    // Window fields.
    id serverField;
    id serviceField;
    id databaseField;
    id costField;
    id unitsField;
    id maintainerField;
    id descriptionField;
    
    // Indexer Fields.
    id indexPanel;
    id indexMode;
    id indexPublic;
    id indexPrivate;
    id indexInputWell;
    id indexFiles;
    id indexScriptWell;
    id indexIWC;
    BOOL isPublic;
}

+ (const char *)fileType;
+ (const char *)nibName;
+ (const char *)miniIconName;
+ (const char *)defaultFolder;
- init;
- free;
- dump:sender;
- load:sender;
- setFileName:(const char *)aName;
- (int)openFile:(const char *)name ok:(int *)flag;
- bugReport:sender; // send mail to maintainer of WAIS source
- indexPanel:sender; // returns panel
- addToIndex:sender;
- applyIndexMode:sender;
- makePrivate:sender;
- makePublic:sender;
- createIndex:sender;
- updateSelection:sender;

@end
