#!/bin/sh
# Enable/disable Internet access to WAIS server on NeXT systems.
# Must be run as root.  Usage:
#
#	create-public-next.sh -on system_wais_folder
#	create-public-next.sh -off
#
# If -on system_wais_folder is given, the script will enable Internet access, 
# through the waisserver program, to WAIS sources contained in
# system_wais_folder (and only those sources).
#
# If -off is given, the script disables Internet WAIS access.
#
WHAT_TO_DO=${1:-"-help"}
SYSTEM_WAIS_FOLDER=${2:-"/!!!NON-EXISTENT!!!/"}
if test $WHAT_TO_DO = "-on"
then
	if test -d $SYSTEM_WAIS_FOLDER
	then
		cd $SYSTEM_WAIS_FOLDER
		SYSTEM_WAIS_FOLDER=`pwd`
		echo "Setting up public WAIS server on $SYSTEM_WAIS_FOLDER..."
		echo
		echo 'Making Z39.50 (WAIS) service known to NetInfo...'
		niutil -create . /services/z3950
		niutil -createprop . /services/z3950 name z3950 WAIS
		niutil -createprop . /services/z3950 port 210
		niutil -createprop . /services/z3950 protocol tcp
		echo '...New NetInfo entry reads:'
		niutil -read . /services/z3950
		echo
		echo 'Setting up Internet Daemon to listen for Z39.50 requests...'
		if cp /etc/inetd.conf /etc/inetd.conf~
		then
			echo '...Backed up inetd.conf file.'
		else
			echo 'ERROR: Cannot back up /etc/inetd.conf'
			exit
		fi
		if test 0 -eq "`grep 'z3950' /etc/inetd.conf | wc -l`";  
		then
			echo "z3950	stream	tcp	nowait	root	$SYSTEM_WAIS_FOLDER/bin/waisserver waisserver.d -d $SYSTEM_WAIS_FOLDER/sources">> /etc/inetd.conf
			echo '...Updated inetd.conf file.'
		else
			echo '...WAIS server already listed in inetd.conf file.'
		fi
	else
		echo "ERROR: No such folder: $SYSTEM_WAIS_FOLDER"
		exit
	fi
elif test $WHAT_TO_DO = "-off"
then
	echo "De-installing public WAIS server..."
	echo	
	echo 'Deleting Z39.50 (WAIS) service from NetInfo...'
	niutil -destroy . /services/z3950
	echo '...Deleted.'
	echo
	echo 'Resetting Internet Daemon to ignore Z39.50 requests...'
	if cp /etc/inetd.conf /etc/inetd.conf~
	then
		echo '...Backed up inetd.conf file.'
	else
		echo 'ERROR: Cannot back up /etc/inetd.conf'
		exit
	fi
	grep -v 'z3950' /etc/inetd.conf~ > /etc/inetd.conf
	echo '...Updated inetd.conf file.'
else
	echo 'Usage:'
	echo '	create-public-next.sh -on system_wais_folder'
	echo '	create-public-next.sh -off'
	exit
fi
echo '...Done.'
echo
echo '*** These changes will take full effect upon system reboot. ***'
echo


