/* $Id: server.c,v 4.4.3.1 1991/11/22 04:12:21 davison Trn $
**
** $Log:	server.c,v $
** Revision 4.4.3.1  1991/11/22  04:12:21  davison
** Trn Release 2.0
** 
*/

#include "EXTERN.h"
#include "common.h"
#include "threads.h"

#ifdef SERVER

#include "server.h"

char *
get_server_name(errflag)
int errflag;
{
    char *name;
    extern char *getenv();

    if (SERVER_FILE[0] == '/') {
	name = getserverbyfile(SERVER_FILE);
    } else {
	if ((name = getenv("NNTPSERVER")) == NULL)
	    name = SERVER_FILE;
    }
    if (name == NULL && errflag) {
	fprintf(stderr, "Couldn't get name of news server from %s\n",
	    SERVER_FILE);
	fprintf(stderr,
	    "Either fix this file, or put NNTPSERVER in your environment.\n");
    }
    return name;
}

# ifdef XTHREAD

extern FILE *ser_rd_fp;

static	long	rawbytes = -1;	/* bytes remaining to be transfered */

/*
 * rawcheck_server -- get a line of text from the server, interpreting
 * it as a status message for a raw (binary) command.  Call this once
 * before calling rawget_server() for the actual data transfer.
 *
 *	Parameters:	"string" has the buffer space for the
 *			line received.
 *			"size" is the size of the buffer.
 *
 *	Returns:	-1 on error, otherwise the length of the raw data.
 *
 *	Side effects:	Talks to server, changes contents of "string".
 */
long
rawcheck_server(string, size)
char	*string;
int	size;
{
    /* try to get the status line and the status code */
    if (get_server(string, size) || *string != CHAR_OK)
	return rawbytes = -1;

    /* try to get the number of bytes being transfered */
    if (sscanf(string, "%*d%ld", &rawbytes) != 1)
	return rawbytes = -1;
    return rawbytes;
}

/*
 * rawget_server -- read data from the server in raw format.  This call must
 * follow an appropriate put_server command and a rawcheck_server call.
 *
 *	Parameters:	"buf" is the buffer for the data to receive.
 *			"n" is the size of the buffer.
 *
 *	Returns:	0 on EOF, otherwise the length of the read.
 *
 *	Side effects:	Talks to server, changes contents of "buf".
 */
long
rawget_server(buf, n)
char	*buf;
long	n;
{
    /* if no bytes to read, then just return EOF */
    if (rawbytes < 0)
	return 0;

    /* try to read some data from the server */
    if (rawbytes) {
	n = fread(buf, 1, n > rawbytes ? rawbytes : n, ser_rd_fp);
	rawbytes -= n;
    } else
	n = 0;

    /* if no more left, then fetch the end-of-command signature */
    if (!rawbytes) {
	char buf[5];	/* "\r\n.\r\n" */

	fread(buf, 1, 5, ser_rd_fp);
	rawbytes = -1;
    }
    return n;
}
# endif

#endif /* SERVER */
