sub main'RFC822parser {

$args = join(" ", @_);				# All args on one line
@args = split(/,/, $args);			# [0] = lines, [1] = options

$readfile = $args[0];
$options = $args[1];
$BITNET = grep(/\bBITNET\b/i, $options);

$retcode = 0;
$special[0] = "\\\"@<>\(\):;,";
$special[1] = "\\\"";
$special[2] = "\\\(\)";
$special[3] = "\."."%";

(-e $readfile) || die("File $readfile does not exist");
open(INPUTFILE, $readfile) || die("Can not open file $readfile");
&ParseMailHeader(INPUTFILE, *temp_header);
close(INPUTFILE);

$rfc822out = "";
if(grep(/\bSUBJECT\b/i, $options)) {
	$tag = "subject";
	&outfield("$tag $temp_header{$tag}");
}

if(grep(/\bREPLYTO\b/i, $options)) {
	$tag = &First('resent-reply-to reply-to');
	if($tag ne ":") {
		$input = $temp_header{$tag};
		while($input ne "") { 
			$result = &Getaddress;
			($result ne "") && (&outfield("replyto $result"));
		}
	}
}

if(grep(/\bDATE\b/i, $options)) {
	$tag = &First('resent-date date');
	if(defined($temp_header{$tag})) { 
		&outfield("date $temp_header{$tag}");
	}
	else { 
		&gendate;
		&outfield("date $date");
	}
}

if(grep(/\bMSGID\b/i, $options)) {
	$tag = &First('resent-message-id message-id');
	(defined($temp_header{$tag})) &&
		(&outfield("msgid $temp_header{$tag}"));
}

if(grep(/\bOMSGID\b/i, $options)) {
	$tag = "message-id";
	(defined($temp_header{$tag})) &&
		(&outfield("omsgid $temp_header{$tag}"));
}

if(grep(/\bRCPT\b/i, $options)) {
	&Gendest("to");
	&Gendest("cc");
	&Gendest("bcc");
}

(grep(/\bFROM\b/i, $options)) && (&Gendest("from"));
(grep(/\bSENDER\b/i, $options)) && (&Gendest("sender"));
if(grep(/\bOFROM\b/i, $options)) {
	$tag = "from";
	if(defined($temp_header{$tag})) {
		$input = $temp_header{$tag};
		while($input ne "") {
			$result = &Getaddress;
			($result ne "") && (&outfield("ofrom $result"));
		}
	}
}

$tag = &First("resent-sender resent-from sender from");
if($tag ne ":") {
	$input = $temp_header{$tag};
	$result = &Getaddress;
	if($result eq "") {
		&Error("Mail origin can not be determined.");
		&Error("Original tag was -> $tag: $temp_header{$tag}");
	}

	else {
		&outfield("origin $result");
		($input ne "") &&
			(&Warning("More than one sender was specified. Second and following senders discarded."));
	}
}

else {  &Error("\"From:\"/\"Sender:\" field is missing."); }

$retcode;
}

sub First {
	local($a) = @_;
	local(@stem);
	@stem = split(" ", $a);
	$done = 0;
	while((!$done) && ($a = shift(@stem))) {
		(defined($temp_header{$a})) && ($done = 1);
	}

	(!$done) ? ":" : $a;
}

sub gendate {
	local($temp_date);
	$temp_date = `date`;
	chop($temp_date);
	@temp_date = split(/ +/, $temp_date);
	$date = $temp_date[0] . ", " . $temp_date[2] . " " . $temp_date[1] .
		" ". $temp_date[5] . " " . $temp_date[3] . " " . $temp_date[4];
}

sub Getaddress {
	local($output, $finished, $ret);
	local($i, $quote, $saved, $userid, $domain, $name, $string);
	$quote = $saved = 0;
	$userid = $domain = $name = $string = "";
	
	$finished = 0;
	until($finished) {
		$i = &MVerify($input."\\", $special[$quote]);
		$string .= substr($input, 0, $i);
		$c = substr($input, $i, 1);
		$input = substr($input, $i + 1);
		if($c eq "@") {
			$userid .= " " . $string;
			$string = "";
		}
		elsif($c eq "," || $c eq "") {
			$finished = 1;
			last;
		}
		elsif($c eq "<") {
			$name .= " " . $string;
			$string = "";
		}
		elsif($c eq ">") {
			$domain .= " " . $string;
			$string = "";
		}
		elsif($c eq "\"") {
			$quote = !$quote;
		}
		elsif($c eq "(") {
			&Save;
		}
		elsif($c eq ")") {
			&Restore;
		}
		elsif($c eq "\\") {
			&Backslash;
		}
		elsif($c eq ":") {
			$string = "";
		}
	}

	$ret = "";
	($saved != 0) && (&Error("Unmatched parenthesis in address field."));
	($domain eq "") ? $domain = $string : $name .= " " . $string;
	(&words($userid) > 1) && (&Checkdomain($userid) == 1) && (return "");
	(&words($domain) > 1) && (&Checkdomain($domain) == 1) && (return "");
	($userid ne "") && ($domain ne "") && 
		(return &space("$userid $domain $name"));
	&Inform("Empty address field found and ignored.");
	($input ne "") && ($result = &Getaddress);
		
	$ret = &space($ret);
}

sub MVerify {
	local($str, $pat) = @_;
	local($i);

	$i = 0;
	while(substr($str, $i, 1) !~ /[$pat]/ && $i < length($str)) {
		$i++; 
	}

	$i;
}

sub Save {
	$saved++;
	if($saved == 1) {
		$savestr = $string;
		$string = "";
		$quote = 2;
	}
}

sub Restore {
	$saved--;
	if($saved == 0) {
		$name .= " " . $string;
		$string = $savestr;
		$quote = 0;
	}
}

sub Backslash {
	$c = substr($input, 1, 1);
	$input = substr($input, 2);
	$string .= $c;
}

sub Checkdomain {
	local($string) = @_;
	local($i, $count, $x);

	$string = &space($string);
	$count = 0;
	$ret = 0;
	$i = &words($string) - 1;
	@string = split(/ /, $string);
	while($count < $i && !$ret) {
		$w = $string[$count++];
		$x = substr($w, length($w), 1);
		if($x =~ /[$special[3]]/) { next; }
		(substr($string[$count], 1, 1) !~ /[$special[3]]/) &&
			($ret = 1);	
	}

	$ret;
}

sub Gendest {
	local($tagname) = @_;
	local($tag);

	$tag = &First('resent-' . $tagname . " " . $tagname);
	if($tag ne ":") {
		$input = $temp_header{$tag};
		while($input ne "") {
			$result = &Getaddress;
			($result ne "") && (&outfield("$tagname $result"));
		}
	}
}

sub space { # Emulates the REXX space() function, stripping ALL spaces.
	$_ = join(" ", @_);
	s/ +/ /g;
	s/^ //g;
	s/ $//g;
	$_;
}

sub words {
	$_ = split(/ +/, join(" ", &space(@_)));
}

sub outfield {
	($rfc822out eq "") ? ($rfc822out) = @_ : $rfc822out .= "\x15@_[0]";
}

sub Error {
	local($i);
	&outfield("E @_");
	$retcode = &Max($retcode, 8);
	$i = 1;
}

sub Warning {
	local($i);
	&outfield("W @_");
	$retcode = &Max($retcode, 4);
	$i = 1;
}

sub Inform {
	&outfield("I @_");
}

sub Max {
	($_[0] > $_[1]) ? $_[0] : $_[1];
}

# The following routine taken from mail-header.spaf
#  Routines to parse out an RFC 822 mailheader
#     E. H. Spafford,  last mod: 11/91
#  
#  ParseMailHeader breaks out the header into an % array
#    indexed by a lower-cased keyword, e.g.
#       &ParseMailHeader(STDIN, *Array);
#	use $Array{'subject'}
#
#    Note that some duplicate lines (like "Received:") will get joined
#     into a single entry in %Array; use @Array if you want them separate
#    $Array will contain the unprocessed header, with embedded
#     newlines
#    @Array will contain the header, one line per entry
#
#  RetMailAddr tries to pull out the "preferred" return address
#    based on the presence or absence of various return-reply fields


#  Call as &ParseMailHeader(FileHandle, *array)

sub ParseMailHeader  
{
    local($save1, $save2) = ($*, $/);
    local($FH, *array) =  @_;
    local ($keyw, $val);

    %array = ();

# force unqualified filehandles into callers' package
    local($package) = caller;
    $FH =~ s/^[^']+$/$package'$&/;

    ($*, $/) = (1, '');
    $array = $_ = <$FH>;
    s/\n\s+/ /g;
       
    @array = split('\n');
    foreach $_ (@array)
    {
	($keyw, $val) = m/^([^:]+):\s*(.*\S)\s*$/g;
	$keyw =~ y/A-Z/a-z/;
	if (defined($array{$keyw})) {
	    $array{$keyw} .= ", $val";
	} else {
	    $array{$keyw} = $val;
	}
    }
    ($*, $/) = ($save1, $save2); 
}


1;
