# SiteSpy
Perl module to spy on changes on websites.

Ever wanted RSS on websites that don't provide RSS!? With this module,
you can do pretty much that.

Note that this cares only about if the inner text of specific given elements
has been changed and not really about structural HTML differences...

i.e., the following two pages will have no changes if we're spying on `div`:

```html
<div>
    <p>Hi!</p>
</div>
```

```html
<div>
    <span>Hi!</span>
</div>
```

## Example (Pseudocode)

Consider this in a cronjob:

```perl
my $old_html = get_html_from_cache;
my $new_html = retrieve_html_from_internet;

my $ss = SiteSpy->new({
    old_HTML => $old_html,
    new_HTML => $new_html,
    args     => { # Effectively, which elements are we spying on? See L<HTML::Element/look_down> for arg format, except in a ref
        _tag => 'tr',
    }
});

# L<Array::Diff> object containing the differences between the texts of the two sets of elements
my $diff = $ss->find_diffs;

if (my $new = $diff->added) {
    print "The following new table rows were added:\n";
    print_new $new;
}

if (my $deleted = $diff->deleted) {
    print "The following table rows were deleted:\n";
    print_deleted $deleted;
}

put_html_in_cache($new_html);
```

The script will then notify every time the site changes. Note that currently
caching the previous version is up to you; this module simply shows the
differences between the two.
