:
#! /bin/sh
#
# update version and date within all executables and man pages
# the version used is the one in the file README on the line
# with "VERSION=" in column 1.  The form of that line is:
# RIACS Audit Package version 2.0.0 Fri Jan  6 15:59:55 EST 1989 (bishop@bear)
# version number
VERSION="RIACS Audit Package version 3.1.1 Wed Mar 21 14:46:25 EST 1990 (Matt.Bishop@dartmouth.edu)"
#
# be sure README exists
#
if test ! -s README
then
	echo "$0: missing README file; cannot run!!!" 2>&1
	exit 1
fi
UPVER=no
UPREL=no
WHO=
HOSTNAME=
ARGLIST=
for i in $*
do
	if test -n "$FLAG"
	then
		case $FLAG in
		h)	HOSTNAME="$i";;
		w)	WHO="$i";;
		esac
	fi
	case $i in
	-r)	UPREL=yes;;
	-v)	UPVER=yes;;
	-h*)				# hostname
		HOSTNAME=`expr "$i" : '-h\(.*\)'`
		if test -z "$HOSTNAME"
		then
			FLAG=h
		fi;;
	-w*)				# who
		WHO=`expr "$i" : '-w\(.*\)'`
		if test -z "$WHO"
		then
			FLAG=w
		fi;;
	*)	ARGLIST="$ARGLIST $i";;
	esac
done
#
# VERS is the version information (it follows the = and is in double quotes)
#
grep '> RIACS Audit Package' README | tail -1 > /tmp/$$v
VERS="`sed 's/^> //' /tmp/$$v`"
rm -rf  /tmp/$$v
#
# now walk the argument list
#
for i in $ARGLIST
do
	case $i in
	-s)	WHAT=shellscript;;	# args are shell script files
	-c)	WHAT=cprogram;;		# args are c program files
	-m)	WHAT=manpage;;		# args are manual page files
	-*)				# arg is unknown option
		echo "$0: unknown option $i; use -c, -s, or -m" 2>&1
		exit 1;;
	*)				# file
		#
		# update version number in shell script
		#
		if test "$WHAT" = shellscript
		then
			ed - $i << xxEOEDSCRIPTxx
/^VERSION=/c
VERSION="$VERS"
.
w
q
xxEOEDSCRIPTxx
		#
		# update version number in C program
		#
		elif test "$WHAT" = cprogram
		then
			ed - $i << xxEOEDSCRIPTxx
/^static char \*version =/c
static char *version = "$VERS";
.
w
q
xxEOEDSCRIPTxx
		#
		# update version number in manual page
		#
		elif test "$WHAT" = manpage
		then
			ed - $i << xxEOEDSCRIPTxx
/^\\.\\\\" version$/+1c
.ds Vr $VERS
.
w
q
xxEOEDSCRIPTxx
		#
		# didn't say what it was
		#
		else
			echo "$0: must give one of -c, -m, -s FIRST" 2>&1
			exit 1
		fi;;
	esac
done
#
# bye
#
exit 0
