:
#! /bin/sh
#
# analyze the lists of files and send it to the auditor list
# in a neat format
# note we put a little header up there, and we do so in such a way
# that nothing is mailed is there is nothing to report
#
# Matt Bishop
# Research Institute for Advanced Computer Science
# NASA Ames Research Center
# Moffett Field, CA  94035
#
# mab@riacs.edu, ...!{decvax!decwrl,ihnp4!ames}!riacs!mab
#
# (c) Copyright 1986 by Matt Bishop and the Research Institute for
#			Advanced Computer Science
#
# version number
VERSION="RIACS Audit Package version 3.1.3 Tue May 19 12:59:43 PDT 1992 (Matt.Bishop@dartmouth.edu)"
#
#	system and shell variables
PATH=/usr/ucb:/bin:/usr/bin:%%DESTBIN%%	# execution path
export PATH				# for subprograms
#	variables
HOST=				# name of audited host
FILESYS=			# audited file system
AUDITOR=			# who to mail this list to
OPTIONS=			# a list of options
ONEOUTPUT=			# output to mail or screen
OLDFILES=$1			# list of files deleted
NEWFILES=$2			# list of files added
CHANGES=$3			# list of files that changed
PATCHANGES=$4			# list of mismatched patterns
DEBUG=$5			# -x if debug is on
HEADER=no			# has the header been printed yet
STATUS=0			# 1 if mail is actually sent
MAIL=/tmp/Am$$0			# file to be mailed to AUDITOR
MAILER=%%MAILER%%		# mail program to use
SUBJECT=%%SUBJECT%%		# yes if mailer handles -s flag
				# miscellaneous messages
NEWMSG="The following files have been added:"
OLDMSG="The following files have been deleted:"
CHMSG1="The following files have been changed; the previous attributes"
CHMSG2="are shown on the line with (old), and the current attributes"
CHMSG3="are shown on the line with (new):"
PCMSG1="The following files matched patterns in the pattern master file but"
PCMSG2="the characteristics are different.  If the file has been added since"
PCMSG3="the master files were last generated, the line is labelled (add);"
PCMSG4="if removed, its line is labelled (del), and if changed, the line"
PCMSG5="with the old attributes is labelled (old), and the one with the new"
PCMSG6="attributes is labelled (new); the corresponding pattern and associated"
PCMSG7="attributes are shown on the line with (pat).  If the file name matched"
PCMSG8="more than one pattern, the first pattern only is shown, but the next"
PCMSG9="line beginning with (and) says how many more patterns were matched."
#
# trap on errors
#
trap "rm -f $MAIL; exit 2" 1 2 3 15
#
# set debugging if need be
#
if test "X$DEBUG" != X
then
	set $DEBUG
fi
#
# read the relevant attributes
#
read HOST
read FILESYS
read AUDITOR
read OPTIONS
read ONEOUTPUT
#
# get the host name
#
if test -z "$HOST"
then
	HOST=`hostname`
fi
#
# create the mail file
#
> $MAIL
#
# look for new files
#
if test "$NEWFILES"
then
	if test -s "$NEWFILES"
	then
		HEADER=yes
		echo "$VERSION" >> $MAIL
		echo " " >> $MAIL
		echo "Audit date:  `date`" >> $MAIL
		echo "Host system: $HOST" >> $MAIL
		echo "File system: $FILESYS" >> $MAIL
		echo "Options: $OPTIONS" >> $MAIL
		echo "Copies sent to: $AUDITOR" >> $MAIL
		echo " " >> $MAIL
		echo "$NEWMSG" >> $MAIL
		echo " " >> $MAIL
		auditfmt $NEWFILES >> $MAIL
		echo " " >> $MAIL
	fi
fi
#
# look for old files
#
if test "$OLDFILES"
then
	if test -s "$OLDFILES"
	then
		if test $HEADER = no
			then
			HEADER=yes
			echo "$VERSION" >> $MAIL
			echo " " >> $MAIL
			echo "Audit date:  `date`" >> $MAIL
			echo "Host system: $HOST" >> $MAIL
			echo "File system: $FILESYS" >> $MAIL
			echo "Options: $OPTIONS" >> $MAIL
			echo "Copies sent to: $AUDITOR" >> $MAIL
			echo " " >> $MAIL
		fi
		echo "$OLDMSG" >> $MAIL
		echo " " >> $MAIL
		auditfmt $OLDFILES >> $MAIL
		echo " " >> $MAIL
	fi
fi
#
# look for changed files
#
if test "$CHANGES"
then
	if test -s "$CHANGES"
	then
		if test $HEADER = no
		then
			HEADER=yes
			echo "$VERSION" >> $MAIL
			echo " " >> $MAIL
			echo "Audit date:  `date`" >> $MAIL
			echo "Host system: $HOST" >> $MAIL
			echo "File system: $FILESYS" >> $MAIL
			echo "Options: $OPTIONS" >> $MAIL
			echo "Copies sent to: $AUDITOR" >> $MAIL
			echo " " >> $MAIL
		fi
		echo "$CHMSG1" >> $MAIL
		echo "$CHMSG2" >> $MAIL
		echo "$CHMSG3" >> $MAIL
		echo " " >> $MAIL
		auditfmt $CHANGES >> $MAIL
		echo " " >> $MAIL
	fi
fi
#
# look for changed pattern files
#
if test "$PATCHANGES"
then
	if test -s "$PATCHANGES"
	then
		if test $HEADER = no
		then
			HEADER=yes
			echo "$VERSION" >> $MAIL
			echo " " >> $MAIL
			echo "Audit date:  `date`" >> $MAIL
			echo "Host system: $HOST" >> $MAIL
			echo "File system: $FILESYS" >> $MAIL
			echo "Options: $OPTIONS" >> $MAIL
			echo "Copies sent to: $AUDITOR" >> $MAIL
			echo " " >> $MAIL
		fi
		echo "$PCMSG1" >> $MAIL
		echo "$PCMSG2" >> $MAIL
		echo "$PCMSG3" >> $MAIL
		echo "$PCMSG4" >> $MAIL
		echo "$PCMSG5" >> $MAIL
		echo "$PCMSG6" >> $MAIL
		echo "$PCMSG7" >> $MAIL
		echo "$PCMSG8" >> $MAIL
		echo "$PCMSG9" >> $MAIL
		echo " " >> $MAIL
		auditfmt $PATCHANGES >> $MAIL
		echo " " >> $MAIL
	fi
fi
#
# mail it out
#
if test -s "$MAIL"
then
	if test "$ONEOUTPUT" = yes
	then
		echo "** Audit report for $HOST:$FILESYS **"
		echo ' '
		cat $MAIL
	elif test "$SUBJECT" = yes
	then
		%%MAILER%% -s "Audit report for $HOST:$FILESYS" $AUDITOR < $MAIL
	else
		( echo "** Audit report for $HOST:$FILESYS **"
		  echo ' '
		  cat $MAIL ) | %%MAILER%% $AUDITOR
	fi
	STATUS=1
fi
#
# clean up and exit
#
rm -f $MAIL
exit $STATUS
