.if t .ds Lq \\&``
.if t .ds Rq \\&''
.if n .ds Lq "
.if n .ds Rq "
.de Cw
.cs R 25m
.ss 25m
..
.de cW
.ss
.cs R
..
.ds hO boldface
.de Ho	\" host name
.B "\\$1" "\\$2"
..
.ds mH italics
.de Mh	\" metahost name
.I "\\$1" "\\$2"
..
.ds fN boldface
.de Fn	\" file name
.B "\\$1" "\\$2"
..
.ds mF italics
.de Mf	\" metafile name
.I "\\$1" "\\$2"
..
.ds eV boldface
.de Ev	\" environment variables
.B "\\$1" "\\$2"
..
.ds mV makefile_variable
.de Mv	\" makefile variables
${\f2\\$1\fP}\\$2
..
.de Mp	\" manual page
\f2\\$1\fP(\\$2)\\$3
..
.nr Np 0
.de Np
.nr Np +1
.IP "\\n(Np."
..
.ds LH Version 3.1.0
.ds RH September 28, 1989
.nr PS 12
.nr VS 14
.TL
.ps 14
.vs 16
\!.ps 14
\!.vs 16
Installing the RIACS File Scanning Subsystem
.AU
.ps 12
.vs 14
\!.ps 12
\!.vs 14
Matt Bishop
.AI
Research Institute for Advanced Computer Science
NASA Ames Research Center
Moffett Field, CA  94035
\f2and\fP
Department of Mathematics and Computer Science
Dartmouth College
Hanover, NH  03755
.AB
This guide describes the organization of
the RIACS auditing package,
how to install it,
and how to interpret the output.
.AE
.nr PS 12
.nr VS 14
.FS
.ps 10
.vs 12
This work was supported by grant NCC2-398 from the
National Aeronautics and Space Administration (NASA)
to the
Research Institute for Advanced Computer Science (RIACS);
portions of the work were done at the author's current institution,
Dartmouth College.
.FE
.NH
Introduction
.PP
This document contains installation and configuration instructions
for the RIACS Intelligent Auditing and Categorizing System.
It describes how to set up both local and remote file system auditing.
Logging is done on a time-driven basis,
and auditing in a passive mode.
.PP
The audit package generates a listing of the file system being audited
compares it with a previously-generated listing;
the differences reveal what has changed and these changes are reported.
.PP
In what follows,
file names in
.Fn \*(fN
are real file names;
file names in
.Mf \*(mF
should be replaced by the relevant file names on your system.
Sometimes shell variables are relevant;
these are indicated by
.Ev \*(eV .
Variables defined in the relevant makefile use the syntax of a makefile
variable reference; for example,
.Mv \*(mV .
Finally,
specific host names are in
.Ho \*(hO
and a name that is to be replaced by a host name will be in
.Mh \*(mH .
.NH
Configuring and Compiling the Package
.PP
This package can be compiled on either Berkeley
.UX
or System V
.UX
machines with no changes.
Other versions of
.UX
may require some changes.
.RS
.Np
Determine whether your system is closer to System V or Berkeley
.UX ,
and copy the appropriate file
(\c
.Fn Make.bsd4
or
.Fn Make.sysv )
to
.Fn Makefile .
.Np
Edit
.Fn Makefile .
The parameters which may have to be reset are described
in the next section.
.Np
Switch to the superuser
and compile and install the sources:
.DS B
make install
.DE
If the make dies when it tries to load
.I cdes ,
you have two options.
You can simply delete \*(Lqcdes\*(Rq from the list of executables in the
.Fn Makefile
(the line begins in column 1 with \*(LqEXEC\*(Rq followed by a tab followed by
an \*(Lq=\*(Rq),
or you can (on some systems) retype the command \*(Lqmake install\*(Rq and
it will complete without a problem.
In any event,
you don't have the software to use the supplied encryption and checksumming
program,
so either use something else or don't encrypt things.
.Np
Create the directory for the data files:
.DS C
mkdir \c
.Mv LISTDIR
.DE
.Np
For each host (including the local one) that will be audited,
create a directory for the data files specific to that host:
.DS C
mkdir \c
.Mv LISTDIR /\c
.Mh hostname
.DE
.Np
Configure the data files.
Section 4 describes how to do this.
.Np
Set up a root list for each host;
this list names the roots of the file trees to be audited.
Section 4 describes how to do this.
.Np
For each host which is to be audited remotely,
run the program
.I rinstall .
This takes as arguments a remote host name,
an associated environment file,
an argument (\*(Lqyes\*(Rq or \*(Lqno\*(Rq) saying whether
network messages are to be encrypted,
and an argument (\*(Lqyes\*(Rq or \*(Lqno\*(Rq) saying whether
the programs for the remote host are to be copied into a directory
and moved by the user across to the remote host.
(The latter is appropriate situations where the networks are untrusted
but the hosts are less so.)
If the last argument is \*(Lqno\*(Rq,
this copies several files to the named remote host
and installs them.
If the last argument is \*(Lqyes\*(Rq,
this copies several files into a subdirectory,
builds a shell script and Makefile to compile them on the remote host,
and tells the user how to compile and install the programs;
the user must then transfer the directory to the remote host
(usually using tape)
and do as told.
Unless this is done,
the remote host cannot be audited from the local one.
.Np
Generate and inspect master files for each host.
This is important,
because if no master files are present
and you instruct the audit programs to update the master file
whenever it runs,
you will
.B not
see the first update.
So,
you must check that the master files reflect the desired state of the system.
You ought to go to dinner while this part is being done;
on any decent-sized system,
it takes at least half an hour.
.Np
Set up the auditing commands to run every so often.
Section 5 describes the best way to do this.
.Np
Go home and get some sleep.
.RE
.NH
Makefile
.PP
The
.Fn Makefile
contains several variables that can be changed to provide
the type of auditing desired.
This section summarizes those variables.
.NH 2
CFLAGS
.PP
These are the flags passed to the C compiler.
In addition to the usual ones (see
.I cc (1)),
the following options are useful:
.RS
.de Ip
.IP \f3\\$1\fP \\w'\f3\-DALONE\fP\0'u
..
.Ip \-BSD4
Set this if your version of
.UX
is (or is derived from) the Fourth Berkeley Software Distribution.
.Ip \-DSYSV
Set this if your version of
.UX
is (or is derived from) System V.
.Ip \-DCRAY
Set this if you are using a Cray running UNICOS 5.0 or later.
.Ip \-DNFS
Set this if your system uses NFS.
This requires the library routines
.I getmntent (3),
.I setmntent (3),
and
.I endmntent (3).
.Ip \-DALONE
Set this if you do not have the
.I deszip
library available.
If you don't know what
.I deszip
is,
you don't have it.
.REE
.NH 2
DESLIB
.PP
If you have the
.I deszip
library available,
set this to its location.
.NH 2
VERSION
.PP
Set this to \*(Lq\-r\*(Rq when you modify the package,
and run \*(Lqmake version\*(Rq.
This updates the version information in the files.
.NH 2
ROOTDIR
.PP
This is the root of the audit file tree.
All directories and programs related to the audit
(that is,
executables and data files)
should go under this directory.
.NH 2
AUDITOR
.PP
This variable should be set to a list of addresses
of people who are to receive the audit report
and any error messages from the audit.
If more than one address is to be specified,
separate the addresses by commas.
The addresses may be on the local machine or remote.
The setting of this option may be overridden when the
audit is run.
.NH 2
CAT
.PP
This is the
.I cat (1)
command and is usually in
.B /bin .
.NH 2
DESTBIN
.PP
This is the directory where the executable files are to be placed
on the local machine.
Both shell scripts and executable object files go there.
Be aware that the programs
.Fn auditls ,
.Fn ftype ,
and
.Fn lstat
are assumed to reside in this directory
on the remote host,
unless another path is specified.
(See the
.Fn Environ
file,
below.)
.NH 2
DESTMAN
.PP
This is the root of the directory tree where manual pages are put.
It assumes there are subdirectories
.Fn man1
and
.Fn man8 .
.NH 2
DESTSRC
.PP
If the auditing system is to audit more than one machine,
the machine on which the auditing is done is called the
.I server
and the machines being audited are the
.I clients
(yes, one machine can be the server and a client at the same time!)
Client machines must have three programs installed.
This is the directory containing the sources and makefiles
that are sent to the client.
.NH 2
ECHO
.PP
This is the
.I echo (1)
command and is usually in
.B /bin .
.NH 2
FILESYS
.PP
This is the root of the file tree that will be audited if
no other file tree is specified.
There are numerous ways to specify the root of the file tree
to be audited at run time,
so pick something that is quick.
.NH 2
LIMIT
.PP
This is the number of days for which
.Fn Reject
files are valid.
.NH 2
LISTDIR
.PP
This variable specifies the root of a set of directories
which hold the data files.
.NH 2
MAILER
.PP
This is the program that is used to mail error messages and
the results of an audit to the appropriate people.
It is invoked by giving the list of addresses,
separated by blanks,
as command-line arguments,
and the letter as standard input.
If possible,
a \*(LqSubject: \*(Rq field may be specified using an \*(Lq\-s\*(Rq
option;
see
.B SUBJECT ,
below.
.NH 2
MINCT
.PP
When there are fewer than this many files in a directory,
the
.B THRESH
limit is ignored.
This is useful when the directory being audited is very small
and deleting any file from it appears to the audit package
as a catastrophic loss.
(See
.B THRESH ,
below.)
.NH 2
REMCOPY
.PP
This is the program used to copy files to a client.
It is called with two arguments:
the first is the name of the file to be copied,
and the second the name of the remote host
followed by a colon
followed by the name the file is to be copied to.
.NH 2
REMEXEC
.PP
This is the program that is used to execute a command remotely.
It is called with several arguments:
the first is a host name,
the second a \*(Lq\-n\*(Rq flag to indicate that there is no input,
and the third and successive arguments are a standard
.UX
command with its arguments.
This program invokes a file system logging program
on a remote system when a remote audit is being done,
and to perform remote compilation when three programs
are being installed on clients.
.NH 2
RM
.PP
This is the
.I rm (1)
command and is usually in
.B /bin .
.NH 2
SED
.PP
This is the
.I sed (1)
command and is usually in
.B /bin .
.NH 2
SHELL
.PP
On some versions of
.UX ,
the specific shell
.Mp make 1
uses to run its commands is determined by the setting of this variable.
It should be set to the Bourne shell
.Mp sh 1 .
.NH 2
SUBJECT
.PP
The legal settings of this field are \*(Lqyes\*(Rq and \*(Lqno\*(Rq.
If the mailer allows specification of a \*(LqSubject: \*(Rq header field
by giving a command-line option of the form \*(Lq\-s "\f2subject\fP"\*(Rq,
set this to \*(Lqyes\*(Rq.
Then the first and second command-line arguments will be set to
\*(Lq\-s "\f2subject\fP"\*(Rq,
and the addresses will be the third (and successive) arguments.
.NH 2
TEST
.PP
The shell command
.Mp test 1
is either a built-in command
or a binary,
usually in
.Fn /bin .
Define this as
.Fn test
if it is a built-in shell command,
or to the path name of the executable if it is not.
.NH 2
THRESH
.PP
Under certain circumstances
(notably if network software is unreliable),
the auditing program will scan only part of a file system
before the scan ends.
The result is that a large number of files in that file system
will be reported as deleted.
Since the master file may be changed,
this also results in a bogus message the next time the scan
does succeed,
since all those files will show as having been added.
Use this variable to control this problem;
when
.Mv THRESH
is set to a positive value,
the master file will never be replaced
unless the new master file would be greater than
.Mv THRESH
percent of the old.
For example,
if the old master file showed 100 files in
.Fn  /bin ,
and the scan of
.Fn /bin
showed 12,
the results of the scan would be saved,
an error message describing the problem
and what to do would be generated,
and the master file would remain in place.
A reasonable value to set this to is 10 (for 10%.)
.PP
If the directory contains very few files,
.B THRESH
may cause the generation of an error message
when it is not appropriate.
For this reason,
a minimum number of files may be defined
so that if the directory contains no more than
that many files,
the
.B THRESH
mechanism is disabled.
See
.B MINCT ,
above.
.NH 2
TIMEOUT
.PP
When the command to log information about the file system is run,
it is possible that the command may hang.
(This is especially true during a remote file system audit;
problems with the communications protocols or medium
may cause this to happen.)
Every
.Mv TIMEOUT
seconds,
the file system listing program will be checked to determine
if the process has hung.
If so,
it will terminate the process.
If you do not wish this to be done,
set the value of this variable to 0;
this disables the timeout feature.
.NH 2
TMPDIR
.PP
Temporary files generated during the audit go in this directory.
The directory may be protected;
the audit package must be able to create and delete directories
in it,
but that is all.
It is
.I strongly
recommended that neither
.Fn /tmp
nor
.B /usr/tmp
be used,
because that enables people to delete the temporary files
during processing and can corrupt the results of the audit.
.NH 2
EQN, BIB, ROFF, and TBL
.PP
These are the commands used to print the paper \*(LqSecurity Monitoring\*(Rq
and the installation guide.
.Mv EQN
should be
.Mp eqn 1
or its equivalent,
.Mv BIB
should be
.Mp bib 1
or
.Mp refer 1
or its equivalent,
.Mv TBL
should be
.Mp tbl 1
or its equivalent,
and
.Mv TROFF
should be
.Mp troff 1
or its equivalent.
.NH 2
Defaults
.PP
The following table summarizes the default settings:
.KS
.TS
box, center;
c s s
l l l.
Makefile variables
=
\f2variable\fP	\f2default\fP	\f2what it means\fP
_
AUDITOR	root	where to send audit results
CAT	/bin/cat	\f2cat\fP(1) program
CFLAGS	(\f24BSD\fP) -O -DBSD4 -DALONE	\f2cc\fP(1) options
\^	(\f2SYSV\fP) -O -DSYSV -DALONE	\^
DESLIB	\f2not set\fP	location of \f2deszip\fP library
DESTBIN	${\f2ROOTDIR\fP}/=bin	where to put executables
DESTMAN	(\f24BSD\fP) /usr/local/man	where to put manual pages
\^	(\f2SYSV\fP) /usr/local/man/a_man	\^
DESTSRC	${\f2ROOTDIR\fP}/=src	where to put sources for clients
ECHO	/bin/echo	\f2cat\fP(1) program
FILESYS	/bin	file system to be audited
LIMIT	1	days to leave unmodified reject files
LISTDIR	${\f2ROOTDIR\fP}	where data files are kept
MAILER	(\f24BSD\fP) Mail	program to mail results
\^	(\f2SYSV\fP) mailx	\^
MINCT	20	min directory size for THRESH
REMCOPY	rcp	remote copy command
REMEXEC	(\f24BSD\fP) rsh	remote execution command
\^	(\f2SYSV\fP) remsh	\^
RM	/bin/rm	\f2rm\fP(1) program
ROOTDIR	/usr/local/adm/audit	root for audit system
SED	/bin/sed	\f2sed\fP(1) program
SHELL	/bin/sh	shell used by \f2make\fP(1)
SUBJECT	yes	does MAILER know \*(Lq\-s\*(Rq
TEST	(\f24BSD\fP) /bin/test	\f2test\fP(1) program
\^	(\f2SYSV\fP) test	\^
THRESH	10	audit suspicion threshhold
TMPDIR	${\f2ROOTDIR\fP}/=tmp	where temporary files go
VERSION	\f2not set\fP	how to update version information
.TE
.KE
.LP
See the individual entries above for more details
.NH
Files
.PP
There are several type of files relevant to the audit system.
This section describes each one,
especially those that the user must set up.
.NH 2
${\kx\f2LISTDIR\fP\h'|\nxu+2u'\f2LISTDIR\fP}
.PP
This directory contains the subdirectories that the audit package
will scan during the course of its audit.
The directories may be named anything convenient;
a good convention is to name them after the host to be audited.
For example,
if the hosts
.Ho icarus ,
.Ho hydra ,
and
.Ho miranda
would be audited by this system,
.Mv LISTDIR
would contain three subdirectories:
.RS
.IP \(** 2n
.Mv LISTDIR /\c
.Ho icarus
contains the data files for
.Ho icarus ;
.IP \(** 2n
.Mv LISTDIR /\c
.Ho hydra
contains the data files for
.Ho hydra ;
and
.IP \(** 2n
.Mv LISTDIR /\c
.Ho miranda
contains the data files for
.Ho miranda .
.RE
.NH 2
.Fn Environ
.PP
Each host directory must contain one of these.
Lists of files on remote hosts are generated
by a script on the remote host;
as a result,
certain programs on the remote host must be installed and executed.
This file contains the path name of the programs involved
as well as information about encryption and installation.
.PP
The
.Fn Environ
file consists of lines of two fields separated by blanks or tabs,
the first of which must begin in the first column.
The first field contains the name of the command;
the second,
the full path name of the remote command.
Anything following the second field is treated like a comment
and is ignored.
.PP
The following are the defined entries in the first field and what they mean.
The defaults are given below.
.RS
.IP \(** 2n
.Fn auditls
is the program that generates the listing.
It is a shell script located in the audit package source directory.
.IP \(** 2n
.Fn cat
is the catenation program
.Mp cat 1 .
.IP \(** 2n
.Fn cflags
is a set of command line options to be passed to
.Mp cc 1
on the remote host when the server is installed.
An appropriate second field is \*(Lq\-DSYSV \-DNFS\*(Rq,
for example.
.IP \(** 2n
.Fn checksum
is the program to compute the file's checksum.
It is executed by the shell,
and the
.I first
\*(Lq%s\*(Rq is replaced (using
.Mp printf 3S )
with the name of the file being checksummed.
.IP \(** 2n
.Fn crypt
is a program that does encryption.
If the client and server are to send encrypted messages to each other,
this must be defined;
otherwise it may be omitted.
The program
.I cdes
in the audit source directory will do DES encryption in various modes.
.IP \(** 2n
.Fn delete
is the file deletion utility
.Mp rm 1 .
.IP \(** 2n
.Fn echo
is the argument printing program
.Mp echo 1 .
.IP \(** 2n
.Fn edit
is the stream editing program
.Mp sed 1 .
.IP \(** 2n
.Fn libs
is a set of libraries to be passed to
.Mp cc 1
on the remote host when the server is installed.
For example,
if the
.I deszip
library is on the remote host and you are going
to use end-to-end encryption with
.Mp cdes 1 ,
make the second field be the location of the
.I deszip
library to improve performance.
.IP \(** 2n
.Fn locdec
is the command to read messages from the server.
If encryption is not being used,
set this to
.Mp cat 1  ;
otherwise set it to the appropriate decryption program.
Note you may have to put a key in this file,
since the audit package will not understand being prompted for one.
Also note the programs are run on the local host,
so any key will
.B never
be sent over the network.
.IP \(** 2n
.Fn locenc
is the command to send messages to the server.
If encryption is not being used,
set this to
.Mp cat 1  ;
otherwise set it to the appropriate encryption program.
Note you may have to put a key in this file,
since the audit package will not understand being prompted for one.
Also note the programs are run on the local host,
so any key will
.B never
be sent over the network.
.IP \(** 2n
.Fn makedir
is the directory on the remote host in which the audit programs
are to be compiled and from which they will be installed.
All executables and object files will be deleted once made.
.IP \(** 2n
.Fn mount
is the program that lists the names and types of the volumes
that file systems are mounted on;
it is usually
.Mp mount 1
or
.Mp mount 8
(depending on the distributor).
.IP \(** 2n
.Fn remdec
is the command the server uses to read messages from clients.
If encryption is not being used,
set this to
.Mp cat 1  ;
otherwise set it to the appropriate decryption program.
Note you may have to put a key in this file,
since the audit package will not understand being prompted for one.
Also note this command (key included) will be placed in
the remote server script when it is installed.
This exposes the key to being read as the script is copied over the network.
If this is a concern,
inform
.I rinstall
you wish to move the programs to the remote host yourself,
and do so via a medium other than the network.
.IP \(** 2n
.Fn remenc
is the command to send messages to the server.
If encryption is not being used,
set this to
.Mp cat 1  ;
otherwise set it to the appropriate encryption program.
Note you may have to put a key in this file,
since the server will not understand being prompted for one.
Also note this command (key included) will be placed in
the remote server script when it is installed.
If this is a concern,
inform
.I rinstall
you wish to move the programs to the remote host yourself,
and do so via a medium other than the network.
.IP \(** 2n
.Fn rsh
is the program that executes another program on a remote host.
The format of the command must be
.DS C
\f2rsh\fP \f2host\fP \-l\f2account\fP \f2command\fP
.DE
where
.I rsh
is the appropriate command.
.IP \(** 2n
.Fn scan
is the program that walks the file tree
and lists the files in an auditable form.
The source to this program is in the audit package directory
and is called \*(Lqauditscan.c\*(Rq.
.IP \(** 2n
.Fn test
is the shell's condition command
.Mp test 1 .
If it is built into the shell
(as for System V),
do not specify a path name;
otherwise, do.
.IP \(** 2n
.Fn user
is the account under which the remote auditing software is to be installed;
for example,
if it is to run under the user
.I audit
on the remote machine, the second field should be
.I audit .
.RE
.PP
Here is a sample file:
.KS
.TS
center;
c c c
l l l.
# keyword	program	function
auditls	/usr/local/adm/audit.srv/auditls	# audit server
scan	/usr/local/adm/audit.srv/auditscan	# file tree scanner
checksum	/bin/sum %s	# checksum command
.TE
.KE
This file indicates that when the auditing package issues the command
to scan the remote file system,
it will use the command
.Fn /usr/local/adm/audit.srv/auditls .
When that command calls the file lister,
it will use
.Fn /usr/local/adm/audit.srv/auditscan
to do so,
and the checksum for
.I file
will be computed by the shell command
.DS C
/bin/sum \f2file\fP
.DE
Everything else assumes default values;
these are:
.KS
.TS
box, center;
c s s
c c c
l l l.
\f3Environ\fP Defaults
=
\f2command\fP	\f2path name\fP
_
auditls	${\f2DESTBIN\fP}/auditls	remote audit server
cat	/bin/cat	\f2cat\fP(1) program
cflags	${\f2CFLAGS\fP}	flags to \f2cc\fP(1)
checksum	(\f24BSD\fP) /bin/sum < %s	checksum command
\^	(\f2SYSV\fP) /usr/bin/sum < %s	\^
crypt	${\f2DESTBIN\fP}/cdes	encryption program
delete	/bin/rm	\f2rm\fP(1) program
echo	/bin/echo	\f2echo\fP(1) program
edit	/bin/sed	\f2sed\fP(1) program
libs	\f2none\fP	remote libraries
locdec	/bin/cat	decrypt messages from server
locenc	/bin/cat	encrypt messages to server
makedir	\f2not set\fP	where to build remote programs
mount	/etc/mount	\f2mount\fP(1/8) program
remdec	/bin/cat	decrypt messages from client
remenc	/bin/cat	encrypt messages to client
rsh	(\f24BSD\fP) /usr/ucb/rsh	remote execution command
\^	(\f2SYSV\fP) /usr/bin/remsh	\^
scan	${\f2DESTBIN\fP}/auditscan	scan remote file system
test	(\f24BSD\fP) /bin/test	\f2test\fP(1) program
\^	(\f2SYSV\fP) test	\^
user	\f2same as on local host\fP	who to run as
.TE
.KE
.PP
Note that lines which do not begin in column 1 are ignored
and so may be used for comments.
Hence the first two lines of the above file affect nothing.
.LP
.B
IMPORTANT: If a client is running a BSD-based
.UX
and the server is running a System V-based
.UX ,
specify
\kx\f2test\fP\h'|\nxu+2u'\f2test\fP
in the Environ file,
or the remote audit will not work.
The same holds if a client is running a System V-based
.UX
and the server is running a BSD-based
.UX .
.R
.NH 2
.Fn Equiv
.PP
This file is used to map various host names to directory names.
It consists of lines of two fields separated by blanks or tabs,
the first of which must begin in the first column.
The first field contains a version of the host name;
the second,
the name of the subdirectory of
.Mv LISTDIR
that contains the associated data files.
Anything following the second field is treated like a comment
and is ignored.
Here is a sample file:
.KS
.TS
center;
l s s
c c c
l l l.
 This file contains the mappings from host names to directories.
 host	directory	any comments
icarus.riacs.edu	icarus	full domain names
hydra.riacs.edu	hydra
miranda.riacs.edu	miranda
riacs-icarus.arpa	icarus	old-style arpanet name
.TE
.KE
Requesting any of the systems
.Ho icarus.riacs.edu ,
.Ho icarus ,
and
.Ho riacs-icarus.arpa
will use the files in
.Mv LISTDIR /\c
.Ho icarus .
However,
the remote communications protocol will access the
remote host by the given name,
not the name in field 2;
so if the last form were used,
the remote connection would be made to
.Ho riacs-icarus.arpa
(which ought to be the same as
.Ho icarus !)
.PP
No host name in the second column may contain a comma.
That character indicates the data files for the host named
in the first column are distributed among several directories.
This format will be described at the end of this section.
.PP
Also,
do not use domains in the second column.
For compatibility reasons,
when determining the name of the
.I current
host,
the sudit program will strip everything including and following the first
period (\*(Lq.\*(Rq) in the host name.
If you do put a period in the name
(for example,
by having the fully qualified domain name in the second column),
the audit will proceed using the remote execution commands
even though the local host is being audited.
.PP
Note that lines which do not begin in column 1 are ignored
and so may be used for comments.
Hence the first two lines of the above file affect nothing.
.NH 2
.Fn F*
.PP
These files contain the master lists.
They may be generated automatically using the audit system,
and this should be done,
since the auditing mechanism is very sensitive to the format
of these files.
The files are named by deleting all \*(Lq/\*(Rqes from the
name of the root directory of the file tree,
prefixing a \*(LqF\*(Rq,
and (on some systems) truncating the name to 14 characters
(this is a result of system limits;
the program will not do this.)
If the examination is confined to specific types of files,
the following prefixes are used,
rather than \*(LqF\*(Rq:
.TS
center;
cfI  cfI
cfB  lfR .
prefix	characteristics
F1	setuid
F2	setgid
F3	setuid,setgid
F4	char device
F5	char device,setuid
F6	char device,setgid
F7	char device,setgid,setuid
F8	block device
F9	block device,setuid
FA	block device,setgid
FB	block device,setuid,setgid
FC	block device,char device
FD	block device,char device,setuid
FE	block device,char device,setgid
FF	block device,char device,setgid,setuid
.TE
.PP
Each line in the master file has the following file components in this order:
file name,
type of file,
protection mode,
number of (hard) links,
owner,
group,
size in bytes,
and time of last modification;
the fields are separated by tabs.
For example,
part of the listing for the directory
.Fn /etc
might look like:
.DS B
.nf
.ps 10
.vs 12
.ta 6n 12n 18n 24n 30n 36n 42n 48n 54n 60n
.Cw
/etc/pac	-	0755	1	root	root	16384	12 22341	Jan 12, 1987 at 12:47:54
/etc/passwd	-	0644	1	root	root	5061	*skipped*	May 20, 1987 at 16:16:48
/etc/passwd.dir	-	0644	1	mab	root	4096	*skipped*	Apr 29, 1987 at 08:51:54
/etc/passwd.pag	-	0644	1	mab	root	26624	*skipped*	May 20, 1987 at 16:16:48
/etc/pcnamed	-	0755	1	root	root	16384	22 76253	Mar 20, 1986 at 21:28:55
/etc/pctimed	-	0755	1	root	root	16384	12 12124	Mar 20, 1986 at 21:28:55
/etc/phoned	-	4700	1	root	root	25600	71 23615	Mar 20, 1986 at 21:28:56
/etc/phones	-	0664	1	root	root	531	45 63721	Feb 12, 1987 at 14:09:19
etc/ping	-	4755	1	root	root	22528	30 62562	Jan 12, 1987 at 12:47:55
.cW
.vs
.ps
.DE
.LP
Characteristics of some of these files are expected to change occasionally
and should not be reported,
lest the auditors become swamped with data;
for example,
the size of the password file might change as users change the GECOS field,
and this should not be reported.
On the other hand,
if the owner or protection mode of the password file changes,
this should be reported.
To provide this ability,
if any field in the master file is replaced with an asterisk \*(Lq\(**\*(Rq,
the field is ignored during the audit.
So,
for example,
changing the line for the file
.Fn passwd
to
.DS B
.nf
.ps 10
.vs 12
.ta 6n 12n 18n 24n 30n 36n 42n 48n 54n 60n
.Cw
/etc/passwd	-	0644	1	root	root	\(**	\(**	\(**
.cW
.vs
.ps
.DE
has the desired effect.
.NH 2
.Fn P*
.PP
These files contain the pattern master lists.
These are similar to the master files
but instead of a file name in the first field,
thre is an
.Mp ed 1
style pattern.
If a file has been added or deleted,
its name is compared to the patterns in the file;
if it matches any,
the characteristics are compared.
If the characteristics are the same as those given with the pattern,
the added or deleted file is not reported;
if they differ from those of
.I all
matching patterns in the pattern master file,
the added or deleted file is reported.
The files are named in the same way as the master files,
with
.B P
replacing
.B F .
.PP
Pattern master files aid in auditing spool directories;
for example,
mail data files in the spool directory have names beginning with
\*(Lqdf\*(Rq,
and five digits and a letter follow that.
Since these data files are expected to be created and deleted,
they should not be reported if their characteristics are
as expected for mail files
(that is,
.I root
owned
group
.I daemon ,
and protection mode 0644).
But if a mail data file has protection mode 4701,
this should be reported.
The pattern master file for the mail spool directory would contain:
.DS B
.nf
.ps 10
.vs 12
.ta 6n 12n 18n 24n 30n 36n 42n 48n 54n 60n
.Cw
/usr/spool/mqueue/df[0-9]*[a-z]	-	0644	\(**	root	daemon	\(**	\(**	\(**
.cW
.vs
.ps
.DE
Then any mail data file with permission not 0644,
not owned by
.I root,
or not in the group
.I daemon ,
would be reported.
All others would be ignored.
.NH 2
.Fn I*
.LP
(\c
.B
\kx\f2Warning\fP\h'|\nxu+2u'\f2Warning\fP:
use of this mechanism weakens the ability of this package
to detect corruptions or attacks.
This mechanism is provided simply for backward compatibility,
and may be eliminated at the next release.
It is
\kx\f2strongly\fP\h'|\nxu+2u'\f2strongly\fP
recommended you use the pattern master files and/or wildcards to
achieve the same effect.
.R
)
.PP
These files contain the ignore lists.
When an audit is run,
there are certain files that are expected to change,
and the auditors do not want these changes to be reported.
(An example is the file
.Fn /etc/utmp ,
which is changed whenever a user logs in or logs out.)
These files provide a mechanism to eliminate such files
from the audit.
.PP
The name of each ignore file is the same as the master file
associated with the root directory,
except that the leading \*(LqF\*(Rq is replaced by an \*(LqI\*(Rq.
Each line of the ignore file contains a pattern suitable for passing to
.Mp egrep 1
that will match the files which are to be ignored.
The field ends with a newline or tab.
Anything on the line following that field is ignored;
it is very strongly recommended that you put a comment there,
explaining why that file is being ignored.
Here is a sample ignore file for the root directory;
it is named
.Fn I :
.LD
.nf
.ta 6n 12n 18n
\e\(**	This lists files in the root directory not to be audited.
\e\(**	All these suckers are directories; they will be audited
\e\(**	separately.  This is the file for hydra.riacs.edu.
\e\(**	
\e\(**
^/bin$/		directory with system programs used in single user mode
^/dev$/		directory with device files
^/etc$/		directory with maintenance programs
^/lib$/		directory with library programs
^/lost+found$/	directory for wayward files on this partition
^/mnt$/		directory used to mount new file systems
^/pub$/		directory with "public" stuff; really manufacturer's idea
^/stand$/		directory with standalone programs
^/sys$/		directory with system sources
^/tmp$/		directory used for temporary files by everyone
^/u1$/		directory containing one set of users
^/u2$/		directory containing another set of users
^/usr$/		directory containing links to u1 and u2
^/x.*		garbage files
.fi
.DE
.in 0
The first five lines are comments.
(How many files named
.Fn \(**
are in your root directory?)
The remainder are entries for root subdirectories;
since the important ones are audited separately,
and the unimportant ones (like
.Fn /tmp )
are expected to change,
we can ignore the changes in size to the directory files.
The files beginning with \*(Lqx\*(Rq are temporary files
included to show how to apply pattern matching;
no files or directories beginning with \*(Lqx\*(Rq will
be audited.
.PP
Note that the full (absolute) path names of the files are listed,
.I not
the relative file names as in earlier versions.
Further,
note the \*(Lq^\*(Rq and the \*(Lq$\*(Rq;
this forces,
for example,
the line
\*(Lq^/bin$/\*(Rq
to match only the file
.Fn /bin
and not
.Fn /bin/sh .
The \*(Lq/\*(Rq at the end of the field means that,
even though the directory named is to be ignored,
the subdirectories and files it contains are to be scanned.
Were this \*(Lq/\*(Rq omitted,
no files or subdirectories under
.Fn /bin
would be examined at all.
.NH 2
C*
.PP
The auditing package has the option to checksum any subset of files
in the system being audited.
These files,
named in the same way as the master files
but with
.B C
replacing
.B F ,
list the full path names of those files to be checksummed.
This is useful when using cryptographic checksumming,
because often the computation of such a checksum is so slow
that the audit will take too long.
Using this mechanism,
certain key,
critical files can be singled out for special checking.
.NH 2
Reject
.PP
There are times when a system administrator wants to suppress messages
about changes to a specific file;
this usually happens when a file on an
audited subsystem is updated or changed.
The ignore file mechanism is not suitable for this,
because ignore files
.I permanently
eliminate the file from the listing.
A clumsy solution is to have the system administrator
add the file name to the appropriate ignore file
and delete it after the audit has run again.
.PP
Reject files provide a cleaner mechanism to do this.
A reject file contains a list of file names,
one per line;
each file name must be a full path name and
no pattern matching is done.
(If the file name ends in \*(Lq/\*(Rq,
it is taken to be a directory,
and both it and all files and subdirectories in
the tree rooted at that directory are ignored.)
When any of these files show up in the audit listings,
they are ignored,
just as though they had been entered in the appropriate ignore file.
However,
if the reject file has not been modified (written) in the past
.Mv LIMIT
days,
it is deleted instead of being used.
.PP
A sample reject file is:
.DS I
/vmunix
/bin/su
/usr/src/bin/su/
.DE
The first two lines state that any change to the files
.Fn /vmunix
and
.Fn /bin/su
are to be ignored;
the third line states that if the directory
.Fn /usr/src/bin/su
or any file or subdirectory below it has been changed,
that is to be ignored.
.NH 2
List
.PP
A
.Fn List
file lists the roots of the file trees to be audited,
and for each root in the list specify a set of options
that will be applied to that file tree only along with
the other command line options.
This also allows the auditing system to scan a different set
of file trees for each system.
.PP
A
.Fn List
file consists of the names of the roots of the file trees to be scanned,
one per line,
followed by any options to be added to those specified on the command line
when that file tree is scanned.
Here is a sample
.B List
file:
.DS I
/ \-d
/bin
/usr/bin
/usr/ucb
/usr/unsupported/bin \-u
.DE
The last line states that when the file system
.Fn /usr/unsupported/bin
is audited,
the
.Fn \-u
option is to be used in addition to any command line options;
all other file systems just use the given command line options.
.PP
The
.Fn List
file goes in the appropriate host file directory;
so,
.RS
.IP \(** 2n
the
.Fn List
file for
.Ho icarus
is
.Mv LISTDIR /\c
.Ho icarus /\c
.Fn List ;
.IP \(** 2n
the
.Fn List
file for
.Ho hydra
is
.Mv LISTDIR /\c
.Ho hydra /\c
.Fn List ;
and
.IP \(** 2n
the
.Fn List
file for
.Ho miranda
is
.Mv LISTDIR /\c
.Ho miranda /\c
.Fn List .
.RE
.PP
There is one special option available within a
.Fn List
file that is not available elsewhere.
If the character ampersand (\*(Lq&\*(Rq) appears by itself
(that is,
not as part of some other option)
on a line,
the audit for that file system will be run in parallel
with other audits.
This provides the background mechanism that the shell provides
when a command is followed by \*(Lq&\*(Rq.
.NH 2
.Fn Equiv
again
.PP
At times it is convenient to have the
.Fn F* ,
.Fn I* ,
.Fn P* ,
.Fn C* ,
.Fn Reject ,
.Fn List ,
and
.Fn Environ
files for one host in different directories.
For example,
consider an environment with 35 computers all of a single type.
Some are used for production runs,
some for developing new software,
some for network connections,
and some for administration.
In this case,
it may be necessary to have 4 sets of master lists,
three sets of ignore lists
(assuming the network connection and
administration systems use the same ignore lists),
2 sets of
.Fn List
files,
and one common
.Fn Environ
file.
.PP
To allow this,
the
.Fn Equiv
file has a special syntax for the second column.
In this format,
there are four subfields separated by commas.
The first contains the name of the subdirectory with the master lists,
the second the name of the subdirectory with the ignore lists and reject file,
the third the name of the subdirectory with the
.Fn List
file,
and the fourth the name of the subdirectory with the
.Fn Environ
file.
For example:
.KS
.TS
center;
l s s
c c c
l l l.
 This file contains the mappings from host names to directories.
 host	directory	any comments
icarus.riacs.edu	mriacs,iicarus,Listd,Envd	full domain names
hydra.riacs.edu	mriacs,ihydra,Listd,Envd
miranda.riacs.edu	mriacs,imiranda,imiranda,imiranda
.TE
.KE
With this configuration,
audits of
.Ho icarus.riacs.edu
and
.Ho hydra.riacs.edu
will use the same set of master lists (those in the subdirectory
.Fn mriacs )
and the same
.Fn List
and
.Fn Environ
files (\c
.Fn Listd/List
and
.Fn Envd/Environ ,
respectively)
but separate sets of ignore lists and reject files.
Audits of
.Ho miranda.riacs.edu
will use the same master lists as
.Ho icarus.riacs.edu
and
.Ho hydra.riacs.edu ,
and all other data files for
.Ho miranda.riacs.edu 's
audit will be found in the subdirectory
.Fn imiranda .
.PP
If fewer than four subfields are given,
the last subfield is used for the missing ones.
Thus,
the last two
.Fn imiranda s
could have been omitted from the last line of the sample
.Fn Equiv
file above.
.NH
Running an Audit
.PP
The actual auditing script is
.Fn audit .
The interface to this program is horrendous,
because it is designed to be able to work for very odd configurations.
(Masochists may refer to
.Mp audit 8 .)
The script
.Fn runaudit
provides a simple,
efficient interface,
and is the way to run an audit easily.
.PP
.Fn Runaudit
has several options:
.IP \-1
Collect the output from all file systems audited in this run
and mail it to the auditor(s) in one letter.
Any errors will also be collected and sent in a separate letter.
.IP \-a
This option lists the people to whom the results of the audit
are to be sent.
If this option is given,
no messages are sent to the address named in
.Mv AUDITOR .
As an example,
the option
.DS C
\-aauditor,audit@domain
.DE
sends the results of the audit to
.Ho auditor
and
.Ho audit@domain .
.IP \-c
Checksum all files.
This option is the same as providing a
.Fn C*
file with all files scanned listed in it.
.IP \-d
Do not recurse down the file tree.
If this option is given,
.I only
the root directory of the file tree is audited.
.IP \-g
Generate a master file.
Future audits will compare the information gathered from the files
on the system
with the data in this file,
and report any differences.
.IP \-ga
Audit the file tree,
and then replace the master file with a new master file
reflecting the state of the system at the time the audit is done.
This is useful when the system changes often;
the auditors see the changes once,
when they occur,
rather than every day thereafter.
.IP \-h
This option runs an audit on a remote system.
The option
.DS C
\-hicarus
.DE
will audit the host
.Ho icarus .
Using this option causes
.I runaudit
to look in a specific directory
(see the section on the
.Fn Equiv
file) for the data files;
if no
.Fn Equiv
file is present,
or the host is not listed in it,
the name of the directory is that of the given host.
.IP \-n
This option lists the types of volumes on which no
auditing is to be done.
For example,
if only locally-mounted file systems are to be audited,
the option
.DS C
\-nnfs,rfs
.DE
will prevent any file system mounted on volumes of type
.I nfs
or
.I rfs
(both of which usually indicate that the file volumes
are mounted remotely) from being audited.
This is useful in an environment where there are file servers,
such as NFS.
.IP \-o
With this option,
only filesystems mounted on volumes of the specified types will be audited.
For example,
if only remote-mounted file systems are to be audited,
the option
.DS C
\-onfs,rfs
.DE
will prevent any file system mounted on volumes of type other than
.I nfs
and
.I rfs
(both of which usually indicate that the file volumes
are mounted remotely) from being audited.
It is the exact complement to the option
.B \-n .
This is useful in an environment where there are file servers,
such as NFS.
.IP \-q
If no changes have been made to the audited file system
and no errors are generated,
the people to be sent results are informed of this.
One letter per file system is generated,
and where possible the message is put in the subject of the letter
(to save having to read the whole letter.)
Giving this flag prevents such messages from being sent.
.IP \-r
The rest of this argument
(or the next one,
if no more)
is the name of the Reject file.
Note this is the temporary ignore mechanism,
and its use is
.B strongly
discouraged.
.IP \-sb
Check only those files which are block special files.
If used in conjunction with any of the other \-s options,
it checks files which are any of the types indicated by those options.
.IP \-sc
Check only those files which are character special files.
If used in conjunction with any of the other \-s options,
it checks files which are any of the types indicated by those options.
.IP \-sg
Check only those files with the setgid bit set.
This is done regardless of the group of the file.
If used in conjunction with any of the other \-s options,
it checks files which are any of the types indicated by those options.
.IP \-sG
This is like
\-sg
except that directories with the setgid bit set are ignored.
Some
.UX
systems (such as SunOS 4.0 and later)
use this bit for purposes other than changing identity.
If used in conjunction with any of the other \-s options,
it checks files which are any of the types indicated by those options.
.IP \-su
Check only those files with the setuid bit set.
This is done regardless of the owner of the file.
If used in conjunction with any of the other \-s options,
it checks files which are any of the types indicated by those options.
.IP \-u
When this option is given,
the audit system mails a letter to every user who owns a file
that has changed.
The message is in the form of an audit report.
If the ownership of a file has changed,
both the old and new owners receive messages.
This is useful in scanning file trees where users put contributed
software.
.PP
A typical set of commands to audit a computer system would be:
.DS I
runaudit -d -ga -aroot
runaudit -ga -su -sg -aroot /
.DE
.LP
The first line instructs the audit system to scan the directories
listed in
.Mv LISTDIR /\c
.Mh localhost /\c
.Fn List
and report changes.
The second command scans the entire
.UX
file system,
and reports changes made to setuid and setgid files.
.NH
Reading An Audit Report
.PP
A typical audit report looks like this:
.LD
.nf
.ps 8
.vs 10
.ta 8n 16n 24n 
.Cw
From mab Mon Jul 10 15:18 PDT 1989
>From mab  Mon Jul 10 15:18:40 1989
From: Matthew A. Bishop <mab>
To: mab
Subject: output from runaudit command

** Audit report for amelia:/etc **
 
RIACS Audit Package version 2.2.1 Mon Jun  5 21:31:38 EDT 1989 (Matt.Bishop@dartmouth.edu)
 
Audit date:  Mon Jul 10 15:18:35 PDT 1989
Host system: amelia
File system: /etc
Options: update-master-list,nonrecursive
Copies sent to: mab
 
The following files have been deleted:
 
      file name       type  mode  links  user  group  size   checksum             date
      ---------       ----  ----  -----  ----  -----  ----   --------             ----
/etc/rc.local.bishop     -  0644      1  root  net    2567  *skipped*  May  1, 1989 at 18:22:10
 
The following files have been changed; the previous attributes
are shown on the line with (old), and the current attributes
are shown on the line with (new):
 
    file name     type  mode  links  user  group   size     checksum             date
    ---------     ----  ----  -----  ----  -----   ----     --------             ----
(old) /etc/inetd     -  0755      1  root  staff  29696  06586    28  Apr 13, 1989 at 11:16:28
(new) /etc/inetd     -  0755      1  root  staff  29696  06586    29  Apr 13, 1989 at 11:16:28
(old) /etc/ping      -  4755      1  root  staff  23552    *skipped*  July 9, 1989 at 22:16:25
(new) /etc/ping      -  4755      1  root  staff  23552    *skipped*  Apr 13, 1989 at 11:18:42
(old) /etc/utmp      -  0777      1  root  net     2952    *skipped*  Jul 10, 1989 at 14:33:06
(new) /etc/utmp      -  0777      1  root  net     2952    *skipped*  Jul 10, 1989 at 15:11:52
 
The following files matched patterns in the pattern master file but
characteristics have changed; the file and its attributes are shown on
the line with (new), and the corresponding pattern and associated
attributes are shown on the line with (pat).  If the file name matched
more than one pattern, the first pattern only is shown, but the next
line beginning with (and) says how many more patterns were matched.
 
     file name       type  mode  links  user  group   size    checksum             date
     ---------       ----  ----  -----  ----  -----   ----    --------             ----
(new) /etc/passwd       -  0666      1  root  wheel  118698  *skipped*  Jul 10, 1989 at 14:30:17
(pat) /etc/passwd.*     -  0644      1  root  wheel       *          *  *                       
.cW
.ps \n(PS
.vs \n(VS
.fi
.DE
.LP
The first part is the header of the letter.
After specifying the version of the audit package used,
it gives some information about the audit:
it was made at 3:18PM on July 10, 1989
for the directory
.Fn /etc
on
.Ho amelia ,
and the master file for
.Fn /tmp
was updated (\*(Lqupdate-master-list\*(Rq).
No subdirectories were audited (\*(Lqnonrecursive\*(Rq),
and copies of the audit report were mailed to the user \*(Lqmab\*(Rq.
New files,
old files,
and changed files are reported;
the audit report gives as complete information as possible.
.PP
Here is a table of options and what they mean:
.KS
.TS
center, box;
c s
c c
l c.
Possible Options in the Field \*(LqOptions: \*(Rq
=
\f2listed option\fP	\f2command line option\fP
_
nonrecursive	\-d
notify-users	\-u
block-devices	\-sb
character-devices	\-sc
setgid	\-sg
setuid	\-su
update-master-list	\-ga
.TE
.KE
.PP
Occasionally an error may be encountered when the audit is running.
In this case,
an appropriate error message is sent to the auditors:
.LD
.nf
.ps 8
.vs 10
.ta 8n 16n 24n 
.Cw
From root Wed May 20 11:03:56 1987
Received: by hydra.riacs.edu (4.12/2.0N)
	   id AA07749; Wed, 20 May 87 11:03:51 pdt
Message-Id: <8705201803.AA07749@hydra.riacs.edu>
Date: Wed, 20 May 87 11:03:51 pdt
From: root <root>
To: mab
Subject: errors from runaudit command

command: runaudit -ga -d /tmp
host: hydra.riacs.edu
 
audit: changing -ga option to -g
    ... generating /usr/mab/tasks/security/src/audit/HOSTS/hydra/Ftmp
.cW
.ps \n(PS
.vs \n(VS
.fi
.DE
.LP
The error message indicates the command being run and the host
on which the command was run
(which may or may not be the host being audited.)
With this message,
there was no master file,
so the option \*(Lq\-ga\*(Rq was not applicable.
The audit program assumed the option should have been \*(Lq\-g\*(Rq.
.NH
Error Messages and What To Do
.PP
This section lists possible error messages from the audit system
and how to handle them.
Other sources of error messages are the various system programs used
by the audit system.
See the manual pages of the appropriate commands
for an explanation of any such error messages.
.SH
runaudit: unknown option "\f2arg\fP"
.LP
.I Runaudit
does not recognize the option
.I arg .
.SH
audit: unknown option \f2arg\fP
.LP
.I Audit
does not recognize the option
.I arg .
If
.Fn runaudit
is used,
this error message indicates an internal error.
.SH
audit: expecting list of people to mail audit to
.LP
The option \*(Lq\-a\*(Rq was given without any list of addresses.
.SH
audit: expecting file listing files to checksum
.LP
If
.Fn runaudit
is used,
this error message indicates an internal error;
if
.Fn audit
is used,
it means there was no file name after the \*(Lq\-c\*(Rq option.
.br
audit: expecting file of remote program names
.LP
This means no
.Fn Environ
file was specified.
If
.Fn runaudit
is used,
this error message indicates an internal error;
if
.Fn audit
is used,
it means there was no file name after the \*(Lq\-e\*(Rq option.
.SH
audit: expecting name of root of tree to be audited
.LP
This means that no root directory was specified.
If
.Fn runaudit
is used,
this error message indicates an internal error;
if
.Fn audit
is used,
it means there was no file name after the \*(Lq\-f\*(Rq option.
.SH
audit: expecting name of host to audit
.LP
This means that no host was specified.
If
.Fn runaudit
is used,
this error message indicates an internal error;
if
.Fn audit
is used,
it means there was no host name after the \*(Lq\-h\*(Rq option.
.SH
audit: expecting file of pathnames to ignore
.LP
This means that no ignore file was specified.
If
.Fn runaudit
is used,
this error message indicates an internal error;
if
.Fn audit
is used,
it means there was no file name after the \*(Lq\-i\*(Rq option.
.SH
audit: expecting file to compare audit against
.LP
This means that no master file was specified.
If
.Fn runaudit
is used,
this error message indicates an internal error;
if
.Fn audit
is used,
it means there was no file name after the \*(Lq\-m\*(Rq option.
.SH
audit: expecting type of volume not to audit file systems on
.LP
The option \*(Lq\-n\*(Rq was given without any list of file volume types.
.SH
audit: expecting type of volume to audit file systems on
.LP
The option \*(Lq\-o\*(Rq was given without any list of file volume types.
.SH
audit: expecting pattern file to compare audit against
.LP
This means that no pattern master file was specified.
If
.Fn runaudit
is used,
this error message indicates an internal error;
if
.Fn audit
is used,
it means there was no file name after the \*(Lq\-p\*(Rq option.
.SH
audit: expecting pattern file to compare audit against
.LP
This means that no pattern master file was specified.
If
.Fn runaudit
is used,
this error message indicates an internal error;
if
.Fn audit
is used,
it means there was no file name after the \*(Lq\-p\*(Rq option.
.SH
audit: expecting file of pathnames to ignore temporarily
.LP
This means that no reject file was specified.
If
.Fn runaudit
is used,
this error message indicates an internal error;
if
.Fn audit
is used,
it means there was no file name after the \*(Lq\-r\*(Rq option.
.SH
audit: expecting time out interval compare audit against
.LP
The option \*(Lq\-t\*(Rq was given without any number of seconds.
.SH
audit: master file \f2filename\fP is unreadable
.LP
The master file exists and cannot be read.
.SH
audit: master file \f2filename\fP does not exist
.LP
No master file exists for the file system to be audited.
.SH
audit: checksum file specified when all to be checksummed
.br
\0\0\0\0... ignoring checksum file
.LP
The option \*(Lq\-c\*(Rq was specified and a checksum file exists
for that file system.
The audit simply generates ignores the checksum file,
and checksums everything.
.SH
audit: changing \-ga option to \-g
.br
\0\0\0\0... generating \f2filename\fP
.LP
The option \*(Lq\-ga\*(Rq was specified and no master file
exists.
The audit simply generates the master file.
.SH
audit: could not list file system \f2filesys\fP on \f2host\fP
.br
\0\0\0\0due to the following errors:
.LP
The (remote) file system scan of
.I filesys
on host
..I host
failed;
the error messages follow.
.SH
audit: the following errors occurred when scanning
.br
\0\0\0\0the file system \f2filesys\fP on \f2host\fP
.br
\0\0\0\0but the listing appeared to complete successfully:
.LP
The (remote) file system scan of
.I filesys
on host
..I host
generated error messages (which follow) but appeared to work.
Check the results carefully.
.SH
.nf
********** WARNING **********
There is a potential problem with the file system \f2filesystem\fP
on \f2host\fP -- the audit showed that file system has \f2pct\fP%
of the files it had when the master file was made. Either
the audit failed or most files on that file system have
been deleted.  Check to be sure it is not the latter,
and if the master file must be regenerated, delete the
current one and replace it with \f2file\fP.
*****************************
.fi
.LP
The difference in what should be in
.Mf filesystem
on
.Mh host
and what the audit program picked up as being there
seems too much to be reasonable.
Check to be sure
.Mf filesystem
was not obliterated.
The results of the questionable file system scan were saved in
.Mf file .
.SH
.nf
********** WARNING **********
There is a potential problem with the file system \f2filesystem\fP
on \f2host\fP -- the audit showed that file system has \f2pct\fP%
of the files it had when the master file was made. Either
the audit failed or most files on that file system have
been deleted.  Check to be sure it is not the latter,
and if the master file must be regenerated, delete the
current one and replace it with \f2file\fP.
+++ NOTE: THE MASTER FILES HAVE NOT BEEN UPDATED +++
*****************************
.fi
.LP
This is the same as the previous error message,
except that the auditing system was supposed to update
the master file.
The update was not done.
If it should have been done
(that is,
if the scan was correct),
replace the current master file with
.Mf file .
.SH
gettype: need a file system name
.LP
The program
.Fn gettype
was called with zero, two, or more arguments.
This indicates an internal error,
since
.Fn gettype
is called from within
.Fn audit .
.SH
Usage: auditcomm [ -[123] ] file1 file2
.LP
The program
.Fn auditcomm
was called incorrectly.
This indicates an internal error,
since
.Fn auditcomm
is called from within
.Fn audit .
.SH
Usage: auditfmt file1 ...
.LP
The program
.Fn auditfmt
was called with zero, two, or more arguments.
This indicates an internal error,
since
.Fn auditfmt
is called from within
.Fn audit .
.SH
auditgrep: bad option \f2option\fP
.br
auditgrep: bad field number \f2n\fP
.br
auditgrep: too few args
.LP
The program
.Fn auditgrep
was called incorrectly.
This indicates an internal error,
since
.Fn auditgrep
is called from within
.Fn audit .
.SH
Usage: auditmerge oldfile newfile
.LP
The program
.Fn auditmerge
was called incorrectly.
This indicates an internal error,
since
.Fn auditmerge
is called from within
.Fn audit .
.SH
Usage: auditpnm newfile patternfile [ file ]
.br
auditpnm: patternfile cannot be standard input
.LP
The program
.Fn auditpnm
was called incorrectly.
This indicates an internal error,
since
.Fn auditpnm
is called from within
.Fn audit .
.SH
auditpnm: No previous regular expression in \f2file\fP at line \f2line\fP
.br
auditpnm: Regular expression too long in \f2file\fP at line \f2line\fP
.br
auditpnm: Unmatched \e( in \f2file\fP at line \f2line\fP
.br
auditpnm: missing ] in \f2file\fP at line \f2line\fP
.br
auditpnm: too many \e(\e) pairs in \f2file\fP at line \f2line\fP
.br
auditpnm: unmatched \e) in \f2file\fP at line \f2line\fP
.br
auditpnm: range endpoint too large in \f2file\fP at line \f2line\fP
.br
auditpnm: bad number in \f2file\fP at line \f2line\fP
.br
auditpnm: \edigit out of range in \f2file\fP at line \f2line\fP
.br
auditpnm: illegal or missing delimiter in \f2file\fP at line \f2line\fP
.br
auditpnm: (internal error) no remembered search string
in \f2file\fP at line \f2line\fP
.br
auditpnm: \e( \e) imbalance in \f2file\fP at line \f2line\fP
.br
auditpnm: too many \e( in \f2file\fP at line \f2line\fP
.br
auditpnm: more than 2 numbers given in \e{ \e} in \f2file\fP at line \f2line\fP
.br
auditpnm: } expected after \e in \f2file\fP at line \f2line\fP
.br
auditpnm: first number exceeds second in
\e{ \e} in \f2file\fP at line \f2line\fP
.br
auditpnm: [ ] imbalance in \f2file\fP at line \f2line\fP
.br
auditpnm: regular expression too long in \f2file\fP at line \f2line\fP
.br
auditpnm: unknown regular expression error #\f2n\fP
in \f2file\fP at line \f2line\fP
.LP
These indicate errors in the patterns in the pattern master file
.I file
at line
.I line .
.SH
auditscan: unknown option \f2arg\fP
.br
auditscan: missing argument to -\f2option\fP
.LP
The program
.Fn auditscan
was called incorrectly.
This indicates an internal error,
since
.Fn auditscan
is called from within
.I auditls .
.SH
auditscan: ran out of room (strsave)
.LP
Either there are too any ignore patterns,
too many mounted file systems,
or too many files listed in the checksum file.
Try running two audits on the file system
instead of simply one.
.SH
auditscan: can't open \f2file\fP
.PP
Either
.I auditscan
could not open the file containing mount information about the
file volumes,
or it could not open the named directory.
.SH
auditscan: No previous regular expression in \f2file\fP at line \f2line\fP
.br
auditscan: Regular expression too long in \f2file\fP at line \f2line\fP
.br
auditscan: Unmatched \e( in \f2file\fP at line \f2line\fP
.br
auditscan: missing ] in \f2file\fP at line \f2line\fP
.br
auditscan: too many \e(\e) pairs in \f2file\fP at line \f2line\fP
.br
auditscan: unmatched \e) in \f2file\fP at line \f2line\fP
.br
auditscan: range endpoint too large in \f2file\fP at line \f2line\fP
.br
auditscan: bad number in \f2file\fP at line \f2line\fP
.br
auditscan: \edigit out of range in \f2file\fP at line \f2line\fP
.br
auditscan: illegal or missing delimiter in \f2file\fP at line \f2line\fP
.br
auditscan: (internal error) no remembered search string
in \f2file\fP at line \f2line\fP
.br
auditscan: \e( \e) imbalance in \f2file\fP at line \f2line\fP
.br
auditscan: too many \e( in \f2file\fP at line \f2line\fP
.br
auditscan: more than 2 numbers given
in \e{ \e} in \f2file\fP at line \f2line\fP
.br
auditscan: } expected after \e in \f2file\fP at line \f2line\fP
.br
auditscan: first number exceeds second in
\e{ \e} in \f2file\fP at line \f2line\fP
.br
auditscan: [ ] imbalance in \f2file\fP at line \f2line\fP
.br
auditscan: regular expression too long in \f2file\fP at line \f2line\fP
.br
auditscan: unknown regular expression error #\f2n\fP
in \f2file\fP at line \f2line\fP
.LP
There is a syntax error in the ignore file
.I file
at line
.I line .
.SH
timeout: command "\f2command\fP" timed out after \f2n\fP seconds
.LP
The connection to the remote host,
whose file system was being audited,
failed.
Rerun the audit.
.NH
Troubleshooting
.PP
.B Runaudit
has two debugging options:
.B \-v
and
.B \-x .
These act just like the options
.B \-v
and
.B \-x
to the Bourne shell
.B sh (1).
The
.B \-x
option prints the commands and their arguments as they are executed;
it is very useful when strange error messages come from remote
audits,
because it is propagated to the file listing program
(even if that is on another host.)
The
.B \-v
option is useful when the scripts are changed;
its utility is more limited.
.PP
Both options generate lots of output,
and unless you know the Bourne shell quite well,
you may find the output confusing.
So use these options judiciously.
