:
#! /bin/sh
#
# Matt Bishop
# Research Institute for Advanced Computer Science
# NASA Ames Research Center
# Moffett Field, CA  94035
#
# mab@riacs.edu, ...!{decvax!decwrl,ihnp4!ames}!riacs!mab
#
# (c) Copyright 1986 by Matt Bishop and the Research Institute for
#			Advanced Computer Science
#
# version number
VERSION="RIACS Audit Package version 3.1.3 Tue May 19 12:59:43 PDT 1992 (Matt.Bishop@dartmouth.edu)"
#
LOCAL="`hostname | sed 's/^\([^.]*\)\..*$/\1/'`"	# local host name
HOST=$1				# host to do installation on
ENV=$2				# environment file to use
NET=$3				# use encryption?
SECURE=$4			# secure installation?
#	system and shell variables
PATH=/usr/ucb:/bin:/usr/bin	# execution path
export PATH			# for subprograms
#	remote functions
REMCOPY=%%REMCOPY%%		# command to copy to remote system
REMEXEC=%%REMEXEC%%		# command to execute on remote system
#	location of sources
SRCDIR=%%DESTSRC%%			# where are the sources
# 	default net transmission program
CAT=%%CAT%%			# copy input to output
#
# be sure you have the parameters
#
if test -z "$HOST"
then
	#
	# ask for host name
	#
	echo 'What host should I do the installation on?' "(default $LOCAL)"
	read HOST
	#
	# if none given, default
	#
	if test -z "$HOST"
	then
		HOST="$LOCAL"
	fi
fi
if test -z "$ENV"
then
	#
	# ask for environment file
	#
	echo 'What environment file should I use?' "(default $HOST/Environ)"
	read ENV
	#
	# if none given, default
	#
	if test -z "$ENV"
	then
		ENV="$HOST/Environ"
	fi
	#
	# if can't be read, croak
	#
	if test ! -r "$ENV"
	then
		echo "$0: cannot read environment file $ENV"
		exit 1
	fi
fi
if test -z "$NET"
then
	#
	# ask if network encryption desired
	#
	echo "Do you want to do end-to-end encryption (yes/no)?"
	read NET
fi
#
# if none given, they are installed already
#
if test "$NET" != yes -a "$NET" != no
then
	echo "$0: yes or no only!"
	exit 1
fi
#
# secure installation mode?
#
if test -z "$SECURE"
then
	#
	# ask if secure installation mode required
	#
	echo "Do you want to transfer this to $HOST yourself (yes/no)?"
	read SECURE
fi
#
# must be yes or no
#
if test "$SECURE" != yes -a "$SECURE" != no
then
	echo "$0: yes or no only!"
	exit 1
fi
#
# figure out who to install it as
#
USER=`grep '^user	' $ENV | awk '-F	' '{ print $2 }'`
#
# figure out the compile-time options
#
CFLAGS=`grep '^cflags	' $ENV | awk '-F	' '{ print $2 }'`
LIBS=`grep '^libs	' $ENV | awk '-F	' '{ print $2 }'`
#
# see where to make the programs on the remote host
# put the makefile and the sources in there
#
MAKE=`grep '^makedir	' $ENV | awk '-F	' '{ print $2 }'`
if test -n "$MAKE"
then
	if test "$SECURE" = yes
	then
		MAKEDIR="$MAKE"
		MAKE=./$$x
		cp $SRCDIR/auditscan.c ${MAKE}
		sed -e "s/%%CFLAGS%%/$CFLAGS/" -e "s/%%LIBS%%/$LIBS/" < $SRCDIR/RMake > ${MAKE}/Makefile
		if test "$NET" = yes
		then
			cp $SRCDIR/cdes.c ${MAKE}/cdes.c
		fi
	elif test -n "$USER"
	then
		$REMEXEC $HOST -l $USER mkdir $MAKE
		cat $SRCDIR/auditscan.c | $REMEXEC $HOST -l $USER cat - \> $MAKE/auditscan.c
		sed -e "s/%%CFLAGS%%/$CFLAGS/" -e "s/%%LIBS%%/$LIBS/" < $SRCDIR/RMake |\
			$REMEXEC $HOST -l $USER cat - \> $MAKE/Makefile
	else
		$REMEXEC $HOST mkdir $MAKE
		$REMCOPY $SRCDIR/auditscan.c ${HOST}:${MAKE}/auditscan.c
		sed -e "s/%%CFLAGS%%/$CFLAGS/" -e "s/%%LIBS%%/$LIBS/" < $SRCDIR/RMake > ./$$x
		$REMCOPY ./$$x ${HOST}:${MAKE}/Makefile
		rm -rf ./$$x
	fi
else
	echo "$0: no makedir line in environment file $ENV"
	exit 1
fi
#
# now install the remote audit script
# note that if no remote encryption receiving/sending programs are
# named, we abort; you have to specify something if only "cat"
#
if test "$NET" = yes
then
	REMENC="`grep '^remenc	' $ENV | awk '-F	' '{ print $2 }'`"
	if test -z "$REMENC"
	then
		echo "$0: no remenc program named in environment file $ENV"
		exit 1
	fi
	REMDEC="`grep '^remdec	' $ENV | awk '-F	' '{ print $2 }'`"
	if test -z "$REMDEC"
	then
		echo "$0: no remdec program named in environment file $ENV"
		exit 1
	fi
else
	REMDEC="$CAT"
	REMENC="$CAT"
fi
sed "s@%%NETSEND%%@$REMENC@g" < $SRCDIR/auditls.sh |\
	sed "s@%%NETREC%%@$REMDEC@g" > ./$$x
if test "$SECURE" = yes
then
	cp ./$$x ${MAKE}/auditls.sh
elif test -n "$USER"
then
	cat ./$$x | $REMEXEC $HOST -l $USER cat - \> $MAKE/auditls.sh
else
	$REMCOPY ./$$x ${HOST}:${MAKE}/auditls.sh
fi
rm -f ./$$x
#
# get the destinations
#
AUDITLS="`grep '^auditls	' $ENV | awk '-F	' '{ print $2 }'`"
if test -z "$AUDITLS"
then
	echo "$0: no auditls line in environment file $ENV"; exit 1
fi
SCAN="`grep '^scan	' $ENV | awk '-F	' '{ print $2 }'`"
if test -z "$SCAN"
then
	echo "$0: no scan line in environment file $ENV"; exit 1
fi
if test "$NET" = yes
then
	CRYPT="`grep '^crypt	' $ENV | awk '-F	' '{ print $2 }'`"
	if test -z "$CRYPT"
	then
		echo "$0: no crypt line in environment file $ENV"; exit 1
	fi
	if test -n "$USER"
	then
		cat $SRCDIR/cdes.c | $REMEXEC $HOST -l $USER cat - \> $MAKE/cdes.c
	else
		$REMCOPY $SRCDIR/cdes.c ${HOST}:${MAKE}/cdes.c
	fi
else
	LOCENC="`grep '^locenc	' $ENV | awk '-F	' '{ print $2 }'`"
	if test -z "$LOCENC"
	then
		echo "you need to make the locenc program $CAT"
		echo "I will add the line to your environment file" 
		echo "locenc	$CAT" >> $ENV
	elif test "$LOCENC" != "$CAT"
	then
		echo "you have a locenc program but it does not appear to be"
		echo "	$CAT.  Since you are not using encryption, please"
		echo "	check that $LOCENC copies its input to its output"
		echo "	and if not, use $CAT."
	fi
	LOCDEC="`grep '^locdec	' $ENV | awk '-F	' '{ print $2 }'`"
	if test -z "$LOCDEC"
	then
		echo "you need to make the locdec program $CAT"
		echo "I will add the line to your environment file" 
		echo "locdec	$CAT" >> $ENV
	elif test "$LOCDEC" != "$CAT"
	then
		echo "you have a locdec program but it does not appear to be"
		echo "	$CAT.  Since you are not using encryption, please"
		echo "	check that $LOCDEC copies its input to its output"
		echo "	and if not, use $CAT."
	fi
fi
#
# make them and clean up
#
if test "$SECURE" = yes
then
	touch $MAKE/auditmake
	echo cd $MAKEDIR >> $MAKE/auditmake
	echo make install SCAN=$SCAN >> $MAKE/auditmake
	if test "$NET" = yes
	then
		echo cd $MAKEDIR >> $MAKE/auditmake
		echo make installcrypt CRYPT=$CRYPT >> $MAKE/auditmake
	fi
	echo cd $MAKEDIR >> $MAKE/auditmake
	echo make clobbersrc >> $MAKE/auditmake
elif test -n "$USER"
then
	$REMEXEC $HOST -l $USER -n "cd $MAKE; make install SCAN=$SCAN"
	if test "$NET" = yes
	then
		$REMEXEC $HOST -l $USER -n "cd $MAKE; make installcrypt CRYPT=$CRYPT"
	fi
	$REMEXEC $HOST -l $USER -n "cd $MAKE; make clobbersrc"
else
	$REMEXEC $HOST -n "cd $MAKE; make install SEND=$SEND"
	if test "$NET" = yes
	then
		$REMEXEC $HOST -n "cd $MAKE; make installcrypt CRYPT=$CRYPT"
	fi
	$REMEXEC $HOST -n "cd $MAKE; make clobbersrc"
fi
#
# announce what to do if host is secure
#
if test "$SECURE" = yes
then
	echo "You asked the installation be done for $HOST  securely."
	echo "Everything is ready; copy the contents of the directory"
	echo "$MAKE to $MAKEDIR on $HOST."
	echo "*** USE A SECURE MECHANISM LIKE TAPE, NOT THE NETWORK ***"
	echo "Once the directory is installed, change to it and type"
	echo "                   sh auditmake"
	echo "This will compile and install the programs as indicated"
	echo "by the Environment file $ENVIRON."
	echo " "
	echo "Remember to delete $MAKE after you transfer it."
fi
#
# bye!
#
exit 0
