.\"
.\" Author:	Matt Bishop
.\" Address:	Research Institute for Advanced Computer Science
.\"		Mail Stop 230-5
.\"		NASA Ames Research Center
.\"		Moffett Field, CA  94035
.\" ARPA:	mab@riacs.arpa
.\" UUCP:	...!decvax!decwrl!riacs!mab
.\"		...!ihnp4!ames!riacs!mab
.\" Copyright:	(c) 1986 by Matt Bishop and the Research Institute for
.\"			Advanced Computer Science
.\"
.\" version
.ds Vr RIACS Audit Package version 3.1.3 Tue May 19 12:59:43 PDT 1992 (Matt.Bishop@dartmouth.edu)
.\"
.if n .ds Lq "
.if n .ds Rq "
.if t .ds Lq ``
.if t .ds Rq ''
.TH RUNAUDIT 8
.SH NAME
runaudit \- shell script to audit multiple file systems
.SH SYNOPSIS
.BR runaudit " [ "
.B \-1
] [
.BI \-a name1\f1,\fPname2\f1,\fP...
] [
.B \-d
.B \-c
] [
] [
.B \-g
] [
.B \-ga
] [
.BI \-h host
] [
.BI \-n type1\f1,\fPtype2\f1,\fP...
] [
.BI \-o type1\f1,\fPtype2\f1,\fP...
] [
.B \-q
] [
.BI \-r reject
] [
.B \-sb
] [
.B \-sc
] [
.B \-sG
] [
.B \-sg
] [
.B \-su
] [
.BI \-t timeout
] [
.B \-u
] [
.B \-v
] [
.B \-x
] [
.I filesystem
\&...  ]
.SH DESCRIPTION
.LP
.I Runaudit
audits the
.IR filesystem s
and mails the results of each audit to
.IR %%AUDITOR%% ;
if none are named,
.I runaudit
looks for a file called %%LISTDIR%%/\f2host\fP/List
(where
.I host
is the canonicalized host named with the
.B \-h
option,
or if none the canonicalized local host name)
and if that file is found each line
is treated as having the file system name first,
followed by an (optional) list of options;
if that file is not found,
the value of the variable
.B BINAUDIT
defined in
.I runaudit
is treated as a blank-separated list of file systems to be audited.
.PP
The audit is done by running
.IR audit (8)
on each file system.
For each file system,
the master file
(to which the results of scanning the file system are compared)
is
.RI %%LISTDIR%%/ host /F filesystem
with all \*(Lq/\*(Rq characters deleted,
and the ignore file
(containing patterns to be ignored)
is
.RI %%LISTDIR%%/ host /I filesystem
with all \*(Lq/\*(Rq characters deleted.
Files which are to be ignored temporarily
(because the system administrator made changes and does not
want them reported) are to be listed in
.RI %%LISTDIR%%/ host /Reject.
.BR WARNING :
Use of these two features (the ignore and reject files)
leaves your system wide open to attack.
Use them with
.I extreme
caution!
.LP
Options are:
.TP
.B \-1
Collect the output from all file systems audited in this run
and mail it to the auditor(s) in one letter.
Any errors will also be collected and sent in a separate letter.
.TP
.BI \-a name1\f1,\fPname2\f1,\fP...
Mail the results of the audit to
.IR name1 ,
.IR name2 ", ..."
rather than to
.IR %%AUDITOR%% .
.TP
.B \-c
Compute a checksum for all files scanned.
.TP
.B \-d
Audit the base directory of the file systems only
(in other words,
just the directories and none of their subdirectories.)
.TP
.B \-g
Construct the master list to be used for auditing the filesystem.
No auditing is done.
.TP
.B \-ga
After the audit,
replace the master file with the results of the scan
of the filesystem.
In effect,
this updates the master file.
.TP
.BI \-h host
Run the audit for the host
.IR host .
.TP
.BI \-n type1\f1,\fPtype2\f1,\fP...
If the
.I filesystem
is mounted on a volume of type
.IR type1 ,
.IR type2 ", ..."
do not audit it.
This is useful when auditing multiple systems
that allow remote mounting of file systems such as NFS.
.TP
.BI \-o type1\f1,\fPtype2\f1,\fP...
If the
.I filesystem
is not mounted on a volume of type
.IR type1 ,
.IR type2 ", ..."
do not audit it.
It is the exact opposite of the option
.BR \-n .
.TP
.B \-q
If no changes have been made to the audited file system
and no errors are generated,
the people to be sent results are informed of this.
One letter per file system is generated,
and where possible the message is put in the subject of the letter
(to save having to read the whole letter.)
Giving this flag prevents such messages from being sent.
.TP
.BI \-r reject
Ignore changes made to the files named in this file
rather than in the default %%LISTDIR%%/\f2host\fP/Reject.
Each file must be named by its full path name;
to ignore subtrees,
name the directory at the root of the tree and end with a slash \*(Lq/\*(Rq.
These files differ from ignore files in two ways:
first,
no pattern matching of any kind is done on the names,
and second,
if the reject file has not been modified in
%%LIMIT%% days,
it is deleted before any checking is done.
The purpose of this file is to enable system administrators
to install new programs and then suppress the
message that this would produce when
.I runaudit
is next run.
.TP
.B \-sb
Confine reporting to those files which are block special device files;
if this option and any other
.B \-s
option is given,
reporting is confined to those files matching one or more
of the charcteristics.
.TP
.B \-sc
Confine reporting to those files which are character special device files.
If this option and any other
.BR \-s
option is given,
reporting is confined to those files matching one or more
of the charcteristics.
.TP
.B \-sG
Confine reporting to those files which are setgid
(\f2i.e.,\fP have the 02000 bit in the permissions flags set)
and
.B not
directory files.
If this option and any other
.B \-s
option is given,
reporting is confined to those files matching one or more
of the charcteristics.
.TP
.B \-sg
Confine reporting to those files which are setgid
(\f2i.e.,\fP have the 02000 bit in the permissions flags set.)
If this option and any other
.B \-s
option is given,
reporting is confined to those files matching one or more
of the charcteristics.
.TP
.B \-su
Confine reporting to those files which are setuid
(\f2i.e.,\fP have the 04000 bit in the permissions flags set.)
If this option and any other
.B \-s
option is given,
reporting is confined to those files matching one or more
of the charcteristics.
.TP
.BI \-t timeout
If the listing command is not active for
.I timeout
seconds (default %%TIMEOUT%%),
assume the network has failed and abort the audit.
If
.I timeout
is 0,
.I runaudit
will not time out the listing command.
This is quite useful in an environment with unreliable networking.
.TP
.B \-u
Every user who owns a file that has been added,
deleted,
or changed will be mailed a message describing the change.
This message looks like an audit report.
If a file's ownership changes,
both the new and old owner will be told about it.
.TP
.B \-v
This is a debugging option,
and causes all input lines to be printed as they are read.
It is the same as giving the
.B \-v
option to
.IR sh (1).
This option generates lots of output,
and is propagated to the program
.IR audit (8).
It is not intended for casual use.
.TP
.B \-x
This is a debugging option,
and causes all commands and arguments to be printed as they are executed.
It is the same as giving the
.B \-x
option to
.IR sh (1).
This option generates lots of output,
and is propogated to the program
.IR audit (8).
It is not intended for casual use.
.SH EXAMPLES
.TP
runaudit -g /bin
This generates a master list of files in /bin
to be used in future audits of /bin.
The master file is named \*(Lq%%LISTDIR%%/\f2host\fP/Fbin\*(Rq.
.TP
runaudit -astaff /bin
Audit /bin,
comparing the files there against those in the master list
generated in the previous example.
A letter describing the differences will be mailed to \*(Lqstaff\*(Rq
(by default,
the letter is mailed to \*(Lqroot\*(Rq;
the
.B \-a
option changes this.)
.TP
runaudit -g /usr/unsupported
This generates a master list of files in /usr/unsupported
to be used in future audits of /usr/unsupported.
The file is named \*(Lq%%LISTDIR%%/Fusrunsupported\*(Rq.
Files with audit lines that match lines
in \*(Lq%%LISTDIR%%/\f2host\fP/Iusrunsupported\*(Rq
are ignored;
for example,
to exclude any spool files from the audit,
the file \*(Lq%%LISTDIR%%/\f2host\fP/Iusrunsupported\*(Rq
should contain the line
.ce
^/usr/unsupported/spool/
.TP
runaudit -anasops,staff -u /usr/unsupported
Audit /usr/unsupported,
comparing the files there against those in the master list
generated in the previous example.
A letter describing the differences will be mailed to \*(Lqnasops\*(Rq
and \*(Lqstaff\*(Rq.
Also,
each user who owns a file named in the audit
will receive a letter informing him or her if any of his or her files
have changed.
.TP
runaudit -g /bin /usr/bin /etc
This generates master lists of files in /bin,
/usr/bin,
and /etc
to be used in future audits of /bin,
/usr/bin,
and /etc.
The master files are named \*(Lq%%LISTDIR%%/\f2host\fP/Fbin\*(Rq,
\&\*(Lq%%LISTDIR%%/\f2host\fP/Fusrbin\*(Rq,
and
\&\*(Lq%%LISTDIR%%/\f2host\fP/Fetc\*(Rq,
respectively.
.TP
runaudit -astaff /bin /usr/bin /etc
Audit /bin,
/usr/bin,
and /etc,
comparing the files there against those in the master lists
generated in the previous example.
A letter describing the differences will be mailed to \*(Lqstaff\*(Rq
.SH FILES
\&%%DESTBIN%%/runaudit1	low-level interfact to \f2audit\fP(8)
.br
\&%%LISTDIR%%/\f2host\fP/List	multiple-host master file list
.br
\&%%LISTDIR%%/\f2host\fP/I*	multiple-host ignore files for filesystems
.br
\&%%LISTDIR%%/\f2host\fP/F*	multiple-host master files for filesystems
.br
\&%%LISTDIR%%/\f2host\fP/Reject	multiple-host default ignore list
.br
\&%%TMPDIR%%/Au\f2nnnnnn\fP	temporary files
.SH SEE ALSO
audit(8)
.br
\f2The RIACS Intelligent Audit and Categorizing System\fP, Matt Bishop
.SH AUTHOR
Matt Bishop
.RI ( mab@riacs.edu )
