;;; ZOZY.tit  -*- lexical-binding:t -*-
;; Quail package `chinese-zozy
;;   Generated by the command `titdic-convert'
;;	Original TIT dictionary file: ZOZY.tit

;; # -*- coding: cn-big5 -*-
;; # HANZI input table for cxterm
;; # Generated from ZOZY.cit by cit2tit
;; # To be used by cxterm, convert me to .cit format first
;; # .cit version 1
;; ENCODE:	BIG5
;; MULTICHOICE:	YES
;; PROMPT:	中文輸入【零壹注音】
;; #
;; COMMENT Copyright (c) 1997 Wei-Chung Hwang <wchwang@csie.nctu.edu.tw>
;; COMMENT 
;; COMMENT Permission to copy and distribute both modified and unmodified
;; COMMENT versions is granted without royalty provided this notice is preserved.
;; COMMENT
;; COMMENT Constructed by Wei-Chung Hwang(黃維中 wchwang@csie.nctu.edu.tw)
;; COMMENT Made available in TANET at Oct 15, 1992.
;; COMMENT
;; COMMENT In Taipei(ETen) Big5 coding (eg. used with taipei15,taipei20)
;; COMMENT
;; COMMENT 鍵盤採用零壹〔大千﹐國喬〕鍵盤注音符號排列方式。
;; COMMENT
;; COMMENT 注音: ㄅ ㄆ ㄇ ㄈ ㄉ ㄊ ㄋ ㄌ ㄍ ㄎ ㄏ ㄐ ㄑ ㄒ ㄓ ㄔ ㄕ ㄖ ㄗ ㄘ ㄙ
;; COMMENT 鍵盤:  1  q  a  z  2  w  s  x  e  d  c  r  f  v  5  t  g  b  y  h  n
;; COMMENT
;; COMMENT 注音: ㄚ ㄛ ㄜ ㄝ ㄞ ㄟ ㄠ ㄡ ㄢ ㄣ ㄤ ㄥ ㄦ ㄧ ㄨ ㄩ
;; COMMENT 鍵盤:  8  i  k  ,  9  o  l  .  0  p  ;  /  -  u  j  m
;; COMMENT
;; COMMENT 聲調: 陰平(　)  陽平(ˊ)  上聲(ˇ)  去聲(ˋ)  輕聲(˙)
;; COMMENT 鍵盤:   SPACE      6         3         4         7
;; COMMENT
;; COMMENT                 鍵盤注音符號排列圖
;; COMMENT +----+----+----+----+----+----+----+----+----+----+----+
;; COMMENT |1   |2   |3   |4   |5   |6   |7   |8   |9   |0   |-   |
;; COMMENT |  ㄅ|  ㄉ|上聲|去聲|  ㄓ|陽平|輕聲|  ㄚ|  ㄞ|  ㄢ|  ㄦ|
;; COMMENT ++---++---++---++---++---++---++---++---++---++---++---+
;; COMMENT  |Q   |W   |E   |R   |T   |Y   |U   |I   |O   |P   |
;; COMMENT  |  ㄆ|  ㄊ|  ㄍ|  ㄐ|  ㄔ|  ㄗ|  ㄧ|  ㄛ|  ㄟ|  ㄣ|
;; COMMENT  ++---++---++---++---++---++---++---++---++---++---++
;; COMMENT   |A   |S   |D   |F   |G   |H   |J   |K   |L   |;   |
;; COMMENT   |  ㄇ|  ㄋ|  ㄎ|  ㄑ|  ㄕ|  ㄘ|  ㄨ|  ㄜ|  ㄠ|  ㄤ|
;; COMMENT   ++---++---++---++---++---++---++---++---++---++---++
;; COMMENT    |Z   |X   |C   |V   |B   |N   |M   |,   |.   |/   |
;; COMMENT    |  ㄈ|  ㄌ|  ㄏ|  ㄒ|  ㄖ|  ㄙ|  ㄩ|  ㄝ|  ㄡ|  ㄥ|
;; COMMENT    +----+----+----+----+----+----+----+----+----+--+-+
;; COMMENT         |         (SPACE BAR)                      |
;; COMMENT         |                      陰平                |
;; COMMENT         +------------------------------------------+
;; # define keys
;; VALIDINPUTKEY:	\040,-./0123456789;abcdefghijklmnopqrstuvwxyz
;; SELECTKEY:	1
;; SELECTKEY:	2
;; SELECTKEY:	3
;; SELECTKEY:	4
;; SELECTKEY:	5
;; SELECTKEY:	6
;; SELECTKEY:	7
;; SELECTKEY:	8
;; SELECTKEY:	9
;; SELECTKEY:	0
;; BACKSPACE:	\010\177
;; DELETEALL:	\015\025
;; MOVERIGHT:	>
;; MOVELEFT:	<
;; REPEATKEY:	\020\022
;; KEYPROMPT(\040):	　
;; KEYPROMPT(,):	ㄝ
;; KEYPROMPT(-):	ㄦ
;; KEYPROMPT(.):	ㄡ
;; KEYPROMPT(/):	ㄥ
;; KEYPROMPT(0):	ㄢ
;; KEYPROMPT(1):	ㄅ
;; KEYPROMPT(2):	ㄉ
;; KEYPROMPT(3):	ˇ
;; KEYPROMPT(4):	ˋ
;; KEYPROMPT(5):	ㄓ
;; KEYPROMPT(6):	ˊ
;; KEYPROMPT(7):	˙
;; KEYPROMPT(8):	ㄚ
;; KEYPROMPT(9):	ㄞ
;; KEYPROMPT(;):	ㄤ
;; KEYPROMPT(a):	ㄇ
;; KEYPROMPT(b):	ㄖ
;; KEYPROMPT(c):	ㄏ
;; KEYPROMPT(d):	ㄎ
;; KEYPROMPT(e):	ㄍ
;; KEYPROMPT(f):	ㄑ
;; KEYPROMPT(g):	ㄕ
;; KEYPROMPT(h):	ㄘ
;; KEYPROMPT(i):	ㄛ
;; KEYPROMPT(j):	ㄨ
;; KEYPROMPT(k):	ㄜ
;; KEYPROMPT(l):	ㄠ
;; KEYPROMPT(m):	ㄩ
;; KEYPROMPT(n):	ㄙ
;; KEYPROMPT(o):	ㄟ
;; KEYPROMPT(p):	ㄣ
;; KEYPROMPT(q):	ㄆ
;; KEYPROMPT(r):	ㄐ
;; KEYPROMPT(s):	ㄋ
;; KEYPROMPT(t):	ㄔ
;; KEYPROMPT(u):	ㄧ
;; KEYPROMPT(v):	ㄒ
;; KEYPROMPT(w):	ㄊ
;; KEYPROMPT(x):	ㄌ
;; KEYPROMPT(y):	ㄗ
;; KEYPROMPT(z):	ㄈ
;; # the following line must not be removed
;; BEGINDICTIONARY

;;; End of the header of original TIT dictionary.

;;; Code:

(require 'quail)

(quail-define-package "chinese-zozy" "Chinese-BIG5" "零注"
 '(   (122 . "ㄈ")
   (121 . "ㄗ")
   (120 . "ㄌ")
   (119 . "ㄊ")
   (118 . "ㄒ")
   (117 . "ㄧ")
   (116 . "ㄔ")
   (115 . "ㄋ")
   (114 . "ㄐ")
   (113 . "ㄆ")
   (112 . "ㄣ")
   (111 . "ㄟ")
   (110 . "ㄙ")
   (109 . "ㄩ")
   (108 . "ㄠ")
   (107 . "ㄜ")
   (106 . "ㄨ")
   (105 . "ㄛ")
   (104 . "ㄘ")
   (103 . "ㄕ")
   (102 . "ㄑ")
   (101 . "ㄍ")
   (100 . "ㄎ")
   (99 . "ㄏ")
   (98 . "ㄖ")
   (97 . "ㄇ")
   (59 . "ㄤ")
   (57 . "ㄞ")
   (56 . "ㄚ")
   (55 . "˙")
   (54 . "ˊ")
   (53 . "ㄓ")
   (52 . "ˋ")
   (51 . "ˇ")
   (50 . "ㄉ")
   (49 . "ㄅ")
   (48 . "ㄢ")
   (47 . "ㄥ")
   (46 . "ㄡ")
   (45 . "ㄦ")
   (44 . "ㄝ")
   (32 . "　")
)"中文輸入【零壹注音】

 Copyright (c) 1997 Wei-Chung Hwang <wchwang@csie.nctu.edu.tw>
 
 Permission to copy and distribute both modified and unmodified
 versions is granted without royalty provided this notice is preserved.

 Constructed by Wei-Chung Hwang(黃維中 wchwang@csie.nctu.edu.tw)
 Made available in TANET at Oct 15, 1992.

 In Taipei(ETen) Big5 coding (eg. used with taipei15,taipei20)

 鍵盤採用零壹〔大千﹐國喬〕鍵盤注音符號排列方式。

 注音: ㄅ ㄆ ㄇ ㄈ ㄉ ㄊ ㄋ ㄌ ㄍ ㄎ ㄏ ㄐ ㄑ ㄒ ㄓ ㄔ ㄕ ㄖ ㄗ ㄘ ㄙ
 鍵盤:  1  q  a  z  2  w  s  x  e  d  c  r  f  v  5  t  g  b  y  h  n

 注音: ㄚ ㄛ ㄜ ㄝ ㄞ ㄟ ㄠ ㄡ ㄢ ㄣ ㄤ ㄥ ㄦ ㄧ ㄨ ㄩ
 鍵盤:  8  i  k  ,  9  o  l  .  0  p  ;  /  -  u  j  m

 聲調: 陰平(　)  陽平(ˊ)  上聲(ˇ)  去聲(ˋ)  輕聲(˙)
 鍵盤:   SPACE      6         3         4         7

                 鍵盤注音符號排列圖
 +----+----+----+----+----+----+----+----+----+----+----+
 |1   |2   |3   |4   |5   |6   |7   |8   |9   |0   |-   |
 |  ㄅ|  ㄉ|上聲|去聲|  ㄓ|陽平|輕聲|  ㄚ|  ㄞ|  ㄢ|  ㄦ|
 ++---++---++---++---++---++---++---++---++---++---++---+
  |Q   |W   |E   |R   |T   |Y   |U   |I   |O   |P   |
  |  ㄆ|  ㄊ|  ㄍ|  ㄐ|  ㄔ|  ㄗ|  ㄧ|  ㄛ|  ㄟ|  ㄣ|
  ++---++---++---++---++---++---++---++---++---++---++
   |A   |S   |D   |F   |G   |H   |J   |K   |L   |;   |
   |  ㄇ|  ㄋ|  ㄎ|  ㄑ|  ㄕ|  ㄘ|  ㄨ|  ㄜ|  ㄠ|  ㄤ|
   ++---++---++---++---++---++---++---++---++---++---++
    |Z   |X   |C   |V   |B   |N   |M   |,   |.   |/   |
    |  ㄈ|  ㄌ|  ㄏ|  ㄒ|  ㄖ|  ㄙ|  ㄩ|  ㄝ|  ㄡ|  ㄥ|
    +----+----+----+----+----+----+----+----+----+--+-+
         |         (SPACE BAR)                      |
         |                      陰平                |
         +------------------------------------------+

Zhuyin base input method for Chinese Big5 characters (`chinese-big5-1',
`chinese-big5-2').

Zhuyin is a kind of a phonetic symbol.  One to three Zhuyin symbols
compose a Chinese character.

In this input method, you enter a Chinese character by first typing
keys corresponding to Zhuyin symbols (see the above table) followed by
SPC, 6, 3, 4, or 7 specifying a tone (SPC:陰平, 6:陽平, 3:上聲, 4:去聲,
7:輕聲).

\\<quail-translation-docstring>
"
 '(("\C-?" . quail-delete-last-char)
   
   (">" . quail-next-translation)
   ("<" . quail-prev-translation))
 nil nil nil nil)

(quail-define-rules
(", " "ㄝ")
(",4" "誒")
("- " "ㄦ兒")
("-3" "爾耳洱餌邇珥駬薾鉺峏尒栮")
("-4" "二貳佴刵咡樲聏毦眲衈")
("-6" "兒而洏耏胹輀侕栭陑鮞檽聏荋唲鴯")
(". " "歐甌毆嘔謳鷗ㄡ慪區熰蓲櫙")
(".3" "偶藕嘔耦吘湡腢蕅")
(".4" "嘔漚噢")
(".6" "吽")
("/ " "鞥ㄥ")
("0 " "安鞍庵諳氨銨胺ㄢ鵪媕侒盦峖痷腤萻韽垵")
("03" "俺唵晻堷")
("04" "暗案岸按黯菴闇犴豻匼桉洝荌錌匎婩儑")
("06" "雸玵啽")
("1 " "ㄅ")
("1/ " "崩繃伻弸祊閍塴絣")
("1/3" "菶玤琫埲誁")
("1/4" "蹦搒洴迸跰")
("1/6" "甭")
("10 " "班般搬斑頒扳瘢虨斒攽褩")
("103" "板版闆阪舨昄鈑粄蝂")
("104" "半辦伴扮拌絆姅瓣爿怑湴鉡靽")
("18 " "八捌巴疤芭笆粑叭扒豝吧仈朳")
("183" "把靶鈀")
("184" "罷爸霸壩耙弝灞伯猈")
("186" "拔跋鈸魃茇鼥軷犮菝胈詙")
("187" "吧罷琶杷")
("19 " "掰")
("193" "百擺佰襬粨捭矲絔")
("194" "敗拜唄粺椑稗矲庍")
("196" "白")
("1; " "幫邦傍梆鞤縍垹")
("1;3" "榜綁牓膀氆")
("1;4" "棒磅謗蚌傍鎊旁甏塝艕")
("1i " "玻撥剝菠缽嶓砵播般碆袚襏鱍啵柭蹳岥")
("1i3" "跛簸蚾")
("1i4" "播擘簸亳薜譒薄檗蘗繴挀")
("1i6" "伯博柏泊勃搏渤駁白薄脖帛舶箔荸蔔膊鈸餑鉑欂鵓踣浡襮踄鎛駮僰餺髆桲謈檗馞胉挬猼葧鋍懪簙礡鑮郣鸔糪")
("1j " "逋晡餔峬鵏")
("1j3" "補捕埔哺卜鳪獛")
("1j4" "不部布步怖佈簿埠鈽蔀篰捗咘")
("1j6" "不")
("1l " "包胞苞褒枹笣蕔孢")
("1l3" "保寶飽堡褓葆鴇怉駂鳵媬")
("1l4" "報抱暴爆豹鮑刨趵鉋虣鑤儤菢煲袌嚗犦忁")
("1l6" "雹薄窇瓝")
("1o " "背杯悲卑碑俾揹偝盃裨萆桮椑伓綼鵯藣")
("1o3" "北")
("1o4" "被備背貝輩倍臂狽憊悖孛焙蓓褙邶琲誖鋇哱糒梖珼鄁牬郥犕奰")
("1p " "奔賁錛泍渀")
("1p3" "本畚苯")
("1p4" "笨体坌")
("1u " "逼屄偪稫豍")
("1u, " "憋鱉虌")
("1u,3" "癟蛂")
("1u,4" "彆縪")
("1u,6" "別蹩咇徶襒蟞")
("1u/ " "兵冰掤栟")
("1u/3" "餅丙稟柄秉炳昺邴怲鞞鉼蛃陃苪窉屏庰")
("1u/4" "並病併并摒寎鵧偋")
("1u0 " "邊編鞭蝙砭籩箯稨猵甂柉楄煸")
("1u03" "扁貶匾褊窆萹惼碥")
("1u04" "便變遍辨辯汴辮忭弁釆抃緶艑卞揙汳鴘閞")
("1u3" "比筆彼鄙匕沘秕屄蚍妣疕潷柀朼貏")
("1u4" "必敝畢壁避璧閉鄙臂幣弊婢斃碧泌祕俾蔽庇嗶愎辟弼裨陛埤箄篦畀比嬖睥賁贔襞毖蓽蹕髀怭庳愊楅湢狴獘篳苾薜觱詖躄邲閟柲梐珌痺飶馝駜鎞鷩皕堛鉍痹腷骳坒滭熚疪妼鏎鷝柫佖蜌彃箅蓖鄪罼鮅襒鵖襣驆鼊芘粊稗嫳獙廦鄨縪")
("1u6" "鼻")
("1ul " "標彪鑣鏢飆膘熛麃羆嘌杓滮瀌猋瘭穮颮驫摽儦臕颩髟謤墂贆蔈爂藨")
("1ul3" "表錶婊裱俵褾檦諘")
("1ul4" "鰾")
("1up " "賓濱彬檳儐斌繽豳瀕邠璸蠙鑌豩汃椕霦矉驞")
("1up4" "殯鬢儐擯臏髕鶣")
("2 " "ㄉ")
("2. " "都兜郖")
("2.3" "斗抖陡蚪枓唗敨")
("2.4" "鬥豆逗痘竇荳脰餖鋀梪浢讀")
("2/ " "登燈鐙簦豋璒嬁")
("2/3" "等戥")
("2/4" "鄧瞪蹬凳嶝磴墱邆霯")
("20 " "單擔丹耽簞鄲眈聃酖砃甔襌匰聸勯嚪")
("203" "膽疸撢亶紞刐撣玬衴黵丼澸")
("204" "但旦淡蛋誕擔彈憚氮啖澹憺儋啗噉石癉窞僤幨霮髧萏鉭暺柦帎潬沊狚觛啿舕蜑嘾鴠癚殫灗泹")
("28 " "搭褡答撘瘩躂咑耷")
("283" "打")
("284" "大")
("286" "答達韃靼瘩怛繨噠妲笪荅薘褟鐽匒呾畣炟鎝")
("29 " "呆待獃")
("293" "歹逮")
("294" "代帶待袋戴怠殆黛貸迨大玳岱逮襶埭靆紿廗汏忕瀻軩跢艜蹛柋酨")
("2; " "當噹鐺襠璫簹儅蟷澢艡嵣")
("2;3" "檔黨擋讜攩欓党")
("2;4" "當蕩擋盪碭宕菪逿璗愓瓽礑簜闣")
("2j " "都督嘟闍醏")
("2j/ " "東冬咚鼕苳蝀埬崠氡炵涷菄鶇")
("2j/3" "懂董嬞墥")
("2j/4" "動洞凍棟恫胴挏戙駧霘")
("2j0 " "端耑偳剬媏")
("2j03" "短")
("2j04" "段斷緞鍛毈腶籪椴葮碫躖")
("2j3" "賭堵睹篤肚錖裻帾")
("2j4" "度渡肚妒鍍杜蠹秺喥")
("2j6" "讀獨毒牘纛瀆犢髑讟黷櫝儥碡殰蝳贕韇韥皾")
("2ji " "多朵哆柁茤")
("2ji3" "躲朵埵垛嚲鬌痑趓")
("2ji4" "惰墮舵跺剁咄踱馱垛墯嶞柮陏陊度袉貀鵽")
("2ji6" "奪鐸多掇裰剟敪椯剫敓莌毲腏鮵襗")
("2jo " "堆頧痽")
("2jo4" "對隊兌碓懟譈濧薱轛濻瀩憝")
("2jp " "敦蹲墩惇礅驐蜳撉鐓")
("2jp3" "盹躉")
("2jp4" "頓噸盾鈍遁盹燉沌囤遯炖坉扽伅庉潡崸鶨腞")
("2k6" "得德淂")
("2k7" "的得")
("2l " "刀叨忉舠氘幍魛")
("2l3" "倒島導禱搗擣捯壔禂")
("2l4" "到道倒稻盜蹈悼導纛翿檤菿瓙")
("2o3" "得")
("2u " "低滴氐羝鞮彽磾鍉袛菂墑熵")
("2u, " "爹")
("2u,6" "跌蝶諜碟疊迭牒喋瓞耋絰咥垤堞蜨蹀鰈跕昳峌挕胅苵眣聑臷詄镻艓褋惵楪嶀")
("2u. " "丟銩")
("2u/ " "丁釘叮疔酊盯仃玎帄靪虰")
("2u/3" "頂鼎酊嵿濎薡")
("2u/4" "定訂釘錠碇飣娗椗掟碠顁萣啶")
("2u0 " "顛巔癲滇掂傎瘨敁蹎槙齻厧")
("2u03" "點典碘錪婰琠蕇")
("2u04" "電店殿甸奠墊澱惦靛佃淀玷鈿簟坫痁癜磹阽扂婝踮壂")
("2u3" "底抵邸詆牴砥氐坻柢弤觝呧阺聜菧軧扺")
("2u4" "地第弟帝遞蒂的締諦娣睇棣杕玓禘蔕螮踶楴渧碲虳釱樀旳軑梊焍馰墆嵽珶甋")
("2u6" "的敵迪狄笛滌翟荻嫡嘀鏑蹢芽犒糴覿篴蔋靮梑潪苖嚁鸐藋藡")
("2u8 " "嗲")
("2ul " "雕凋刁貂鵰碉叼彫瞗琱鯛扚蛁鳭虭殦")
("2ul3" "屌")
("2ul4" "調掉釣吊弔窵蓧誂伄魡")
("5 " "之知隻織支枝汁只吱芝脂肢蜘祇梔祗氏枳ㄓ胝鴟卮搘秖跖泜鳷汥秪榰胑衼椥")
("5. " "周週州洲舟粥賙啁盩譸輈喌騆鵃洀淍銂珘徟輖侜婤")
("5.3" "帚肘睭鯞")
("5.4" "晝皺宙紂縐冑咒繇甃籀咮酎僽怞胄噣駎")
("5.6" "軸妯")
("5/ " "爭征蒸睜徵掙箏正怔猙錚崢諍癥鉦烝篜姃炡埩聇丁眐")
("5/3" "整拯氶撜糽")
("5/4" "鄭正證政証症掙幀")
("50 " "詹沾瞻氈霑旃譫鱣覘邅栴鸇驙占呫饘鉆詀薝譠")
("503" "展斬盞輾搌嶄琖魙醆颭樿皽蹍嫸榐橏")
("504" "佔戰站暫占棧顫湛綻蹔蘸虥轏輚偡")
("53" "只指紙止旨址徵祇趾祉咫枳酯恉沚阯芷黹軹疻晊厎坁藢栺淽滍")
("54" "至制治志製致置智秩誌稚質峙緻幟滯摯窒炙痔雉識懥痣輊騭帙陟知寘忮桎躓蛭贄鷙厔鑕豸庤彘猘畤疐紩觶郅銍偫跱遰鋕櫍袟騺淛狾礩胵膣螲挃洷覟庢鴙迣翐臸駤祑觢鴩")
("56" "直職質值植執殖擲姪侄蹠蟄躑桎埴稙摭縶柣犆秷擿馽慹樴膱懫蟙褁瓡嬂蘵")
("58 " "渣扎喳楂查齇柤皻抯挓樝謯")
("583" "眨渣鮓厏苲")
("584" "榨柵炸詐乍搾蚱咋蜡吒溠砟醡鮓痄簎")
("586" "扎札紮閘炸霅鍘哳劄蚻譗蠿")
("59 " "摘齋齊捚")
("593" "窄岝")
("594" "債寨祭責瘵砦")
("596" "宅翟")
("5; " "張章彰漳樟璋獐嫜暲鄣蟑鱆慞傽墇騿遧")
("5;3" "長掌漲仉鞝")
("5;4" "丈仗帳障賬脹杖漲長幛瘴嶂扙瞕粀")
("5j " "珠朱諸株豬蛛茱硃誅銖侏洙瀦邾櫫櫧祩藷絑袾觰鴸蠩蝫鮢藸")
("5j/ " "中鐘終忠鍾衷忪盅螽伀妐蔠柊煄彸舯炂籦")
("5j/3" "種腫塚踵冢")
("5j/4" "中種重仲眾尰湩狆衶偅堹緟")
("5j0 " "專磚耑顓塼鄟鱄剸嫥瑼篿鷒膞蟤")
("5j03" "轉囀")
("5j04" "傳賺篆撰譔饌轉僎瑑縳腞")
("5j3" "主屬煮囑貯渚矚著麈拄瘃斸砫陼孎壴罜欘泞眝")
("5j4" "住著助注祝駐註柱蛀鑄炷苧佇箸杼紵翥宁柷羜馵疰莇鉒紸嵀跓軴樦麆櫡殶諔")
("5j6" "竹築逐燭蠋筑竺朮躅舳軸窋蓫笁趉鱁灟蠾茿篫")
("5j8 " "抓撾髽檛")
("5j83" "爪")
("5j9 " "拽")
("5j93" "跩")
("5j94" "拽")
("5j; " "裝莊樁妝粧庄梉")
("5j;3" "奘")
("5j;4" "狀壯撞戇焋")
("5ji " "捉桌涿棹穛")
("5ji6" "卓茁濁拙濯酌灼著啄鐲擢琢諑倬斲斮梲椓焯蝃踔鷟彴汋斫禚篧浞棳謶錣啅罬斀蠗圴剢灂")
("5jo " "追錐椎隹騅鵻腄鴭")
("5jo3" "沝")
("5jo4" "綴墜贅縋惴餟硾膇鑆")
("5jp " "諄屯肫窀迍宒訰")
("5jp3" "準准隼埻綧")
("5jp4" "稕")
("5k " "遮螫晢嫬")
("5k3" "者赭鍺")
("5k4" "這浙蔗鷓柘宅檡烢蟅")
("5k6" "折哲摺懾褶謫輒摘轍慴蜇磔乇讋晢鮿耴悊砓謺虴鸅讘瓋")
("5k7" "著遮晢嫬")
("5l " "朝招昭召著嘲釗駋鉊晁盄鍣妱")
("5l3" "找沼爪菬瑵")
("5l4" "照趙召罩兆肇詔晁笊櫂炤雿狣棹箌鵫垗旐曌")
("5l6" "著")
("5p " "真針珍貞偵禎斟箴砧甄臻楨榛診蓁獉溱碪胗鍼鱵媜駗薽禛樼潧瑊遉寊蒧轃籈鷏堻")
("5p3" "診枕疹軫畛袗縝稹紾鬒眕黰辴抮抌笉絼祳晸縥黕")
("5p4" "鎮陣振震賑朕枕鴆揕酖眹娠侲挋栚蜄桭誫敶")
("8 " "阿啊ㄚ")
("84" "阿")
("87" "啊阿")
("9 " "挨哀埃唉哎ㄞ誒")
("93" "矮藹靄欸毐昹佁")
("94" "愛礙艾曖璦隘噯乂靉僾堨嬡鑀賹濭鴱譪誒薆")
("96" "捱皚騃敳")
("; " "骯腌ㄤ")
(";3" "軮")
(";4" "盎醠")
(";6" "昂卬")
("a " "ㄇ")
("a.3" "某冇踇")
("a.6" "謀眸繆牟侔蝥鍪蛑麰洠鉾鴾呣哞")
("a/3" "猛蜢艋錳懵蠓懞瓾")
("a/4" "夢孟霿霥")
("a/6" "蒙盟萌矇朦濛檬懵幪甍瞢艨虻曚甿礞氋雺莔儚蕄鄳鄸饛鸏")
("a03" "滿屘矕")
("a04" "慢漫曼蔓幔嫚鏝縵墁熳澫僈獌")
("a06" "蠻饅瞞蹣漫顢謾鰻璊悗慲槾鬘鬗")
("a8 " "媽嗎嬤")
("a83" "馬螞碼瑪溤嗎鎷鷌嘜")
("a84" "罵禡傌榪")
("a86" "麻痲嘛麼蟆犘")
("a87" "嘛嗎蟆")
("a93" "買嘪鷶")
("a94" "賣麥邁脈勱蝐")
("a96" "埋霾薶")
("a;3" "莽蟒漭汒庬硥茻壾")
("a;6" "忙芒茫盲氓尨硭邙哤奀杗盳鋩娏牻痝蛖駹蘉鼆笀")
("ai " "摸")
("ai3" "抹")
("ai4" "末莫默漠沒膜寞陌歿脈沫秣茉驀墨貊磨瘼靺歾饃鄚纆霢嚜眽瞙藦暯枺爅妺万銆鏌貘粖蛨袹嗼塻慔蟔鬕莈覛縸嘜")
("ai6" "模磨摩膜糢魔摹謨蘑劘嫫藦髍")
("ai7" "麼")
("aj3" "母畝牡姆拇牳鉧姥峔砪")
("aj4" "木目幕牧慕墓募穆睦暮沐苜鶩楘霂鉬炑坶毣蚞幙鞪莯")
("aj6" "模氁")
("ak7" "麼")
("al " "貓")
("al3" "卯昴泖茆")
("al4" "帽冒貌貿茂瑁懋旄耄媢楙眊瞀芼袤毷艒萺鄮")
("al6" "毛茅矛髦錨旄蟊芼蝥髳媌堥罞酕嫹鶜枆軞渵")
("ao3" "美每鎂浼媺渼媄挴燘")
("ao4" "妹媚寐昧眛魅瑁沬袂痗韎煝蝞")
("ao6" "沒煤眉枚梅媒莓霉玫黴楣湄嵋苺禖郿堳瑂脢鋂呅腜塺徾攗")
("ap " "悶")
("ap3" "暪")
("ap4" "悶燜懣")
("ap6" "門們捫樠鍆穈菛虋")
("ap7" "們")
("au " "咪瞇")
("au, " "咩乜羋")
("au,4" "滅蔑衊篾蠛幭覕搣薎懱瀎礣鱴")
("au. " "唒")
("au.4" "謬")
("au/3" "眳姳慏")
("au/4" "命暝")
("au/6" "明名鳴銘螟冥瞑暝茗酩溟蓂鄍洺榠嫇覭詺熐")
("au03" "免勉緬冕娩靦湎沔偭眄絻丏俛愐喕鮸")
("au04" "面麵")
("au06" "棉綿眠媔婂蝒櫋矊矏")
("au3" "米靡弭敉眯銤渳葞蔝濔灖")
("au4" "密蜜秘祕覓泌汨謐宓冪塓幦鼏羃幎漞糸峚榓滵蔤蠠嘧")
("au6" "迷彌謎瀰靡糜麋縻獼蘼冞麛醚醾檷蘪攠瓕爢麊鸍")
("aul " "喵")
("aul3" "秒渺藐邈緲杳眇淼杪篎")
("aul4" "妙廟繆玅")
("aul6" "苗描瞄鱙")
("aup3" "敏憫閔閩抿泯皿湣愍黽澠笢敃刡僶簢敯潣")
("aup6" "民岷玟緡痻苠忞旻鈱旼錉罠閺怋崏暋")
("b " "ㄖ")
("b.3" "糅鍕粈煣")
("b.4" "肉")
("b.6" "柔揉韖蹂輮楺禸葇鍒鞣騥鶔媃蝚鰇")
("b/ " "扔")
("b/3" "扔")
("b/6" "仍礽陾")
("b03" "染冉髯苒珃橪呥姌嫨")
("b06" "然燃髯蛅蚺袡")
("b4" "日衵馹鈤")
("b;3" "嚷壤攘爙")
("b;4" "讓懹")
("b;6" "攘禳穰勷瀼瓤儴獽蘘躟鬤蠰")
("bj/3" "冗茸氄傇軵")
("bj/6" "容榮融溶絨熔戎蓉鎔茸榕羢嶸瑢肜毧狨瀜茙烿蠑爃媶榵褣駥髶鰫鷛")
("bj03" "軟阮蠕耎蝡瓀緛礝朊")
("bj06" "堧壖撋")
("bj3" "乳汝辱擩女侞")
("bj4" "入辱褥孺茹洳縟蓐溽鄏媷嗕")
("bj6" "如儒孺茹蠕嚅濡袽襦鴽筎臑醹挐薷銣曘燸帤蕠")
("bji4" "若弱箬偌爇鄀篛蒻楉鶸")
("bjo3" "蕊橤繠惢桵")
("bjo4" "瑞銳芮睿蚋叡枘汭")
("bjo6" "蕤緌婑")
("bjp " "犉")
("bjp4" "潤閏橍")
("bk3" "惹喏若")
("bk4" "熱渃")
("bl3" "擾")
("bl4" "繞遶隢")
("bl6" "饒蕘嬈橈蟯襓")
("bp3" "忍稔荏腍棯栠荵")
("bp4" "任認刃飪賃軔衽紉妊恁仞訒韌牣鵀屻肕軠")
("bp6" "人任仁壬紝儿芢銋")
("c " "ㄏ")
("c. " "齁")
("c.3" "吼")
("c.4" "後候厚后逅鱟垕堠郈鄇缿洉")
("c.6" "猴侯喉篌鍭餱瘊銗翭鯸葔")
("c/ " "亨哼脝諻")
("c/4" "橫啈澋絎")
("c/6" "橫恆衡恒珩蘅桁姮鑅楻誙諻揘佷")
("c0 " "酣鼾蚶憨頇魽唅甝谽嫨")
("c03" "喊罕厂蔊豃嚂")
("c04" "和漢汗旱焊憾翰撼悍頷扞瀚閈捍暵熯晥犴睅菡豻銲釬駻哻涆淊馯蜭頜螒顄雗攌譀鋎鶾")
("c06" "寒含函涵韓邯汗邗榦琀梒鋡焓")
("c8 " "哈")
("c83" "哈")
("c86" "蛤")
("c9 " "咳嗨咍")
("c93" "海醢烸")
("c94" "害亥駭嗨氦嗐絯餀")
("c96" "還孩骸頦")
("c; " "夯")
("c;3" "酐")
("c;4" "行沆")
("c;6" "行航杭吭頏桁迒苀肮蚢斻貥雽魧")
("cj " "忽呼乎惚滹戲猢欻膴虖吰虍幠寣昒歑烼垀曶啒峘淴謼匢淲")
("cj/ " "轟哄烘薨訇吽揈渹哅輷谾鍧焢魟")
("cj/3" "哄嗊")
("cj/4" "鬨汞澒蕻鍙")
("cj/6" "紅洪宏鴻虹弘泓訌鋐閎黌竑紘翃浤鞃灴葒耾仜汯竤鈜霟妅玒谹渱舼触谼篊彋瓨苰")
("cj0 " "歡驩讙獾犿懽酄鴅")
("cj03" "緩皖澣睆輐")
("cj04" "換喚宦患幻煥奐渙瘓豢梡逭擐漶垸轘瑍觨嚾瞣")
("cj06" "還環桓圜繯鬟鍰鐶寰闤梡洹瓛貆澴荁萑肒捖羦懁豲嬛狟雈")
("cj3" "虎琥滸唬許汻")
("cj4" "護戶互滬扈瓠怙祜笏冱戽楛沍岵鄠臛頀枑槴昈嫭婟嫮熩豰綔謢蔰")
("cj6" "胡湖壺蝴糊狐弧葫鬍瑚餬斛鵠囫縠衚觳醐猢搰鶘槲媩抇鰗焀魱螜瀫楜嘝鶦")
("cj8 " "花華嘩鷨錵")
("cj84" "話化畫劃樺華嫿摦崋嬅杹觟槬繣澅")
("cj86" "華滑划猾譁嘩樺驊鏵豁劃崋釫螖")
("cj94" "壞坏諙孬咶蘹蘾")
("cj96" "懷淮徊槐踝佪怀褢褱櫰瀤")
("cj; " "荒慌肓衁巟嚝")
("cj;3" "謊恍晃幌洸怳榥熀鎤滉皝")
("cj;4" "晃軦")
("cj;6" "黃徨惶簧璜磺蝗煌皇凰湟遑隍潢篁喤艎鍠熿韹鰉堭蟥偟穔鷬媓騜崲葟餭撗獚趪")
("cji " "豁")
("cji3" "火伙夥鈥")
("cji4" "或穫獲和惑禍霍貨豁壑蠖嚄藿鑊矱檴濩砉雘硅擭湱騞謋捇沎眓掝嗀嗀瓁臒攉瀖曤矐韄靃")
("cji6" "活佸鈥萿")
("cji7" "和")
("cjo " "灰揮輝恢詼暉麾徽墮褌撝隳煇翬豗褘洃隓顪鰴拻噅禈")
("cjo3" "會悔誨毀燬賄虺虫烠毇檓譭")
("cjo4" "會惠匯繪慧彙穢誨賄晦彗諱潰卉蕙濊燴喙恚薈翽闠嘒槥篲繢繐蟪璯嬇憓潓瞺譓譿鏸橞廆詴圚蔧獩餯鐬饖芔禬襘")
("cjo6" "回迴蛔茴蚘洄痐恛藱")
("cjp " "婚昏葷閽惛睯殙棔涽敯睧")
("cjp3" "混睔")
("cjp4" "混渾溷諢圂慁輥倱梡")
("cjp6" "魂渾餛混琿楎餫棞顐鼲繉轋")
("ck " "喝呵訶峆")
("ck4" "賀和鶴喝荷嚇赫郝暍嗃熇猲翯佫煂")
("ck6" "何合和河荷核盒禾褐劾闔閤曷龢涸盍覈蓋貉閡紇滆翮蝎嗑齕郃餲鶡鉌魺鞨菏姀毼熆蒚篕螛礉盉廅楁澕趷")
("cl " "蒿嚆薅")
("cl3" "好郝")
("cl4" "號耗浩皓鎬涸昊好灝澔皜顥鄗秏淏滈皞哠悎鰝昦薃")
("cl6" "號毫豪壕濠蠔貉嚎鶴蚵嗥籇諕勂譹")
("co " "黑嘿潶")
("co3" "黑")
("cp3" "很狠")
("cp4" "恨")
("cp6" "痕拫鞎")
("d " "ㄎ")
("d. " "摳彄芤袧鏂")
("d.3" "口")
("d.4" "扣寇叩蔻釦鷇筘佝怐滱瞉簆")
("d/ " "坑硜鏗牼吭阬硻銵娙挳鍞")
("d/3" "挳")
("d0 " "刊堪勘戡看龕嵁")
("d03" "砍侃坎崁莰檻欿轗歁歞埳凵顑")
("d04" "看瞰勘闞矙磡衎墈鬫竷")
("d8 " "咖喀哈鉲")
("d83" "卡咳佧")
("d84" "喀髂")
("d9 " "開揩痎侅")
("d93" "凱慨楷愷剴豈鎧塏闓鍇颽暟輆")
("d94" "慨愾愒咳欬烗勓壒")
("d; " "康慷糠鏮漮嫝")
("d;3" "慷")
("d;4" "亢抗炕伉匟囥犺閌邟鈧")
("d;6" "扛")
("dj " "哭枯窟骷跍挎桍刳顝胐橭")
("dj/ " "空崆倥箜悾硿涳錓")
("dj/3" "恐孔倥")
("dj/4" "空控鞚")
("dj0 " "寬髖臗")
("dj03" "款窾梡")
("dj3" "苦楛")
("dj4" "庫褲酷嚳矻瘔趶")
("dj8 " "誇夸姱荂晇侉舿")
("dj83" "垮侉銙")
("dj84" "跨胯骻")
("dj9 " "咼喎")
("dj93" "蒯")
("dj94" "快塊會筷檜劊鄶澮膾噲獪儈鱠駃鬠欳")
("dj; " "匡框筐誆劻恇洭")
("dj;3" "俇")
("dj;4" "況礦曠框眶鄺貺壙纊絖懭爌彉")
("dj;6" "狂誑鵟")
("dji3" "擃")
("dji4" "括擴闊廓鞹漷蛞姡霩籗")
("djo " "虧窺盔闚刲悝鞹鍷茥藈噅巋蘬")
("djo3" "傀跬頍煃蹞峞")
("djo4" "愧潰匱饋餽喟簣媿聵憒簀蕢瞶槶樻鐀嘳撌騩硊蔮")
("djo6" "魁睽奎揆葵逵戣夔騤暌鄈頯聧楏櫆湀馗楑犪躨")
("djp " "昆崑坤琨錕焜褌晜鯤菎騉髡惃猑")
("djp3" "捆綑悃梱閫壼稛硱裍齫")
("djp4" "困睏涃")
("dk " "科柯刻棵顆苛瞌磕蚵蝌軻稞窠珂砢簻薖峇鈳樖犐嵙")
("dk3" "可渴哿坷岢堁敤嶱閜")
("dk4" "客課刻克剋喀溘恪嗑可榼緙髁氪騍搕厒勀")
("dk6" "咳殼")
("dl " "尻")
("dl3" "考烤拷栲攷薧洘")
("dl4" "靠銬犒")
("dp3" "肯啃墾懇齦齗豤錹")
("dp4" "掯硍裉")
("e " "ㄍ")
("e. " "句溝勾鉤枸泃篝緱构芶耩")
("e.3" "狗茍岣枸苟笱耇茩蚼")
("e.4" "夠購垢構媾彀搆詬遘覯冓姤雊傋瞉簼韝唦")
("e/ " "更耕庚粳羹賡浭緪鶊菮揯")
("e/3" "梗耿哽綆鯁埂骾郠挭")
("e/4" "更亙堩")
("e0 " "乾甘干竿肝尷柑坩泔咁疳玕杆矸虷筸蜬鳱嵅")
("e03" "敢感趕桿橄稈澉皯盰赶")
("e04" "幹贛凎淦紺旰骭詌榦灨涻簳嵅")
("e8 " "嘎旮")
("e84" "尬")
("e86" "軋噶釓")
("e87" "價")
("e9 " "該垓陔賅荄侅峐胲祴絯豥賌隑")
("e93" "改")
("e94" "概蓋丐鈣溉戤摡瓂")
("e; " "剛鋼缸崗綱岡肛扛杠罡疘舡釭堽碙棡笐堈犅")
("e;3" "港崗")
("e;4" "槓")
("ej " "姑孤辜咕沽估菇菰呱蛄痼箍鴣觚酤泒罛箛鈷鮕夃柧鈲軱家嫴橭")
("ej/ " "工公功供攻宮恭躬弓蚣紅龔肱觥疘釭篢塨愩匑共幊")
("ej/3" "鞏拱汞共珙礦栱廾拲蛬穬")
("ej/4" "共供貢羾摃")
("ej0 " "官關觀冠棺矜鰥綸倌莞瘝毌鱞")
("ej03" "管館莞琯筦脘痯錧")
("ej04" "慣貫灌罐摜盥鸛冠觀丱爟瓘祼矔鑵涫悺悹雚鱹")
("ej3" "股古鼓骨谷穀賈凸蠱汩牯滑罟嘏詁轂鵠瞽臌盬羖蛌扢鈷杚淈狜唃尳榖蓇濲瀔愲縎薣")
("ej4" "故固顧雇僱錮告估痼梏榾牿堌崮凅棝稒")
("ej6" "骨鶻")
("ej8 " "瓜括刮蝸颳呱聒鴰栝适騧胍腡筈葀劀瘑緺懖趏膼")
("ej83" "寡剮")
("ej84" "掛卦褂罫罣絓詿挂髺")
("ej9 " "乖")
("ej93" "拐柺枴")
("ej94" "怪旝夬廥癐")
("ej; " "光胱洸桄珖炚茪銧垙烡")
("ej;3" "廣獷")
("ej;4" "逛桄臩臦矌")
("eji " "郭鍋蟈堝嘓崞埻墎濄")
("eji3" "果裹槨蜾輠粿猓淉惈鐹錁")
("eji4" "過")
("eji6" "國幗虢馘摑聝膕漍慖簂")
("ejo " "歸規龜瑰閨圭珪皈傀媯槻鮭槼邽窐溈嫢摫")
("ejo3" "鬼軌詭癸匭晷宄簋佹垝氿姽蟡庪祪蛫觤厬")
("ejo4" "貴桂櫃跪劌溎鱖昋炔筀柜嶡襘暩")
("ejp3" "滾袞鯀緄輥掍蔉")
("ejp4" "棍璭")
("ek " "哥歌割鴿擱胳戈肐疙渮牁菏滒麧")
("ek3" "葛哿舸擖魺騔笴")
("ek4" "個各鉻虼箇")
("ek6" "格革隔閣葛骼蛤咯膈轕嗝搿郃韐塥觡鬲閤挌佮輵鮯敆茖愅獦鎘鞷齃")
("ek7" "個")
("el " "高糕膏篙羔皋櫜睪鼛槔睾滜韟")
("el3" "稿攪搞槁縞杲暠檺筶")
("el4" "告誥郜鋯祰煰")
("eo3" "給")
("ep " "跟根")
("ep3" "艮")
("ep4" "亙艮茛")
("ep6" "哏")
("f " "ㄑ")
("fm " "區屈驅趨軀嶇曲蛆瞿袪敺蛐佉砠胠岨祛呿凵抾阹镼魼鶌鱋紶髷")
("fm, " "缺闕蒛")
("fm,4" "卻確鵲雀怯闕榷搉恪殼闋愨埆确碏碻礐硞皵毃礭")
("fm,6" "瘸")
("fm/ " "芎穹銎")
("fm/6" "窮瓊芎穹跫蛩惸邛璚藭瞏煢筇輁藑桏赹笻橩蒆")
("fm0 " "圈悛棬弮絟惓")
("fm03" "犬綣甽畎琄虇汱圈")
("fm04" "勸券牶烇絭")
("fm06" "全權泉詮拳銓痊顴蜷筌卷荃鬈牷輇佺犬踡醛恮婘犈觠駩巏齤蠸姾瑔跧縓灥")
("fm3" "取曲娶齲浀紶")
("fm4" "去趣娶漆覷闃湨麮刞鼁")
("fm6" "渠劬麴衢蟝瞿籧璩氍蘧磲蕖朐軥鴝翑葋豦懅螶鼩匷灈欋臞蠷躣胊斪淭菃翵")
("fmp " "逡踆峮")
("fmp6" "群裙宭")
("fu " "七妻欺戚漆棲悽淒柒萋慼溪沏諆郪娸鸂嘁顣悊榿磎倛咠栖谿凄唭徛桼僛緀磩霋魌鶈攲")
("fu, " "切沏")
("fu,3" "且")
("fu,4" "切竊妾怯愜挈篋鍥契朅踥鯜蛪緀藒洯")
("fu,6" "茄伽癿")
("fu. " "秋邱丘蚯鞦鰍鶖楸坵萩偢緧媝蓲趥龜恘蝵蟗蠤")
("fu.3" "糗")
("fu.6" "求球囚仇酋裘遒毬泅鰽逑俅厹璆絿艽虯蝤觩賕盚銶頄鼽訄犰朹梂釚煪苬紌脙莍崷僋蛷鮂鯄殏")
("fu/ " "清青輕傾卿氫蜻頃鯖圊氰狅郬")
("fu/3" "請頃廎")
("fu/4" "慶罄親凊綮謦磬漀汫鑋靘掅碃罊")
("fu/6" "情晴擎傾檠勍殑樈殌")
("fu0 " "千鉛遷簽牽謙籤嵌仟阡韆騫愆僉慳搴褰粁岍汧縴芊掔扦檶鐱婜羥攐攓譣顩奷忏顅麉櫏")
("fu03" "遣淺譴繾槏撖忏蜸")
("fu04" "欠歉倩慊茜塹芡傔嗛槧縴篟綪棈蒨輤")
("fu06" "前錢乾潛黔鉗虔箝鈐掮媊揵燂拑鬵灊黚忴扲岒漧葥鳹騚鰬仱姏蚙軡榩")
("fu3" "起啟豈乞綺杞稽綮屺棨敧芑婍邔芞呇")
("fu4" "企氣器汽棄契砌泣迄訖汔憩緝亟葺磧栔愒妻蟿鏚盵蚑忔湆气諿湇甈鼜")
("fu6" "其期齊奇旗騎祈棋祺碁祁崎琦岐歧琪麒鰭畦臍祇耆淇跂枝綦騏衹蘄圻錡旂萁蜞埼墘蠐頎懠艩蚔軝藄鄿鯕鬐蚑錤掑岓碕翗釮亓蚚稘鬿踑鮨鶀鵸玂麡濝")
("fu8 " "掐")
("fu83" "卡酠")
("fu84" "恰洽帢愘殎")
("fu; " "槍腔鎗羌嗆搶鏘鏹蜣蹌斨瑲椌蹡錆矼嶈將牄謒")
("fu;3" "強搶襁磢傸墏繈")
("fu;4" "嗆羻唴熗蹌")
("fu;6" "強牆薔戕墻嬙檣爿漒蘠廧彊")
("ful " "敲鍬橇撬蹺磽蹻墝幧繑髜鐰鏒塙鄡墽骹庨郻頝")
("ful3" "巧悄愀鵲雀燋頝")
("ful4" "翹竅俏峭鞘誚撬蹺殼帩撽躈")
("ful6" "橋瞧僑喬樵翹憔蕎礄譙簥趫燆劁嘺嫶趬敿")
("fup " "親侵欽衾駸嶔綅瀙鋟")
("fup3" "寢昑寑曋螼坅顉")
("fup4" "沁撳唚菣")
("fup6" "勤琴秦禽擒芹檎懃噙芩螓鈙嫀斳耹靲澿庈肣蚙軡雂")
("g " "失施師詩濕溼獅屍ㄕ蝨噓虱尸迉蓍葹鳲邿湤絁鰤溮鶳箷褷襹螄")
("g. " "收荍")
("g.3" "手首守掱艏")
("g.4" "受售壽獸授瘦狩綬")
("g.6" "熟")
("g/ " "生聲勝升牲昇甥笙陞泩鉎鼪呏狌湦焺鵿")
("g/3" "省眚冼箵偗")
("g/4" "勝盛聖剩嵊乘賸圣貹")
("g/6" "繩澠憴譝鱦溗")
("g0 " "山扇衫杉刪珊羶舢煽潸跚姍芟苫搧縿穇挻烻狦笘剼")
("g03" "閃陝睒晱覢")
("g04" "善扇汕擅膳繕鄯煽訕單贍疝鱔騸禪墠嬗掞摲謆墡釤蟺赸儃")
("g3" "使始史駛矢屎豕")
("g4" "市是事世士勢識室示試視式氏適釋飾侍誓逝嗜恃仕柿使螫弒噬拭豉媞筮舐軾諡貰奭戺澨諟襫鈰揓鉽唑翨銴謚遾簭鯷齛跩烒崼徥詍戠褆衋")
("g6" "十什石時實食拾蝕碩射提蒔湜鰣塒祏鼫鉐榯湁溡鼭寔")
("g7" "匙")
("g8 " "殺沙紗砂莎煞鯊裟杉痧鎩魦樧猀帴摋蔱硰")
("g83" "傻繌")
("g84" "煞霎廈嗄歃箑翣萐喢")
("g86" "啥")
("g9 " "篩")
("g93" "骰繺")
("g94" "曬晒閷殺")
("g; " "商傷殤觴湯漡蔏螪謪鬺")
("g;3" "賞晌上")
("g;4" "上尚爙姠仩")
("g;7" "裳")
("gj " "書輸殊舒梳疏蔬樞紓抒攄姝樗摴殳杸陎綀橾祋軗鵨藲")
("gj0 " "栓閂拴")
("gj04" "涮")
("gj3" "數鼠屬暑署薯蜀黍癙潻藷钃婌襩糬韣")
("gj4" "術數樹束述署豎疏恕庶曙墅漱倏戍澍翛沭裋鉥尌儵鏣鶐")
("gj6" "叔熟淑塾贖孰菽秫襡埱焂跾鸀虪")
("gj8 " "刷唰鮛")
("gj83" "耍")
("gj9 " "摔衰縗孈")
("gj93" "甩")
("gj94" "率帥蟀咰繂")
("gj; " "雙霜孀艭驦鷞孇礵")
("gj;3" "爽塽樉漺慡縔")
("gj;4" "灀")
("gji " "說")
("gji4" "朔碩爍數鑠嗍率蟀帥搠妁槊箾蒴勺欶揱獡鎙")
("gjo3" "水")
("gjo4" "說睡稅蛻帨涗裞")
("gjo6" "誰脽")
("gjp3" "盾楯吮揗賰")
("gjp4" "順舜瞬蕣鬊瞚")
("gk " "奢賒奓檨譇")
("gk3" "捨舍")
("gk4" "社設射涉舍攝赦歙麝厙猞灄蔎韘騇拾葉捑蠂")
("gk6" "蛇舌甚佘什揲鉈")
("gl " "燒稍梢艄捎弰蛸莦筲旓髾輎鮹蕱")
("gl3" "少")
("gl4" "少紹哨邵召卲劭袑睄潲")
("gl6" "杓韶芍勺玿圴牊")
("go6" "誰")
("gp " "身深伸申紳呻信參蔘娠莘甡侁籸葠詵駪燊砷柛氠屾珅胂阠妽峷眒")
("gp3" "沈審嬸瀋諗讅矧哂寀瞫邥覾")
("gp4" "慎腎滲甚蜃沁葚椹脤抻侺鋠")
("gp6" "神甚")
("h " "疵庛雌ㄘ差趀骴")
("h.4" "湊輳腠楱")
("h/ " "噌")
("h/4" "蹭")
("h/6" "曾層嶒鄫碀")
("h0 " "參餐驂")
("h03" "慘憯朁噆黲")
("h04" "燦孱璨粲澯")
("h06" "殘蠶慚嬠")
("h3" "此佌泚玼跐皉")
("h4" "次刺賜廁伺佽蛓莿朿栨蚝絘")
("h6" "詞辭慈磁瓷雌祠疵茨粢餈柌嬨濨呲飺薋")
("h8 " "擦搽嚓")
("h83" "礤")
("h84" "囃")
("h9 " "猜")
("h93" "採彩采睬踩綵跴寀棌婇")
("h94" "蔡菜埰采縩")
("h96" "才財材裁纔")
("h; " "蒼倉滄艙傖鶬凔嵢")
("h;6" "藏鑶")
("hj " "粗麤觕")
("hj/ " "匆聰從囪璁瑽樅驄蓯鏦熜棇暰蔥瞛蟌鍐")
("hj/4" "欉藂謥")
("hj/6" "從叢淙琮悰潀漎賨錝婃孮徖慒")
("hj0 " "攛躥鋑")
("hj04" "竄篡爨篹")
("hj06" "攢巑劗")
("hj4" "促醋簇蹴蔟蹙猝卒錯趣趨鏃瘯踧槭梀噈殧鼀")
("hj6" "殂徂")
("hji " "搓撮磋蹉蒫遳髊")
("hji3" "瑳脞縒硰")
("hji4" "錯措挫銼撮剉厝莝侳剒齰蓌")
("hji6" "瘥矬鹺痤醝嵯蔖")
("hjo " "摧催崔嗺墔磪鏙榱衰")
("hjo3" "璀趡漼")
("hjo4" "翠脆粹悴瘁萃啐淬倅毳橇焠竁膬綷膵脺濢")
("hjo6" "凗慛")
("hjp " "村皴")
("hjp3" "忖刌")
("hjp4" "寸吋籿")
("hjp6" "存袸")
("hk4" "冊策測側廁惻筴畟茦粣拺矠憡蓛")
("hl " "操糙鄵喿")
("hl3" "草懆騲艸")
("hl4" "糙操肏襙")
("hl6" "曹槽嘈漕螬艚嶆")
("hp " "參嵾梫")
("hp6" "岑涔梣笒埁")
("i " "喔ㄛ")
("i6" "哦")
("j " "屋烏污汙圬誣嗚巫鎢鄔洿歍ㄨ惡於杇陓剭窏腛鴮螐")
("j/ " "翁嗡螉鶲霐")
("j/3" "蓊滃暡浻瞈聬塕")
("j/4" "甕瓮齆罋")
("j0 " "灣彎豌剜莞蜿刓潫")
("j03" "晚碗挽宛婉娩皖輓莞浣蜿畹菀琬鞔綰晼綩鯇倇脕睕鋄睌葂")
("j04" "萬玩腕惋卍翫忨仴綄万蟃捥踠")
("j06" "完玩頑丸汍紈芄烷婠岏抏")
("j3" "五午武舞侮伍鵡憮嫵潕廡仵忤碔甒摀啎捂嵨玝倵橆躌")
("j4" "勿物務惡誤悟晤霧戊鎢塢兀兀騖寤軏杌婺鶩堊沕迕遻鋈屼扤煟卼焐靰阢粅矹芴埡逜痦齀蘁岉噁蓩")
("j6" "無吳吾梧巫蕪唔蜈誣毋亡牾膴麌鼯郚鋘鋙峿浯珸俉鯃莁鷡洖瞴譕")
("j8 " "哇蛙挖窪呱媧洼穵溛窊窐漥")
("j83" "瓦佤")
("j84" "襪嗢膃")
("j86" "娃")
("j9 " "歪")
("j93" "舀")
("j94" "外")
("j; " "汪尪尢")
("j;3" "往網枉罔惘魍輞瀇网暀菵臦")
("j;4" "忘妄望旺王朢迋莣")
("j;6" "王亡")
("ji " "窩倭渦萵猧踒")
("ji3" "我婐捰")
("ji4" "握臥沃渥斡齷幄涴偓濣焥")
("jo " "威崴偎煨葳隈萎委逶烓椳渨碨愄揋葨隇溾詴蝛覣燰")
("jo3" "委尾偉緯萎諉葦痿猥煒亹隗娓韙寪洧瑋薳蘤韡鮪磈蒍頠暐痏骫椲浘艉芛鍡峗壝喡徫腲蜲儰蓶崣硊踓斖")
("jo4" "為位未魏衛味偽謂胃喂慰餵尉渭畏蔚蘶蝟犩遺亹霨磑罻褽薉媦蜼藯鏏菋犚餧贀讆躗穌鮇徻")
("jo6" "為圍微危唯維惟違韋薇巍桅闈濰帷嵬幃囗湋溦鄬鍏鮠潿洈覹醀霺瀢濻癓欈")
("jp " "溫瘟轀塭馧瞃豱殟")
("jp3" "穩吻刎呡桽")
("jp4" "問聞紊文汶抆免搵璺妏")
("jp6" "文聞紋蚊玟雯閿炆芠琝閺闅鼤駇魰鳼")
("k " "阿婀痾ㄜ屙峉錒")
("k3" "噁")
("k4" "惡餓俄鄂厄遏鍔扼鱷顎呃愕噩軛阨鶚堊諤萼咢啞崿搤詻閼頞堨齶枙堮岋鑩櫮砐砨蚅豟軶圔搹蝁嶭餩蘁")
("k6" "額訛鵝娥哦蛾峨莪俄囮吪硪蚵鋨迗珴涐皒睋魤")
("l " "凹ㄠ坳柪")
("l3" "襖媼芺镺")
("l4" "傲澳奧懊墺奡扷擙拗詏嶴")
("l6" "熬敖遨翱嗷螯鰲鼇鏖驁廒獒璈聱鏊滶磝隞摮蔜簢謷爊")
("m " "淤迂瘀紆ㄩ毹箊扜穻盓")
("m, " "約曰噦箹焥")
("m,4" "月越樂悅閱粵躍岳嶽耀鑰曜藥鉞說刖瀹籥樾爚礿禴趯軏鸑龠狘玥戉泧鈅抈蚎蘥鸙")
("m/ " "傭庸雍擁壅癰臃墉鏞慵饔邕廱雝嗈灉鄘噰澭蕹滽郺")
("m/3" "永泳詠勇擁踴湧蛹甬壅恿臃俑踊埇塎禜涌悀銢")
("m/4" "用佣醟")
("m/6" "傭喁顒傛槦嫆嵱嫞")
("m0 " "冤淵鴛鳶宛眢蜎鵷肙鋺惌棩蒬裷鼘葾蜵裫駌嬽灁")
("m03" "遠妴")
("m04" "院願怨苑遠媛瑗愿掾褑夗謜禐噮")
("m06" "原元員園圓緣源援媛袁猿垣沅轅爰圜黿嫄櫞芫湲騵笎羱蝯邧蝝妧萲螈蚖杬榞溒媴猭獂榬蒝鎱邍鶢")
("m3" "與語雨予羽嶼宇禹庾齬噢圄圉窳傴俁敔噳楀瑀与萭貐偊祤斞鄅寙篽蘌斔螤")
("m4" "育遇預玉欲域喻愈譽獄慾浴裕煜寓禦與鈺豫御鬱籲諭癒郁馭昱毓芋尉熨俞峪聿嫗彧飫鬻谷鷸燠蜮堉語瘉棫澦矞禺罭蕷遹閾隩鵒棜淢燏獝繘魊薁驈悆鴥鋊淯黦栯砡礜欥軉輍悇稢蒮噊鳿醧饇爩灪戫袬緎蓹錥")
("m6" "於愉魚娛餘于漁予愚余竽榆逾虞俞輿瑜渝隅臾腴盂諛踰舁圩歟覦畬萸嵎窬妤揄歈禺轝隃雩杅楰玗緰羭蝓褕瘐艅狳邘璵硢籅釪崳湡鄃腧睮雓澞蕍螸謣鮽鵌蘛鸆鸒衧唹堣堬雽歶旟鰅齵")
("mp " "暈氳縕贇奫蝹")
("mp3" "允隕殞狁霣褞抎賱輑鈗阭")
("mp4" "運韻孕熨蘊慍醞惲暈韞鄆薀枟緷鶤員")
("mp6" "雲云勻昀耘芸紜熅筠溳澐畇篔沄熉鋆蕓妘伝縜荺鄖枃眃")
("n " "司思斯絲私撕廝鷥嘶ㄙ澌緦偲罳颸禠虒楒鍶凘泀蕬鉰俬覗榹禗蜤磃謕蟴鷈鼶")
("n. " "搜颼鄋蒐廋溲餿獀醙嗖鎪騪")
("n.3" "叟嗾藪擻瞍謏籔")
("n.4" "嗽")
("n/ " "僧鬙")
("n0 " "三參毿攕鬖")
("n03" "散傘繖糝鏾")
("n04" "散閐")
("n3" "死")
("n4" "四似賜嗣飼寺肆祀食俟伺泗巳耜儩姒笥駟兕涘柶汜肂貄蕼洍")
("n7" "思")
("n8 " "撒仨")
("n83" "灑撒靸洒")
("n84" "薩卅趿颯攃馺隡")
("n9 " "塞鰓腮毢揌")
("n94" "賽塞僿")
("n; " "喪桑")
("n;3" "嗓顙搡磉鎟褬")
("n;4" "喪")
("nj " "蘇甦酥穌囌櫯")
("nj/ " "松鬆淞嵩忪菘娀崧濍倯硹蜙")
("nj/3" "聳慫悚竦傱愯嵷駷")
("nj/4" "送宋頌訟誦")
("nj0 " "酸痠狻")
("nj03" "匴")
("nj04" "算蒜筭")
("nj4" "訴速素肅宿塑夙粟溯餗愬蓿縮觫愫膆謖嗉橚泝涑潚簌蔌樕遫驌鱐鷫嫊玊榡洬栜傃溹憟鋉縤藗僳窣")
("nj6" "俗")
("nji " "縮梭莎唆娑簑嗦傞挲蓑桫蹜莏趖摍")
("nji3" "所索鎖瑣璅嗩摵鎍鏼")
("nji4" "逤")
("njo " "雖綏濉睢荽毸眭浽哸娞荾滖")
("njo3" "髓嶲瀡巂靃")
("njo4" "歲遂碎穗隧祟燧誶睟穟璲檖襚鐩邃埣賥檅繀禭旞繸鐆")
("njo6" "隨隋雟")
("njp " "孫飧蓀猻搎槂薞蕵")
("njp3" "損筍榫簨鎨")
("njp4" "潠愻")
("nk4" "色塞瑟圾嗇澀穡濇轖譅銫璱翜犞飋濏")
("nl " "艘騷繅搔臊慅溞颾鱢")
("nl3" "掃嫂埽")
("nl4" "掃臊氉瘙")
("np " "森槮罧襂幓篸")
("o " "ㄟ")
("p " "恩嗯ㄣ")
("p4" "摁")
("q " "ㄆ")
("q. " "剖吥")
("q.3" "剖瓿棓婄")
("q.6" "掊裒抔捊")
("q/ " "砰烹抨怦漰澎匉閛恲軯駍磞")
("q/3" "捧皏")
("q/4" "碰堋掽椪")
("q/6" "朋彭澎蓬膨硼棚鵬篷蟛芃淜鬅痭錋倗輣傰韸髼憉樥鑝")
("q0 " "潘攀眅")
("q03" "坢")
("q04" "判叛盼畔拚袢泮襻詊頄溿沜牉頖")
("q06" "盤磐蟠般胖槃蹣磻踫鞶幋縏柈瀊蒰媻搫跘")
("q8 " "趴葩啪蚆舥")
("q84" "怕帕帊袙")
("q86" "爬扒琶耙杷跁")
("q9 " "拍啪")
("q93" "矲俖")
("q94" "派湃鎃蒎")
("q96" "排牌徘俳簰棑")
("q; " "乓磅滂")
("q;3" "嗙耪")
("q;4" "胖")
("q;6" "旁龐膀螃徬蒡厖尨雱逄庬篣舽")
("qi " "波潑坡陂鏺癹翍")
("qi3" "頗剖叵笸")
("qi4" "破迫魄珀泊朴粕醱岶烞蒪")
("qi6" "婆鄱皤櫇")
("qj " "撲仆鋪噗扑痡醭抪瞨")
("qj3" "普浦埔譜圃溥烳氆鐠潽誧")
("qj4" "暴鋪瀑曝舖")
("qj6" "僕樸葡蒲菩朴蹼脯濮璞匍莆蒱襆酺釙鏷轐纀墣")
("ql " "拋脬")
("ql3" "跑")
("ql4" "泡砲炮皰奅麭髱")
("ql6" "袍咆刨匏庖麃炰齙鞄炮瓟")
("qo " "胚呸坏醅柸岯垺衃")
("qo3" "琣昢")
("qo4" "配佩沛珮霈帔旆浿轡姵翇伂")
("qo6" "培賠陪裴邳碚毰陫荖")
("qp " "噴歕")
("qp3" "呠翸翉")
("qp6" "盆湓葐")
("qu " "批披匹劈霹砒被丕坯坏伾狉紕秠鈹鴄怌翍釽憵銔駓髬")
("qu, " "瞥撇氕")
("qu,3" "撇")
("qu/ " "乒娉砯頩覮")
("qu/3" "絣")
("qu/6" "平瓶憑評屏蘋萍坪枰泙帡洴缾軿俜玶甹苹郱呯竮艵蛢馮荓蓱炾")
("qu0 " "篇偏扁翩萹媥貵頨鶣")
("qu04" "片騙遍")
("qu06" "便胼駢諞蹁楩骿")
("qu3" "否匹疋痞嚭苤仳庀圮崥諀")
("qu4" "譬闢僻媲屁辟癖甓擗澼濞淠揊潎鷿髲礔")
("qu6" "皮疲脾琵枇裨啤毗埤沘貔陂羆罷紕郫陴鼙鈹膍毘阰蚽蜱玭笓鈚錍魾螷犤毞猈藣蠯")
("qul " "飄漂慓螵薸僄旚翲魒")
("qul3" "漂莩縹瞟殍皫摽醥犥鷅")
("qul4" "票漂剽驃彯篻顠蔈")
("qul6" "瓢嫖淲")
("qup " "拼姘礗涄")
("qup3" "品")
("qup4" "聘牝")
("qup6" "貧瀕頻顰嬪嚬矉")
("r " "ㄐ")
("rm " "居拘駒沮疽蛆狙俱車据鋸裾苴趄罝菹娵椐腒崌痀琚雎涺葅鮈鶋斪揟蜛踙輋")
("rm, " "噘嗟撅")
("rm,3" "蹶")
("rm,4" "倔")
("rm,6" "決覺絕爵掘嚼訣厥獗蹶蕨崛攫倔炔抉噱矍觖角孓玨劂橛爝譎屩觼玦腳臄蕝躩戄桷潏鴃貜趹鱖傕嵑瘚蠼鐍钁玃捔芵焆鈌蚗谻赽僪憰蟨彏鱊鷢堀殌穱")
("rm/ " "扃坰駉")
("rm/3" "窘迥煚泂炅絅褧冏熲囧皛炯幜顈")
("rm0 " "捐娟鵑涓鐫圈蠲朘身脧裐")
("rm03" "捲卷埢菤臇")
("rm04" "倦卷眷絹雋悁狷圈獧睊睠罥鄄帣錈腃韏鬳")
("rm3" "舉矩咀莒沮齟櫸筥踽蒟椇柜竘袓跙蝺")
("rm4" "據句具巨劇聚俱拒距鋸懼鉅炬詎遽倨瞿踞颶泃苣窶醵屨秬虡寠鐻佢据粔姖怚絇足耟岠埧蚷駏澽貗躆洰焣壉犋")
("rm6" "局鞠菊橘掬跼桔挶鞫侷匊踘鋦鵙鶪椈焗淗驧狊梮郹犑輂箤趜鵴蘜鼳陱駶")
("rmp " "軍君均鈞皸囷麇莙鮶桾蚐袀頵龜碅")
("rmp3" "窘蜠")
("rmp4" "俊菌郡峻竣雋濬駿蕈浚珺畯焌捃餕箘寯晙呁鵘葰蔨")
("ru " "機基積績蹟激跡姬雞饑肌稽飢奇畸碁箕磯譏羈几机乩屐躋璣幾嘰畿嵇犄齎其期居唧勣禨欚癘羇虀觭霙蛣銈枅丌尐簊虮鐖櫅稘毄樍諅齍鞿鑇鰿齏笄剞隮鸄癪")
("ru, " "街接皆階揭偕嗟喈幯結湝薢袺啑椄菨蝔鶛")
("ru,3" "姐解姊檞媎")
("ru,4" "界借介戒藉屆疥芥誡解唶喈玠蚧犗褯吤岕价砎悈紒祴躤繲")
("ru,6" "節潔傑捷竭劫截結杰頡詰桀睫訐咭拮羯櫛桔孑癤絜偈擷倢劼婕楬碣鮚岊榤犵袺嵑栨騔滐鉣鐑衱迼崨嵥楶趌踕擳瀄鍻蠽昅揤緁巀緳")
("ru. " "糾揪啾鳩轇湫樛揫勼朻牞觓揂萛鬮")
("ru.3" "九久酒玖赳灸韭糾")
("ru.4" "就究救舊舅臼柩疚咎僦鷲廄捄慦鯦麔")
("ru/ " "經精京驚睛莖晶菁更兢涇鯨荊旌粳黥箐鶄巠婛旍鵛鶁鼱麠仱惊")
("ru/3" "景警井頸阱儆璟憬剄璥丼烴憼暻蟼燛")
("ru/4" "敬竟鏡靜境淨競逕徑靖勁凊脛痙獍倞靚竫婧桱俓凈葝擏弳")
("ru0 " "間監堅尖兼肩艱奸姦煎緘濺漸箋殲菅戔鞬牋椷縑湔熸蒹鶼廌犍籛豜韉鬋鈃鑯鰹鰜櫼熞蕑揃搛幵菺靬葌鳽餰礛騝鵳瀸虃惤猏麉")
("ru03" "簡撿剪減檢揀繭儉鹼柬筧翦謇戩蹇譾趼堿囝鰔挸湕瞼寋藆襺暕瑐")
("ru04" "見建健漸件間監鍵鑑箭劍艦鑒賤踐諫毽薦餞腱濺僭檻閒洊俴牮栫楗珔瀳澗瞷荐諓榗糋鰎蔪鋻螹襉糮鑳")
("ru3" "幾給己擠脊戟濟几麂庋蟣剞掎泲踦魕丮穖妀撠")
("ru4" "計記既紀際繼季寄技妓濟劑繫悸祭忌暨冀騎鯽稷躋薺驥霽薊髻罽覬伎洎瘈跽嚌塈惎漈穧芰蔇痵癠穄鮆鱭鯚鰶旡刉臮裚穊誋鬾瞡檕璾鵋齌懻瀱鱀蘮蘻")
("ru6" "及級極即集急擊疾籍吉寂輯脊圾唧嫉汲亟吃棘藉瘠楫岌笈鶺戢殛蹐伋蒺耤芨蕺踖鈒佶堲姞濈襋墼潗鴶嶯洁忣湒极銡狤鏶蝍衱偮庴莋塉槉漃膌蓻橶蕀轚霵彶揤楖秸鞊螏觙")
("ru8 " "家加嘉佳傢迦枷袈痂笳珈跏茄葭豭耞麚泇毠鎵鴐猳幏犌貑夾")
("ru83" "假甲賈鉀岬胛斝榎瘕檟婽玾徦椵夏")
("ru84" "價假架駕嫁賈稼价")
("ru86" "夾挾頰蛺莢浹戛郟恝袷筴裌鋏梜跲舺唊鉿硈扴鞂鞈鵊")
("ru; " "將江疆僵漿姜薑豇殭韁螿橿茳礓瓨翞")
("ru;3" "講獎蔣槳顜膙")
("ru;4" "降匠醬強將絳糨洚謽嵹彊弶袶")
("rul " "教交膠驕焦嬌郊跤澆蛟蕉礁椒茭姣鮫僬憍艽鷦燋詨鱎鐎鵁鷮嘄憿膲穚蟂鷍嶕蟭")
("rul3" "腳角繳攪勦矯絞姣佼餃皎僥剿較鉸狡皦儌筊蟜摷撟捁灚曒漅劋譑煍")
("rul4" "教叫校較覺轎窖皭醮徼噭嶠挍斠珓釂滘窌嘂潐譥")
("rul6" "嚼")
("rup " "今金禁津斤巾筋襟矜浸觔衿祲瑧菳珒埐紟嶜惍")
("rup3" "緊僅錦謹儘覲瑾饉槿墐殣堇慬菫巹")
("rup4" "進近盡禁晉儘浸勁覲燼廑噤靳縉僅藎妗贐寖搢肵璡賮嬧榗僸蓳瘽嚍濜璶伒溍")
("s " "ㄋ")
("s.4" "耨鎒嗕譨")
("s.6" "羺獳")
("s/4" "濘")
("s/6" "能薴儜")
("s0 " "囝囡")
("s03" "赧戁蝻湳腩揇")
("s04" "難婻")
("s06" "南男難喃楠柟暔諵奻萳莮")
("s83" "那哪")
("s84" "那納吶訥鈉捺娜肭衲軜妠豽魶笝")
("s86" "拿挐拏誽")
("s93" "乃奶迺氖嬭奈氝釢艿尕")
("s94" "耐奈褦鼐柰倷螚渿錼")
("s96" "孻摨")
("s; " "囔")
("s;3" "曩攮灢")
("s;4" "齉")
("s;6" "囊")
("s;7" "囔")
("sj/4" "弄")
("sj/6" "農濃膿儂噥穠襛醲齈鬞")
("sj03" "暖餪煖渜")
("sj3" "努弩砮")
("sj4" "怒")
("sj6" "奴駑孥笯蒘")
("sji3" "橠")
("sji4" "諾懦糯搦挼逽懧糑")
("sji6" "挪娜儺捼梛")
("sk " "呢")
("sl " "峱")
("sl3" "腦惱瑙")
("sl4" "鬧淖")
("sl6" "撓鐃橈呶猱怓譊髐嶩獶繷獿夒")
("sm,4" "虐瘧謔")
("sm3" "女籹釹")
("sm4" "忸恧衄朒")
("so3" "餒哪腇")
("so4" "內")
("sp4" "嫩")
("su, " "捏踗鑈")
("su,4" "孽鎳躡聶鑷涅囁囓臬乜嚙臲闑隉齧敜顳糱蘗疌嵲踂篞櫱蠥钀巕")
("su,6" "苶")
("su. " "妞")
("su.3" "紐扭鈕忸狃炄莥")
("su.4" "拗")
("su.6" "牛")
("su/3" "擰")
("su/4" "濘佞")
("su/6" "寧凝獰嚀檸甯擰鸋鑏寍聹嬣")
("su03" "捻撚攆拈輦碾輾涊簐跈躎鯰")
("su04" "念唸淰齞廿鼰")
("su06" "年黏粘姩哖")
("su3" "你妳擬禰儗旎昵坭柅薿檷抳苨馜隬譺")
("su4" "逆溺匿膩泥睨暱惄鷁鷊嫟縌迡堄")
("su6" "泥尼妮倪霓怩猊蜺輗郳麑鯓鯢齯臡秜狋觬婗淣呢狔屔跜鈮鶂")
("su;4" "釀")
("su;6" "娘孃")
("sul3" "鳥裊嬲嬝嫋蔦褭")
("sul4" "尿")
("sup3" "拰")
("sup6" "您")
("t " "吃蚩癡痴嗤喫ㄔ郗魑笞絺鴟媸摛瓻螭眵齝离貾誺瞝齹黐麶")
("t. " "抽瘳搊篘犨婤")
("t.3" "丑醜瞅杻杽吜莥")
("t.4" "臭簉溴殠憱")
("t.6" "愁仇籌綢酬稠紬躊疇惆裯儔讎幬鯈薵嬦椆絒菗懤詶雔燽栦")
("t/ " "稱撐瞠蟶偁檉赬琤橕鏿浾埥棦牚竀崝饓")
("t/3" "逞騁悜庱塣")
("t/4" "稱秤偁牚")
("t/6" "成程承盛乘誠呈城懲澄橙丞澂棖酲宬晟裎郕埕掁湞珵荿騬脀脭揨峸鋮塍")
("t0 " "摻攙梴襜辿鋓惉嬓欃")
("t03" "產鏟闡剷蕆嘽囅丳嵼燀諂驏幝繟滻簅灛旵譂")
("t04" "懺羼儳")
("t06" "纏蟬禪饞讒潺蟾巉嬋單澶廛孱劖毚瀍瀺躔鑱磛艬僝棎湹鋋煘獑繵嚵酁")
("t3" "尺齒恥呎侈褫欼搋蚇恀拸姼傂誃鉹伬鶒")
("t4" "赤翅斥飭叱熾啻傺敕眙抶饎栻遫彳跮踅鷘乿瘛鉓哧淔痸懘戠摰")
("t6" "持池遲馳匙弛墀坻踟箎茬蚳篪蚔茌痄忯汦荎栘歭耛貾趍箈徲謘徥")
("t8 " "差插叉喳艖嗏扠杈偛疀鎈")
("t83" "蹅")
("t84" "詫岔剎差汊衩蜡侘奼紁")
("t86" "查察茶搽槎鍤碴臿垞秅")
("t9 " "拆釵差偨")
("t94" "蠆袃囆")
("t96" "柴豺儕祡喍")
("t; " "昌倡猖娼閶菖鯧倀鼚錩淐琩裮")
("t;3" "場廠敞氅昶鋹")
("t;4" "唱倡暢悵鬯韔")
("t;6" "長常場嘗裳償腸嫦鱨徜嚐萇鋿粻")
("tj " "出初齣貙")
("tj/ " "充衝沖舂忡憧珫茺浺蹖祌")
("tj/3" "寵")
("tj/4" "衝銃揰")
("tj/6" "重崇虫蟲种翀蝩隀茧痋")
("tj0 " "穿川鐉氚瑏")
("tj03" "喘舛荈")
("tj04" "串釧玔汌夼賗")
("tj06" "傳船遄椽歂諯暷輲")
("tj3" "處楚儲礎杵褚楮濋檚")
("tj4" "處觸畜絀矗黜俶怵搐歜詘鄐斶亍豖泏琡踀滀儊臅敊")
("tj6" "除儲廚鋤櫥雛芻躇滁躕篨耡蜍鉏蒢跦鶵幮貙趎犓")
("tj8 " "欻")
("tj93" "揣")
("tj94" "踹嘬")
("tj96" "膗")
("tj; " "窗創瘡囪憃戧摐")
("tj;3" "闖搶漺")
("tj;4" "創闖愴刱獊")
("tj;6" "床幢撞橦")
("tji " "戳")
("tji4" "綽輟齪婼啜惙歠醊婥畷逴娖吷珿磭腏趠擉嚽")
("tjo " "吹炊")
("tjo4" "吹炊諈")
("tjo6" "垂鎚槌搥椎陲錘捶棰箠圌湷倕菙綞娷腄甀")
("tjp " "春椿杶輴焞鰆媋暙鶞")
("tjp3" "蠢惷踳偆萶")
("tjp6" "純唇醇淳蓴鶉漘錞韕脣憌鯙")
("tk " "車硨莗")
("tk3" "扯撦奲")
("tk4" "徹澈轍撤掣坼屮迠硩")
("tl " "抄鈔超勦弨怊訬剿罺")
("tl3" "吵炒眧")
("tl4" "耖")
("tl6" "朝潮巢嘲晁樔轈鄛")
("tp " "嗔琛瞋郴賝棽謓諃搷堔")
("tp3" "捵磣鍖裖墋踸贂")
("tp4" "趁稱襯櫬讖疢齔嚫藽儭")
("tp6" "陳沉晨臣塵辰娠忱沈宸諶煁茞蔯樄莐愖鈂螴麎鷐伔敶")
("u " "一壹衣依醫伊揖噫漪猗咿ㄧ禕繄黟曀銥泆鷖欹郼圪溰稦燚洢陭蛜嫛瑿檹毉黳嶬")
("u, " "耶噎蠮")
("u,3" "也野冶埜漜")
("u,4" "業葉頁夜咽謁拽靨鄴燁瞱擫射曄饁煠鍱鐷澲鎑偞殗嶪擛")
("u,6" "爺耶椰琊揶擨")
("u. " "優憂幽悠呦攸耰麀櫌鄾懮怮嚘瀀纋蚴")
("u.3" "有友酉莠牖黝羑泑銪岰庮蒏苃聈槱")
("u.4" "又右幼誘佑柚釉祐有莠宥侑囿鼬卣姷狖峟貁鴢扰牰迶")
("u.6" "由游遊尤油郵猶猷鈾輶疣蚰蕕斿蝣訧逌楢魷优沋浟偤秞莤")
("u/ " "應英鷹嬰鶯櫻膺瑛鸚嚶罌纓攖瓔嫈甖罃煐韺甇霙碤礯朠蝧渶褮偀霒蘡譻蠳鶧")
("u/3" "影景穎潁癭郢瀴矨梬浧")
("u/4" "應硬映媵瀅鎣摬賏")
("u/6" "營迎蠅螢贏盈瑩縈瀛滎嬴塋熒楹瀅瀠籯瀯謍攍巆廮藀")
("u0 " "煙焉淹殷醃咽胭奄湮菸嫣燕蔫閹厭崦臙鄢漹猒珚偣嬮酀腌")
("u03" "眼演掩衍郾偃兗甗儼魘剡弇罨沇巘扊揜渰蝘黶姶戭棪嬿鰋鼴琰匽厴椼抁龑酓嵃愝萒隒裺褗鶠黤曮惔躽馣黭")
("u04" "驗燕厭晏雁宴淹豔燄彥堰硯咽嚥唁饜研讌諺沿讞焱釅贗喭灩爓閆鷃嬿鴳醼焰牪姲鷰椻曣懨婩傿鴈噞騴觾艷驠莚敥")
("u06" "研言顏嚴延沿炎癌鹽岩筵簷閻妍蜒檐埏喦揅碞綖郔巖孍楌礹閰娮鈆狿虤顃壛麙壧莚嵒")
("u3" "以已乙倚椅矣蟻尾艤迤苡偯扆旖螘扡酏鳦釔齮顗檥鉯迆胣礒掜陭崺晲轙")
("u4" "意義易議亦益異藝億憶譯液役翼疫毅逸邑抑肄一誼繹溢縊軼詣屹佚翌羿驛掖懿裔臆曳奕蜴腋衣刈翳挹鎰囈弈佾乂弋艾懌劓圛斁薏悒瘞仡勩埸嶧帟曀杙枻殪浥熠艗襼饐黓亄唈燡藙豷寱阣熤劮檍嗌廙鐿鞥醳醷翊肊异枍伿浂澺芅熼玴抴蘙俋焲燱晹垼釴捙欭埶羛隿殔跇裛嫕緆膉靾槷潩蓺墿瘱謚繶瀷帠槸霬鷾齸")
("u6" "遺疑移宜怡姨儀夷一誼胰貽飴咦詒沂頤彝迤椸痍蛇圯嶷笫桋匜宧洟簃訑貤迻杝柂袲酏峓眱羠鈶寲侇珆衪銕呲恞萓沶栘瓵袘羡蛦暆跠歋熪箷螔顊謻觺鸃")
("u8 " "呀壓鴉鴨押丫椏煆孲")
("u83" "亞啞雅掗厊庌蕥雃疋")
("u84" "亞訝迓砑氬婭揠錏聐軋圠襾玡猰窫齾")
("u86" "牙芽涯衙蚜押枒犽齖伢堐")
("u96" "崖睚啀娾")
("u; " "央秧殃鴦鞅泱坱胦柍佒姎紻鉠雵")
("u;3" "養仰氧癢鞅卬攁岟炴抰痒懩蝆")
("u;4" "樣養恙漾怏煬瀁羕")
("u;6" "楊陽揚洋羊佯烊瘍鍚徉颺暘煬垟昜禓蛘瑒珜鐊崵鸉眻婸")
("ui " "唷")
("ul " "要腰夭妖邀么吆喲喓祅葽訞")
("ul3" "咬窈舀夭殀杳窅窔鷕宎抭苭眑偠溔榚騕岆嫍蓔")
("ul4" "要藥耀曜鑰樂鷂拗燿袎靿艞覞穾筄葯獟趭")
("ul6" "搖謠堯遙姚洮瑤僥淆餚颻傜繇嶢徭殽猺軺爻垚崤銚珧柼猇鰩肴媱烑窯嗂愮榣顤")
("up " "因音陰姻殷茵慇氤瘖喑堙湮愔禋絪裀闉駰銦蒑諲垔韾洇凐歅噾霠韽黫摿")
("up3" "引飲隱尹癮蚓听靷紖縯讔趛螾馻鈏檃濦蘟粌")
("up4" "印飲隱蔭胤廕窨憖湚垽猌朄酳")
("up6" "銀吟寅淫鄞齦檐霪垠夤狺嚚崟誾蟫婬冘苂釿圁烎凐荶殥蔩檭鷣鏔")
("v " "ㄒ")
("vm " "須需虛鬚噓墟戌胥訏吁歔盱嬃繻殈旴呴楈嬬鑐欨倠稰縃蝑蕦驉魖晇幁揟糈")
("vm, " "薛靴噱嶨吙")
("vm,3" "雪鱈")
("vm,4" "血雪穴削趐泬謞岤袕")
("vm,6" "學穴鷽觷踅燢澩壆")
("vm/ " "兄兇胸凶匈洶忷哅恟")
("vm/4" "敻詗")
("vm/6" "雄熊赨")
("vm0 " "宣軒喧瑄萱暄壎儇諼塤嬛揎翾諠愃晅鍹鶱梋煖萲愋佡昍鋗媗禤蝖蠉矎")
("vm03" "選咺烜")
("vm04" "炫絢漩眩泫渲旋眴楦敻鉉衒蔙駽鞙鏇昡楥袨縼讂贙")
("vm06" "玄旋懸漩璇璿伭妶琁玹嫙誸還縣蜁")
("vm3" "許栩煦咻詡冔姁湑諝醑鄦珝喣")
("vm4" "序續蓄緒敘絮旭恤卹酗婿畜洫旮侐慉漵藚頊芧藇魆勖勗訹鱮烅怴垿窢瞲銊沀昫瞁")
("vm6" "徐")
("vmp " "勳薰燻熏醺峋曛焄獯纁臐蔒勛矄")
("vmp4" "訊訓迅遜殉馴徇巽汛蕈噀侚潠韗迿鵔")
("vmp6" "尋巡詢循旬馴潯珣蟳洵荀徇恂峋栒燖璿紃郇鱘槆撏枔咰璕橁蕁噚")
("vu " "西希吸攜嘻犧稀悉溪析蟋熙禧膝棲釐嬉兮犀晰羲畦曦僖蜥扱熹奚盻觿譆晞欷蹊樨巇淅皙唏烯傒徯恓窸粞豨醯鼷氥浠潝燨瓗疧酅媐巂悕睎硒蠵鑴榽歖爔琋螇俙徆怷娭屖谿莃菥僁橀螝豯貕鵗騱驨郋桸惁凞闟誒礂")
("vu, " "些歇蠍蝎猲褉嗋")
("vu,3" "寫血")
("vu,4" "謝械洩屑瀉懈卸泄蟹解屜褻榭契駭廨渫邂燮楔絏薤紲媟嶰澥瀣獬躞灺疶鞢骱駴偰檞齘伳妎祄榍韰屧焎揳齥躠")
("vu,6" "協鞋斜脅諧邪偕頡挾絜攜擷勰纈襭脥慀劦蝢垥拹籺奊龤愶搚瑎熁燲")
("vu. " "修休羞脩咻庥貅髹饈鵂滫樇臹茠銝蓨鎀潃")
("vu.3" "朽宿糔")
("vu.4" "秀繡鏽袖嗅宿臭銹琇溴岫珛玊殠褎螑")
("vu/ " "興星猩腥馨惺騂煋瑆胜垶蛵觲馫")
("vu/3" "省醒擤渻")
("vu/4" "行興性幸姓杏倖悻荇婞莕涬")
("vu/6" "行形型刑邢陘硎鉶餳侀烆洐胻鋞濴")
("vu0 " "先仙掀鮮纖暹姍孅憸躚銛秈韱枮氙馦嬐仚屳奾杴忺澖灦祆僊嘕蓒褼廯襳珗")
("vu03" "險顯鮮癬蘚銑燹跣嶮蜆姺尟幰獫獮玁筅韅毨烍鍌搟鼸齴赻攇禒")
("vu04" "縣現線限憲獻羨陷腺餡蜆莧霰俔僩峴晛睍豏轞鋧涀瀗粯娊撊錎姭")
("vu06" "賢閒嫌咸鹹弦銜絃嫻嫺涎啣舷閑癇諴蚿憪鷴娹葴胘蛝羬燅礥鷳唌")
("vu3" "喜洗徙璽鰓屣蓰囍枲蟢縰纚蹝釃匚狶諰簁葸漇敼")
("vu4" "細戲係系繫夕汐隙歙鬩翕穸咥屭綌肸鄎醯餼滊褉酅潟舄矽鑴卌怬釸鎎釳赩郤熂覤蕮黖謑虩忥恄摡禊齂")
("vu6" "習昔息席惜媳錫襲熄蓆褶檄覡隰裼嶍螅鰼腊槢焟謵鎴欯棤蒠瘜獥薂霫飁騽蝷")
("vu8 " "瞎蝦岈颬鍜")
("vu84" "下夏嚇廈暇罅芐欱鏬鶷")
("vu86" "暇峽轄霞俠狹挾匣呷遐硤狎瑕斜黠柙祫洽舝碬騢搳烚冾笚縖珨陜磍赮魻蕸")
("vu; " "鄉相香箱湘襄鑲廂驤緗薌瓖纕欀葙忀")
("vu;3" "想響享餉饗鯗饟晑")
("vu;4" "巷向相像項象橡嚮曏蠁萫闀蟓襐鐌鄉恦潒鱌")
("vu;6" "詳祥降翔庠")
("vul " "消銷蕭瀟宵逍囂簫削硝霄哮驍梟蠨枵魈鴞嘵綃嘐歊潚烋獢虓蛸痚憢灱呺穘洨涍痟萷踃膮藃櫹髇毊虈庨啋窙顤謼")
("vul3" "小曉筱篠謏")
("vul4" "校笑孝效酵嘯肖傚恔熽踍")
("vul6" "學洨笅郩")
("vup " "心新辛薪欣鋅馨鑫莘炘歆芯昕訢鈊盺兟廞忻妡噷")
("vup3" "伈")
("vup4" "信釁芯焮舋膷囟妡煡阠")
("vup6" "尋鄩杺攳襑")
("w " "ㄊ")
("w. " "偷媮")
("w.3" "黈妵紏鈄蘣")
("w.4" "透斢")
("w.6" "頭投牏酘")
("w.7" "頭")
("w/6" "疼騰藤籐謄滕螣縢")
("w0 " "貪灘攤癱坍怹抩舑緂探")
("w03" "坦毯袒襢忐禫菼贉嗿膻憳醓裧")
("w04" "探嘆歎碳炭賧埮湠羰")
("w06" "談彈痰潭譚檀壇曇罈覃郯錟餤驔鐔倓醰貚婒憛藫橝黮鷤")
("w8 " "它他她牠塌褟祂禢")
("w83" "塔榙鎝")
("w84" "踏榻蹋塌獺搨遢嚃躂沓嗒撻遝闥鎉闒錔鞜鞳鰨羍涾傝毾誻鑉漯迖濌龘")
("w9 " "胎苔")
("w94" "太態泰汰鈦燤溙呔傣")
("w96" "台臺抬颱苔邰跆檯薹炱駘鮐儓嬯籉旲秮")
("w; " "湯鏜鼞蹚蝪")
("w;3" "倘躺儻淌帑惝钂鎲戃曭爣矘")
("w;4" "趟燙鐋摥")
("w;6" "堂糖唐塘膛螳棠醣搪鏜溏螗瑭赯榶樘漟煻鎕闛橖蓎磄踼薚鶶")
("wj " "禿鵚涋捸嶀")
("wj/ " "通恫蓪痌炵熥狪")
("wj/3" "統筒桶捅垌筩姛")
("wj/4" "痛衕慟蘳")
("wj/6" "同童銅桐潼瞳彤佟僮峒侗艟曈膧穜罿硐橦氃獞茼烔浵鉖餇仝酮迵粡絧朣犝蕫鮦鼨爞哃詷")
("wj0 " "湍煓貒")
("wj04" "彖褖")
("wj06" "團摶糰漙剸慱鏄鷻槫")
("wj3" "土吐釷芏唋")
("wj4" "兔吐菟鵵堍")
("wj6" "圖途突徒塗屠凸荼涂余酴瘏稌腯峹葖鵚捈怢鍎跿梌湥筡蒤瑹駼鶟鷋鼵嵞廜潳鷵")
("wji " "脫拖托託堶侂挩扥矺沰馲侻詑魠")
("wji3" "妥橢撱庹嫷")
("wji4" "拓唾柝籜蘀跅毻毤")
("wji6" "駝陀馱沱佗鴕跎橐坨紽酡砣阤鮀岮碢鞁驒鼉鉈袉飥")
("wjo " "推蓷藬")
("wjo3" "腿俀")
("wjo4" "退蛻駾螁")
("wjo6" "頹穨隤魋橔僓蹪弚")
("wjp " "吞暾啍涒旽")
("wjp3" "汆吨畽")
("wjp4" "褪螁")
("wjp6" "屯囤豚飩臀軘魨忳芚吨拵")
("wk4" "特慝忒忑鋱貣蟘")
("wl " "掏濤滔饕韜弢絛縚搯慆槄幍翢嫍蜪")
("wl3" "討")
("wl4" "套")
("wl6" "逃桃陶萄淘濤啕洮燾檮匋咷綯鞀醄騊錭駣祹鋾")
("wu " "梯踢剔焍")
("wu, " "貼帖怗")
("wu,3" "鐵帖驖僣")
("wu,4" "帖餮蛈")
("wu/ " "聽廳汀桯艼耵")
("wu/3" "挺艇町梃頲珽脡鋌烶圢侹")
("wu/4" "聽")
("wu/6" "停庭廷亭蜓霆婷渟莛朾筳蝏聤葶鼮楟榳閮嵉綎")
("wu0 " "天添倎屇酟婖")
("wu03" "舔忝殄腆靦淟餂賟悿蚕晪痶")
("wu04" "掭煔瑱")
("wu06" "田甜填恬闐畋窴沺盷湉菾磌")
("wu3" "體体綈")
("wu4" "替惕涕屜悌剃銻嚏倜薙殢裼揥籊鬄悐褅逖鵜")
("wu6" "題提啼堤蹄醍禔稊緹荑騠隄鶗惿厗鍗偍趧謕鶙崹睼蝭蕛鷤鯷鵜")
("wul " "挑祧恌庣鮡")
("wul3" "挑窕誂宨嬥")
("wul4" "跳眺糶朓覜頫絩窱脁")
("wul6" "條調笤佻迢蜩髫岧苕齠鰷鞗芀鎥趒祒")
("x " "ㄌ")
("x. " "摟")
("x.3" "簍摟塿嶁")
("x.4" "漏陋露鏤瘺")
("x.6" "樓嘍婁螻髏僂蔞廔漊耬熡謱艛鞻鷜瞜")
("x/3" "冷")
("x/4" "愣踜楞")
("x/6" "稜崚棱薐蔆倰楞")
("x03" "覽懶攬欖纜壈爦灠醂嬾顲浨")
("x04" "爛濫纜鑭爁壏")
("x06" "蘭籃藍欄攔瀾襤婪嵐闌襴讕斕籣欗糷灆灡譋躝")
("x8 " "拉啦喇柆鞡翋菈")
("x83" "喇藞")
("x84" "臘蠟鑞辣剌腊落鬎瘌揧楋")
("x86" "剌邋旯")
("x87" "啦")
("x94" "賴癩瀨籟睞賚藾娕")
("x96" "來萊徠淶騋箂崍郲錸鯠棶庲鶆唻")
("x; " "啷")
("x;3" "朗閬硠峎悢誏烺塱")
("x;4" "浪埌蒗")
("x;6" "郎狼廊螂瑯琅榔稂莨蜋桹筤鋃俍崀欴")
("xj " "嚕")
("xj/3" "隴攏壟")
("xj/4" "衖哢徿梇")
("xj/6" "龍隆籠嚨聾瓏朧窿瀧癃櫳礱曨巃矓蘢躘豅鏧鑨靇蠪襱鸗儱龒蠬")
("xj03" "卵")
("xj04" "亂薍")
("xj06" "巒鑾鸞灤臠圞欒曫羉癵")
("xj3" "魯虜擄滷鹵櫓艣磠鐪鏀蓾擼氌")
("xj4" "路陸錄鹿露賂祿碌氯麓鷺戮轆蓼逯漉輅僇潞籙璐甪稑穋簏醁騄淥琭盝磟彔菉蔍錴垏鏕鯥摝硉睩廘熝踛蕗螰簬鵱淕塶蹗")
("xj6" "盧蘆廬臚爐顱瀘鱸轤壚鸕玈罏艫鑪籚櫨嚧攎蠦纑")
("xji " "囉")
("xji3" "裸瘰臝蠃蓏鎯")
("xji4" "落駱洛絡雒烙酪濼犖咯珞纙袼硌鮥鵅峈")
("xji6" "羅螺蘿鑼邏籮騾囉玀儸覶摞欏蔂鏍鸁剆")
("xjp " "掄")
("xjp3" "稐")
("xjp4" "論溣")
("xjp6" "倫論輪淪崙侖綸掄圇碖錀惀陯菕踚棆蜦")
("xk4" "樂垃勒肋泐埒叻仂捋扐阞砳鰳氻哷竻")
("xk7" "了")
("xl " "撈")
("xl3" "老姥佬栳狫轑咾橑銠恅荖")
("xl4" "勞絡烙酪嫪軂橯僗")
("xl6" "勞牢癆澇嘮醪浶鐒簩蟧嶗")
("xm,4" "略掠鋝撂擽")
("xm03" "孌")
("xm06" "攣孿")
("xm3" "呂旅履侶鋁屢縷褸婁膂漊穭梠郘挔絽儢祣")
("xm4" "律綠率慮濾氯嵂膟鑢菉葎勴")
("xm6" "驢閭櫚藘慺氀膢")
("xo " "勒")
("xo3" "累壘儡漯耒磊蕾誄藟樏癗礌絫磥鑸瘣櫑櫐礨灅讄鸓頛礧蘲虆")
("xo4" "類淚累擂纇酹銇儽蘱禷")
("xo6" "雷累纍擂嫘鐳羸縲罍檑畾櫑瓃蠝轠壨欙")
("xu " "哩")
("xu, " "咧")
("xu,3" "咧")
("xu,4" "列烈劣裂獵捩冽鬣躐洌茢睙擸趔姴迾脟蛚蛶颲儠鮤鴷犣")
("xu. " "溜蹓")
("xu.3" "柳綹罶鉚飹珋")
("xu.4" "六陸溜餾霤坴翏雡廇塯蹓")
("xu.6" "劉流留硫琉榴瀏瘤遛旒騮鏐飀鶹懰鎏泵鎦媹嬼嵧藰裗麍鷎蓅鰡巰")
("xu/ " "拎")
("xu/3" "領嶺彾")
("xu/4" "令另炩")
("xu/6" "零玲靈鈴齡陵凌菱聆羚苓伶綾淩翎鴒囹蛉瓴泠舲酃軨錂櫺柃欞睖砱詅輘霝鯪醽岭昤澪呬坽夌姈狑皊呤琌笭裬蘦怜婈駖蕶爧堎")
("xu03" "臉鄻膦摙僆羷")
("xu04" "練鍊戀煉鏈殮斂瀲楝襝湅澰蘞歛薟萰堜")
("xu06" "連聯憐廉蓮漣簾鐮鰱奩璉帘褳嗹鎌鬑溓蠊槤縺謰覝磏濂翴薕蹥譧奱嬚")
("xu3" "李里裡理禮裏哩浬鯉娌俚澧邐醴蠡鱧鋰粴豊峛欚")
("xu4" "力立利麗歷壢例曆莉厲勵礪粒蒞靂瀝儷隸礫吏荔栗慄俐痢癘笠戾唳酈琍詈嚦溧蠣櫪沴糲櫟轢瓅鬁猁盭篥苙唎屴躒釙鬲皪秝瑮轣岦朸欐禲赲鴗砅濿砬悷蚸厤筣綟蜧磿斄犡藶蠫鷅麜攦觻鷑攭鱳靋栵浰塛搮蝷儮曞讈瓥鱱娳")
("xu6" "離璃黎梨籬釐犛罹貍驪犁漓灕狸藜蜊蠡鸝嫠褵黧梩漦縭蔾氂厘蘺剺喱篱醨鱺劙孋廲騹孷樆謧鯬鵹攡麗菞鑗黐粍麶")
("xu83" "倆")
("xu;3" "兩倆魎緉裲")
("xu;4" "量亮諒輛喨晾涼啢踉湸悢")
("xu;6" "良梁量糧涼粱樑椋綡輬踉駺")
("xul " "撩")
("xul3" "了瞭蓼憭釕暸鄝蟟")
("xul4" "廖料瞭燎尥撂炓蟉窲")
("xul6" "聊寮遼療寥撩僚燎潦嘹繚鐐嫽獠鷯屪鷚膋漻摎豂嵺憀嶚敹窷膫簝镽飂飉顟")
("xup3" "凜懍廩檁菻亃綝榃")
("xup4" "吝躪藺賃橉閵焛")
("xup6" "林臨鄰淋鱗麟霖磷琳遴嶙燐璘粼轔潾痳疄瞵惏暽罧驎碄箖甐繗僯翷蹸壣鏻")
("y " "資茲滋吱姿咨孜諮貲玆ㄗ輜淄齜緇孳粢髭嵫菑鎡鶿鼒孖澬甾鄑鯔錙趑椔鈭鶅齍栥紎崰秶蠀")
("y. " "鄒謅鄹諏啁掫菆陬騶鯫棸緅棷郰媰黀齱齺")
("y.3" "走")
("y.4" "奏驟揍")
("y/ " "曾增憎罾繒矰橧磳驓璔")
("y/4" "贈甑")
("y0 " "簪鐕")
("y03" "拶攢寁昝禶喒儹揝礸")
("y04" "贊暫讚鏨瓚欑酇饡灒囋趲")
("y06" "咱偺糌")
("y3" "子仔紫梓籽滓耔訾笫秭胏茈吇杍芓呰矷釨訿")
("y4" "自字恣漬眥孳剚胔胾扻倳牸")
("y7" "子")
("y8 " "紮匝咂唼嘁抸鉔")
("y86" "雜咱砸偺雥磼")
("y9 " "災栽哉渽賳")
("y93" "仔宰崽載縡")
("y94" "在再載")
("y; " "髒贓臢牂臧")
("y;3" "駔")
("y;4" "藏臟葬奘")
("yj " "租蒩")
("yj/ " "宗蹤縱綜棕鬃豵騣鬷翪熧倧惾猣稯艐嵕蝬")
("yj/3" "總摠傯熜朡蓗")
("yj/4" "縱粽綜從瘲昮")
("yj0 " "鑽躦")
("yj03" "纂鑽纘籫儹")
("yj04" "賺鑽攥饡")
("yj3" "組祖阻俎詛珇靻")
("yj6" "足族卒嗾捽崒踿哫傶踤")
("yji3" "左佐繓")
("yji4" "做作坐座酢祚鑿柞怍胙阼葄夎")
("yji6" "昨作砟椊筰稓葃")
("yjo " "堆厜羧嶉纗")
("yjo3" "嘴璻觜嶊噿濢")
("yjo4" "最罪醉檇蕞晬檌絊祽鋷墬嶵")
("yjp " "尊遵樽墫鐏嶟繜鷷壿")
("yjp3" "撙噂墫僔譐")
("yjp4" "俊圳捘鱒銌燇")
("yk3" "怎")
("yk4" "仄側昃庂稄")
("yk6" "則責擇澤嘖窄舴咋幘笮賾迮崱萴謮蠌賊蠈")
("yl " "遭糟蹧傮")
("yl3" "早棗澡藻蚤璪繰")
("yl4" "造皂燥噪慥譟灶躁皁趮矂")
("yl6" "鑿")
("yo6" "賊")
("yp3" "怎")
("yp4" "譖")
("z " "ㄈ")
("z.3" "否缶殕缹鴀")
("z.6" "罘芣紑剻")
("z/ " "風蜂封豐瘋峰鋒丰烽楓諷酆葑灃犎捀桻妦檒偑崶蘴飌麷猦")
("z/3" "唪覂")
("z/4" "奉鳳俸諷縫賵焨")
("z/6" "逢縫馮夆渢堸艂摓")
("z0 " "番翻蕃繙幡帆旛籓僠嬏轓鱕")
("z03" "反返魬")
("z04" "範范犯氾汎飯販泛梵畈笵鄤奿軓軬滼嬔")
("z06" "凡煩繁帆蕃礬藩樊蘩璠籵墦燔膰蠜蹯颿笲釩瀿鐇勫橎薠羳鷭杋柉瀪")
("z8 " "發伐瞂")
("z83" "法髮")
("z84" "法琺")
("z86" "乏伐罰閥筏砝茷法疺藅")
("z; " "方芳坊枋邡淓鈁匚汸")
("z;3" "訪彷仿紡倣舫昉瓬髣鶭")
("z;4" "放")
("z;6" "房防妨肪坊魴")
("zi6" "佛坲")
("zj " "夫膚敷孵伕麩跗趺柎砆鄜鈇箙罦衭稃邞泭怤尃荴綒鳺姇糐璷紨")
("zj/4" "甮")
("zj3" "府腐撫輔甫斧俯釜脯腑莆滏嘸拊黼簠頫郙弣鯆暊冹蜅蚥軵父")
("zj4" "父負婦付附富復副傅覆複腹咐赴賦駙阜訃馥賻蝮鮒祔偩輹鰒鍑榑复胕蚹萯蝜褔姇峊蛗緮蕧")
("zj6" "服福扶浮符伏彿縛幅俘拂苻弗孚袱芙輻蝠匐蜉罘涪夫郛莩怫蚨桴紼茯菔紱咈洑綍艴芾茀艀刜帗笰葍袚氟棴澓烰枹玸岪枎垘昲柫琈虙踾鳧巿沷祓翇韍諨鴔黻鵩鶝")
("zo " "非飛菲扉啡妃緋霏馡騑鯡騛婓裶")
("zo3" "匪翡斐蜚誹悱菲朏棐榧篚奜餥")
("zo4" "廢費肺沸吠痱怫疿芾屝剕狒砩濷癈昲胇俷厞曊鼣櫠蟦鐨")
("zo6" "肥淝腓萉蜰")
("zp " "分紛芬氛吩棻玢酚雰昐鈖砏翂衯饙梤鳻")
("zp3" "粉黺")
("zp4" "份忿奮憤分糞僨瀵坋秎魵橨膹羵")
("zp6" "墳焚汾枌棼蚡豶鼖幩濆轒鼢妢炃羒蒶黂弅蕡鐼")
("zul4" "覅")
)
;; Local Variables:
;; version-control: never
;; no-update-autoloads: t
;; End:
