Учебник Emacs. Условия распространения приведены в конце файла.

Для управления Emacs обычно используются сочетания клавиш (key -- сочетание
клавиш клавиатуры и/или кнопок мыши), включающие в себя клавишу CONTROL
(иногда отмечаемая как CTRL или CTL) или клавишу META (иногда помеченную как
ALT или EDIT). Вместо того, чтобы каждый раз писать META или CONTROL, мы
будем использовать следующие сокращения:

 C-<chr> -- следует удерживать клавишу CONTROL, пока набирается символ
	 <chr>. Так, C-f должно означать: одновременно нажать клавиши CONTROL и f.
 M-<chr> -- следует удерживать клавишу META, пока набирается символ
         <chr>. Если нет клавиши META, ALT или EDIT, то нажмите <ESC>,
         отпустите ее, а потом наберите символ <chr>.

Важное замечание: для завершения работы Emacs, наберите C-x C-c (два сочетания
клавиш).  Чтобы прервать частично набранную команду, нажмите C-g.
Символы ">>" с левой стороны указывают, что вам нужно делать, чтобы
попробовать применить команду. Например:
<<Blank lines inserted here by startup of help-with-tutorial>>
[Середина страницы оставлена пустой в учебных целях. Текст продолжается ниже]
>> Теперь нажмите C-v (просмотр следующего экрана) для перемещения к следующему
   экрану. (Выполните эту команду удерживая клавишу CONTROL и нажимая v.) Теперь
   вы должны это сделать еще раз, когда вы закончите читать текст на экране.

Обратите внимание на то, что при переходе с экрана на экран показываются две
строки с предыдущего экрана -- это обеспечивает некоторую непрерывность
восприятия, так что вы можете продолжать читать текст не теряя нити
повествования.

Первое, что вам необходимо знать -- это то, как передвигаться по тексту из
одного места в другое. Вы уже знаете, как переместиться вперед на один экран
используя сочетание клавиш C-v. Для перемещения назад на один экран, нажмите
M-v (удерживайте клавишу META и наберите v, или нажмите <ESC> и затем v,
если у вас нет клавиши META, EDIT или ALT).

>> попробуйте набрать M-v, а затем C-v, несколько раз.


* КРАТКИЙ ПЕРЕЧЕНЬ КОМАНД
-------------------------

Следующие сочетания клавиш полезны при по-экранном просмотре текста:

	C-v	Перейти на один экран вперед
	M-v	Перейти на один экран назад
	C-l     Очистить экран и отобразить все заново,
		разместив текст, находящийся возле курсора,
		в центре экрана. (это CONTROL-L, а не CONTROL-1.)

>> Найдите курсор и запомните текст возле него. Потом нажмите C-l.
   Найдите курсор снова и убедитесь, что возле него все тот же текст.

Вы также можете использовать клавиши PageUp и PageDn для перемещения между
экранами (если они есть на вашем терминале), но вы сможете работать более
эффективно, если будете использовать сочетания C-v и M-v.


* БАЗОВЫЕ КОМАНДЫ УПРАВЛЕНИЯ КУРСОРОМ
-------------------------------------

Движение от экрана к экрану удобно, но как переместиться в определенную
точку в тексте на экране?

Есть несколько способов сделать это. Вы можете использовать клавиши
управления курсором (стрелки), но более эффективным будет сохранение рук в
их стандартной позиции и использовать команды C-p, C-b, C-f и C-n. Эти
команды эквивалентны четырем клавишам перемещения курсора, как это показано
на схеме:

			  Предыдущая строка, C-p
				  :
				  :
         Назад, C-b .... Текущая позиция курсора .... Вперед, C-f
				  :
				  :
			   Следующая строка, C-n

>> Переместите курсор на строку с центром диаграммы, используя сочетания
   клавиш C-n или C-p. Затем нажмите C-l и посмотрите как диаграмма
   переместится в центр экрана.

Вам будет несложно запомнить эти команды по первым буквам соответствующих
слов: P -- предыдущий (previous), N -- следующий (next), B -- назад
(backward) и F -- вперед (forward). Вы постоянно будете использовать эти
основные команды позиционирования курсора.

>> Нажмите несколько раз C-n, чтобы опустить курсор вниз к этой строке.

>> Переместитесь по строке, используя C-f, и потом поднимитесь вверх с
   помощью C-p. Посмотрите, как изменилось положение курсора при нажатии
   С-р, если он находился в середине строки.

Каждая строка текста завершается символом перевода строки (Newline
character), который отделяет ее от следующей строки. (Обычно, последняя
строка файла завершается символом перевода строки, но Emacs не требует
этого).

>> Попробуйте использовать C-b в начале строки. Курсор должен переместиться
   на конец предыдущей строки. Это происходит потому, что он движется назад
   через символ перевода строки.

C-f может перемещать курсор через символ перевода строки так же, как и C-b.

>> Попробуйте несколько раз применить C-b так, чтобы вы увидели, как
   движется курсор. Далее используйте сочетание клавиш C-f чтобы вернуться
   на конец строки. Нажмите C-f еще раз, чтобы перейти к началу следующей
   строки.

Когда вы перемещаетесь за верхний или нижний край экрана, текст, находящийся
за экраном, сдвигается внутрь экрана. Это называется "прокрутка"
(scrolling). Прокрутка позволяет Emacs перемещать курсор в нужное место
текста без перемещения его за пределы экрана.

>> Попробуйте переместить курсор за нижнюю границу экрана, используя C-n, и
   посмотрите, что произойдет.

Если посимвольное перемещение слишком медленно, вы можете двигаться по
словам. M-f (META-f) перемещает вперед на слово, а M-b назад на слово.

>> Нажмите несколько раз M-f и M-b.

Если курсор находится в середине слова, M-f переместит его в конец слова.
Если курсор находится между словами, M-f переместит его в конец следующего
слова. M-b работает точно так же, но в противоположном направлении.

>> Нажмите M-f и M-b несколько раз, перемежая их с C-f и C-b, -- так вы
   сможете увидеть как действуют M-f и M-b из разных позиций в словах и
   между ними.

Отметьте параллель между C-f и C-b с одной стороны, и M-f и M-b с другой.
Очень часто Meta-сочетания используются для соответствующих операций над
единицами, определенными в языке (слова, предложения, абзацы), тогда как
Control-сочетания работают с базовыми единицами, независимо от того, что вы
редактируете (символы, строки, и т.д.).

Эта параллель также применима к строкам и предложениям: C-a и C-e перемещает
курсор в начало и конец строки, а M-a и M-e перемещает курсор в начало и
конец предложения.

>> Попробуйте пару раз нажать C-a, а потом пару раз C-e. Попробуйте пару раз
   нажать M-a, после этого пару раз нажать M-e.

Посмотрите, что повтор C-a ничего не изменяет, а повтор M-a продолжает
движение курсора к следующему предложению. Это не совсем аналогично, но
выглядит естественно.

Положение курсора в тексте также называют "точкой вставки" (point). Скажем
иначе: курсор показывает место на экране в котором будет расположен вводимый
текст.

Вот список всех основных команд перемещения курсора, включая движение по
словам и предложениям:

	C-f	На символ вперед
	C-b	На символ назад

	M-f	На слово вперед
	M-b	На слово назад

	C-n	На следующую строку
	C-p	На предыдущую строку

	C-a	В начало строки
	C-e	В конец строки

	M-a	Назад, в начало предложения
	M-e	Вперед, в конец предложения

>> Попробуйте сейчас несколько раз использовать все эти команды.
   Это наиболее часто используемые команды.

Две другие важные команды перемещения курсора: M-< (META Less-then
{Меньше-Чем}), которая перемещает курсор в начало текста, и M-> (META
Greater-than {Больше-Чем}), которая перемещает курсор в конец текста.

На большинстве терминалов знак "<" находится над знаком точки, и чтобы
набрать его, вы должны использовать клавишу Shift. На этих терминалах вы так
же должны использовать Shift, чтобы набрать M-< (без удержания клавиши Shift
вы наберете M-точка).

>> Сейчас попробуйте M-<, чтобы переместиться в начало учебника.
   Потом используйте C-v, пока не вернетесь назад.

>> Сейчас попробуйте M->, чтобы переместиться к концу учебника.
   Используйте M-v, пока не вернетесь назад.

Курсор можно перемещать клавишами управления курсора (стрелками), если ваш
терминал оборудован ими. Мы рекомендуем выучить C-b, C-f, C-n и C-p по трем
причинам. Во-первых, они работают на любых терминалах. Во-вторых, однажды
получив практику использования Emacs, вы поймете, что использовать
Control-сочетания удобнее и быстрее, чем клавиши со стрелочками (потому что
вы не убираете руки с обычного их положения при печати). В-третьих, как
только вы привыкнете использовать Control-сочетания, вы сможете так же легко
выучить и использовать другие, более сложные команды перемещения курсора.

Большинство команд Emacs допускают задание цифрового аргумента; для
большинства команд, это служит счетчиком повторений. Чтобы задать счетчик
повторений для команды, нажмите C-u, потом число повторений, и затем укажите
команду. Если у вас есть клавиша META (или EDIT или ALT), то цифровой
аргумент можно задать другим способом: наберите цифры, удерживая клавишу
META. Мы рекомендуем привыкнуть к использованию C-u, поскольку это сочетание
клавиш работает на любом терминале. Числовой аргумент также называется
"префиксным аргументом", поскольку вы задаете аргумент до выполнения
команды.

Например, C-u 8 C-f переместит курсор на восемь символов вперед.

>> Попробуйте использовать C-n или C-p с цифровым аргументом, чтобы
   переместить курсор на эту строку с помощью одной команды.

Многие команды используют числовой аргумент как счетчик повторений, но
некоторые команды используют его другим способом. Некоторые команды (но мы
еще не изучили ни одну из них) используют его как флаг -- наличие
префиксного аргумента вне зависимости от его значения, изменяет поведение
команды.

Другим видом исключений являются сочетания клавиш C-v и M-v. При получении
числового аргумента, они прокручивают экран вверх или вниз на указанное
число строк, вместо указанного числа экранов. Например, C-u 8 C-v прокрутит
экран на 8 строк.

>> Сейчас попробуйте набрать комбинацию C-u 8 C-v.

Эта команда должна прокрутить экран на 8 строк вверх. Если вы хотите
прокрутить его вниз, можете задать аргумент для M-v.

Если вы используете оконную систему, такую как X11 или MS-Windows, то должна
быть видна прямоугольная область, именуемая полосой прокрутки, расположенная
с одной из сторон окна Emacs. Вы можете прокручивать текст, щелкая кнопкой
мыши на полосе прокрутки.

Если ваша мышь имеет колесо прокрутки, вы можете использовать его.

* ЕСЛИ EMACS ЗАВИС
------------------

Если Emacs перестал реагировать на ваши команды, то вы можете вывести его из
этого состояния нажав C-g. Вы можете использовать C-g, чтобы остановить
выполнение команд, которые слишком долго выполняются.

Вы также можете использовать C-g для отмены набранного цифрового аргумента
или команды, которая начала выполняться, но которую вы не хотите завершить.

>> Наберите C-u 100 для задания аргумента 100, потом нажмите C-g. Теперь
   нажмите C-f. Курсор должен переместиться всего на один символ, потому что
   вы отменили аргумент нажатием C-g.

Если вы нажали <ESC> по ошибке, то вы так же можете использовать C-g чтобы
избежать воздействия данной команды.


* ЗАПРЕЩЕННЫЕ КОМАНДЫ (DISABLED COMMANDS)
-----------------------------------------

Некоторые команды Emacs "запрещены", так что начинающие пользователи не
смогут случайно использовать их.

Если вы набрали одну из запрещенных команд, то Emacs покажет сообщение,
говорящее о том, какая команда вызывается, и запросит у вас, хотите ли вы
продолжать работу и выполнить данную команду.

Если вы действительно хотите выполнить эту команду, то нажмите клавишу
<SPC> (пробел) в ответ на заданный вопрос. А если вы не хотите выполнить
запрещенную команду, то ответьте на вопрос нажатием клавиши "n".

>> Нажмите "C-x C-l" ("запрещенная" команда), а потом ответьте "n" на
   заданный вопрос.


* ОКНА (WINDOWS)
------

Emacs может отображать информацию в нескольких "окнах", каждое из которых
отображает свой текст. Позже мы объясним как работать с несколькими окнами.
А сейчас мы хотим объяснить вам как избавляться от лишних окон и вернуться к
редактированию в одном окне. Это очень просто сделать:

	C-x 1	Одно окно. (закрыть все другие окна).

Это CONTROL-x со следующей цифрой 1. C-x 1 развернет окно, которое содержит
курсор, так, чтобы оно заняло весь экран. При этом будут удалены все
остальные окна.

>> Переместите курсор на эту строку и нажмите C-u 0 C-l.

>> Наберите C-h k C-f.
   Заметьте как текущее окно уменьшится, когда появится новое окно и
   отобразит документацию для сочетания клавиш C-f.

>> Наберите C-x 1 и посмотрите, как окно с документацией исчезнет.

Эта команда отличается от других изученных команд, что она состоит из двух
сочетаний клавиш. Она начинается с сочетания CONTROL-x. Есть целый набор
команд, которые начинаются с CONTROL-x -- многие из них работают с окнами,
буферами, файлами и т.п. вещами. Эти команды состоят из двух, трех или
четырех сочетаний клавиш.


* ВСТАВКА И УДАЛЕНИЕ
--------------------

Если вы хотите вставить текст, то просто набирайте его. Обычные символы,
такие как A, 7, *, и пр.  вставляются сразу как вы нажимаете на них. Чтобы
вставить символ новой строки нажмите <Return> (клавиша перевода каретки,
часто помечена как "Enter").

Чтобы удалить символ перед курсором, нажмите клавишу <DEL>.  Обычно это
клавиша помеченная как "Backspace" -- та самая клавиша, которую вы обычно
используете вне Emacs для удаления последнего набранного символа.

На клавиатуре может присутствовать и другая клавиша, помеченная как
"Delete", но она имеет другую функцию, отличную от <DEL>.

>> Попробуйте сделать это -- наберите несколько символов, а затем удалите их
   нажимая <DEL>. Не волнуйтесь что этот файл изменяется -- вы не изменяете
   учебник.  Это ваша личная копия учебника.

Когда строка текста становится слишком большой для строки экрана, то она
"продолжается" на следующей строке.  Если вы используете графический
дисплей, то небольшие изогнутые стрелки появятся на обоих сторонах экрана
("fringes") чтобы показать, что строка продолжается с предыдущей
строки. Если вы используете текстовый терминал, то "продолжаемая" строка
обозначается символом "обратный слэш" («\») в правой части экрана.

>> Вводите текст, пока он не достигнет правой границы, и продолжайте вставку
   символов. Вы увидите что появится "продолжаемая" строка.

>> Используйте <DEL> для удаления текста до тех пор, пока строка снова не
   поместится в экран. Символ продолжения строки исчезнет с экрана.

Символ новой строки можно удалять точно так же, как и любой другой символ.
Удаление символа новой строки между двумя строками приведет к их склейке в
одну. Если полученная строка будет слишком длинной, чтобы вместиться в
экран, то она будет отображена как строка "с продолжением".

>> Переместите курсор в начало строки и нажмите <DEL>. Это соединит
   текущую строку с предыдущей.

>> Нажмите <Return> для вставки символа новой строки, вместо удаленного
   вами.

Помните, что многие команды Emacs могут получать счетчик повторения --
обычные символы не являются исключением. Вы можете вставлять по несколько
символов, используя счетчики повторений.

>> Попробуйте -- наберите C-u 8 * для вставки ********.

Вы уже научились основам набора текста в Emacs и исправления ошибок. Вы
также можете удалять слова и строки. Вот основные операции удаления:

	<DEL>     удалить символ перед курсором
	C-d   	  удалить символ следующий за (над) курсором

	M-<DEL>   "убить" слово, стоящее перед курсором
	M-d	  "убить" слово, стоящее за курсором

	C-k	  "убить" все от курсора до конца строки
	M-k	  "убить" все до конца предложения

Заметьте, что <DEL> и C-d, вместе с M-<DEL> и M-d продолжает параллель,
начатую C-f и M-f (да, <DEL> -- это не настоящий управляющий символ, но не
нужно об этом волноваться). C-k и M-k, также как и C-e и M-e, продолжают
параллель между строками и предложениями.

Вы можете "убить" любую часть текста следующим методом. Переместитесь к
одному из концов выбранной области и нажмите C-<SPC> (<SPC> -- клавиша
пробела). Переместите курсор к другому концу текста, который вы собираетесь
"убить".  По мере того, как вы будете это делать, Emacs будет подсвечивать
текст между курсором и точкой, где вы нажали C-<SPC>. Затем нажмите C-w. Эта
операция убьет весь текст между двумя указанными позициями.

>> Переместите курсор к букве В в начале предыдущего параграфа.
>> Наберите C-<SPC>. Emacs должен отобразить в нижней части экрана сообщение
   "Mark set" (метка установлена).
>> Переместите курсор к букве о в слове "концов", на второй строке параграфа.
>> Нажмите C-w. Это удалит текст начиная с буквы В, и оканчивающийся перед
   буквой о.

Отличие между "убить" (killing) и "удалить" (deleting) заключается в том,
что "убитый" текст может быть заново вставлен (в любой точке), в то время
как "удаленные" части не могут быть вставлены (вы однако можете отменить
удаление -- см. ниже). Вставка "убитого" текста называется "восстановление"
(yanking). В общем, команды, которые могут удалять большие части текста,
убивают этот текст (они настраиваются так, что вы можете восстановить
текст), в то время как команды, которые убирают только один символ, или
убирают только пустые строки и пробельные символы, выполняют операцию
удаления (так что вы не можете восстановить текст).  В простейшем случае,
без дополнительного аргумента, команды <DEL> и C-d выполняют удаление.
Однако, если им передан аргумент, то они "убивают" текст.

>> Переместите курсор на начало не пустой строки. Теперь нажмите C-k, чтобы
   убить текст в этой строке.

>> Нажмите C-k еще раз. Вы видите, что это действие убьет символ новой
   строки, который следует за этой строкой.

Заметьте, что первое выполнение C-k убивает содержимое строки, а второй
вызов C-k убивает саму строку и поднимает вверх другие строки. C-k
обрабатывает числовой аргумент специальным образом -- убивает заданное
количество строк _И_ их содержимое. Это не просто повторение команды. C-u 2
C-k удалит две строки, а также завершающие их символы новой строки;
выполнение C-k два раза подряд этого не сделает.

Возврат убитого ранее текста называется "восстановление" (yanking). (Думайте
об этом, как о восстановлении или помещении назад некоторого взятого
текста). Вы можете восстановить убитый текст в месте удаления или в любой
другой точке редактируемого текста или даже в другом файле. Вы можете
восстановить текст несколько раз и получить несколько копий данного текста.
Некоторые редакторы называют операции "убить" и "восстановить" иначе:
"вырезать" (cutting) и "вставить" (pasting) (ознакомьтесь с глоссарием
(Glossary) в руководстве по Emacs).

Для восстановления убитого текста используется сочетание клавиш C-y. Данная
команда восстанавливает последний убитый текст в точке расположения курсора.

>> Попробуйте -- наберите C-y, чтобы вставить текст назад.

Помните, что если вы использовали несколько команд C-k подряд, то все убитые
строки будут сохранены вместе, так что C-y также восстановит их вместе.

>> Попробуйте -- нажмите C-k несколько раз.

Теперь вернем убитый текст:

>> Нажмите C-y. Теперь переместите курсор на несколько строк вниз, и снова
   нажмите C-y. Вы увидите копию некоторого текста.

Что делать, если есть некоторый текст, который вы хотите вернуть назад, а
потом убить что-то еще? Одно нажатие C-y вернет только последний удаленный
текст. Но предыдущий текст не потерян -- вы можете его вернуть назад,
используя команду M-y. После того как вы вернули последний удаленный текст с
помощью C-y, нажмите M-y для замены этого восстановленного текста тем,
который был убит ранее. Выполняя M-y снова и снова, вы будете возвращать
ранее убитые части текста. Когда вы достигнете нужного текста, то вам не
нужно ничего делать, чтобы сохранить его. Просто продолжайте работать,
оставив восстановленный текст там, где он есть.

Нажимая M-y достаточное число раз, вы можете вернуться в начальную точку
(наиболее раннее удаление).

>> Убейте строку, переместите курсор и убейте еще одну строку. Затем
   используйте C-y для восстановления второй убитой строки. Затем нажмите
   M-y, и она будет заменена первой убитой строкой. Нажмите M-y еще
   несколько раз, чтобы увидеть что вы получаете. Продолжайте выполнять эту
   команду до тех пор, пока вторая убитая строка не будет восстановлена
   снова. Если вам хочется, то вы можете задавать положительные и
   отрицательные аргументы для команды M-y.


* ОТМЕНА (UNDO)
---------------

Если вы сделали изменения в тексте, и решили, что это была ошибка, то вы
можете отменить изменения с помощью команды "отмена" (undo), которая
привязана к сочетанию клавиш С-/.

Обычно, C-/ отменяет изменения, сделанные одной командой; если повторить
C-/ несколько раз подряд, то каждый раз будет отменяться еще одна команда.

Но есть два исключения: не учитываются команды не изменяющие текст (сюда
включаются команды перемещения курсора и прокрутки текста), а команды
вставки символов собираются в группы до 20 символов. (Это уменьшает число
нажатий C-/, которые вам нужно будет набрать для отмены ввода текста).

>> Убейте эту строку с помощью C-k, а затем наберите C-/, и строка должна
   вернуться назад.

C-_ -- это еще команда отмены; она работает точно так же, как и C-/. На
некоторых текстовых терминалах, набор C-/ в действительности приводит к
отправке C-_.  Кроме того, вы можете использовать C-x u для выполнения этой
же операции, но эту команду менее удобно набирать

Числовой аргумент для C-/, C-_ или C-x u используется как счетчик повторений.

Вы можете отменить удаление текста точно так же, как и отмену "убития"
текста.  Отличие между убийством и удалением чего-либо заключается в том,
что вы можете восстановить убитый текст с помощью команды C-y; но для
команды отмены нет никакой разницы между этими операциями.

* ФАЙЛЫ
-------

Для того, чтобы сохранить отредактированный текст вы должны поместить его в
файл. Иначе он исчезнет, когда вы закончите работу Emacs. Чтобы поместить
ваш текст в файл, вы должны "найти (открыть)" (find) файл до ввода
текста. (Эту операцию также называют "посетить" (visiting) файл).

Открыть файл означает что вы видите его содержимое в Emacs.  Это практически
также как редактирование самого файла. Однако, ваши изменения, сделанные с
помощью Emacs, не будут сохранены, пока вы не сохраните файл.  Так что вы
можете не оставлять частично измененный файл в системе, если вы не хотите
его сохранять. Даже когда вы сохраняете файл, то Emacs оставляет
оригинальный файл, но с другим именем, на случай, если вы решите что ваши
изменения были ошибкой.

Если вы посмотрите в нижнюю часть экрана, то вы увидите строку, которая
начинается с тире, и начало которой выглядит примерно так " -:---  TUTORIAL.ru".
Эта часть экрана всегда показывает имя открытого вами файла. Итак, сейчас у
вас открыт файл с именем "TUTORIAL.ru", который является вашей персональной
копией учебника Emacs. Когда вы открываете файл в Emacs, имя этого файла
появится в этой строке.

Одной из вещей, которые вам нужно знать о команде открытия файла -- это то,
что вы должны ввести имя файла, который нужно открыть. Такие команды мы
называем командами, "читающими аргумент" (в нашем случае аргументом является
имя файла). После ввода команды

	C-x C-f   Открыть (найти) файл

Emacs попросит вас ввести имя файла. Имя файла набирается в нижней строке
экрана. Нижняя строка называется мини-буфером когда она используется для
ввода данных. Вы можете использовать обычные команды редактирования Emacs
для ввода имени файла.

Когда вы вводите имя файла (или любую другую информацию в мини-буфере), вы
можете отменить текущую команду нажав C-g.

>> Нажмите C-x C-f, а затем нажмите C-g. Это действие отменит ввод данных в
   мини-буфере, и заодно и команду C-x C-f, которая использовала мини-буфер
   для ввода аргумента. В итоге, вы не открыли никакого файла.

Когда вы завершите ввод имени файла, нажмите <Return>. Мини-буфер исчезнет и
команда C-x C-f выполнит работу по открытию указанного вами файла.

А мгновением позже содержимое файла появится на экране, и вы сможете его
редактировать. Когда вы захотите сохранить изменения, наберите команду

	C-x C-s   Сохранить файл

Эта команда скопирует текст из Emacs в файл. В первый раз, когда вы это
сделаете, Emacs переименует оригинальный файл в файл с новым именем, так что
он не будет потерян. Имя файла с предыдущим содержимым получается
добавлением символа "~" к оригинальному имени файла.

Когда сохранение завершится, Emacs отобразит имя сохраненного файла. Вы
должны сохранять изменения достаточно часто, чтобы не потерять внесенные
изменения, если система вдруг "рухнет" (см. раздел "Автоматическое
сохранение" ниже).

>> Наберите C-x C-s TUTORIAL.ru <Return>.
   Эта команда должна сохранить вашу копию учебника в файле TUTORIAL.ru. В
   нижней строке экрана должна появиться надпись "Wrote ...TUTORIAL.ru".

Вы можете открыть существующий файл для просмотра или редактирования. Вы
также можете открыть файл, который еще не существует. Таким образом вы
можете создать файл с помощью Emacs: откройте несуществующий файл (Emacs
покажет его пустым) и вводите в него текст. Когда вы выполните команду
сохранения файла в первый раз, Emacs создаст настоящий файл с набранным
вами текстом. Далее, как вы поняли, вы будете редактировать уже существующий
файл.


* БУФЕРА (BUFFERS)
-----------------

Если вы откроете еще один файл с помощью C-x C-f, то предыдущий файл
остается внутри Emacs. Вы можете переключиться назад к предыдущему файлу,
открыв его снова с помощью C-x C-f. Таким образом вы можете загрузить
большое количество файлов в Emacs.

Emacs хранит текст каждого файла в объекте, называемом "буфер" (buffer).
Открытие файла создает новый буфер внутри Emacs. Чтобы увидеть список
буферов, созданных в текущем сеансе Emacs, наберите

	C-x C-b   Отобразить список буферов

>> Попробуйте выполнить C-x C-b.

Мы видим, что каждый буфер имеет имя и может иметь связанное с ним имя
файла, содержимое которого хранится в данном буфере. ЛЮБОЙ текст, который вы
видите в окне Emacs, всегда является частью какого-либо буфера.

>> Наберите C-x 1, чтобы избавиться от списка буферов.

Когда у вас есть несколько буферов, только один из них является "текущим" в
конкретный момент времени. Это тот буфер, который вы редактируете. Если вы
хотите редактировать другой буфер, то вы должны "переключиться" в него.
Если вы хотите переключиться в буфер, связанный с файлом, то вы можете
открыть этот файл снова с помощью C-x C-f. Но есть более простой способ --
использовать команду C-x b. В качестве аргумента для данной команды вы
должны указать имя буфера.

>> Наберите C-x b foo <Return> для переключения в буфер "foo". Затем
   наберите C-x b TUTORIAL.ru <Return> для возвращения в буфер с учебником.

Чаще всего имя буфера совпадает с именем файла (только без имени каталога).
Но иногда это не так. Список буферов, который вы создаете с помощью команды
C-x C-b, показывает вам имя буфера и имя файла для каждого буфера.

Некоторые буфера не относятся к файлам. Например, буфер с именем "*Buffer
List*", который создан с помощью C-x C-b и содержит список всех буферов, не
связан ни с каким файлом. Буфер с данным учебником также сначала не был
связан с файлом, но сейчас уже связан, поскольку в предыдущем разделе мы
использовали C-x C-s для сохранения его в файле.

Буфер с именем "*Messages*" также не связан ни с каким файлом; он содержит
сообщения, которые отображаются в самой нижней строке окна Emacs в течение
текущего сеанса работы с Emacs.

>> Наберите C-x b *Messages* <Return> для просмотра содержимого буфера
   сообщений. Затем наберите C-x b TUTORIAL.ru <Return> для возврата к
   учебнику.

Если вы изменили текст одного файла, а затем открываете другой, то текст в
первом буфере остается не сохраненным. Изменения останутся внутри Emacs, в
буфере, связанном с файлом. Создание или редактирование следующего буфера не
влияет на первый буфер. Это очень удобно, но имейте в виду, что вам нужно
иметь удобный способ сохранить буфер первого файла. Было бы неприятно каждый
раз возвращаться назад используя C-x C-f и потом использовать C-x C-s для
сохранения данных. Поэтому существует команда

	C-x s     Сохранить некоторые буфера. (Save some buffers)

C-x s запрашивает у вас подтверждение о сохранении для каждого буфера,
который содержит не сохраненные изменения. Для каждого такого буфера у вас
запросят: сохранять или не сохранять изменения.

>> Вставьте строку текста, потом наберите C-x s.
   Должен появиться запрос: сохранять ли буфер с именем TUTORIAL.ru.
   Ответьте на запрос утвердительно нажатием клавиши "y".


* РАСШИРЕНИЕ НАБОРА КОМАНД
--------------------------

У Emacs очень много команд, и они все не могут быть назначены на control- и
meta- сочетания. Emacs решает эту проблему, используя X-команду (eXtend,
расширять). Есть два варианта:

	C-x	Расширение с помощью ввода префикса. За ним следует один символ.
	M-x	Расширение набора команд с помощью их именования. За ним
		следует имя команды.

Это полезные команды, но они используются менее часто, чем те команды,
которые мы уже изучили. Вы уже видели некоторые из этих команд. Например,
команды работы с файлами: C-x C-f -- открыть файл, и C-x C-s -- сохранить
файл. Другой пример -- команда завершения работы Emacs: C-x C-c.  (Не
волнуйтесь о том, что вы потеряете сделанные изменения, C-x C-c предлагает
сохранить изменения перед выходом из Emacs).

Если вы работаете на графическом дисплее, то вам не нужно выполнять
специальных команд чтобы переключится от Emacs к другой программе. Вы можете
сделать это используя мышь или соответствующее команды операционной системы.
Но когда вы используете текстовый терминал, который способен показывать
только одну программу в конкретный момент времени, то для переключения к
другой программе вам понадобится "приостановить" (suspend) Emacs.

C-z -- это команда *временного* выхода из Emacs. Вы можете позже вернуться в
ту же сессию Emacs.  Когда Emacs запускается на текстовом терминале, команда
C-z "приостанавливает" (suspend) Emacs, т.е. она возвращает вас в командный
процессор (shell), но не завершает Emacs. В большинстве командных
процессоров вы можете вернуться в Emacs с помощью команды "fg" или "%emacs".

Чтобы покинуть Emacs используйте C-x C-c.  Это сочетание также используется,
чтобы выйти из Emacs, вызванного из почтовой программы или другой утилиты.

Существует много команд с префиксом C-x. Вы уже изучили следующие команды:

	C-x C-f		Открыть файл
	C-x C-s		Сохранить файл
	C-x s		Сохранить некоторые буфера
	C-x C-b		Получить список буферов
	C-x b		Переключиться в буфер
	C-x C-c		Завершить Emacs
	C-x 1		Удалить все окна, кроме текущего
	C-x u		Отмена изменений

Именованные расширенные команды -- это команды, которые используются гораздо
реже, или используются только в определенных режимах. В качестве примера
можно привести команду replace-string, которая заменяет одну строку на
другую во всем тексте. Когда вы наберете M-x, Emacs предложит вам ввести имя
команды; в нашем случае это команда "replace-string". Наберите лишь
"repl-s<TAB>", и Emacs дополнит имя. (<TAB> -- это клавиша табуляции, обычно
находящаяся над клавишами CapsLock или Shift в левой части клавиатуры.)
Подтвердите имя нажатием <Return>.

Команда replace-string требует два аргумента -- строку, которая будет
заменена, и строку, на которую нужно заменить. Вы должны завершать каждый
аргумент вводом <Return>.

>> Переместите курсор к пустой строке на две строчки ниже этой.
   Наберите M-x repl-s<Return>файл<Return>файлы<Return>.

   Заметьте, как эта строчка изменится: вы замените слово файл
   словом "файлы" везде, где оно встретится, ниже позиции курсора.


* АВТОМАТИЧЕСКОЕ СОХРАНЕНИЕ
---------------------------

Если вы измените файл, но не сохраните его, то в случае "падения" системы вы
можете потерять информацию. Чтобы защитить вас от этого, Emacs периодически
сохраняет каждый файл, который вы редактируете. Автоматически сохраняемый
файл имеет имя с символами "#" в начале и в конце.  Например, если ваш файл
называется "hello.c", то автоматически сохраненный файл будет называться
"#hello.c#". Когда вы сохраните файл обычным способом, Emacs удаляет
автоматически сохраненный файл.

Если система зависла, то вы можете восстановить ваши изменения, которые были
сохранены автоматически, путем открытия нужного файла (файла, который вы
редактировали, а не того, что бы сохранен автоматически) и затем набрав M-x
recover-file<Return>.  Когда у вас запросят подтверждение, наберите
yes<Return>, чтобы восстановить автоматически сохраненные данные.


* ОБЛАСТЬ ЭХА (ECHO AREA)
-------------------------

Если Emacs видит, что вы медленно набираете команды из нескольких сочетаний
клавиш, то он покажет их вам в нижней части экрана, в области называемой
"область эха" (echo area).  Область эха -- это самая нижняя строка окна
Emacs.


* СТРОКА СОСТОЯНИЯ (MODE LINE)
-----------------------------

Строка сразу над областью эха называется "строкой состояния" (mode
line). Выглядит эта строка примерно так:

--:**  TUTORIAL.ru       63% L749    (Fundamental)-----------------------

Эта строка сообщает полезную информацию о состоянии Emacs и текста, который
вы редактируете.

Вы уже знаете, что означает имя файла -- это файл, который вы открыли. NN%
показывает вашу текущую позицию в тексте.  Это означает что NN процентов
текста находятся выше начала окна. Если отображается начало текста, вы
увидите "Top" вместо "0%". Если отображается конец текста, то будет
отображено "Bot".  Если текст настолько мал, что вмещается в один экран, то
строка состояния сообщит "All".

Буква L и цифры показывают позицию другим способом -- они показывают номер
строки в которой находится курсор.

Звездочки в начале строки означают, что вы изменяли текст. Сразу после
открытия или сохранения файла эта часть строки будет содержать не звездочки,
а тире.

Часть строки состояния внутри скобок сообщает вам о режиме редактирования,
который вы сейчас используете. Стандартный, или базовый, режим -- Fundamental,
он используется и в данном учебнике. Это пример "основного режима" ("major
mode").

Emacs имеет много различных основных режимов. Некоторые из режимов
используются для редактирования текста на различных языках и/или различных
видов текста, такие как Lisp-режим, Text-режим и пр. В каждый момент
времени действует только один основной режим, и его название вы можете найти
в скобках -- там, где сейчас находится слово "Fundamental" (базовый).

Каждый основной режим заставляет некоторые команды вести себя по разному.
Например, имеются команды создания комментариев в программе, и поскольку в
каждом языке программирования комментарии записываются по своему, то и
каждый основной режим вставляет их по разному. Каждый основной режим имеет
именованную команду, которая включает его. Например, M-x fundamental-mode --
это команда, которая включает базовый (Fundamental) режим.

Если вы редактируете текст на естественном языке, например, как этот файл,
то вы, вероятно должны переключиться в режим Text.

>> Наберите M-x text mode<Return>.

Не волнуйтесь, ни одна из выученных вами команд Emacs не изменилась. Но вы
можете заметить, что M-f и M-b теперь рассматривают апострофы как часть
слова. Ранее, в базовом режиме (Fundamental mode), M-f и M-b воспринимали
апострофы как разделители слов.

Как правило, основные режимы производят незначительные изменения:
большинство команд "работает одинаково" в каждом из режимов, но их действие
отличается какой-нибудь мелочью.

Для просмотра документации о текущем основном режиме, нажмите C-h m.

>> Используйте C-l C-l чтобы расположить эту строку вверху экрана.
>> Наберите C-h m, чтобы посмотреть отличия Text-режима от базового.
>> Наберите C-x 1, чтобы убрать документацию с глаз долой :)

Основной режим называется основным потому, что также существуют
дополнительные (minor) режимы. Дополнительные режимы не являются
альтернативами основным, они только немного изменяют их поведение. Каждый
дополнительный режим включается/выключается независимо от других
дополнительных режимов и независимо от вашего основного режима.  Вы можете
использовать основной режим без дополнительных, или с любой комбинацией
нескольких дополнительных режимов.

Один из дополнительных режимов очень полезен, особенно для редактирования
текста -- это режим автозаполнения (Auto Fill mode). Когда этот режим
включен, то Emacs автоматически разрывает строку между словами в тех
случаях, когда вставленный текст делает строку слишком длинной.

Вы можете включить режим автозаполнения, набрав M-x auto-fill-mode<Return>.
Когда этот режим включен, его можно выключить с помощью той же команды --
M-x auto-fill-mode<Return>. Если режим включен, то такая команда его
выключит, если выключен, то включит. Мы говорим что команда "переключает
режим".

>> Наберите M-x auto-fill-mode<Return>. Затем вводите строку из слов "фыва "
   пока не увидите, как она разделится на две строки. Эти пробелы между
   словами необходимы, потому что режим автозаполнения разбивает строки
   только по пробелам.

Граница разбиения обычно равна 70-ти символам, но вы можете изменить ее
используя команду C-x f.  Вы должны задать границу в виде числового
аргумента для этой команды.

>> Введите C-x f с аргументом 20 (C-u 2 0 C-x f).
   Затем введите какой-нибудь текст и посмотрите как Emacs заполняет строки
   по 20 символов в каждой.  Верните значение границы равное 70 назад,
   используя команду C-x f.

Если вы сделали изменения в середине параграфа, то автозаполнение не
переформатирует текст автоматически.
Чтобы переформатировать параграф, наберите M-q (META-q), когда курсор
находится внутри параграфа.

>> Переместите курсор в предыдущий параграф, и нажмите M-q.


* ПОИСК
-------

Emacs умеет искать строки (строка -- непрерывная группа символов) вперед или
назад по тексту. Поиск строки -- это команда перемещения курсора -- она
перемещает курсор в следующую точку, где найдена искомая строка.

Команда поиска в Emacs является инкрементальной.  Это означает, что поиск
происходит по мере того, как вы набираете искомую строку.

Команда, начинающая поиск вперед -- C-s, а C-r ищет назад. ПОДОЖДИТЕ! Не
нужно пробовать прямо сейчас.

Когда вы нажмете C-s, вы увидите строку "I-search", появившуюся в области
эха.  Вам сообщается, что Emacs ждет ввода строки, которую вы хотите найти.
<Return> завершает поиск.

>> Теперь нажмите C-s для начала поиска. Медленно, по одной букве, набирайте
   слово "курсор", останавливаясь после каждой введенной буквы и замечая, что
   происходит с курсором.
   Сейчас вы нашли первое вхождение слова "курсор".
>> Нажмите C-s снова, чтобы найти следующее вхождение слова "курсор".
>> Теперь нажмите <DEL> четыре раза и проследите за перемещениями курсора.
>> Нажмите <Return> для завершения поиска.

Вы заметили, что произошло? Emacs в режиме инкрементального поиска пытался
переходить к строкам, совпадающим с набираемой вами строкой.  Чтобы перейти
к следующему вхождению слова "курсор", просто нажмите C-s снова. Если больше
нет вхождений, то Emacs издаст звуковой сигнал и сообщит, что ваш поиск не
удался ("failing"), C-g также завершает поиск.

Если вы во время инкрементального поиска нажмете <DEL>, то поиск "вернется"
к предыдущему найденному месту.  Если вы наберете <DEL> сразу после того как
вы нажали C-s для перемещения к следующей позиции, то <DEL> переместит к
предыдущему вхождению.  Если предыдущей позиции не было, то <DEL> удалит
последний символ в строке поиска.  Например, предположим, что вы набрали "к",
поиск перейдет к первому вхождению символа "к". Теперь, если вы наберете
"у", курсор перейдет к первому вхождению "ку". Нажатие <DEL> удалит символ
"у" из строки поиска, и курсор вернется к первому вхождению "к".

Если вы во время поиска введете control- или meta- сочетание клавиш (за
некоторыми исключениями, например, такими, как C-s и C-r, которые имеют
специальное значение в поиске), то поиск прекратится.

C-s начинает поиск и ищет любые вхождения искомой строки ПОСЛЕ текущей
позиции курсора. Если вы хотите найти что-то ранее в тексте, то нажмите
C-r. Все, что мы говорили о C-s, применимо и к C-r, только C-r ищет в
противоположном направлении.


* МНОЖЕСТВО ОКОН (MULTIPLE WINDOWS)
-----------------------------------

Одной из приятных возможностей Emacs является то, что вы можете одновременно
отображать на экране несколько окон.  (Заметьте, что Emacs использует термин
"фрейм" (frame), описанный в следующем разделе, для того, что другие
приложения называют окна.  В Руководстве Emacs имеется подробный глоссарий).

>> Переместите курсор на эту строку и наберите C-l C-l.

>> Теперь наберите C-x 2, что разделит экран на два окна.
   Оба окна отображают учебник. Курсор остался в верхнем окне.

>> Нажмите C-M-v для прокрутки нижнего окна.
   (если у вас нет клавиши META (Alt), то нажмите <ESC> C-v.)

>> Нажмите C-x o ("o" от слова "other" -- другое) для перемещения курсора в
   нижнее окно.
>> Используйте C-v и M-v в нижнем окне, для прокрутки текста.
   Продолжите чтение этой инструкции в верхнем окне.

>> Снова нажмите C-x o, чтобы переместить курсор назад в верхнее окно.
   Курсор в верхнем окне там же, где и был до того.

Вы можете продолжать использовать C-x o для переключения между окнами.
"Выбранное окно", где производится редактирование -- это окно с видимым
курсором, который мигает когда вы не набираете текст.  Остальные окна
сохраняют собственные позиции курсора.  Если вы используете Emacs в
графической среде, то эти курсоры будут отображаться как немигающие полые
прямоугольники.

Команда C-M-v очень удобна, когда вы редактируете текст в одном окне, а
второе используете в качестве справочника. С помощью C-M-v вы можете
прокручивать текст в другом окне не покидая текущего окна.

C-M-v -- пример CONTROL-META сочетания клавиш. Если у вас есть клавиша META
(или Alt), то вы можете набрать C-M-v, нажав одновременно CONTROL и META и,
не отпуская их, нажать v. Не важно, какая из клавиш, CONTROL или META, будет
нажата первой, поскольку обе эти клавиши изменяют набираемый вами символ.

Если у вас нет клавиши META, и вместо нее вы используете <ESC>, то порядок
нажатия важен: сначала вы должны нажать <ESC>, а затем CTRL-v, поскольку
CONTROL-<ESC> v не будет работать. Это происходит потому, что <ESC> сама
является символом, а не модифицирующей клавишей.

>> Нажмите C-x 1 (в верхнем окне), чтобы избавиться от нижнего окна.

(Если бы вы нажали C-x 1 в нижнем окне, то вы бы избавились от верхнего.
Понимайте эту команду как "Оставить только одно окно -- то, в котором я
сейчас нахожусь").

Вам не нужно отображать один и тот же буфер в обоих окнах. Если вы
используете C-x C-f, чтобы открыть файл в одном окне, другое останется без
изменения. Вы можете независимо открывать файлы в каждом окне.

Есть и другой путь использовать два окна, отображающих разные файлы:

>> Наберите C-x 4 C-f, и введите имя одного из ваших файлов. Завершите ввод
   нажатием <Return>. Заметьте, что выбранный файл появился в нижнем окне.
   Курсор перешел туда же.

>> Наберите C-x o, чтобы вернуться в верхнее окно, и затем C-x 1, чтобы
   удалить нижнее окно.


* МНОЖЕСТВО ФРЕЙМОВ (MULTIPLE FRAMES)
-------------------------------------

Emacs также может создавать множество "фреймов" (frames).  Фрейм -- это то,
что мы называем коллекцией окон, вместе со строкой меню, полосами прокрутки,
областью эхо, и т.д.  На графических дисплеях, то что в Emacs называется
"фрейм", большинство других приложений называют "окно".  В графической среде
одновременно может быть отображено несколько фреймов. А на текстовых
терминалах, может быть показан только один фрейм в конкретный момент
времени.

>> Наберите M-x make-frame <Return>.
   Вы увидите что новый фрейм появился на экране.

В новом фрейме вы можете делать все то же самое что и в оригинальном
фрейме.  Между ними нет особых отличий.

>> Наберите M-x delete-frame <Return>.
   Эта команда удалит текущий фрейм.

Вы также можете удалить фрейм используя стандартные методы вашей графической
среды (часто путем нажатия кнопки "X" в верхней части фрейма).  Если вы
таким способом удалите последний имеющийся фрейм Emacs, то это приведет к
завершению работы Emacs.


* РЕКУРСИВНЫЕ УРОВНИ РЕДАКТИРОВАНИЯ (RECURSIVE EDITING LEVELS)
--------------------------------------------------------------

Иногда вы будете попадать в так называемые "рекурсивные уровни
редактирования".  На это указывают прямоугольные скобки в строке состояния,
окружающие обычные скобки вокруг имени основного режима. Например, вы
увидите [(Fundamental)] вместо (Fundamental).

Чтобы выйти из рекурсивных уровней редактирования, нажмите <ESC> <ESC>
<ESC>.  Это многоцелевая команда "выхода". Вы также можете использовать ее
как для уничтожения лишних окон, так и для выхода из мини-буфера.

>> Нажмите M-x, чтобы попасть в мини-буфер, а затем нажмите <ESC> <ESC>
   <ESC>, чтобы покинуть его.

Вы не можете использовать C-g для выхода из рекурсивных уровней
редактирования. Это потому, что C-g используется для отмены команд и
аргументов ВНУТРИ рекурсивных уровней редактирования.


* КАК ПОЛУЧИТЬ ДОПОЛНИТЕЛЬНУЮ ПОМОЩЬ
------------------------------------

В этом учебнике мы попытались снабдить вас достаточной информацией для
начала использования Emacs.  В Emacs очень много разной функциональности, и
представить все это здесь не представляется возможным.  Однако, возможно вы
захотите узнать больше о возможностях Emacs.  Emacs предоставляет команды
для чтения документации о командах Emacs. Все команды "справки" (help)
начинаются с сочетания CONTROL-h, которое является "символом справки".

Чтобы использовать справку, нажмите C-h, а затем -- символ, который
расскажет, какой именно вид справки вы хотите получить. Если вы
ДЕЙСТВИТЕЛЬНО растерялись, наберите C-h ?, и Emacs расскажет вам о том,
какую справку он может вам предоставить. Если вы нажали C-h и передумали
обращаться к справке, то просто нажмите C-g, чтобы отменить эту команду.

(Если C-h не отображает справку внизу экрана, то попробуйте вместо этого
нажать клавишу F1 или набрать M-x help RET).

Одна из самых главных функций справки -- C-h c. Нажмите C-h, а затем c и
символ команды или последовательность, и Emacs отобразит краткое описание
набранной команды.

>> Нажмите C-h c C-p.

Сообщение должно выглядеть примерно так:

	C-p runs the command previous-line
       (C-p выполняет команду previous-line {предыдущая строка})

Вам сообщают "имя функции". Поскольку имена функций выбраны так, чтобы
показать, что именно команда делает, то они могут служить короткой
документацией -- достаточно чтобы напомнить вам об уже выученных командах.

Многосимвольные сочетания клавиш, такие как C-x C-s и (если у вас нет клавиши
META или EDIT или ALT) <ESC> v также будут доступны для получения справки с
помощью C-h c.

Вы можете получить больше информации о сочетании клавиш используя C-h k вместо C-h c.

>> Наберите C-h k C-p.

В отдельном окне Emacs вы увидите описание функции, а также ее имя. Когда вы
завершите чтение, нажмите C-x 1, чтобы избавиться от окна с текстом справки.
Не обязательно нажимать C-x 1 сразу: вы можете сначала выполнить какие-либо
изменения текста во время просмотра текста справки, и только затем нажать
C-x 1.

Есть еще несколько полезных функций, доступных через C-h:

   C-h f	Описывает функцию. Вам необходимо набрать имя функции.

>> Попробуйте набрать C-h f previous-line<Return>.
   Это отобразит информацию Emacs о функции, которая выполняется командой
   C-p.

Аналогичная команда C-h v отображает документацию о переменных, включая те,
значение которых вы можете изменить для настройки поведения Emacs. Вам нужно
набрать имя переменной, когда Emacs запросит его.

   C-h a (Command Apropos). Введите ключевое слово и Emacs покажет вам
	 список всех команд и функций, имена которых содержат это слово.
         Эти команды могут быть запущены с помощью Meta-x.
         Для некоторых команд, эта команда также покажет последовательности
	 клавиш которые могут использоваться для их запуска.

>> Наберите C-h a file<Return>.

Это отобразит в другом окне список всех команд M-x, у которых в именах
содержится слово "file". Также в списке кроме таких команд, как find-file,
вы увидите соответствующие символьные команды, такие как C-x C-f.

>> Наберите C-M-v для прокрутки окна справки. Выполните это несколько раз.

>> Наберите C-x 1 для удаления окна справки.

   C-h i Читать интерактивные руководства (команда Info). Эта команда
         переходит в специальный буфер с именем "*info*", где вы можете
         читать интерактивные руководства для пакетов, установленных в вашей
         системе. Наберите m emacs <Return> для чтения руководства по
         Emacs. Если вы никогда ранее не использовали Info, то наберите ? и
         Emacs откроет учебник по возможностям режима Info. Однажды
         ознакомившись с этим учебником, вы должны использовать руководство
         Emacs Info в качестве основной документации.


* ДОПОЛНИТЕЛЬНЫЕ ВОЗМОЖНОСТИ
----------------------------

Вы можете узнать больше об Emacs, читая руководство по нему, книги или
интерактивный справочник (используйте меню Help или наберите F10 h r). Вам
особенно понравятся две функции -- дополнение имен (completion), которое
сокращает количество нажимаемых клавиш, и dired, который упрощает работу с
файлами.

Дополнение имен используется для того, чтобы избежать набора лишних
символов.  Например, если вы хотите переключиться в буфер *Messages*, то вы
можете набрать C-x b *M<Tab> и Emacs дополнит остаток имени буфера,
поскольку он может определить его из того, что вы уже набрали. Дополнение
имен описано в Info-версии руководства по Emacs в разделе "Completion".

Dired позволяет вам отображать список файлов в каталоге (а также
подкаталогах, в зависимости от настройки), перемещаться по списку файлов,
открывать их, переименовывать, удалять и выполнять прочие действия над
файлами. Dired описан в Info-версии руководства по Emacs в разделе "Dired".

В руководстве также описаны остальные возможности Emacs.


* ЗАКЛЮЧЕНИЕ
------------

Для выхода из Emacs, используется сочетание клавиш C-x C-c.

Этот учебник должен быть понятен всем новым пользователям, но если вы
найдете что-нибудь неясное, не нужно сидеть и порицать себя -- жалуйтесь!


* УСЛОВИЯ РАСПРОСТРАНЕНИЯ
-------------------------

Этот учебник произошел из длинной серии учебников Emacs, начатой с однажды
написанного Stuart Cracraft учебника для оригинального Emacs.

Эта версия учебника, как и GNU Emacs, защищена правами копирования
(copyrighted) и приходит с ограничениями распространения копий со
следующими соглашениями:

Copyright (C) 1985, 1996, 1998, 2001-2022 Free Software Foundation, Inc.

   Permission is granted to anyone to make or distribute verbatim copies
   of this document as received, in any medium, provided that the
   copyright notice and permission notice are preserved,
   and that the distributor grants the recipient permission
   for further redistribution as permitted by this notice.

   Permission is granted to distribute modified versions
   of this document, or of portions of it,
   under the above conditions, provided also that they
   carry prominent notices stating who last altered them.

Условия распространения самого Emacs более сложные, но примерно в том же духе.
Пожалуйста, прочтите файл COPYING и затем раздайте копию GNU Emacs вашим
друзьям. Помогите уничтожить обструкционизм в области программного
обеспечения ("владение"), используя, создавая и распространяя свободное
программное обеспечение!

// жду замечаний и исправления ошибок по адресу alexott@gmail.com.
// Alex Ott.

;;; Local Variables:
;;; coding: utf-8
;;; sentence-end-double-space: nil
;;; mode: fundamental
;;; fill-column: 76
;;; End:
