/*  GNU moe - My Own Editor
    Copyright (C) 2005-2019 Antonio Diaz Diaz.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

namespace ISO_8859 {

// 'seq[i]' begins a escape sequence (the characters following a '\').
// Returns the corresponding code and, in '*lenp', the characters read.
// Returns -1 if error.
//
int escape( const std::string & seq, const unsigned i, int * lenp = 0 );

// Replace special characters with escape sequences; '\n' --> "\n"
//
void escapize( std::string & s );

// Replace escape sequences with special characters; "\n" --> '\n'
// (but not "\?" --> '?')
//
void deescapize_search_string( std::string & s );

bool islower( const unsigned char ch );
bool isupper( const unsigned char ch );
bool isalpha_( const unsigned char ch );
bool isalnum_( const unsigned char ch );
inline bool isblank_( const unsigned char ch )
  { return ( ch == ' ' || ch == '\t' ); }
inline bool isspace( const unsigned char ch )
  { return ( std::isspace( ch ) || ch == 0xA0 ); }

inline bool iscntrl( const unsigned char ch )
  { return ( ch < 32 || ( ch >= 0x7F && ch < 0xA0 ) ); }
inline bool isgraph( const unsigned char ch )
  { return ( !iscntrl( ch ) && ch != ' ' && ch != 0xA0 ); }
inline bool isprint( const unsigned char ch )
  { return !iscntrl( ch ); }

inline bool isodigit( const unsigned char ch )	// is 'ch' an octal digit?
  { return ( ch <= '7' && ch >= '0' ); }

const char * control_name( const unsigned char ch );	// '^A' --> "^A"
int controlize( int code );	// converts 'A' or 'a' into '^A'
int decontrolize( int code );	// converts '^A' or 'a' into 'A'
unsigned char tolower( const unsigned char ch );
unsigned char toupper( const unsigned char ch );
void map_to_ascii( const unsigned char ch, std::string & out );
unsigned char xdigit( const int value );	// hex digit for 'value'
int xvalue( const unsigned char ch );		// value of hex digit 'ch' or -1

} // end namespace ISO_8859
