#! /bin/sh
# check script for GNU Ocrad - Optical Character Recognition program
# Copyright (C) 2009 Antonio Diaz Diaz.
#
# This script is free software: you have unlimited permission
# to copy, distribute and modify it.

objdir=`pwd`
testdir=`cd "$1" ; pwd`
OCRAD="${objdir}"/ocrad
framework_failure() { echo 'failure in testing framework'; exit 1; }

if [ ! -x "${OCRAD}" ] ; then
	echo "${OCRAD}: cannot execute"
	exit 1
fi

if [ -d tmp ] ; then rm -r tmp ; fi
mkdir tmp
echo testing ocrad...
cd "${objdir}"/tmp

fail=0

"${OCRAD}" -q "${testdir}"/test.pbm > out || fail=1
cmp "${testdir}"/test.txt out || fail=1

if test ${fail} = 0; then
	echo "tests completed successfully."
	if cd "${objdir}" ; then rm -r tmp ; fi
else
	echo "tests failed."
fi
exit ${fail}
