# Make a simple catalog for NoiseChisel's output.
#
# See the Tests subsection of the manual for a complete explanation
# (in the Installing gnuastro section).
#
# Original author:
#     Mohammad Akhlaghi <mohammad@akhlaghi.org>
# Contributing author(s):
#
# Copying and distribution of this file, with or without modification,
# are permitted in any medium without royalty provided the copyright
# notice and this notice are preserved.  This file is offered as-is,
# without any warranty.





# Preliminaries
# =============
#
# Set the variables (The executable is in the build tree). Do the
# basic checks to see if the executable is made or if the defaults
# file exists (basicchecks.sh is in the source tree).
prog=mkcatalog
execname=../bin/$prog/ast$prog
labels=connected-components.fits
base=convolve_spatial_noised_detected.fits





# Skip?
# =====
#
# If the dependencies of the test don't exist, then skip it. There are two
# types of dependencies:
#
#   - The executable was not made (for example due to a configure option),
#
#   - The input data was not made (for example the test that created the
#     data file failed).
if [ ! -f $execname ]; then echo "$execname not created.";  exit 77; fi
if [ ! -f $labels   ]; then echo "$labels does not exist."; exit 77; fi
if [ ! -f $base     ]; then echo "$base does not exist.";   exit 77; fi





# Actual test script
# ==================
$execname $labels -h1 --valuesfile=$base --tableformat=txt            \
          --output=detections.txt --x --y --ra --dec --magnitude --sn
