/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.demo.mentalarithmetic;

import gnu.prolog.database.Pair;
import gnu.prolog.database.PrologTextLoaderError;
import gnu.prolog.demo.mentalarithmetic.NoAnswerException;
import gnu.prolog.io.TermWriter;
import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.IntegerTerm;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.Environment;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.TermConstants;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;

public class MentalArithmetic {
    private static final int DEFAULTLIMIT = 500;
    private static final int DEFAULTLENGTH = 5;
    public static final String USAGE = "Either no arguments or {Limit, Length}.\n Where Limit is the largest number to use and Length is the number of operations to use.\n--help|-h displays this usage text.";
    private static boolean issetup = false;
    private static Environment env;
    private static Interpreter interpreter;

    private MentalArithmetic() {
    }

    public static void main(String[] args) {
        block12: {
            int length;
            int limit;
            if (args.length == 1 && ("--help".equals(args[0]) || "-h".equals(args[0]))) {
                System.out.println(USAGE);
            }
            if (args.length == 2) {
                try {
                    limit = Integer.parseInt(args[0]);
                    length = Integer.parseInt(args[1]);
                }
                catch (NumberFormatException e) {
                    System.err.println(String.format("Not a number (%s) or (%s)", args[0], args[1]));
                    System.out.println(USAGE);
                    return;
                }
            } else {
                limit = 500;
                length = 5;
            }
            try {
                Pair<String, Integer> question = MentalArithmetic.generateQuestion(limit, length);
                System.out.print((String)question.left + ": ");
                BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
                String answer = reader.readLine();
                try {
                    int value = Integer.parseInt(answer);
                    if ((Integer)question.right == value) {
                        System.out.println("Correct.");
                        break block12;
                    }
                    System.out.println("Wrong. Answer was: " + question.right);
                }
                catch (NumberFormatException e) {
                    System.err.println(String.format("Not a number: (%s)", answer));
                }
            }
            catch (PrologException e) {
                System.err.println(e.toString());
            }
            catch (NoAnswerException e) {
                System.err.println(e.toString());
            }
            catch (IOException e) {
                System.err.println(e.toString());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Pair<String, Integer> generateQuestion(int limit, int length) throws PrologException, NoAnswerException {
        MentalArithmetic.setup();
        VariableTerm listTerm = new VariableTerm("List");
        VariableTerm answerTerm = new VariableTerm("Answer");
        Term[] args = new Term[]{new IntegerTerm(limit), new IntegerTerm(length), listTerm, answerTerm};
        CompoundTerm goalTerm = new CompoundTerm(AtomTerm.get("arithmetic"), args);
        Interpreter interpreter = MentalArithmetic.interpreter;
        synchronized (interpreter) {
            MentalArithmetic.debug();
            int rc = MentalArithmetic.interpreter.runOnce(goalTerm);
            if (rc != 0 && rc != 1) throw new NoAnswerException("Goal failed");
            Pair<Object, Integer> answer = new Pair<Object, Integer>(null, 0);
            Term list = listTerm.dereference();
            Term value = answerTerm.dereference();
            if (list == null) throw new NoAnswerException("List null when it should not be null");
            if (!(list instanceof CompoundTerm)) throw new NoAnswerException("List is not a list: " + list);
            CompoundTerm cList = (CompoundTerm)list;
            if (cList.tag != TermConstants.listTag) {
                throw new NoAnswerException("List is not a list but is a CompoundTerm: " + list);
            }
            answer.left = TermWriter.toString(list);
            if (value == null) throw new NoAnswerException("Answer null when it should not be null");
            if (!(value instanceof IntegerTerm)) {
                throw new NoAnswerException("Answer is not an integer: (" + value + ") but List is:" + list);
            }
            answer.right = ((IntegerTerm)value).value;
            return answer;
        }
    }

    private static synchronized void setup() {
        if (issetup) {
            return;
        }
        env = new Environment();
        env.ensureLoaded(AtomTerm.get(MentalArithmetic.class.getResource("mentalarithmetic.pro").getFile()));
        interpreter = env.createInterpreter();
        env.runInitialization(interpreter);
        issetup = true;
    }

    private static void debug() {
        List<PrologTextLoaderError> errors = env.getLoadingErrors();
        for (PrologTextLoaderError error : errors) {
            error.printStackTrace();
        }
    }
}

