/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm.buildins.list;

import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.CompoundTermTag;
import gnu.prolog.term.Term;
import gnu.prolog.term.TermComparator;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.BacktrackInfo;
import gnu.prolog.vm.ExecuteOnlyCode;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.TermConstants;
import gnu.prolog.vm.interpreter.Predicate_call;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Predicate_predsort
extends ExecuteOnlyCode {
    public static final CompoundTermTag COMPARE_TAG = CompoundTermTag.get("compare", 3);

    @Override
    public int execute(Interpreter interpreter, boolean backtrackMode, Term[] args) throws PrologException {
        if (!CompoundTerm.isListPair(args[1])) {
            PrologException.typeError(TermConstants.listAtom, args[1]);
        }
        HashSet<Term> set = new HashSet<Term>();
        CompoundTerm.toCollection(args[1], set);
        ArrayList<Term> list = new ArrayList<Term>(set);
        try {
            Collections.sort(list, this.getComparator(interpreter, args[0]));
        }
        catch (ComparatorException e) {
            if (e.thrown == null) {
                return -1;
            }
            throw e.thrown;
        }
        Term result = CompoundTerm.getList(list);
        return interpreter.unify(args[2], result);
    }

    protected Comparator<? super Term> getComparator(Interpreter interpreter, Term sorter) throws PrologException {
        Term[] args;
        CompoundTermTag tag;
        if (sorter instanceof AtomTerm) {
            tag = CompoundTermTag.get(((AtomTerm)sorter).value, 3);
            args = new Term[3];
        } else if (sorter instanceof CompoundTerm) {
            CompoundTerm ct = (CompoundTerm)sorter;
            tag = CompoundTermTag.get(ct.tag.functor, ct.tag.arity + 3);
            args = new Term[tag.arity];
            System.arraycopy(ct.args, 0, args, 3, ct.args.length);
        } else {
            PrologException.typeError(TermConstants.atomAtom, sorter);
            return null;
        }
        CompoundTerm call = new CompoundTerm(tag, args);
        if (call.tag == COMPARE_TAG) {
            return new TermComparator();
        }
        return new CallPredComparator(interpreter, call);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CallPredComparator
    implements Comparator<Term> {
        Interpreter interpreter;
        CompoundTerm callMe;

        public CallPredComparator(Interpreter interp, CompoundTerm call) {
            this.interpreter = interp;
            this.callMe = call;
        }

        @Override
        public int compare(Term o1, Term o2) {
            BacktrackInfo startBi;
            int startUndoPosition;
            block12: {
                String retval;
                block11: {
                    block10: {
                        Term result = new VariableTerm();
                        this.callMe.args[0] = result;
                        this.callMe.args[1] = o1;
                        this.callMe.args[2] = o2;
                        startUndoPosition = this.interpreter.getUndoPosition();
                        startBi = this.interpreter.peekBacktrackInfo();
                        boolean callBacktrackMode = false;
                        int rc = Predicate_call.staticExecute(this.interpreter, callBacktrackMode, this.callMe);
                        callBacktrackMode = true;
                        if (rc == -1) {
                            throw new ComparatorException(null);
                        }
                        result = ((Term)result).dereference();
                        retval = null;
                        if (result instanceof AtomTerm) {
                            retval = ((AtomTerm)result).value;
                        }
                        this.interpreter.undo(startUndoPosition);
                        if (!"=".equals(retval)) break block10;
                        return 0;
                    }
                    if (!">".equals(retval)) break block11;
                    return 1;
                }
                if (!"<".equals(retval)) break block12;
                return -1;
            }
            try {
                try {
                    throw new ComparatorException(null);
                }
                catch (RuntimeException rex) {
                    if (rex instanceof ComparatorException) {
                        throw rex;
                    }
                    PrologException.systemError(rex);
                    return 0;
                }
            }
            catch (PrologException ex) {
                this.interpreter.popBacktrackInfoUntil(startBi);
                this.interpreter.undo(startUndoPosition);
                throw new ComparatorException(ex);
            }
        }
    }

    static class ComparatorException
    extends RuntimeException {
        private static final long serialVersionUID = 7709083338614572022L;
        PrologException thrown;

        ComparatorException(PrologException thrownElm) {
            this.thrown = thrownElm;
        }
    }
}

