/*
 * float.h - 960 floating point characteristics
 */

#define FLT_RADIX        2
#define FLT_ROUNDS       0    /* round toward 0 (crt0.s sets this in AC) */

#define FLT_DIG          6
#define FLT_EPSILON	 1.19209290e-7
#define FLT_MANT_DIG     24
#define FLT_MAX		 3.40282347e+38
#define FLT_MAX_EXP      128
#define FLT_MAX_10_EXP	 38
#define FLT_MIN		 1.17549435e-38
#define FLT_MIN_EXP	 -125
#define FLT_MIN_10_EXP   -37

#define DBL_DIG          14
#define DBL_EPSILON	 1.110223024625156e-16
#define DBL_MANT_DIG     53
#define DBL_MAX		 1.797693134862315e+308
#define DBL_MAX_EXP      1024
#define DBL_MAX_10_EXP	 308
#define DBL_MIN		 2.225073858507201e-308
#define DBL_MIN_EXP	 -1021
#define DBL_MIN_10_EXP   -307

#define LDBL_DIG         18
#define LDBL_EPSILON	 1.08420217248550443400e-19L
#define LDBL_MANT_DIG    64
#define LDBL_MAX	 1.18973149535723176405e+4932L
#define LDBL_MAX_EXP     16384
#define LDBL_MAX_10_EXP	 4932
#define LDBL_MIN	 1.7e-4932L /* from ic960 header */
#define LDBL_MIN_EXP	 -16382
#define LDBL_MIN_10_EXP  -4931

