/* 
 * stubs for (future) multi-thread host OS's
 * [atw] 7-Nov-89
 */

#ifndef __REENT_H__
#define __REENT_H__

/*
 * need "size_t"
 */
#include <stddef.h>
#define _EXIT_HANDLER_MAX 32
struct _exit
{
	void	*open_stream_sem;
	struct _iobuf	*open_stream_list;	/* the list is maintained as a stack */
	void	*exit_handler_sem;
	int	exit_handler_count;
	void	(*exit_handler_list[_EXIT_HANDLER_MAX])();
};

struct _thread
{
	int		errno;
	unsigned long	_rand_seed;
	char		*_strtok_buffer;
	char		_asctime_buffer[26];
	struct tm	*_gmtime_buffer;
};

struct _tzset
{
	char	*_tzname[2];
	long	_timezone;
	int	_daylight;
};

void		_exit_init(void);
void		_stdio_init(void);
void		_thread_init(void);
struct _exit	*_exit_create(size_t);
struct _stdio	*_stdio_create(size_t);
struct _thread	*_thread_create(size_t);
struct _exit	*_exit_ptr(void);
struct _stdio	*_stdio_ptr(void);
struct _thread	*_thread_ptr(void);
struct _tzset	*_tzset_ptr(void);
void		_semaphore_init(void **);
void		_semaphore_wait(void **);
void		_semaphore_signal(void **);

#endif /* __REENT_H__ */

#ifndef _stdio_stream

#if 0
#ifdef _stdioh
#define _stdio_stream
struct _stdio
{
	FILE	_stdin;			/* stdin stream */
	FILE	_stdout;		/* stdout stream */
	FILE	_stderr;		/* stderr stream */
};
#endif /* _stdioh */
#endif /* _stdio_stream */
#endif
