/*
 * <signal.h> : signal & raise, etc.
 *
 */

#ifndef __SIGNAL_H__
#define __SIGNAL_H__

typedef char sig_atomic_t;

/*
 * signals required by ANSI
 */
#define	SIGINT	1	/* keyboard interrupt */
#define	SIGILL	2	/* illegal instruction */
#define SIGABRT 3	/* sent by abort() */
#define	SIGFPE	4	/* floating point exception */
#define	SIGSEGV	5	/* segmentation violation */
#define	SIGTERM	6	/* software termination signal */

/*
 * define number of signals.
 */
#define NSIG (SIGTERM+1)

#define SIG_ERR	(void(*)())-1
#define	SIG_DFL	(void(*)())0
#define	SIG_IGN	(void (*)())1


/* ANSI functions */
void (*signal(int, void (*)(int)))(int);
int raise(int);

#endif
