/* 
/* <stdarg.h> : ANSI-style varargs.
 *
 * Andy Wilson, 16-Oct.89.
 *
 */

#ifndef _STDARGS_H
#define	_STDARGS_H

#define	_VA_NREGS	12	/* number of argument registers */
#define	_VA_NBYTES	(_VA_NREGS * sizeof(int))
#define _VA_2ALGN	(4 * sizeof(int) )

/* va_list[0] is base of argblk; va_list[1] is displacement of current arg */
typedef unsigned va_list[2];	

#define	va_start(ap,fixarg)	\
  ap[1] = 0, ap[0] = (unsigned)(&fixarg), va_arg(ap, __typeof__(fixarg));

#define _va_mask(type) (					\
	(sizeof(type) <= sizeof(int))				\
	?							\
		0x03						\
	:							\
		((sizeof(type) <= sizeof(double))		\
		?						\
			0x07					\
		:						\
			0x0f)					\
	)

#define	va_arg(ap,type) (						\
	(  							        \
	    ((ap[1] < _VA_NBYTES) && (sizeof(type) > _VA_2ALGN))	\
	    ?								\
		(ap[1]=_VA_NBYTES + sizeof(type))      			\
	    :								\
		(ap[1]=(((ap[1]+_va_mask(type))&~_va_mask(type)) + sizeof(type))) \
	) ,								\
	*((type *) ((char *) ap[0] + ap[1] - sizeof(type)))      	\
    )

#define	va_end(ap)

#endif
