/*
 * <string.h> : string handling routines for gcc960
 */

#ifndef __STRING_H__
#define __STRING_H__

/*
 * bring in size_t.
 */
#include <stddef.h>

#if defined(__STD_C__)
/*
 * Prototypes.
 */
void *		memccpy(void *, const void *, int, int);
void *		memchr(const void *, int, size_t);
int		memcmp(const void *, const void *, size_t);
void *          memcpy(void *, const void *, size_t);
void *          memmove(void *, const void *, size_t);
void *		memset(void *, int, size_t);
char *		strcat(char *, const char *);
char *		strchr(const char *, int);
int		strcmp(const char *, const char *);
char *		strcpy(char *, const char *);
size_t		strcspn(const char *, const char *);
char *		strerror(int);
size_t		strlen(const char *);
char *		strncat(char *, const char *, size_t);
int		strncmp(const char *, const char *, size_t);
char *		strncpy(char *, const char *, size_t);
char *		strpbrk(const char *, const char *);
int		strpos(const char *, char);
char *		strrchr(const char *, int);
char *		strrpbrk(const char *, const char *);
int		strrpos(const char *, char);
size_t		strspn(const char *, const char *);
char *		strstr(const char *, const char *);
char *		strtok(char *, const char *);
int		strcoll(const char *, const char *);
size_t		strxfrm(char *, const char *, size_t);
#else
/*
 * not STD_C, just declare types.
 */
void *		memccpy();
void *		memchr();
int		memcmp();
void *          memcpy();
void *          memmove();
void *		memset();
char *		strcat();
char *		strchr();
int		strcmp();
char *		strcpy();
size_t		strcspn();
char *		strerror();
size_t		strlen();
char *		strncat();
int		strncmp();
char *		strncpy();
char *		strpbrk();
int		strpos();
char *		strrchr();
char *		strrpbrk();
int		strrpos();
size_t		strspn();
char *		strstr();
char *		strtok();
int		strcoll();
size_t		strxfrm();
#endif  /* __STD_C__ */

#endif	/* __STRING_H__ */

