/*			_ a l l o c b u f
 *
 * Allocate a buffer to a stream. This routine is designed to
 * be called from _flsbuf or _filbuf and hence has some hooks
 * in it for these routines.
 *
 * The routine initialises _bufsiz, _base, _ptr and _ctr. No
 * buffer is allocated if _IONBF is in effect. Line buffering
 * is engaged if the stream is attached to a terminal and the
 * stream is not opened for input.
 *
 * Patchlevel 1.0
 *
 * Edit History:
 */

#include "stdiolib.h"

/*LINTLIBRARY*/

int _allocbuf(fp)

FILE *fp;				/* stream */

{
  int isatty();				/* channel is tty */
#ifdef __STDC__
  void *malloc(unsigned int);			/* memory allocator */
#else
  void *malloc();			/* memory allocator */
#endif

  if (TESTFLAG(fp, _IONBF)) {
    fp->_base   = &fp->_buf;
    fp->_bufsiz = sizeof(fp->_buf);
  }
  else {
    if ((fp->_base = (unsigned char *) malloc((unsigned int)BUFSIZ)) == NULL)
      return -1;
    SETFLAG(fp, _IOMYBUF);
    fp->_bufsiz = BUFSIZ;
    if (! TESTFLAG(fp, _IOREAD) && isatty(fp->_file))
      SETFLAG(fp, _IOLBF);
  }
  INITBUFFER(fp);
  return fp->_bufsiz;
}
