/*				_ f i l e
 *
 * Allocate and initialise a FILE structure. If the pointer passed
 * to the function is NULL, a FILE will be allocated, otherwise
 * the one specified will be used. The function will return
 * a pointer to the FILE structure, or NULL if it fails.
 *
 * Patchlevel 1.0
 *
 * Edit History:
 */

#include "stdiolib.h"

/*LINTLIBRARY*/

#ifdef __STDC__
FILE *_file(FILE *fp, int fd, short flags)
#else
FILE *_file(fp, fd, flags)
FILE *fp;				/* stream */
int fd;					/* channel */
short flags;				/* flags */
#endif
{
#ifdef __STDC__
  void *malloc(unsigned int);			/* memory allocator */
#else
  void *malloc();			/* memory allocator */
#endif

/* Allocate a file structure */
  if (fp == NULL)
    fp = (FILE *) malloc((unsigned int)(sizeof(*fp)));

/* Now initialise the structure */
  if (fp != NULL) {
    fp->_end    = NULL;
    fp->_ptr    = NULL;
    fp->_base   = NULL;
    fp->_bufsiz = 0;
    fp->_flag   = flags;
    fp->_file   = fd;
  }

  return fp;
}
