/*				e x i t
 *
 * Exit with stdio wrap up. A scan is made of the exit handler list.
 * All non-null pointers will be used to call the named functions.
 * Finally the stdio exit handler, _ioflush(), is called, followed by an
 * _exit().
 *
 * Patchlevel 1.1
 *
 * Edit History:
 * 07-Nov-1989  Changed to use a based structure a la DTO. [atw]
 * 03-Nov-1989  Added _exit_init() to reset handler at startup
 *              time [atw].
 * 02-Oct-1989  Extended handler table to 32 as per ANSI std. [atw]
 * 06-Sep-1989	Corrected prototypes. Correct exit handler table
 *		initialisation. Lint control.
 * 05-Sep-1989	Created.
 */

#include "stdiolib.h"

/*LINTLIBRARY*/

void
  _exit_init()
{
  int i;
  struct _exit *ep;

  ep = _exit_create(1);
  ep->exit_handler_count = 0;
}


void 
exit(status)
     int status;	       		/* exit status */
{
  int _exit P((int));			/* exit */
  int i;
  struct _exit *ep;

  ep = _exit_ptr();
  for (i=ep->exit_handler_count ; i-- > 0; )
    (*(ep->exit_handler_list[i]))();
  _ioflush();
 (void) _exit(status);
}

