/*			f o p e n
 *
 * Open a stream and associate it with the named file. The name
 * of the file is passed as a character string. The type of
 * stream is passed as a string with the first character indicating
 * the mode with which the file is to be opened.
 *
 * The function returns a pointer to the stream if successful
 * otherwise it returns NULL.
 *
 * Patchlevel 1.0
 *
 * Edit History:
 */

#include "stdiolib.h"

/*LINTLIBRARY*/

FILE *fopen(name, mode)

CONST char *name;				/* name of file */
CONST char *mode;				/* mode to open */

{
  FILE **sp;				/* slot in table */
  int fd;				/* opened file descriptor */
  short flags;				/* flag settings */

  return (sp = _slot((FILE *) NULL)) == NULL ||
         (fd = _fopen(name, mode, -1, &flags)) == -1
    ? NULL
    : (*sp = _file((FILE *) NULL, fd, flags));
}
