#ifndef FP960_H
#define FP960_H
#ifdef KB
#define HAS_FP
#endif

typedef struct {
unsigned  long x[2];} LONGLONG;

#ifdef HAS_FP
inline static LONGLONG const cvtzril(flo)
     double flo;
{
  LONGLONG dfix;
  asm volatile ("cvtzril %1,%0" : "=rG" (dfix) : "f" (flo));
  return dfix;
}

inline static double const cvtilr(dfix)
     LONGLONG dfix;
{
  double doub;
  asm volatile ("cvtilr %1,%0" : "=f" (doub) : "rG" (dfix));
  return doub;
}

#else

/*
 * Prototypes for the emulation library.
 */

LONGLONG const cvtzril(double);
double const   cvtilr(LONGLONG);

#endif /* HAS_FP */
#endif  /* ifndef FP960_H */
