/*				f p u t s
 *
 * Write a string onto the specified stream. The terminating null
 * character in the string is not written.
 *
 * The function returns EOF on error, otherwise it will return the
 * last character written.
 *
 * Patchlevel 1.1
 *
 * Edit History:
 * 05-Sep-1989	Change SETCLEANUP to SETIOFLUSH. Cast buffer
 *		pointer to unsigned char *.
 * 03-Sep-1989	Accommodate line buffered streams by flushing
 *		afterwards. Don't even bother looking for '\n'.
 *		Call NPUTC() for faster processing of unbuffered
 *		streams.
 * 02-Sep-1989	Speed up by writing directly to buffer.
 */

#include "stdiolib.h"

/*LINTLIBRARY*/

int fputs(str, fp)

CONST char *str;				/* string */
FILE       *fp;					/* stream */

{
  char flush;				/* flush line buffered stream */
  int lastch;				/* last character */
  unsigned int bytesleft;		/* bytes left in output buffer */
  unsigned char *q;			/* output buffer pointer */
  unsigned char *s;			/* input string */

/* Check for output buffer */
  if (! HASBUFFER(fp)) {
    if (_allocbuf(fp) < 0)
      return EOF;
    SETIOFLUSH();
  }

/* Cast buffer pointer */
  s = (unsigned char *) str;

/* Do unbuffered cases slowly */
  if (TESTFLAG(fp, _IONBF)) {
    for (lastch = 0; *s; lastch = (unsigned char) *s++) {
      if (NPUTC(*s, fp) == EOF)
	return EOF;
    }
    return lastch;
  }

/* Buffered mode --- write directly to buffer */
  for (lastch = s[0]; ; ) {
    if ((bytesleft = UNUSEDINWRITEBUFFER(fp)) != 0) {
      flush = 0;
      q = GETWRITEPTR(fp);
      if (TESTFLAG(fp, _IOLBF)) {
	UNROLL_DO(fputslb, bytesleft,
		  if (*s == '\n') flush = 1;
		  if ((*q++ = *((unsigned char *) s)++) == 0) break);
      }
      else {
	UNROLL_DO(fputsfb, bytesleft,
		  if ((*q++ = *((unsigned char *) s)++) == 0) break);
      }
      if (bytesleft) {
	SETWRITEPTR(fp, q-1);
	if (flush)
	  (void) fflush(fp);
	return lastch ? s[-2] : 0;
      }
      SETWRITEPTR(fp, q);
    }
    if (fflush(fp) == EOF)
      return EOF;
  }
}
