#include "lib.h"
#include <string.h>

/*
 * memccpy - copy bytes up to a certain char
 *
 * CHARBITS should be defined only if the compiler lacks "unsigned char".
 * It should be a mask, e.g. 0377 for an 8-bit machine.
 */

#ifdef NULL
#undef NULL
#endif

#define	NULL	0

#ifndef CHARBITS
#	define	UNSCHAR(c)	((unsigned char)(c))
#	define  uchar		unsigned char
#else
#	define	UNSCHAR(c)	((c)&CHARBITS)
#	define  uchar		char
#endif

VOIDSTAR
memccpy(dst, src, ucharstop, size)
VOIDSTAR dst;
CONST VOIDSTAR src;
int ucharstop;
int size;
{
	register char *d;
	register CONST char *s;
	register SIZET n;
	register int uc;

	if (size <= 0)
		return(NULL);

	s = src;
	d = dst;
	uc = UNSCHAR(ucharstop);
	for (n = size; n > 0; n--)
		if (UNSCHAR(*(uchar *)d++ = *(uchar *)s++) == uc)
			return(d);

	return(NULL);
}
