/*				p u t s
 *
 * Write a string followed by a newline character onto stdout. The
 * null character terminating the string is not written.
 *
 * The function returns the last character written (the newline)
 * on success and EOF on error.
 *
 * Patchlevel 1.0
 *
 * Edit History:
 * 03-Sep-1989	Call PUTC() for faster processing of files. Explicit
 *		flush for line buffered streams.
 */

#include "stdiolib.h"

/*LINTLIBRARY*/

int puts(s)

CONST char *s;				/* string */

{
  return fputs(s, stdout)  == EOF ||
         PUTC('\n',stdout) == EOF ||
	 TESTFLAG(stdout, _IOLBF) && fflush(stdout) == EOF
         ? EOF : '\n';
}
